/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.undo;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;

public class CellCommentAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -4359865087115306982L;
    private final String _newRichText;
    private String _oldRichText;
    private boolean _doFlag;

    public CellCommentAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, String editText) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._newRichText = editText;
    }

    public void doAction() {
        if (!this.isSheetProtected()) {
            Range r = Ranges.range((Sheet)this._sheet, (int)this._row, (int)this._column, (int)this._lastRow, (int)this._lastColumn);
            this._oldRichText = r.getCommentRichText();
            r.setCommentRichText(this._newRichText);
            this._doFlag = true;
        }
    }

    public boolean isUndoable() {
        return this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    public boolean isRedoable() {
        return !this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    public void undoAction() {
        Ranges.range((Sheet)this._sheet, (int)this._row, (int)this._column, (int)this._lastRow, (int)this._lastColumn).setCommentRichText(this._oldRichText);
        this._doFlag = false;
    }

    protected boolean isSheetProtected() {
        Range range = Ranges.range((Sheet)this._sheet);
        return super.isSheetProtected() && !range.getSheetProtection().isObjectsEditable();
    }
}

