/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikaiex.ui.impl.ua.AbstractPasteSpecialHandler;
import org.zkoss.util.resource.Labels;

public class PasteSpecialHandler
extends AbstractPasteSpecialHandler {
    private static final long serialVersionUID = 6005845018927840123L;
    protected final Range.PasteType type;
    protected final Range.PasteOperation operation;
    protected final boolean skipBlank;
    protected final boolean transpose;

    public PasteSpecialHandler(Range.PasteType type, Range.PasteOperation operation, boolean skipBlank, boolean transpose) {
        this.type = type;
        this.operation = operation;
        this.skipBlank = skipBlank;
        this.transpose = transpose;
    }

    protected boolean processAction(UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)(selection = ctx.getSelection()));
        if (range.isProtected()) {
            return true;
        }
        UserActionContext.Clipboard cb = ctx.getClipboard();
        if (cb == null) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.cant_find_thing_to_paste"));
            return true;
        }
        if (cb.isCutMode()) {
            throw new IllegalOpArgumentException("Cannot support paste special for cut");
        }
        this.doPaste(ctx, this.type, this.operation, this.skipBlank, this.transpose);
        return true;
    }
}

