/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.SheetOperationUtil;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.ZSFileupload;
import io.keikaiex.ui.impl.ua.AbstractObjectHandler;
import org.zkoss.image.AImage;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.event.UploadEvent;

public class InsertPictureHandler
extends AbstractObjectHandler {
    private static final long serialVersionUID = 2854009085197831214L;

    protected boolean processAction(final UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range((Sheet)sheet, (int)(selection = ctx.getSelection()).getRow(), (int)selection.getColumn(), (int)selection.getLastRow(), (int)selection.getLastColumn());
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            this.showProtectMessage();
            return true;
        }
        ZSFileupload.get((int)1, (EventListener)new SerializableEventListener<UploadEvent>(){
            private static final long serialVersionUID = 767590813246792367L;

            public void onEvent(UploadEvent event) throws Exception {
                Media media = event.getMedia();
                InsertPictureHandler.this.doInsertPicture(ctx, media);
            }
        });
        return true;
    }

    protected boolean doInsertPicture(UserActionContext ctx, Media media) {
        if (media == null) {
            return true;
        }
        if (!(media instanceof AImage) || SheetOperationUtil.getPictureFormat((AImage)((AImage)media)) == null) {
            this.showWarnMessage(Labels.getLabel((String)"zss.actionhandler.msg.cant_support_file", (Object[])new Object[]{media == null ? "" : media.getName()}));
            return true;
        }
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        Range range = Ranges.range((Sheet)sheet, (int)selection.getRow(), (int)selection.getColumn(), (int)selection.getLastRow(), (int)selection.getLastColumn());
        SheetOperationUtil.addPicture((Range)range, (AImage)((AImage)media));
        return true;
    }
}

