/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractBookHandler;

public class HideSheetHandler
extends AbstractBookHandler {
    private static final long serialVersionUID = 7151025305640454638L;

    public boolean isEnabled(Book book, Sheet sheet) {
        if (book == null) {
            return false;
        }
        int count = 0;
        int length = book.getNumberOfSheets();
        for (int i = 0; i < length; ++i) {
            Sheet s = book.getSheetAt(i);
            if (s.isHidden() || s.isVeryHidden()) continue;
            ++count;
        }
        return count > 1;
    }

    protected boolean processAction(UserActionContext ctx) {
        Book book = ctx.getBook();
        int len = book.getNumberOfSheets();
        int index = book.getSheetIndex(ctx.getSheet());
        index = this.findAvailableCandidate(book, index, len);
        Ranges.range((Sheet)ctx.getSheet()).setSheetVisible(Range.SheetVisible.HIDDEN);
        ctx.getSpreadsheet().setSelectedSheet(book.getSheetAt(index).getSheetName());
        return true;
    }

    protected int findAvailableCandidate(Book book, int index, int length) {
        int i;
        for (i = index + 1; i < length; ++i) {
            if (this.isHidden(book.getSheetAt(i))) continue;
            return i;
        }
        for (i = index - 1; i >= 0; --i) {
            if (this.isHidden(book.getSheetAt(i))) continue;
            return i;
        }
        return -1;
    }

    protected boolean isHidden(Sheet sheet) {
        return sheet.isHidden() || sheet.isVeryHidden();
    }
}

