/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.SheetProtection;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.ResizeHeaderAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikaiex.ui.dialog.HeaderSizeCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class HeaderSizeHandler
extends AbstractHandler {
    private static final long serialVersionUID = -4438278621658453175L;
    protected HeaderSizeCtrl.HeaderType headerType;

    public HeaderSizeHandler(HeaderSizeCtrl.HeaderType headerType) {
        this.headerType = headerType;
    }

    protected boolean processAction(final UserActionContext ctx) {
        final Sheet sheet = ctx.getSheet();
        final AreaRef selection = ctx.getSelection();
        int size = this.headerType == HeaderSizeCtrl.HeaderType.COLUMN ? sheet.getColumnWidth(selection.getColumn()) : sheet.getRowHeight(selection.getRow());
        HeaderSizeCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -8392523484662788558L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (HeaderSizeCtrl.ON_OK.equals(event.getName())) {
                    int size = (Integer)event.getData(HeaderSizeCtrl.ARG_HEADER_SIZE);
                    String label = HeaderSizeHandler.this.headerType == HeaderSizeCtrl.HeaderType.COLUMN ? Labels.getLabel((String)"zss.undo.columnSize") : Labels.getLabel((String)"zss.undo.rowSize");
                    ResizeHeaderAction.Type action = HeaderSizeHandler.this.headerType == HeaderSizeCtrl.HeaderType.COLUMN ? ResizeHeaderAction.Type.COLUMN : ResizeHeaderAction.Type.ROW;
                    UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
                    uam.doAction((UndoableAction)new ResizeHeaderAction(label, sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), action, size, true));
                }
            }
        }, this.headerType, size, ctx.getSpreadsheet());
        return true;
    }

    public boolean isEnabled(Book book, Sheet sheet) {
        if (book == null || sheet == null) {
            return false;
        }
        if (!sheet.isProtected()) {
            return true;
        }
        SheetProtection sheetProtection = Ranges.range((Sheet)sheet).getSheetProtection();
        boolean allowed = false;
        switch (this.headerType) {
            case COLUMN: {
                allowed = sheetProtection.isFormatColumnsAllowed();
                break;
            }
            case ROW: {
                allowed = sheetProtection.isFormatRowsAllowed();
            }
        }
        return allowed;
    }
}

