/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.range.SRange;
import io.keikai.range.impl.DataRegionHelper;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.SortCellAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikaiex.ui.dialog.CustomSortCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import java.util.List;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class CustomSortHandler
extends AbstractHandler {
    private static final long serialVersionUID = -8000940195023894982L;

    protected boolean processAction(final UserActionContext ctx) {
        AreaRef selection;
        SRange srcrng;
        CellRegion rng;
        AreaRef selection0;
        final Sheet sheet = ctx.getSheet();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)(selection0 = new AreaRef((rng = new DataRegionHelper(srcrng = Ranges.range((Sheet)sheet, (int)(selection = ctx.getSelection()).getRow(), (int)selection.getColumn(), (int)selection.getLastRow(), (int)selection.getLastColumn()).getInternalRange()).findCustomSortRegion()).getRow(), rng.getColumn(), rng.getLastRow(), rng.getLastColumn())));
        if (range.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        CustomSortCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -4841252864311531700L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (CustomSortCtrl.ON_OK.equals(event.getName())) {
                    boolean caseSensitive = (Boolean)event.getData(CustomSortCtrl.ARG_CASE_SENSITIVE);
                    boolean hasHeader = (Boolean)event.getData(CustomSortCtrl.ARG_HAS_HEADER);
                    boolean byRow = "row".equals((String)event.getData(CustomSortCtrl.ARG_ORIENTATION));
                    List rules = (List)event.getData(CustomSortCtrl.ARG_RULES);
                    if (rules.size() < 1) {
                        return;
                    }
                    Object[][] sortInfo = new Object[3][];
                    int row = selection0.getRow();
                    int col = selection0.getColumn();
                    int lastrow = selection0.getLastRow();
                    int lastcol = selection0.getLastColumn();
                    for (int i = 0; i < 3; ++i) {
                        Object[] info = new Object[3];
                        if (i < rules.size()) {
                            CustomSortCtrl.SortRule rule = (CustomSortCtrl.SortRule)rules.get(i);
                            info[0] = byRow ? Ranges.range((Sheet)sheet, (int)(row + rule.sortIndex), (int)col, (int)(row + rule.sortIndex), (int)lastcol) : Ranges.range((Sheet)sheet, (int)row, (int)(col + rule.sortIndex), (int)lastrow, (int)(col + rule.sortIndex));
                            info[1] = !rule.ascending;
                        } else {
                            info[0] = null;
                            info[1] = false;
                        }
                        sortInfo[i] = info;
                    }
                    UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
                    uam.doAction((UndoableAction)new SortCellAction(Labels.getLabel((String)"zss.undo.sort"), sheet, selection0.getRow(), selection0.getColumn(), selection0.getLastRow(), selection0.getLastColumn(), (Range)sortInfo[0][0], ((Boolean)sortInfo[0][1]).booleanValue(), null, (Range)sortInfo[1][0], ((Boolean)sortInfo[1][1]).booleanValue(), null, (Range)sortInfo[2][0], ((Boolean)sortInfo[2][1]).booleanValue(), null, hasHeader, caseSensitive, byRow));
                }
            }
        }, sheet, selection0, ctx.getSpreadsheet());
        return true;
    }

    public boolean isEnabled(Book book, Sheet sheet) {
        return book != null && sheet != null && (!sheet.isProtected() || Ranges.range((Sheet)sheet).getSheetProtection().isSortAllowed());
    }
}

