/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.DialogCtrlBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Window;

public class UnhideSheetCtrl
extends DialogCtrlBase {
    private static final long serialVersionUID = 3360528271114203033L;
    public static String URI = "~./zssex/dlg/unhideSheet.zul";
    public static String ARG_SHEET_NAMES = "sheetNames";
    @Wire
    protected Button okBtn;
    @Wire
    protected Listbox nameListbox;
    @Wire
    protected Checkbox checkbox;

    public static void show(EventListener<DialogCallbackEvent> callback, List<String> names) {
        Map arg = UnhideSheetCtrl.newArg(callback);
        arg.put(ARG_SHEET_NAMES, names);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        for (String name : (List)arg.get(ARG_SHEET_NAMES)) {
            this.nameListbox.appendChild((Component)new Listitem(name));
        }
        if (this.nameListbox.getChildren().size() > 0) {
            this.nameListbox.setSelectedIndex(0);
        }
    }

    @Listen(value="onCheck = #checkbox")
    public void onCheck() {
        if (this.checkbox.isChecked()) {
            this.nameListbox.selectAll();
        } else {
            this.nameListbox.clearSelection();
        }
    }

    @Listen(value="onOK=window; onClick=#okBtn;")
    public void onOK() {
        Set itemSet = this.nameListbox.getSelectedItems();
        ArrayList<String> nameList = new ArrayList<String>(itemSet.size());
        for (Listitem item : itemSet) {
            nameList.add(item.getLabel());
        }
        if (nameList.size() > 0) {
            this.postCallback(ON_OK, UnhideSheetCtrl.newMap(UnhideSheetCtrl.newEntry(ARG_SHEET_NAMES, nameList)));
        }
        this.detach();
    }

    @Listen(value="onCancel = window; onClick = #cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }
}

