/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.model.SheetProtection;
import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.PasswordCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.DialogCtrlBase;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class ProtectSheetCtrl
extends DialogCtrlBase {
    private static final long serialVersionUID = -4600082937506137037L;
    public static String URI = "~./zssex/dlg/protectSheet.zul";
    public static String ARG_PASSWORD = "password";
    public static String ARG_SHEET_PROTECTION = "sheetProtection";
    public static String ARG_ALLOW_OPTIONS = "allowedOptions";
    @Wire
    protected Button okBtn;
    @Wire
    protected Checkbox checkbox;
    @Wire
    protected Textbox passwordBox;
    @Wire
    protected Listbox allowedOptions;
    @Wire
    protected Listitem lockCells;
    @Wire
    protected Listitem unlockCells;
    @Wire
    protected Listitem formatCells;
    @Wire
    protected Listitem formatColumns;
    @Wire
    protected Listitem formatRows;
    @Wire
    protected Listitem insertColumns;
    @Wire
    protected Listitem insertRows;
    @Wire
    protected Listitem insertHyperlinks;
    @Wire
    protected Listitem deleteColumns;
    @Wire
    protected Listitem deleteRows;
    @Wire
    protected Listitem sort;
    @Wire
    protected Listitem autoFilter;
    @Wire
    protected Listitem editObjects;

    public static void show(EventListener<DialogCallbackEvent> callback, SheetProtection sheetProtection) {
        Map arg = ProtectSheetCtrl.newArg(callback);
        arg.put(ARG_SHEET_PROTECTION, sheetProtection);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        this.initialOptions((SheetProtection)arg.get(ARG_SHEET_PROTECTION));
    }

    @Listen(value="onOK=window; onClick=#okBtn")
    public void onOK() {
        final String password = this.passwordBox.getValue();
        if (password == null || password.isEmpty()) {
            this.postData();
        } else {
            String title = Labels.getLabel((String)"zssex.dlg.protectSheet.confirm_passowrd");
            String hint = Labels.getLabel((String)"zssex.dlg.protectSheet.confirm_passowrd_hint");
            String caution = Labels.getLabel((String)"zssex.dlg.protectSheet.confirm_passowrd_caution");
            PasswordCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
                private static final long serialVersionUID = 420272954779448143L;

                public void onEvent(DialogCallbackEvent event) throws Exception {
                    if (ON_OK.equals(event.getName())) {
                        if (password.equals((String)event.getData("password"))) {
                            ProtectSheetCtrl.this.postData();
                        } else {
                            ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.protectSheet.confirm_passowrd_error"), (String)"Keikai Spreadsheet", (int)1, (String)"z-messagebox-icon z-messagebox-exclamation", (EventListener)new SerializableEventListener(){
                                private static final long serialVersionUID = -7358057033654454683L;

                                public void onEvent(Event evt) {
                                    ProtectSheetCtrl.this.passwordBox.setFocus(true);
                                    ProtectSheetCtrl.this.passwordBox.select();
                                }
                            });
                        }
                    }
                }
            }, title, hint, caution);
        }
    }

    @Listen(value="onCheck = #checkbox")
    public void onCheck() {
        this.okBtn.setDisabled(!this.checkbox.isChecked());
    }

    @Listen(value="onCancel = window; onClick = #cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    @Listen(value="onClick = #lockCells")
    public void selectUnlockCells() {
        if (this.lockCells.isSelected()) {
            this.unlockCells.setSelected(true);
        }
    }

    @Listen(value="onClick = #unlockCells")
    public void unselectLockCells() {
        if (!this.unlockCells.isSelected()) {
            this.lockCells.setSelected(false);
        }
    }

    protected void postData() {
        this.detach();
        int result = 0;
        for (Listitem listitem : this.allowedOptions.getSelectedItems()) {
            result += Integer.parseInt((String)listitem.getValue(), 16);
        }
        this.postCallback(ON_OK, ProtectSheetCtrl.newMap(ProtectSheetCtrl.newEntry(ARG_PASSWORD, this.passwordBox.getValue()), ProtectSheetCtrl.newEntry(ARG_ALLOW_OPTIONS, result)));
    }

    protected void initialOptions(SheetProtection sheetProtection) {
        if (sheetProtection.isSelectLockedCellsAllowed()) {
            this.lockCells.setSelected(true);
        }
        if (sheetProtection.isSelectUnlockedCellsAllowed()) {
            this.unlockCells.setSelected(true);
        }
        if (sheetProtection.isFormatCellsAllowed()) {
            this.formatCells.setSelected(true);
        }
        if (sheetProtection.isFormatColumnsAllowed()) {
            this.formatColumns.setSelected(true);
        }
        if (sheetProtection.isFormatRowsAllowed()) {
            this.formatRows.setSelected(true);
        }
        if (sheetProtection.isInsertColumnsAllowed()) {
            this.insertColumns.setSelected(true);
        }
        if (sheetProtection.isInsertRowsAllowed()) {
            this.insertRows.setSelected(true);
        }
        if (sheetProtection.isInsertHyperlinksAllowed()) {
            this.insertHyperlinks.setSelected(true);
        }
        if (sheetProtection.isDeleteColumnsAllowed()) {
            this.deleteColumns.setSelected(true);
        }
        if (sheetProtection.isDeleteRowsAllowed()) {
            this.deleteRows.setSelected(true);
        }
        if (sheetProtection.isSortAllowed()) {
            this.sort.setSelected(true);
        }
        if (sheetProtection.isAutoFilterAllowed()) {
            this.autoFilter.setSelected(true);
        }
        if (sheetProtection.isObjectsEditable()) {
            this.editObjects.setSelected(true);
        }
    }
}

