/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.Range;
import io.keikai.api.model.Book;
import io.keikai.ui.Spreadsheet;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.RefocusDialogCtrlBase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Window;

public class PasteSpecialCtrl
extends RefocusDialogCtrlBase {
    private static final Logger log = LoggerFactory.getLogger(PasteSpecialCtrl.class);
    private static final long serialVersionUID = 1691798403088433067L;
    public static String URI = "~./zssex/dlg/pasteSpecial.zul";
    public static String ARG_PASTE_OP = "pasteOp";
    public static String ARG_SKIP_BLANK = "skipBlank";
    public static String ARG_PASTE_TYPE = "pasteType";
    public static String ARG_TRANSPOSE = "transport";
    public static String ARG_BOOK_TYPE = "bookType";
    @Wire
    protected Radiogroup pasteTypeRadiogroup;
    @Wire
    protected Radiogroup operationRadiogroup;
    @Wire
    protected Checkbox skipBlankBox;
    @Wire
    protected Checkbox transposeBox;
    @Wire
    protected Radio comment;
    @Wire
    protected Radio validation;

    public static void show(EventListener<DialogCallbackEvent> callback, Book.BookType type, Spreadsheet ss) {
        Map arg = PasteSpecialCtrl.newArg(callback);
        arg.put(ARG_BOOK_TYPE, type);
        arg.put("spreadsheet", ss);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window w) throws Exception {
        super.doAfterCompose(w);
        Book.BookType type = (Book.BookType)Executions.getCurrent().getArg().get(ARG_BOOK_TYPE);
        if (type == Book.BookType.XLS) {
            this.comment.setDisabled(true);
            this.validation.setDisabled(true);
        }
    }

    @Listen(value="onOK=window; onClick=#okBtn")
    public void onClick$okBtn() {
        this.postCallback(ON_OK, PasteSpecialCtrl.newMap(PasteSpecialCtrl.newEntry(ARG_PASTE_TYPE, this.getPasteType()), PasteSpecialCtrl.newEntry(ARG_PASTE_OP, Range.PasteOperation.NONE), PasteSpecialCtrl.newEntry(ARG_SKIP_BLANK, this.skipBlankBox.isChecked()), PasteSpecialCtrl.newEntry(ARG_TRANSPOSE, this.transposeBox.isChecked())));
        this.detach();
    }

    protected Range.PasteOperation getPasteOperation() {
        String operation;
        Radio sel = this.operationRadiogroup.getSelectedItem();
        String string = operation = sel == null ? null : (String)sel.getValue();
        if (operation == null || "none".equals(operation)) {
            return Range.PasteOperation.NONE;
        }
        if ("add".equals(operation)) {
            return Range.PasteOperation.ADD;
        }
        if ("sub".equals(operation)) {
            return Range.PasteOperation.SUB;
        }
        if ("mul".equals(operation)) {
            return Range.PasteOperation.MUL;
        }
        if ("divide".equals(operation)) {
            return Range.PasteOperation.DIV;
        }
        log.warn("unknown paste operation " + operation);
        return Range.PasteOperation.NONE;
    }

    protected Range.PasteType getPasteType() {
        String type;
        Radio sel = this.pasteTypeRadiogroup.getSelectedItem();
        String string = type = sel == null ? null : (String)sel.getValue();
        if (type == null || "paste".equals(type) || "all".equals(type)) {
            return Range.PasteType.ALL;
        }
        if ("allExcpetBorder".equals(type)) {
            return Range.PasteType.ALL_EXCEPT_BORDERS;
        }
        if ("columnWidth".equals(type)) {
            return Range.PasteType.COLUMN_WIDTHS;
        }
        if ("comment".equals(type)) {
            return Range.PasteType.COMMENTS;
        }
        if ("formula".equals(type)) {
            return Range.PasteType.FORMULAS;
        }
        if ("formulaWithNumFmt".equals(type)) {
            return Range.PasteType.FORMULAS_AND_NUMBER_FORMATS;
        }
        if ("value".equals(type)) {
            return Range.PasteType.VALUES;
        }
        if ("valueWithNumFmt".equals(type)) {
            return Range.PasteType.VALUES_AND_NUMBER_FORMATS;
        }
        if ("format".equals(type)) {
            return Range.PasteType.FORMATS;
        }
        if ("validation".equals(type)) {
            return Range.PasteType.VALIDATAION;
        }
        log.warn("unknown paste type " + type);
        return Range.PasteType.ALL;
    }

    @Listen(value="onCancel=window; onClick=#cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }
}

