/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.model.Validation;
import io.keikai.model.InvalidDataValidationException;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.RefocusDialogCtrlBase;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class DataValidationCtrl
extends RefocusDialogCtrlBase {
    private static final long serialVersionUID = 1L;
    public static String URI = "~./zssex/dlg/dataValidation.zul";
    public static String ARG_VALIDATION_CODE = "validationCode";
    public static String ARG_VALIDATION_TYPE_CODE = "validationTypeCode";
    public static String ARG_OPERATOR_TYPE_CODE = "operatorTypeCode";
    public static String ARG_IGNORE_BLANK_CODE = "ignoreBlankCode";
    public static String ARG_IN_CELL_DROPDOWN_CODE = "inCellDropdownCode";
    public static String ARG_PARAM1_CODE = "param1Code";
    public static String ARG_PARAM2_CODE = "param2Code";
    public static String ARG_SHOW_INPUT_CODE = "showInputCode";
    public static String ARG_INPUT_TITLE_CODE = "inputTitleCode";
    public static String ARG_INPUT_MESSAGE_CODE = "inputMessageCode";
    public static String ARG_SHOW_ERROR_CODE = "showErrorCode";
    public static String ARG_ALERT_STYLE_CODE = "alertStyleCode";
    public static String ARG_ERROR_TITLE_CODE = "errorTitleCode";
    public static String ARG_ERROR_MESSAGE_CODE = "errorMessageCode";
    protected ListModelList<AllowPair> allowListmodel = new ListModelList((Object[])AllowPair.values());
    protected ListModelList<DataPair> dataListmodel = new ListModelList((Object[])DataPair.values());
    protected ListModelList<AlertStyle> styleListmodel = new ListModelList((Object[])AlertStyle.values());
    @Wire
    protected Combobox allowCombobox;
    @Wire
    protected Combobox dataCombobox;
    @Wire
    protected Checkbox ignoreBlankCheckbox;
    @Wire
    protected Checkbox inCellDropdownCheckbox;
    @Wire
    protected Label inCellDropdownLabel;
    @Wire
    protected Textbox param1Textbox;
    @Wire
    protected Textbox param2Textbox;
    @Wire
    protected Label param1Label;
    @Wire
    protected Label param2Label;
    @Wire
    protected Checkbox inputMsgCheckbox;
    @Wire
    protected Textbox inputTitleTextbox;
    @Wire
    protected Textbox inputMsgTextbox;
    @Wire
    protected Checkbox errorMsgCheckbox;
    @Wire
    protected Combobox errorStyleCombobox;
    @Wire
    protected Textbox errorTitleTextbox;
    @Wire
    protected Textbox errorMsgTextbox;

    public static void show(EventListener<DialogCallbackEvent> callback, Validation validation, Spreadsheet ss) {
        Map arg = DataValidationCtrl.newArg(callback);
        arg.put(ARG_VALIDATION_CODE, validation);
        arg.put("spreadsheet", ss);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        Validation validation = (Validation)arg.get(ARG_VALIDATION_CODE);
        this.initSettings(validation);
        this.initInputMsg(validation);
        this.initErrorAlert(validation);
        this.updateCascade();
        this.onCheck$msgCheckbox();
        this.onCheck$errorMsgCheckbox();
    }

    protected void initErrorAlert(Validation validation) {
        if (validation != null) {
            this.errorMsgCheckbox.setChecked(validation.isShowError());
            this.styleListmodel.addToSelection((Object)AlertStyle.getAlertStyle(validation.getAlertStyle()));
            this.errorStyleCombobox.setModel(this.styleListmodel);
            this.errorTitleTextbox.setValue(validation.getErrorTitle());
            this.errorMsgTextbox.setValue(validation.getErrorMessage());
        } else {
            this.initDefaultErrorAlert();
        }
    }

    protected void initDefaultErrorAlert() {
        this.errorMsgCheckbox.setChecked(true);
        this.styleListmodel.addToSelection((Object)AlertStyle.STOP);
        this.errorStyleCombobox.setModel(this.styleListmodel);
        this.errorTitleTextbox.setValue("");
        this.errorMsgTextbox.setValue("");
    }

    protected void initInputMsg(Validation validation) {
        if (validation != null) {
            this.inputMsgCheckbox.setChecked(validation.isShowInput());
            this.inputTitleTextbox.setValue(validation.getInputTitle());
            this.inputMsgTextbox.setValue(validation.getInputMessage());
        } else {
            this.initDefaultInputMsg();
        }
    }

    protected void initDefaultInputMsg() {
        this.inputMsgCheckbox.setChecked(true);
        this.inputTitleTextbox.setValue("");
        this.inputMsgTextbox.setValue("");
    }

    protected void initSettings(Validation validation) {
        if (validation != null) {
            AllowPair allowPair = AllowPair.getAllowPair(validation.getValidationType());
            DataPair dataPair = DataPair.getDataPair(validation.getOperatorType());
            this.allowListmodel.addToSelection((Object)allowPair);
            this.allowCombobox.setModel(this.allowListmodel);
            this.dataListmodel.addToSelection((Object)dataPair);
            this.dataCombobox.setModel(this.dataListmodel);
            this.param1Textbox.setValue(validation.getFormula1());
            this.param2Textbox.setValue(validation.getFormula2());
            this.ignoreBlankCheckbox.setChecked(validation.isIgnoreBlank());
            this.inCellDropdownCheckbox.setChecked(validation.isInCellDropdown());
        } else {
            AllowPair allowPair = AllowPair.ANY_VALUE;
            DataPair dataPair = DataPair.BETWEEN;
            this.allowListmodel.addToSelection((Object)allowPair);
            this.allowCombobox.setModel(this.allowListmodel);
            this.dataListmodel.addToSelection((Object)dataPair);
            this.dataCombobox.setModel(this.dataListmodel);
            this.param1Textbox.setValue("");
            this.param2Textbox.setValue("");
            this.ignoreBlankCheckbox.setChecked(true);
            this.inCellDropdownCheckbox.setChecked(true);
        }
    }

    protected void updateCascade() {
        this.updateDataType();
        this.updateParameter();
        this.updateCheckbox();
    }

    protected void updateCheckbox() {
        AllowPair allowPair = AllowPair.values()[((AllowPair)((Object)this.allowListmodel.getSelection().iterator().next())).ordinal()];
        boolean ignore = !allowPair.isIgnoreBlankEnabled();
        this.ignoreBlankCheckbox.setDisabled(ignore);
        boolean inCell = allowPair.isInCellCheckEnabled();
        this.inCellDropdownCheckbox.setVisible(inCell);
        this.inCellDropdownLabel.setVisible(inCell);
        this.inCellDropdownCheckbox.setChecked(inCell);
    }

    protected void updateParameter() {
        AllowPair allowPair = AllowPair.values()[((AllowPair)((Object)this.allowListmodel.getSelection().iterator().next())).ordinal()];
        DataPair dataPair = DataPair.values()[((DataPair)((Object)this.dataListmodel.getSelection().iterator().next())).ordinal()];
        boolean isParam1Enabled = allowPair.isParam1Enabled();
        boolean isParam2Enabled = allowPair.isParam2Enabled();
        boolean twoParams = dataPair == DataPair.BETWEEN || dataPair == DataPair.NOT_BETWEEN;
        boolean pointParam = dataPair == DataPair.EQUAL_TO || dataPair == DataPair.NOT_EQUAL_TO || allowPair == AllowPair.CUSTOM || allowPair == AllowPair.LIST;
        boolean minParam = twoParams || dataPair == DataPair.GREATER_EUQAL || dataPair == DataPair.GREATER_THAN;
        boolean maxParam = !pointParam && !minParam;
        this.param1Label.setVisible(isParam1Enabled);
        this.param1Textbox.setVisible(isParam1Enabled);
        this.param2Label.setVisible(isParam2Enabled && twoParams);
        this.param2Textbox.setVisible(isParam2Enabled && twoParams);
        if (isParam1Enabled) {
            if (pointParam) {
                this.param1Label.setValue(allowPair.getPointName());
            } else if (minParam) {
                this.param1Label.setValue(allowPair.getMinimumName());
            } else if (maxParam) {
                this.param1Label.setValue(allowPair.getMaximumName());
            }
        }
        if (isParam2Enabled) {
            this.param2Label.setValue(allowPair.getMaximumName());
        }
    }

    protected void updateDataType() {
        AllowPair allowPair = AllowPair.values()[((AllowPair)((Object)this.allowListmodel.getSelection().iterator().next())).ordinal()];
        this.dataCombobox.setDisabled(!allowPair.isDataEnabled());
    }

    @Listen(value="onSelect=#allowCombobox")
    public void onSelect$allowCombobox() {
        this.updateCascade();
    }

    @Listen(value="onSelect=#dataCombobox")
    public void onSelect$dataCombobox() {
        this.updateCheckbox();
        this.updateParameter();
    }

    @Listen(value="onCheck=#inputMsgCheckbox")
    public void onCheck$msgCheckbox() {
        boolean checked = this.inputMsgCheckbox.isChecked();
        this.inputTitleTextbox.setDisabled(!checked);
        this.inputMsgTextbox.setDisabled(!checked);
    }

    @Listen(value="onCheck=#errorMsgCheckbox")
    public void onCheck$errorMsgCheckbox() {
        boolean checked = this.errorMsgCheckbox.isChecked();
        this.errorStyleCombobox.setDisabled(!checked);
        this.errorTitleTextbox.setDisabled(!checked);
        this.errorMsgTextbox.setDisabled(!checked);
    }

    @Listen(value="onOK=window; onClick=#okBtn")
    public void onClick$okBtn() {
        Validation.ValidationType validationType = ((AllowPair)((Object)this.allowListmodel.getSelection().iterator().next())).getType();
        Validation.OperatorType operatorType = ((DataPair)((Object)this.dataListmodel.getSelection().iterator().next())).getType();
        boolean ignoreBlank = this.ignoreBlankCheckbox.isChecked();
        boolean inCellDropDown = this.inCellDropdownCheckbox.isChecked();
        String param1 = this.param1Textbox.getValue();
        String param2 = this.param2Textbox.getValue();
        boolean isShowInput = this.inputMsgCheckbox.isChecked();
        String inputTitle = this.inputTitleTextbox.getValue();
        String inputMessage = this.inputMsgTextbox.getValue();
        boolean isShowError = this.errorMsgCheckbox.isChecked();
        Validation.AlertStyle alertStyle = ((AlertStyle)((Object)this.styleListmodel.getSelection().iterator().next())).getStyle();
        String errorTitle = this.errorTitleTextbox.getValue();
        String errorMessage = this.errorMsgTextbox.getValue();
        try {
            this.sendCallback(ON_OK, DataValidationCtrl.newMap(DataValidationCtrl.newEntry(ARG_VALIDATION_TYPE_CODE, validationType), DataValidationCtrl.newEntry(ARG_OPERATOR_TYPE_CODE, operatorType), DataValidationCtrl.newEntry(ARG_IGNORE_BLANK_CODE, ignoreBlank), DataValidationCtrl.newEntry(ARG_IN_CELL_DROPDOWN_CODE, inCellDropDown), DataValidationCtrl.newEntry(ARG_PARAM1_CODE, param1), DataValidationCtrl.newEntry(ARG_PARAM2_CODE, param2), DataValidationCtrl.newEntry(ARG_SHOW_INPUT_CODE, isShowInput), DataValidationCtrl.newEntry(ARG_INPUT_TITLE_CODE, inputTitle), DataValidationCtrl.newEntry(ARG_INPUT_MESSAGE_CODE, inputMessage), DataValidationCtrl.newEntry(ARG_SHOW_ERROR_CODE, isShowError), DataValidationCtrl.newEntry(ARG_ALERT_STYLE_CODE, alertStyle), DataValidationCtrl.newEntry(ARG_ERROR_TITLE_CODE, errorTitle), DataValidationCtrl.newEntry(ARG_ERROR_MESSAGE_CODE, errorMessage)));
        }
        catch (InvalidDataValidationException e) {
            ZSMessagebox.show((String)e.getMessage(), (String)"Warning", (int)1, (String)"z-messagebox-icon z-messagebox-exclamation");
            return;
        }
        this.detach();
    }

    @Listen(value="onCancel=window; onClick=#cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    @Listen(value="onClick=#clearBtn")
    public void onClear() {
        this.allowListmodel.clearSelection();
        this.allowListmodel.addToSelection((Object)AllowPair.ANY_VALUE);
        this.initDefaultInputMsg();
        this.initDefaultErrorAlert();
        this.updateCascade();
        this.onCheck$msgCheckbox();
        this.onCheck$errorMsgCheckbox();
    }

    public static enum AlertStyle {
        STOP(Labels.getLabel((String)"zssex.dlg.format.dataValidation.error.alert.stop"), Validation.AlertStyle.STOP),
        WARNING(Labels.getLabel((String)"zssex.dlg.format.dataValidation.error.alert.warning"), Validation.AlertStyle.WARNING),
        INFORMATION(Labels.getLabel((String)"zssex.dlg.format.dataValidation.error.alert.info"), Validation.AlertStyle.INFO);

        Validation.AlertStyle style;
        String title;

        private AlertStyle(String title, Validation.AlertStyle style) {
            this.title = title;
            this.style = style;
        }

        public static AlertStyle getAlertStyle(Validation.AlertStyle style) {
            for (AlertStyle s : AlertStyle.values()) {
                if (s.style != style) continue;
                return s;
            }
            return null;
        }

        public Validation.AlertStyle getStyle() {
            return this.style;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum DataPair {
        BETWEEN(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.between"), Validation.OperatorType.BETWEEN),
        NOT_BETWEEN(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.notBetween"), Validation.OperatorType.NOT_BETWEEN),
        EQUAL_TO(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.equalTo"), Validation.OperatorType.EQUAL),
        NOT_EQUAL_TO(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.notEqualTo"), Validation.OperatorType.NOT_EQUAL),
        GREATER_THAN(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.greaterThan"), Validation.OperatorType.GREATER_THAN),
        LESS_THAN(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.lessThan"), Validation.OperatorType.LESS_THAN),
        GREATER_EUQAL(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.greaterOrEqual"), Validation.OperatorType.GREATER_OR_EQUAL),
        LESS_EQUAL(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.data.lessOrEqual"), Validation.OperatorType.LESS_OR_EQUAL);

        String title;
        Validation.OperatorType type;

        private DataPair(String title, Validation.OperatorType type) {
            this.title = title;
            this.type = type;
        }

        public static DataPair getDataPair(Validation.OperatorType type) {
            for (DataPair pair : DataPair.values()) {
                if (pair.type != type) continue;
                return pair;
            }
            return null;
        }

        public Validation.OperatorType getType() {
            return this.type;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum AllowPair {
        ANY_VALUE(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.anyValue"), Validation.ValidationType.ANY, false, false, false, "", "", "", false, false),
        WHOLE_NUMBER(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.wholeNumber"), Validation.ValidationType.INTEGER, true, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.value"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.minimum"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.maximum"), true, true),
        DECIMAL(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.decimal"), Validation.ValidationType.DECIMAL, true, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.value"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.minimum"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.maximum"), true, true),
        LIST(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.list"), Validation.ValidationType.LIST, false, true, true, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.source"), "", "", true, false),
        DATE(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.date"), Validation.ValidationType.DATE, true, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.date"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.startDate"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.endDate"), true, true),
        TIME(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.time"), Validation.ValidationType.TIME, true, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.time"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.startTime"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.endTime"), true, true),
        TEXT_LENGTH(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.textLength"), Validation.ValidationType.TEXT_LENGTH, true, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.length"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.minimum"), Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.maximum"), true, true),
        CUSTOM(Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.allow.custom"), Validation.ValidationType.CUSTOM, false, true, false, Labels.getLabel((String)"zssex.dlg.format.dataValidation.settings.formula"), "", "", true, false);

        String title;
        Validation.ValidationType type;
        boolean dataEnabled;
        boolean ignoreBlankEnabled;
        boolean inCellCheckEnabled;
        String pointName;
        String minimumName;
        String maximumName;
        boolean param1Enabled;
        boolean param2Enabled;

        private AllowPair(String title, Validation.ValidationType type, boolean dataEnabled, boolean ignoreBlankEnabled, boolean inCellCheckEnabled, String pointName, String minimumName, String maximumName, boolean param1Enabled, boolean param2Enabled) {
            this.title = title;
            this.type = type;
            this.dataEnabled = dataEnabled;
            this.ignoreBlankEnabled = ignoreBlankEnabled;
            this.inCellCheckEnabled = inCellCheckEnabled;
            this.pointName = pointName;
            this.minimumName = minimumName;
            this.maximumName = maximumName;
            this.param1Enabled = param1Enabled;
            this.param2Enabled = param2Enabled;
        }

        public static AllowPair getAllowPair(Validation.ValidationType type) {
            for (AllowPair pair : AllowPair.values()) {
                if (pair.type != type) continue;
                return pair;
            }
            return null;
        }

        public Validation.ValidationType getType() {
            return this.type;
        }

        public boolean isDataEnabled() {
            return this.dataEnabled;
        }

        public boolean isIgnoreBlankEnabled() {
            return this.ignoreBlankEnabled;
        }

        public boolean isInCellCheckEnabled() {
            return this.inCellCheckEnabled;
        }

        public String getPointName() {
            return this.pointName;
        }

        public String getMinimumName() {
            return this.minimumName;
        }

        public String getMaximumName() {
            return this.maximumName;
        }

        public boolean isParam1Enabled() {
            return this.param1Enabled;
        }

        public boolean isParam2Enabled() {
            return this.param2Enabled;
        }

        public String toString() {
            return this.title;
        }
    }
}

