/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellData;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.RefocusDialogCtrlBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Window;

public class CustomSortCtrl
extends RefocusDialogCtrlBase {
    private static final long serialVersionUID = 1L;
    public static String URI = "~./zssex/dlg/customSort.zul";
    public static String ARG_SELECTION = "selection";
    public static String ARG_SHEET = "sheet";
    public static String ARG_CASE_SENSITIVE = "caseSensitive";
    public static String ARG_HAS_HEADER = "hasHeader";
    public static String ARG_ORIENTATION = "orientation";
    public static String ARG_RULES = "rules";
    protected ListModelList<SortRule> sortRuleModel;
    protected List<String> availableSortIndex = new ArrayList<String>();
    @Wire
    protected Caption rangeCaption;
    @Wire
    protected Listbox sortRuleBox;
    @Wire
    protected Checkbox caseSensitiveBox;
    @Wire
    protected Checkbox hasHeaderBox;
    @Wire
    protected Combobox sortOrientationBox;
    @Wire
    protected Button addBtn;
    @Wire
    protected Button delBtn;
    @Wire
    protected Button upBtn;
    @Wire
    protected Button downBtn;
    protected AreaRef selection;
    protected Sheet sheet;
    protected ListitemRenderer sortRuleRenderer = new ListitemRenderer(){

        public void render(Listitem item, Object data, int index) throws Exception {
            item.setZclass("zss-listitem");
            Listcell cell = new Listcell();
            cell.setZclass("zss-listcell");
            SortRule sort = (SortRule)data;
            cell.setLabel(index == 0 ? Labels.getLabel((String)"zssex.dlg.sort.sortBy") : Labels.getLabel((String)"zssex.dlg.sort.thenBy"));
            item.appendChild((Component)cell);
            cell = new Listcell();
            cell.setZclass("zss-listcell");
            item.appendChild((Component)cell);
            SortIndexCombobox indexComp = new SortIndexCombobox(item, sort);
            indexComp.setZclass("zss-combobox");
            cell.appendChild((Component)indexComp);
            cell = new Listcell();
            cell.setZclass("zss-listcell");
            item.appendChild((Component)cell);
            SortAlgorithmCombobox algorComp = new SortAlgorithmCombobox(item, sort);
            algorComp.setZclass("zss-combobox");
            cell.appendChild((Component)algorComp);
        }
    };

    public static void show(EventListener<DialogCallbackEvent> callback, Sheet sheet, AreaRef selection, Spreadsheet ss) {
        Map arg = CustomSortCtrl.newArg(callback);
        arg.put(ARG_SHEET, sheet);
        arg.put(ARG_SELECTION, selection);
        arg.put("spreadsheet", ss);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        this.selection = (AreaRef)arg.get(ARG_SELECTION);
        this.sheet = (Sheet)arg.get(ARG_SHEET);
        this.sortOrientationBox.setSelectedIndex(0);
        this.sortRuleModel = new ListModelList();
        this.sortRuleModel.add((Object)new SortRule());
        this.sortRuleBox.setItemRenderer(this.sortRuleRenderer);
        this.refreshSortRule();
    }

    protected void refreshSortRule() {
        this.updateAvailableList();
        this.sortRuleBox.setModel((ListModel)null);
        this.sortRuleBox.setModel(this.sortRuleModel);
        this.updateButtons();
    }

    protected void updateAvailableList() {
        this.availableSortIndex.clear();
        boolean header = this.hasHeaderBox.isChecked();
        int row1 = this.selection.getRow();
        int row2 = this.selection.getLastRow();
        int col1 = this.selection.getColumn();
        int col2 = this.selection.getLastColumn();
        if (this.sortOrientationBox.getSelectedIndex() == 0) {
            this.hasHeaderBox.setDisabled(false);
            if (!header) {
                for (int i = col1; i <= col2; ++i) {
                    Range r = Ranges.range((Sheet)this.sheet, (int)row1, (int)i);
                    this.availableSortIndex.add(new String("Column " + Ranges.getColumnRefString((int)i)));
                }
                this.rangeCaption.setLabel(new String("(" + Ranges.getAreaRefString((int)row1, (int)col1, (int)row2, (int)col2) + ")"));
            } else if (row1 == row2) {
                for (int i = col1; i <= col2; ++i) {
                    Range r = Ranges.range((Sheet)this.sheet, (int)row1, (int)i);
                    this.availableSortIndex.add(new String("(Column " + Ranges.getColumnRefString((int)i) + ")"));
                }
                this.rangeCaption.setLabel(new String("(" + Ranges.getAreaRefString((int)row1, (int)col1, (int)row2, (int)col2) + ")"));
            } else {
                for (int i = col1; i <= col2; ++i) {
                    Range r = Ranges.range((Sheet)this.sheet, (int)row1, (int)i);
                    this.availableSortIndex.add(new String(r.getCellFormatText()));
                }
                this.rangeCaption.setLabel(new String("(" + Ranges.getAreaRefString((int)(row1 + 1), (int)col1, (int)row2, (int)col2) + ")"));
            }
        } else {
            this.hasHeaderBox.setDisabled(true);
            for (int i = row1; i <= row2; ++i) {
                Range r = Ranges.range((Sheet)this.sheet, (int)i, (int)col1);
                this.availableSortIndex.add(new String("Row " + Ranges.getRowRefString((int)i)));
            }
            this.rangeCaption.setLabel(new String("(" + Ranges.getAreaRefString((int)row1, (int)col1, (int)row2, (int)col2) + ")"));
        }
    }

    @Listen(value="onSelect=#sortRuleBox")
    public void onSelect$sortRuleBox() {
        this.updateButtons();
    }

    protected void updateButtons() {
        int idx = CustomSortCtrl.getSingleSelectionIndex(this.sortRuleModel);
        this.upBtn.setDisabled(idx <= 0);
        this.downBtn.setDisabled(idx < 0 || idx == this.sortRuleModel.size() - 1);
        this.addBtn.setDisabled(this.sortRuleModel.size() >= 3);
        this.delBtn.setDisabled(idx < 0);
    }

    @Listen(value="onClick=#addBtn")
    public void onClick$addBtn() {
        if (this.sortRuleModel.size() >= 3) {
            return;
        }
        this.sortRuleModel.add((Object)new SortRule());
        this.updateButtons();
    }

    @Listen(value="onClick=#delBtn")
    public void onClick$delBtn() {
        int idx = CustomSortCtrl.getSingleSelectionIndex(this.sortRuleModel);
        if (idx < 0) {
            return;
        }
        this.sortRuleModel.remove(idx);
        this.updateButtons();
    }

    @Listen(value="onClick=#upBtn")
    public void onClick$upBtn() {
        int idx = CustomSortCtrl.getSingleSelectionIndex(this.sortRuleModel);
        if (idx <= 0) {
            return;
        }
        SortRule o1 = (SortRule)this.sortRuleModel.get(idx);
        SortRule o2 = (SortRule)this.sortRuleModel.get(idx - 1);
        this.sortRuleModel.set(idx - 1, (Object)o1);
        this.sortRuleModel.set(idx, (Object)o2);
        this.sortRuleModel.addToSelection((Object)o1);
        this.updateButtons();
    }

    @Listen(value="onClick=#downBtn")
    public void onClick$downBtn() {
        int idx = CustomSortCtrl.getSingleSelectionIndex(this.sortRuleModel);
        if (idx < 0 || idx == this.sortRuleModel.size() - 1) {
            return;
        }
        SortRule o1 = (SortRule)this.sortRuleModel.get(idx);
        SortRule o2 = (SortRule)this.sortRuleModel.get(idx + 1);
        this.sortRuleModel.set(idx + 1, (Object)o1);
        this.sortRuleModel.set(idx, (Object)o2);
        this.sortRuleModel.addToSelection((Object)o1);
        this.updateButtons();
    }

    @Listen(value="onOK=#window;onClick=#okBtn")
    public void onClick$okBtn() {
        if (this.checkEmptySortRule(this.sortRuleModel.getInnerList()) || this.checkDuplicateSortIndex(this.sortRuleModel.getInnerList())) {
            return;
        }
        this.postCallback(ON_OK, CustomSortCtrl.newMap(CustomSortCtrl.newEntry(ARG_CASE_SENSITIVE, this.caseSensitiveBox.isChecked()), CustomSortCtrl.newEntry(ARG_HAS_HEADER, this.sortOrientationBox.getSelectedIndex() == 1 ? false : this.hasHeaderBox.isChecked()), CustomSortCtrl.newEntry(ARG_ORIENTATION, this.sortOrientationBox.getSelectedIndex() == 1 ? "row" : "column"), CustomSortCtrl.newEntry(ARG_RULES, this.sortRuleModel.getInnerList())));
        this.detach();
    }

    protected boolean checkEmptySortRule(List<SortRule> list) {
        boolean r = false;
        boolean column = this.sortOrientationBox.getSelectedIndex() == 0;
        int w = this.selection.getLastColumn() - this.selection.getColumn();
        int h = this.selection.getLastRow() - this.selection.getRow();
        for (SortRule s : list) {
            if (s.sortIndex == -1) {
                r = true;
                break;
            }
            if (column && s.sortIndex > w) {
                r = true;
                break;
            }
            if (column || s.sortIndex <= h) continue;
            r = true;
            break;
        }
        if (list.size() == 0 || r) {
            ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.sort.err.hasEmptySortRule"));
            r = true;
        }
        return r;
    }

    protected boolean checkDuplicateSortIndex(List<SortRule> list) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (SortRule s : list) {
            if (map.containsKey(s.sortIndex)) {
                String title = null;
                title = this.sortOrientationBox.getSelectedIndex() == 0 ? Labels.getLabel((String)"zssex.dlg.column") + " " + Ranges.getColumnRefString((int)(this.selection.getColumn() + s.sortIndex)) : Labels.getLabel((String)"zssex.dlg.row") + " " + Ranges.getRowRefString((int)(this.selection.getRow() + s.sortIndex));
                ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.sort.err.duplicateSortRule", (Object[])new Object[]{title}));
                return true;
            }
            map.put(s.sortIndex, true);
        }
        return false;
    }

    @Listen(value="onCheck=#hasHeaderBox")
    public void onCheck$hasHeaderBox() {
        this.refreshSortRule();
    }

    @Listen(value="onSelect=#sortOrientationBox")
    public void onSelect$sortOrientationBox() {
        this.refreshSortRule();
    }

    @Listen(value="onCancel=window; onClick=#cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    public static class SortRule {
        public int sortIndex = 0;
        public boolean ascending = true;

        public String toString() {
            return "{index:" + this.sortIndex + ",ascending:" + this.ascending + "}";
        }
    }

    public class SortAlgorithmCombobox
    extends Combobox {
        protected SortRule sort;
        protected Listitem listitem;
        protected static final String STR_ASCENDING_KEY = "zssex.dlg.sort.str.ascending";
        protected static final String STR_DESCENDING_KEY = "zssex.dlg.sort.str.descending";
        protected static final String NUM_ASCENDING_KEY = "zssex.dlg.sort.num.ascending";
        protected static final String NUM_DESCENDING_KEY = "zssex.dlg.sort.num.descending";

        public SortAlgorithmCombobox(Listitem listitem, SortRule sort) {
            this.sort = sort;
            this.setWidth("100%");
            this.setReadonly(true);
            this.setMold("rounded");
            this.setSclass("zscombobox");
            this.refreshModel();
            listitem.addEventListener("onSortRuleChanged", (EventListener)new SerializableEventListener<Event>(){
                private static final long serialVersionUID = 3238074278451651852L;

                public void onEvent(Event event) throws Exception {
                    if (event.getData() == SortAlgorithmCombobox.this.sort) {
                        SortAlgorithmCombobox.this.refreshModel();
                    }
                }
            });
            listitem.setZclass("zss-listitem");
            this.listitem = listitem;
        }

        protected void refreshModel() {
            ListModelList model = new ListModelList(this.createLabelList());
            model.addToSelection(model.get(this.sort.ascending ? 0 : 1));
            this.setModel((ListModel)model);
        }

        protected List<String> createLabelList() {
            ArrayList<String> list = new ArrayList<String>(2);
            if (this.isAllCellNumberType(this.sort.sortIndex)) {
                list.add(Labels.getLabel((String)NUM_ASCENDING_KEY));
                list.add(Labels.getLabel((String)NUM_DESCENDING_KEY));
            } else {
                list.add(Labels.getLabel((String)STR_ASCENDING_KEY));
                list.add(Labels.getLabel((String)STR_DESCENDING_KEY));
            }
            return list;
        }

        protected boolean isAllCellNumberType(int idx) {
            boolean column = CustomSortCtrl.this.sortOrientationBox.getSelectedIndex() == 0;
            boolean header = CustomSortCtrl.this.hasHeaderBox.isChecked();
            if (column) {
                int col = CustomSortCtrl.this.selection.getColumn() + idx;
                int lrow = CustomSortCtrl.this.selection.getLastRow();
                for (int row = CustomSortCtrl.this.selection.getRow() + (header ? 1 : 0); row <= lrow; ++row) {
                    Range r = Ranges.range((Sheet)CustomSortCtrl.this.sheet, (int)row, (int)col);
                    if (r.getCellData().getResultType() == CellData.CellType.NUMERIC) continue;
                    return false;
                }
            } else {
                int row = CustomSortCtrl.this.selection.getRow() + idx;
                int lcol = CustomSortCtrl.this.selection.getLastColumn();
                for (int col = CustomSortCtrl.this.selection.getColumn() + (header ? 1 : 0); col <= lcol; ++col) {
                    Range r = Ranges.range((Sheet)CustomSortCtrl.this.sheet, (int)row, (int)col);
                    if (r.getCellData().getResultType() == CellData.CellType.NUMERIC) continue;
                    return false;
                }
            }
            return true;
        }

        public void onSelect(SelectEvent evt) {
            this.sort.ascending = CustomSortCtrl.getSingleSelectionIndex(this.getModel()) != 1;
        }
    }

    public class SortIndexCombobox
    extends Combobox {
        SortRule sort;
        Listitem listitem;

        public SortIndexCombobox(Listitem listitem, SortRule sort) {
            this.setWidth("100%");
            this.setReadonly(true);
            this.setMold("rounded");
            this.setSclass("zscombobox");
            this.sort = sort;
            ListModelList model = new ListModelList(CustomSortCtrl.this.availableSortIndex);
            if (sort.sortIndex >= 0 && sort.sortIndex < model.size()) {
                model.addToSelection(model.get(sort.sortIndex));
            } else if (model.size() == 0) {
                sort.sortIndex = -1;
            }
            this.setModel((ListModel)model);
            listitem.setZclass("zss-combobox");
            this.listitem = listitem;
        }

        public void onSelect() {
            this.sort.sortIndex = CustomSortCtrl.getSingleSelectionIndex(this.getModel());
            Events.postEvent((Event)new Event("onSortRuleChanged", (Component)this.listitem, (Object)this.sort));
        }
    }
}

