/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.model.SAutoFilter;
import io.keikai.model.SCell;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.STop10Filter;
import io.keikai.model.impl.AutoFilterImpl;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import io.keikai.range.impl.FilterRowInfo;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.DialogCtrlBase;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ZssContext;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Window;

public class CustomFiltersCtrl
extends DialogCtrlBase {
    private static final long serialVersionUID = 9029733549704530911L;
    public static String URI = "~./zssex/dlg/customFilters.zul";
    public static String ARG_F1_OP = "f1op";
    public static String ARG_F2_OP = "f2op";
    public static String ARG_F1_VAL = "f1val";
    public static String ARG_F2_VAL = "f2val";
    public static String ARG_F1_DISPLAY = "f1display";
    public static String ARG_F2_DISPLAY = "f2display";
    public static String ARG_ANDOR = "andor";
    public static String ARG_ROW_TEXTS = "rowtexts";
    public static String ARG_FILTER_TYPE = "filterType";
    protected ListModelList<SAutoFilter.FilterOp> f1opsModel;
    protected ListModelList<SAutoFilter.FilterOp> f2opsModel;
    protected ListModelList<FilterRowInfo> f1valsModel;
    protected ListModelList<FilterRowInfo> f2valsModel;
    @Wire
    protected Button okBtn;
    @Wire
    protected Listbox f1operators;
    @Wire
    protected Combobox f1values;
    @Wire
    protected Listbox f2operators;
    @Wire
    protected Combobox f2values;
    @Wire
    protected Radiogroup andor;

    public static void show(EventListener<DialogCallbackEvent> callback, SAutoFilter filter, int index, SAutoFilter.FilterOp op) {
        SAutoFilter.NFilterColumn fc = filter.getFilterColumn(index, false);
        SCustomFilters cusf = fc == null ? null : fc.getCustomFilters();
        Boolean isAnd = cusf == null ? Boolean.TRUE.booleanValue() : cusf.isAnd();
        SCustomFilter f1 = cusf == null ? null : cusf.getCustomFilter1();
        SCustomFilter f2 = cusf == null ? null : cusf.getCustomFilter2();
        int filterType = ((AutoFilterImpl)filter).getFilterType(index);
        Object val = null;
        Object val2 = null;
        SAutoFilter.FilterOp f1op = null;
        SAutoFilter.FilterOp f2op = null;
        if (op == SAutoFilter.FilterOp.between || op == SAutoFilter.FilterOp.betweenDates) {
            f1op = SAutoFilter.FilterOp.greaterThanOrEqual;
            f2op = SAutoFilter.FilterOp.lessThanOrEqual;
        } else {
            f1op = op;
        }
        if (f1op != SAutoFilter.FilterOp.custom) {
            if (f1op != (f1 != null ? f1.getOperator() : null) || f2op != (f2 != null ? f2.getOperator() : null)) {
                f1 = null;
                f2 = null;
                isAnd = true;
            }
        } else {
            SDynamicFilter df;
            SDynamicFilter sDynamicFilter = df = fc == null ? null : fc.getDynamicFilter();
            if (df != null) {
                SAutoFilter.FilterOp opx = SAutoFilter.FilterOp.valueOf((String)df.getType());
                switch (opx) {
                    case aboveAverage: {
                        op = SAutoFilter.FilterOp.greaterThan;
                        val = df.getValue();
                        break;
                    }
                    case belowAverage: {
                        op = SAutoFilter.FilterOp.lessThan;
                        val = df.getValue();
                        break;
                    }
                    case before: 
                    case after: 
                    case betweenDates: 
                    case tomorrow: 
                    case today: 
                    case yesterday: 
                    case nextWeek: 
                    case thisWeek: 
                    case lastWeek: 
                    case nextMonth: 
                    case thisMonth: 
                    case lastMonth: 
                    case nextQuarter: 
                    case thisQuarter: 
                    case lastQuarter: 
                    case nextYear: 
                    case thisYear: 
                    case lastYear: 
                    case yearToDate: {
                        op = SAutoFilter.FilterOp.within;
                        val = CustomFiltersCtrl.formatDateText(df.getValue());
                        val2 = CustomFiltersCtrl.formatDateText(df.getMaxValue());
                        break;
                    }
                    default: {
                        op = SAutoFilter.FilterOp.equal;
                        break;
                    }
                }
            } else {
                STop10Filter tf;
                STop10Filter sTop10Filter = tf = fc == null ? null : fc.getTop10Filter();
                if (tf != null) {
                    op = tf.isTop() ? SAutoFilter.FilterOp.greaterThanOrEqual : SAutoFilter.FilterOp.lessThanOrEqual;
                    val = tf.getFilterValue();
                }
            }
        }
        SAutoFilter.FilterOp filterOp = f1 == null ? (op == null ? SAutoFilter.FilterOp.equal : (op == SAutoFilter.FilterOp.within ? SAutoFilter.FilterOp.afterEq : op)) : (f1op = f1.getOperator());
        SAutoFilter.FilterOp filterOp2 = f2 == null ? (op == SAutoFilter.FilterOp.within ? SAutoFilter.FilterOp.before : SAutoFilter.FilterOp.none) : (f2op = f2.getOperator());
        if (filterType == 1) {
            f1op = CustomFiltersCtrl.convertToDateOp(f1op);
            f2op = CustomFiltersCtrl.convertToDateOp(f2op);
        }
        if (f1 != null) {
            if (filterType == 1) {
                val = CustomFiltersCtrl.parseInput(f1.getValue());
                val = CustomFiltersCtrl.formatDateText(val);
            } else {
                val = Optional.ofNullable(f1.getDisplayValue()).orElse(f1.getValue());
            }
            if (f2 != null) {
                if (filterType == 1) {
                    val2 = CustomFiltersCtrl.parseInput(f2.getValue());
                    val2 = CustomFiltersCtrl.formatDateText(val2);
                } else {
                    val2 = Optional.ofNullable(f2.getDisplayValue()).orElse(f2.getValue());
                }
            }
        }
        String f1val = val == null ? "" : val.toString();
        String f2val = val2 == null ? "" : val2.toString();
        List rowInfos = ((AutoFilterImpl)filter).getCachedSet(index);
        Map arg = CustomFiltersCtrl.newArg(callback);
        arg.put(ARG_F1_OP, f1op);
        arg.put(ARG_F2_OP, f2op);
        arg.put(ARG_ANDOR, isAnd);
        arg.put(ARG_F1_VAL, f1val);
        arg.put(ARG_F2_VAL, f2val);
        arg.put(ARG_ROW_TEXTS, rowInfos);
        arg.put(ARG_FILTER_TYPE, filterType);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    public static SAutoFilter.FilterOp convertToDateOp(SAutoFilter.FilterOp op) {
        if (op == null) {
            return op;
        }
        switch (op) {
            case greaterThan: {
                return SAutoFilter.FilterOp.after;
            }
            case greaterThanOrEqual: {
                return SAutoFilter.FilterOp.afterEq;
            }
            case lessThan: {
                return SAutoFilter.FilterOp.before;
            }
            case lessThanOrEqual: {
                return SAutoFilter.FilterOp.beforeEq;
            }
            case between: {
                return SAutoFilter.FilterOp.betweenDates;
            }
        }
        return op;
    }

    public static boolean isDateOp(SAutoFilter.FilterOp op) {
        return op == SAutoFilter.FilterOp.before || op == SAutoFilter.FilterOp.beforeEq || op == SAutoFilter.FilterOp.after || op == SAutoFilter.FilterOp.afterEq;
    }

    public static Object parseInput(String editText) {
        if (editText == null) {
            editText = "";
        }
        if (editText.startsWith("=")) {
            return editText;
        }
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        InputResult irx = ie.parseInput(editText, "General", new InputParseContext(ZssContext.getCurrent().getLocale()));
        if (irx.getType() != SCell.CellType.NUMBER && irx.getType() != SCell.CellType.STRING) {
            return editText;
        }
        return irx.getValue();
    }

    public static String formatDateText(Object val) {
        FormatContext formatContext = new FormatContext(ZssContext.getCurrent().getLocale());
        FormatEngineImpl formatEngine = new FormatEngineImpl();
        String format = "m/d/yyyy";
        if (!(val instanceof Number) && !(val instanceof Date)) {
            return val.toString();
        }
        if (val instanceof Number) {
            val = DateUtil.getJavaDate((double)((Number)val).doubleValue(), (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        FormatResult result = formatEngine.format("m/d/yyyy", val, formatContext, 8);
        return result.getText();
    }

    protected void init(SAutoFilter.FilterOp f1op, String f1val, boolean isAnd, SAutoFilter.FilterOp f2op, String f2val, List<FilterRowInfo> rowInfos) {
        this.f1opsModel = this.newOps(f1op);
        HashSet<SAutoFilter.FilterOp> f1ops = new HashSet<SAutoFilter.FilterOp>();
        f1ops.add(f1op);
        this.f1opsModel.setSelection(f1ops);
        this.f1operators.setModel(this.f1opsModel);
        this.andor.setSelectedIndex(isAnd ? 0 : 1);
        this.f2opsModel = this.newOps(f1op);
        HashSet<SAutoFilter.FilterOp> f2ops = new HashSet<SAutoFilter.FilterOp>();
        f2ops.add(f2op);
        this.f2opsModel.setSelection(f2ops);
        this.f2operators.setModel(this.f2opsModel);
        this.f1valsModel = rowInfos == null ? new ListModelList() : new ListModelList(rowInfos);
        this.f1values.setModel(this.f1valsModel);
        this.f1values.setValue(f1val);
        this.f2valsModel = rowInfos == null ? new ListModelList() : new ListModelList(rowInfos);
        this.f2values.setModel(this.f2valsModel);
        this.f2values.setValue(f2val);
    }

    protected ListModelList newOps(SAutoFilter.FilterOp op) {
        ListModelList opmodel = new ListModelList();
        opmodel.add((Object)SAutoFilter.FilterOp.none);
        opmodel.add((Object)SAutoFilter.FilterOp.equal);
        opmodel.add((Object)SAutoFilter.FilterOp.notEqual);
        switch (op) {
            case before: 
            case after: 
            case betweenDates: 
            case tomorrow: 
            case today: 
            case yesterday: 
            case nextWeek: 
            case thisWeek: 
            case lastWeek: 
            case nextMonth: 
            case thisMonth: 
            case lastMonth: 
            case nextQuarter: 
            case thisQuarter: 
            case lastQuarter: 
            case nextYear: 
            case thisYear: 
            case lastYear: 
            case yearToDate: 
            case afterEq: 
            case beforeEq: 
            case Q1: 
            case Q2: 
            case Q3: 
            case Q4: 
            case M1: 
            case M2: 
            case M3: 
            case M4: 
            case M5: 
            case M6: 
            case M7: 
            case M8: 
            case M9: 
            case M10: 
            case M11: 
            case M12: {
                opmodel.add((Object)SAutoFilter.FilterOp.after);
                opmodel.add((Object)SAutoFilter.FilterOp.afterEq);
                opmodel.add((Object)SAutoFilter.FilterOp.before);
                opmodel.add((Object)SAutoFilter.FilterOp.beforeEq);
                break;
            }
            default: {
                opmodel.add((Object)SAutoFilter.FilterOp.greaterThan);
                opmodel.add((Object)SAutoFilter.FilterOp.greaterThanOrEqual);
                opmodel.add((Object)SAutoFilter.FilterOp.lessThan);
                opmodel.add((Object)SAutoFilter.FilterOp.lessThanOrEqual);
            }
        }
        opmodel.add((Object)SAutoFilter.FilterOp.beginWith);
        opmodel.add((Object)SAutoFilter.FilterOp.notBeginWith);
        opmodel.add((Object)SAutoFilter.FilterOp.endWith);
        opmodel.add((Object)SAutoFilter.FilterOp.notEndWith);
        opmodel.add((Object)SAutoFilter.FilterOp.contains);
        opmodel.add((Object)SAutoFilter.FilterOp.notContains);
        return opmodel;
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        SAutoFilter.FilterOp f1op = (SAutoFilter.FilterOp)arg.get(ARG_F1_OP);
        SAutoFilter.FilterOp f2op = (SAutoFilter.FilterOp)arg.get(ARG_F2_OP);
        String f1val = (String)arg.get(ARG_F1_VAL);
        String f2val = (String)arg.get(ARG_F2_VAL);
        Boolean isAnd = (Boolean)arg.get(ARG_ANDOR);
        List rowInfos = (List)arg.get(ARG_ROW_TEXTS);
        int type = (Integer)arg.get(ARG_FILTER_TYPE);
        this.init(f1op, f1val, isAnd, f2op, f2val, rowInfos);
    }

    @Listen(value="onOK=window; onClick=#okBtn;")
    public void onOK() {
        SAutoFilter.FilterOp f1op = (SAutoFilter.FilterOp)this.f1opsModel.getSelection().iterator().next();
        SAutoFilter.FilterOp f2op = (SAutoFilter.FilterOp)this.f2opsModel.getSelection().iterator().next();
        Set f1valSelSet = this.f1valsModel.getSelection();
        Set f2valSelSet = this.f2valsModel.getSelection();
        FilterRowInfo f1valInfo = f1valSelSet == null || f1valSelSet.isEmpty() ? null : (FilterRowInfo)f1valSelSet.iterator().next();
        FilterRowInfo f2valInfo = f2valSelSet == null || f2valSelSet.isEmpty() ? null : (FilterRowInfo)f2valSelSet.iterator().next();
        Object f1val = null;
        Object f2val = null;
        switch (f1op) {
            case equal: 
            case notEqual: 
            case beginWith: 
            case notBeginWith: 
            case endWith: 
            case notEndWith: 
            case contains: 
            case notContains: {
                f1val = f1valInfo != null ? f1valInfo.getDisplay() : this.f1values.getValue();
                break;
            }
            default: {
                Object object = f1val = f1valInfo != null ? CustomFiltersCtrl.parseInput(f1valInfo.getDisplay()) : CustomFiltersCtrl.parseInput(this.f1values.getValue());
                if (!(f1val instanceof Date)) break;
                f1val = DateUtil.getExcelDate((Date)((Date)f1val));
            }
        }
        switch (f2op) {
            case equal: 
            case notEqual: 
            case beginWith: 
            case notBeginWith: 
            case endWith: 
            case notEndWith: 
            case contains: 
            case notContains: {
                f2val = f2valInfo != null ? f2valInfo.getDisplay() : this.f2values.getValue();
                break;
            }
            default: {
                Object object = f2val = f2valInfo != null ? CustomFiltersCtrl.parseInput(f2valInfo.getDisplay()) : CustomFiltersCtrl.parseInput(this.f2values.getValue());
                if (!(f2val instanceof Date)) break;
                f2val = DateUtil.getExcelDate((Date)((Date)f2val));
            }
        }
        Boolean isAnd = this.andor.getSelectedIndex() == 0;
        this.postCallback(ON_OK, CustomFiltersCtrl.newMap(CustomFiltersCtrl.newEntry(ARG_F1_OP, f1op), CustomFiltersCtrl.newEntry(ARG_F1_VAL, f1val), CustomFiltersCtrl.newEntry(ARG_F1_DISPLAY, f1valInfo != null ? f1valInfo.getDisplay() : null), CustomFiltersCtrl.newEntry(ARG_ANDOR, isAnd), CustomFiltersCtrl.newEntry(ARG_F2_OP, f2op), CustomFiltersCtrl.newEntry(ARG_F2_VAL, f2val), CustomFiltersCtrl.newEntry(ARG_F2_DISPLAY, f2valInfo != null ? f2valInfo.getDisplay() : null)));
        this.detach();
    }

    @Listen(value="onCancel = window; onClick = #cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }
}

