/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.model.sys;

import io.keikai.model.SBook;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.impl.sys.DependencyTableImpl;
import io.keikai.model.sys.dependency.ColumnPrecedentRef;
import io.keikai.model.sys.dependency.ConditionalRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.dependency.StyleRef;
import io.keikaiex.model.sys.SheetTracker;
import io.keikaiex.util.Interval;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class DependencyTableEx
extends DependencyTableImpl {
    private static final long serialVersionUID = -5868552271149633187L;
    private static final Logger _logger = LoggerFactory.getLogger(DependencyTableEx.class);
    private static final int MAX_ROW_LIMIT = 1048575;
    private static final int MAX_COL_LIMIT = 16383;
    public static final String DEPENDENT_CACHE = "dependentCache";
    private Map<Ref, Set<Ref>> _premap = new LinkedHashMap<Ref, Set<Ref>>();
    private Map<String, SheetTracker> _trackers = new HashMap<String, SheetTracker>();
    private Map<String, Set<Ref>> _refErrorPrecedents = new HashMap<String, Set<Ref>>();

    public Set<Ref> getDependents(Ref precedent) {
        LinkedHashSet<Ref> results = new LinkedHashSet<Ref>();
        HashSet<Ref> hasWatched = new HashSet<Ref>();
        this.getDependents0(precedent, results, hasWatched);
        return results;
    }

    private void getDependents0(Ref precedent, Set<Ref> results, HashSet<Ref> hasWatched) {
        Set<Ref> dependents = this.getDirectDependents(precedent, hasWatched);
        for (Ref ref : dependents) {
            if (results.contains(ref)) continue;
            this.handleConditionalRef(precedent, ref, results);
            results.add(ref);
            this.getDependents0(ref, results, hasWatched);
        }
    }

    private HashMap<Ref, Set<Ref>> getOrCreateDependentCacheMap() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return null;
        }
        HashMap dependentCache = (HashMap)execution.getAttribute(DEPENDENT_CACHE);
        if (dependentCache == null) {
            dependentCache = new HashMap();
            execution.setAttribute(DEPENDENT_CACHE, dependentCache);
        }
        return dependentCache;
    }

    private Set<Ref> getDependentCache(Ref precedent) {
        HashMap<Ref, Set<Ref>> dependentCache = this.getOrCreateDependentCacheMap();
        if (dependentCache != null) {
            return dependentCache.get(precedent);
        }
        return null;
    }

    private void putDependentCache(Ref precedent, Set<Ref> dependents) {
        HashMap<Ref, Set<Ref>> dependentCache;
        if (dependents.isEmpty()) {
            dependents = Collections.emptySet();
        }
        if ((dependentCache = this.getOrCreateDependentCacheMap()) != null) {
            dependentCache.put(precedent, dependents);
        }
    }

    private void clearDependentCacheMap() {
        HashMap<Ref, Set<Ref>> dependentCache = this.getOrCreateDependentCacheMap();
        if (dependentCache != null) {
            dependentCache.clear();
        }
    }

    private void handleConditionalRef(Ref precedent, Ref ref, Set<Ref> results) {
        if (ref instanceof ConditionalRef) {
            results.add((Ref)StyleRef.inst);
        }
    }

    private Set<Ref> getDirectDependents(Ref precedent, Set<Ref> hasWatched) {
        Set<Ref> cachedDependents = this.getDependentCache(precedent);
        if (cachedDependents != null) {
            return cachedDependents;
        }
        LinkedHashSet<Ref> dependents = new LinkedHashSet<Ref>();
        if (_regionTypes.contains(precedent.getType())) {
            Collection<Interval<Ref>> overlaps = this.overlaps(precedent);
            if (overlaps != null) {
                for (Interval<Ref> ip : overlaps) {
                    Set<Ref> refs;
                    Ref payload = ip.getPayload();
                    if (hasWatched.contains(payload)) continue;
                    hasWatched.add(payload);
                    if (this._map.containsKey(payload)) {
                        dependents.add(payload);
                    }
                    if ((refs = this._premap.get(payload)) != null) {
                        dependents.addAll(refs);
                    }
                    dependents.remove(precedent);
                }
            }
        } else {
            Set<Ref> refs = this._premap.get(precedent);
            if (refs != null) {
                dependents.addAll(refs);
            }
        }
        this.putDependentCache(precedent, dependents);
        return dependents;
    }

    public Set<Ref> getDirectDependents(Ref precedent) {
        return this.getDirectDependents(precedent, new HashSet<Ref>());
    }

    public Set<Ref> getEvaluatedDependents(Ref precedent) {
        this.handlePrecedentUpdate(precedent);
        LinkedHashSet<Ref> results = new LinkedHashSet<Ref>();
        HashSet<Ref> hasWatched = new HashSet<Ref>();
        this.getDependents0(precedent, results, hasWatched);
        return results;
    }

    public void add(Ref dependant, Ref precedent) {
        dependant = this.insertRef(dependant);
        precedent = this.insertRef(precedent);
        super.add(dependant, precedent);
        Set<Ref> dependents = this._premap.get(precedent);
        if (dependents == null) {
            dependents = new LinkedHashSet<Ref>();
            this._premap.put(precedent, dependents);
        }
        dependents.add(dependant);
        this.clearDependentCacheMap();
    }

    public void setEvaluated(Ref dependent) {
    }

    public void clearDependents(Ref ref) {
        this.clearDependents(ref, null);
    }

    public void clearDependents(Ref ref, Ref.RefType skipType) {
        Set precedents = (Set)this._map.remove(ref);
        if (precedents != null) {
            for (Ref precedent : precedents) {
                if (skipType != null && precedent.getType() == skipType) continue;
                this.clearPrecedent(precedent, ref);
            }
        }
        if (skipType == null || precedents == null || precedents.isEmpty()) {
            this._evaledMap.remove(ref);
        }
        if (skipType != null && precedents != null && !precedents.isEmpty()) {
            this._map.put(ref, precedents);
        }
        if (this._premap.get(ref) == null || this._premap.get(ref).isEmpty()) {
            this.deleteRef(ref);
        }
        if (precedents != null) {
            for (Ref precedent : precedents) {
                if (precedent.getType() != Ref.RefType.INDIRECT && precedent.getType() != Ref.RefType.OFFSET || this._premap.get(precedent) != null && !this._premap.get(precedent).isEmpty()) continue;
                this.clearDependents(precedent);
            }
        }
        this.clearDependentCacheMap();
    }

    public void del(Ref ref, Ref precedent) {
        Set precedents = (Set)this._map.get(ref);
        if (precedents != null) {
            precedents.remove(precedent);
            if (precedents.isEmpty()) {
                this._map.remove(ref);
            }
        }
        this.clearPrecedent(precedent, ref);
        Set evaled = (Set)this._evaledMap.get(ref);
        if (evaled != null) {
            evaled.remove(precedent);
            if (evaled.isEmpty()) {
                this._evaledMap.remove(ref);
            }
        }
        if (this._premap.get(ref) == null || this._premap.get(ref).isEmpty()) {
            this.deleteRef(ref);
        }
    }

    public void merge(DependencyTableAdv dependencyTable) {
        super.merge(dependencyTable);
        if (!(dependencyTable instanceof DependencyTableEx)) {
            _logger.error("can't merge different type of dependency table: " + dependencyTable.getClass().getName() + " to this advanced dependency table: " + ((Object)((Object)this)).getClass().getName());
            return;
        }
        DependencyTableEx another = (DependencyTableEx)dependencyTable;
        this.mergeAllRefs(this._premap, another._premap);
        this._trackers.putAll(another._trackers);
        this.mergeAllRefs(this._refErrorPrecedents, another._refErrorPrecedents);
        this.clearDependentCacheMap();
    }

    public void adjustSheetIndex(String bookName, int index, int size) {
        SheetTracker tracker = this.getTracker(bookName);
        if (tracker != null) {
            tracker.adjustSheetIndex(index, size);
        }
        this.clearDependentCacheMap();
    }

    public void moveSheetIndex(String bookName, int oldIndex, int newIndex) {
        SheetTracker tracker = this.getTracker(bookName);
        if (tracker != null) {
            tracker.moveSheetIndex(oldIndex, newIndex);
        }
        this.clearDependentCacheMap();
    }

    private String getKey(String bookName, String sheetName) {
        return bookName + "]" + sheetName;
    }

    private Ref insertRef(Ref ref) {
        if (_regionTypes.contains(ref.getType())) {
            SheetTracker tracker = this.getTracker(ref);
            if (tracker != null) {
                Interval<Ref> intv = tracker.insertRef(ref);
                if (intv == null) {
                    this.registerRefErrorPrecedent(ref);
                    return ref;
                }
                return intv.getPayload();
            }
            this.registerRefErrorPrecedent(ref);
        }
        return ref;
    }

    private void registerRefErrorPrecedent(Ref ref) {
        String bookName = ref.getBookName();
        String sht1 = ref.getSheetName();
        String sht2 = ref.getLastSheetName();
        if (sht1 != null) {
            this.handleRefErrorPrecedents(ref, this.getKey(bookName, sht1));
        }
        if (sht2 != null && !sht1.equals(sht2)) {
            this.handleRefErrorPrecedents(ref, this.getKey(bookName, sht2));
        }
    }

    private void handleRefErrorPrecedents(Ref ref, String key) {
        Set<Ref> precedents = this._refErrorPrecedents.get(key);
        if (precedents == null) {
            precedents = new HashSet<Ref>();
            this._refErrorPrecedents.put(key, precedents);
        }
        precedents.add(ref);
    }

    private void handlePrecedentUpdate(Ref precedent) {
        if (!this._refErrorPrecedents.isEmpty() && _regionTypes.contains(precedent.getType())) {
            String key;
            String bookName = precedent.getBookName();
            String sheetName = precedent.getSheetName();
            SBook book = this._books.getBook(bookName);
            if (book != null && this._refErrorPrecedents.containsKey(key = this.getKey(bookName, sheetName)) && book.getSheetIndex(sheetName) >= 0) {
                Set<Ref> precedents = this._refErrorPrecedents.remove(key);
                for (Ref p : precedents) {
                    if (!bookName.equals(p.getBookName()) || !sheetName.equals(p.getSheetName()) && !sheetName.equals(p.getLastSheetName())) continue;
                    this.insertRef(p);
                }
            }
        }
    }

    private void deleteRef(Ref ref) {
        SheetTracker tracker;
        if (_regionTypes.contains(ref.getType()) && (tracker = this.getTracker(ref)) != null) {
            tracker.deleteRef(ref);
        }
    }

    private Collection<Interval<Ref>> overlaps(Ref ref) {
        SheetTracker tracker;
        if (_regionTypes.contains(ref.getType()) && (tracker = this.getTracker(ref)) != null) {
            return tracker.overlaps(ref);
        }
        return Collections.emptySet();
    }

    private SheetTracker getTracker(Ref ref) {
        return this.getTracker(ref.getBookName());
    }

    private SheetTracker getTracker(String bookName) {
        SBook book;
        SheetTracker tracker = this._trackers.get(bookName);
        if (tracker == null && (book = this._books.getBook(bookName)) != null) {
            tracker = new SheetTracker(book, 1048575, 16383);
            this._trackers.put(bookName, tracker);
        }
        return tracker;
    }

    private void clearPrecedent(Ref precedent, Ref ref) {
        Set<Ref> dependents = this._premap.get(precedent);
        if (dependents != null) {
            dependents.remove(ref);
            if (dependents.isEmpty()) {
                this._premap.remove(precedent);
                if (this._map.get(precedent) == null || ((Set)this._map.get(precedent)).isEmpty()) {
                    this.deleteRef(precedent);
                }
            }
        }
        this.clearDependentCacheMap();
    }

    public Set<Ref> getDirectRegionPrecedents(Ref dependent) {
        Set precedents = this.getDirectPrecedents(dependent);
        if (precedents != null) {
            HashSet<Ref> results = new HashSet<Ref>(precedents.size());
            this.filterNonRegionPrecedents(precedents, results, new HashSet<Ref>(precedents.size()));
            return results;
        }
        return Collections.emptySet();
    }

    private void filterNonRegionPrecedents(Set<Ref> pres, Set<Ref> results, Set<Ref> hasWatched) {
        for (Ref pre : pres) {
            Set pres0;
            if (hasWatched.contains(pre)) continue;
            hasWatched.add(pre);
            if (_regionTypes.contains(pre.getType())) {
                results.add(pre);
                continue;
            }
            if (pre instanceof ColumnPrecedentRef || (pres0 = (Set)this._map.get(pre)) == null) continue;
            this.filterNonRegionDependents(pres0, results, hasWatched);
        }
    }

    public Set<Ref> getRegionPrecedents(Ref dependent) {
        LinkedHashSet<Ref> results = new LinkedHashSet<Ref>();
        HashSet<Ref> hasWatched = new HashSet<Ref>();
        this.getPrecedents0(dependent, results, hasWatched);
        return results;
    }

    private Set<Ref> getOverlapDependents(Ref pre, Set<Ref> hasWatched) {
        if (_regionTypes.contains(pre.getType())) {
            Collection<Interval<Ref>> overlaps = this.overlaps(pre);
            if (overlaps != null) {
                LinkedHashSet<Ref> dependents = new LinkedHashSet<Ref>();
                for (Interval<Ref> ip : overlaps) {
                    Ref payload = ip.getPayload();
                    if (hasWatched.contains(payload)) continue;
                    hasWatched.add(payload);
                    if (!this._map.containsKey(payload)) continue;
                    dependents.add(payload);
                }
                return dependents;
            }
        } else {
            Set<Ref> refs = this._premap.get(pre);
            if (refs != null) {
                return new LinkedHashSet<Ref>(refs);
            }
        }
        return Collections.emptySet();
    }

    private void getPrecedents0(Ref dependent, Set<Ref> results, HashSet<Ref> hasWatched) {
        Set precedents = super.getDirectPrecedents(dependent);
        if (precedents != null) {
            for (Ref pre : precedents) {
                if (results.contains(pre)) continue;
                results.add(pre);
                Set<Ref> dependents = this.getOverlapDependents(pre, hasWatched);
                for (Ref dep : dependents) {
                    this.getPrecedents0(dep, results, hasWatched);
                }
            }
        }
    }

    public Set<Ref> getDirectRegionDependents(Ref precedent) {
        Set<Ref> deps = this.getDirectDependents(precedent, new HashSet<Ref>());
        if (deps != null) {
            LinkedHashSet<Ref> results = new LinkedHashSet<Ref>(deps.size());
            this.filterNonRegionDependents(deps, results, new HashSet<Ref>(deps.size()));
            return results;
        }
        return Collections.emptySet();
    }

    private void filterNonRegionDependents(Set<Ref> deps, Set<Ref> results, Set<Ref> hasWatched) {
        for (Ref dep : deps) {
            if (hasWatched.contains(dep)) continue;
            hasWatched.add(dep);
            if (_regionTypes.contains(dep.getType())) {
                results.add(dep);
                continue;
            }
            Set<Ref> deps0 = this._premap.get(dep);
            if (deps0 == null) continue;
            this.filterNonRegionDependents(deps0, results, hasWatched);
        }
    }

    public Set<Ref> getRegionDependents(Ref precedent) {
        return this.getDependents(precedent);
    }
}

