/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import io.keikai.model.CellRegion;
import io.keikai.model.SCell;
import io.keikai.model.impl.sys.formula.EvalBook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.commons.math3.util.FastMath;
import org.apache.poi.ss.formula.AreaEvalHelper;
import org.apache.poi.ss.formula.CacheAreaEval;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.Mode;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.NumericFunctionHelper;
import org.apache.poi.ss.formula.functions.Rank;
import org.apache.poi.ss.formula.functions.UtilFns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatFunctionImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatFunctionImpl.class);
    public static final Function AVERAGEA = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            List ls = UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex);
            if (ls.isEmpty()) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)ls)).getMean());
        }
    };
    public static final Function BINOMDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double number = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int trails = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double p_s = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            Boolean isCumulative = OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
            if (number > (double)trails || number < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            BinomialDistribution bd = new BinomialDistribution(trails, p_s);
            if (isCumulative.booleanValue()) {
                return NumericFunctionHelper.checkValue((double)bd.cumulativeProbability((int)number));
            }
            return NumericFunctionHelper.checkValue((double)bd.probability((int)number));
        }
    };
    public static final Function CHIDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (x < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ChiSquaredDistribution chi = new ChiSquaredDistribution(df);
            return NumericFunctionHelper.checkValue((double)(1.0 - chi.cumulativeProbability(x)));
        }
    };
    public static final Function CHIINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (p < 0.0 || p > 1.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ChiSquaredDistribution chi = new ChiSquaredDistribution(df);
            return NumericFunctionHelper.checkValue((double)chi.inverseCumulativeProbability(1.0 - p));
        }
    };
    public static final Function EXPONDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double lambda = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = 1.0 / lambda;
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Boolean isCumulative = OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
            ExponentialDistribution expDist = new ExponentialDistribution(mean);
            if (isCumulative.booleanValue()) {
                return NumericFunctionHelper.checkValue((double)expDist.cumulativeProbability(x));
            }
            return NumericFunctionHelper.checkValue((double)expDist.density(x));
        }
    };
    public static final Function FDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double ddf = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            FDistribution fDist = new FDistribution(df, ddf);
            double result = 1.0 - fDist.cumulativeProbability(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function FINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double ddf = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            FDistribution fDist = new FDistribution(df, ddf);
            double result = fDist.inverseCumulativeProbability(1.0 - p);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function GAMMADIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            Boolean isCumulative = OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
            GammaDistribution gammaDist = new GammaDistribution(alpha, beta);
            if (isCumulative.booleanValue()) {
                return NumericFunctionHelper.checkValue((double)gammaDist.cumulativeProbability(x));
            }
            return NumericFunctionHelper.checkValue((double)gammaDist.density(x));
        }
    };
    public static final Function GAMMAINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            GammaDistribution gammaDist = new GammaDistribution(alpha, beta);
            double result = gammaDist.inverseCumulativeProbability(p);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function GAMMALN = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return NumericFunctionHelper.checkValue((double)Gamma.logGamma((double)x));
        }
    };
    public static final Function GEOMEAN = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))).getGeometricMean());
        }
    };
    public static final Function HARMEAN = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double[] values;
            double result = 0.0;
            for (double v : values = UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))) {
                result += 1.0 / v;
            }
            if (result != 0.0) {
                result = (double)values.length / result;
            }
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function HYPGEOMDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            boolean cumulative;
            int s = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int ns = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            int p = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            int np = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            boolean bl = cumulative = args.length <= 4 ? false : StatFunctionImpl.singleOperandEvaluateToBoolean(args[4], srcRowIndex, srcColumnIndex);
            if (s < 0 || s > ns || s > p || s < ns - np + p || ns <= 0 || ns > np || p <= 0 || p > np || np <= 0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            HypergeometricDistribution hDist = new HypergeometricDistribution(np, p, ns);
            double result = cumulative ? hDist.cumulativeProbability(s) : hDist.probability(s);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function INTERCEPT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    };
    public static final Function KURT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))).getKurtosis());
        }
    };
    public static final Function NORMDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double sDev = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = StatFunctionImpl.singleOperandEvaluateToBoolean(args[3], srcRowIndex, srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution(mean, sDev);
            double result = cumulative ? normDist.cumulativeProbability(x) : normDist.density(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function POISSON = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Boolean isCumulative = OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
            PoissonDistribution poiDist = new PoissonDistribution(mean);
            if (isCumulative.booleanValue()) {
                return NumericFunctionHelper.checkValue((double)poiDist.cumulativeProbability((int)x));
            }
            return NumericFunctionHelper.checkValue((double)poiDist.probability((int)x));
        }
    };
    public static final Function SKEW = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))).getSkewness());
        }
    };
    public static final Function SLOPE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            List l0 = AreaEvalHelper.toDoubleList((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            List l1 = AreaEvalHelper.toDoubleList((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            return NumericFunctionHelper.checkValue((double)UtilFns.getRegre((double[])UtilFns.toDoubleArray((List)l1), (double[])UtilFns.toDoubleArray((List)l0)).getSlope());
        }
    };
    public static final Function STDEV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))).getStandardDeviation());
        }
    };
    public static final Function TDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double degree_freedom = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            int tails = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            return StatFunctionImpl.tdist(x, degree_freedom, tails);
        }
    };
    public static final Function TDIST2T = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double degree_freedom = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            return StatFunctionImpl.tdist(x, degree_freedom, 2);
        }
    };
    public static final Function TDISTRT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double degree_freedom = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            return StatFunctionImpl.tdist(x, degree_freedom, 1);
        }
    };
    public static final Function TINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double degree_freedom = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            TDistribution td = new TDistribution(degree_freedom);
            double result = td.inverseCumulativeProbability(1.0 - p / 2.0);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function VAR = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return NumericFunctionHelper.checkValue((double)UtilFns.getStats((double[])UtilFns.toDoubleArray((List)UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex))).getVariance());
        }
    };
    public static final Function WEIBULL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = StatFunctionImpl.singleOperandEvaluateToBoolean(args[3], srcRowIndex, srcColumnIndex);
            WeibullDistribution wb = new WeibullDistribution(alpha, beta);
            double result = cumulative ? wb.cumulativeProbability(x) : wb.density(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function NORMINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double sDev = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution(mean, sDev);
            double result = normDist.inverseCumulativeProbability(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function NORMSDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = args.length <= 1 ? true : StatFunctionImpl.singleOperandEvaluateToBoolean(args[1], srcRowIndex, srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution();
            double result = cumulative ? normDist.cumulativeProbability(x) : normDist.density(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function NORMSINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution();
            double result = normDist.inverseCumulativeProbability(x);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function LOGNORMDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double sDev = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = args.length <= 3 ? true : StatFunctionImpl.singleOperandEvaluateToBoolean(args[3], srcRowIndex, srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution(mean, sDev);
            double logx = FastMath.log((double)x);
            double result = cumulative ? normDist.cumulativeProbability(logx) : normDist.density(logx) / x;
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function LOGNORMINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double sDev = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            NormalDistribution normDist = new NormalDistribution();
            double invx = normDist.inverseCumulativeProbability(x);
            double result = FastMath.exp((double)(invx * sDev + mean));
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function BINOMINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int trial = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            if (trial < 0 || p <= 0.0 || p >= 1.0 || alpha <= 0.0 || alpha >= 1.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            BinomialDistribution binomDist = new BinomialDistribution(trial, p);
            double result = binomDist.inverseCumulativeProbability(alpha);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function BETADIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double a = args.length <= 3 ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double b = args.length <= 4 ? 1.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            return StatFunctionImpl.betadist(x, alpha, beta, true, a, b);
        }
    };
    public static final Function BETA$DIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = StatFunctionImpl.singleOperandEvaluateToBoolean(args[3], srcRowIndex, srcColumnIndex);
            double a = args.length <= 4 ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            double b = args.length <= 5 ? 1.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            return StatFunctionImpl.betadist(x, alpha, beta, cumulative, a, b);
        }
    };
    public static final Function BETAINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double b;
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double alpha = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double beta = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double a = args.length <= 3 ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double d = b = args.length <= 4 ? 1.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            if (alpha <= 0.0 || beta <= 0.0 || p <= 0.0 || p > 1.0 || a == b) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            BetaDistribution betaDist = new BetaDistribution(alpha, beta);
            double result = betaDist.inverseCumulativeProbability(p);
            result = result * (b - a) + a;
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function CHISQDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = StatFunctionImpl.singleOperandEvaluateToBoolean(args[2], srcRowIndex, srcColumnIndex);
            if (x < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ChiSquaredDistribution chi = new ChiSquaredDistribution(df);
            if (cumulative) {
                return NumericFunctionHelper.checkValue((double)chi.cumulativeProbability(x));
            }
            return NumericFunctionHelper.checkValue((double)chi.density(x));
        }
    };
    public static final Function CHISQINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double df = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (p < 0.0 || p > 1.0 || df < 1.0 || df > 1.0E10) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            ChiSquaredDistribution chi = new ChiSquaredDistribution(df);
            return NumericFunctionHelper.checkValue((double)chi.inverseCumulativeProbability(p));
        }
    };
    public static final Function POISSONINV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double mean = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            PoissonDistribution poiDist = new PoissonDistribution(mean);
            return NumericFunctionHelper.checkValue((double)poiDist.inverseCumulativeProbability(p));
        }
    };
    public static final Function CORREL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            ValueEval[] arg0 = new ValueEval[]{args[0]};
            ValueEval[] arg1 = new ValueEval[]{args[1]};
            List ls1 = UtilFns.toList((ValueEval[])arg0, (int)srcRowIndex, (int)srcColumnIndex);
            if (ls1.isEmpty()) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            List ls2 = UtilFns.toList((ValueEval[])arg1, (int)srcRowIndex, (int)srcColumnIndex);
            if (ls2.isEmpty()) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            double[] xa = UtilFns.toDoubleArray((List)ls1);
            DescriptiveStatistics x = UtilFns.getStats((double[])xa);
            double xstd = x.getStandardDeviation();
            int xn = xa.length;
            if (xstd == 0.0 || xn <= 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            double[] ya = UtilFns.toDoubleArray((List)ls2);
            DescriptiveStatistics y = UtilFns.getStats((double[])ya);
            int yn = ya.length;
            double ystd = y.getStandardDeviation();
            if (ystd == 0.0 || yn <= 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            if (xn != yn) {
                throw new EvaluationException(ErrorEval.NA);
            }
            double result = new PearsonsCorrelation().correlation(xa, ya);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function NEGBINOMDIST = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double r = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double k = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double p = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            boolean cumulative = args.length <= 3 ? false : StatFunctionImpl.singleOperandEvaluateToBoolean(args[3], srcRowIndex, srcColumnIndex);
            PascalDistribution normDist = new PascalDistribution((int)k, p);
            double result = cumulative ? normDist.cumulativeProbability((int)r) : normDist.probability((int)r);
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function MODESNGL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            List ls = UtilFns.toList((ValueEval[])args, (int)srcRowIndex, (int)srcColumnIndex);
            double[] vals = UtilFns.toDoubleArray((List)ls);
            return NumericFunctionHelper.checkValue((double)Mode.evaluate((double[])vals));
        }
    };
    public static final Function RANKEQ = new Rank();
    public static final Function LINEST = new Function(){

        public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
            switch (args.length) {
                case 1: {
                    return this.evaluate(srcRowIndex, srcColumnIndex, args[0], null, (ValueEval)BoolEval.TRUE, (ValueEval)BoolEval.FALSE);
                }
                case 2: {
                    return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], (ValueEval)BoolEval.TRUE, (ValueEval)BoolEval.FALSE);
                }
                case 3: {
                    return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2], (ValueEval)BoolEval.FALSE);
                }
                case 4: {
                    return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2], args[3]);
                }
            }
            return ErrorEval.VALUE_INVALID;
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg1, ValueEval arg2, ValueEval arg3, ValueEval arg4) {
            try {
                ValueEval[] arg0 = new ValueEval[]{arg1};
                List ls1 = UtilFns.toList((ValueEval[])arg0, (int)srcRowIndex, (int)srcColumnIndex);
                if (ls1.isEmpty()) {
                    throw new EvaluationException(ErrorEval.DIV_ZERO);
                }
                double[] ya = UtilFns.toDoubleArray((List)ls1);
                double[] xa = null;
                boolean constB = OperandResolver.coerceValueToBoolean((ValueEval)arg3, (boolean)true);
                boolean stats = OperandResolver.coerceValueToBoolean((ValueEval)arg4, (boolean)false);
                if (arg2 != null && !(arg2 instanceof MissingArgEval)) {
                    ValueEval[] args2 = new ValueEval[]{arg2};
                    List ls2 = UtilFns.toList((ValueEval[])args2, (int)srcRowIndex, (int)srcColumnIndex);
                    if (ls2.isEmpty()) {
                        throw new EvaluationException(ErrorEval.DIV_ZERO);
                    }
                    xa = UtilFns.toDoubleArray((List)ls2);
                } else {
                    xa = Arrays.stream(IntStream.rangeClosed(1, ya.length).toArray()).asDoubleStream().toArray();
                }
                if (ya.length > xa.length && ya.length % xa.length == 0) {
                    return ErrorEval.REF_INVALID;
                }
                if (xa.length >= ya.length && xa.length % ya.length == 0) {
                    double[] doubles;
                    double[] dArray;
                    int n = ya.length;
                    int end = xa.length / n;
                    double[][] xData = new double[n][end];
                    SimpleRegression simpleRegression = new SimpleRegression(constB);
                    OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
                    for (int start = 0; start < end; ++start) {
                        for (int i2 = 0; i2 < n; ++i2) {
                            xData[i2][start] = xa[start * n + i2];
                            if (start != 0) continue;
                            simpleRegression.addData(xData[i2][start], ya[i2]);
                        }
                    }
                    regression.newSampleData(ya, xData);
                    if (!constB) {
                        regression.setNoIntercept(true);
                    }
                    ValueEval[] valueEvals = null;
                    if (end == 1) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = simpleRegression.getIntercept();
                        dArray = dArray2;
                        dArray2[1] = simpleRegression.getSlope();
                    } else {
                        dArray = doubles = regression.estimateRegressionParameters();
                    }
                    if (stats) {
                        int i3;
                        double[] dArray3;
                        ArrayList<Object> vals = new ArrayList<Object>((end + 1) * 5);
                        vals.addAll(IntStream.range(0, doubles.length).mapToDouble(i -> doubles[doubles.length - i - 1]).mapToObj(x$0 -> StatFunctionImpl.getValidValue(x$0)).collect(Collectors.toList()));
                        if (end == 1) {
                            double[] dArray4 = new double[2];
                            dArray4[0] = simpleRegression.getInterceptStdErr();
                            dArray3 = dArray4;
                            dArray4[1] = simpleRegression.getSlopeStdErr();
                        } else {
                            dArray3 = regression.estimateRegressionParametersStandardErrors();
                        }
                        double[] standardErrors = dArray3;
                        vals.addAll(IntStream.range(0, standardErrors.length).mapToDouble(i -> standardErrors[standardErrors.length - i - 1]).mapToObj(x$0 -> StatFunctionImpl.getValidValue(x$0)).collect(Collectors.toList()));
                        vals.add(StatFunctionImpl.getValidValue(end == 1 ? simpleRegression.getRSquare() : regression.calculateRSquared()));
                        double meanSquareError = simpleRegression.getMeanSquareError();
                        double standardError = Math.sqrt(meanSquareError);
                        vals.add(StatFunctionImpl.getValidValue(end == 1 ? standardError : regression.estimateRegressionStandardError()));
                        for (int i4 = end - 1; i4 > 0; --i4) {
                            vals.add(ErrorEval.NA);
                        }
                        double rss = end == 1 ? simpleRegression.getSumSquaredErrors() : regression.calculateResidualSumOfSquares();
                        double ess = simpleRegression.getTotalSumSquares() - rss;
                        int df1 = regression.estimateRegressionParameters().length - 1;
                        int df2 = regression.estimateResiduals().length - regression.estimateRegressionParameters().length + (constB ? 0 : 1);
                        double fStatistic = ess / (double)df1 / (rss / (double)df2);
                        vals.add(StatFunctionImpl.getValidValue(fStatistic));
                        vals.add(StatFunctionImpl.getValidValue(df2));
                        for (i3 = end - 1; i3 > 0; --i3) {
                            vals.add(ErrorEval.NA);
                        }
                        vals.add(StatFunctionImpl.getValidValue(ess));
                        vals.add(StatFunctionImpl.getValidValue(rss));
                        for (i3 = end - 1; i3 > 0; --i3) {
                            vals.add(ErrorEval.NA);
                        }
                        valueEvals = vals.toArray(new ValueEval[0]);
                    } else {
                        valueEvals = IntStream.range(0, doubles.length).mapToDouble(i -> doubles[doubles.length - i - 1]).mapToObj(x$0 -> StatFunctionImpl.getValidValue(x$0)).collect(Collectors.toList()).toArray(new ValueEval[0]);
                    }
                    OperationEvaluationContext context = OperationEvaluationContext.getContext();
                    int row = srcRowIndex;
                    int col = srcColumnIndex;
                    int lastRow = srcRowIndex;
                    int lastCol = srcColumnIndex + end;
                    if (context != null) {
                        CellRegion arrayFormulaRegion;
                        SCell cell = ((EvalBook)context.getWorkbook()).getNBook().getSheet(context.getSheetIndex()).getCell(srcRowIndex, srcColumnIndex);
                        CellRegion cellRegion = arrayFormulaRegion = cell.isPartOfArrayFormulaGroup() ? cell.getArrayFormulaRegion() : null;
                        if (arrayFormulaRegion != null) {
                            row = arrayFormulaRegion.getRow();
                            col = arrayFormulaRegion.getColumn();
                            lastRow = arrayFormulaRegion.getLastRow();
                            lastCol = arrayFormulaRegion.getLastColumn();
                        }
                    }
                    return new CacheAreaEval(row, col, lastRow, lastCol, valueEvals);
                }
                return ErrorEval.REF_INVALID;
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }
    };

    protected static final boolean singleOperandEvaluateToBoolean(ValueEval arg, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
        if (arg == null) {
            throw new IllegalArgumentException("arg must not be null");
        }
        ValueEval ve = OperandResolver.getSingleValue((ValueEval)arg, (int)srcRowIndex, (int)srcColumnIndex);
        return OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
    }

    private static final double tdist(double x, double degree_freedom, int tails) throws EvaluationException {
        double result;
        TDistribution td = new TDistribution(degree_freedom);
        if (tails == 1) {
            result = 1.0 - td.cumulativeProbability(x);
        } else if (tails == 2) {
            result = (1.0 - td.cumulativeProbability(x)) * 2.0;
        } else {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        return NumericFunctionHelper.checkValue((double)result);
    }

    private static final double betadist(double x, double alpha, double beta, boolean cumulative, double a, double b) throws EvaluationException {
        if (alpha <= 0.0 || beta <= 0.0 || x < a || x > b || a == b) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        BetaDistribution betaDist = new BetaDistribution(alpha, beta);
        x = (x - a) / (b - a);
        double result = cumulative ? betaDist.cumulativeProbability(x) : betaDist.density(x) / 2.0;
        return NumericFunctionHelper.checkValue((double)result);
    }

    private static ValueEval getValidValue(double value) {
        if (Double.isInfinite(value)) {
            return ErrorEval.NUM_ERROR;
        }
        if (Double.isNaN(value)) {
            return ErrorEval.NA;
        }
        return new NumberEval(value);
    }
}

