/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.poi.ss.formula.CacheAreaEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayFunction;
import org.apache.poi.ss.formula.functions.Function;

public class LookupAndReferenceFunctionImpl {
    public static final Unique UNIQUE = new Unique();

    public static class Unique
    implements Function,
    ArrayFunction {
        public ValueEval evaluateArray(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
            return this.evaluate(args, srcRowIndex, srcColumnIndex);
        }

        public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
            int nIncomingArgs = args.length;
            if (nIncomingArgs < 1 || nIncomingArgs > 3) {
                return ErrorEval.NA;
            }
            try {
                int toRowIndex;
                boolean byCol;
                AreaEval aeRange = Unique.convertRangeArg(args[0]);
                boolean bl = nIncomingArgs >= 2 ? Optional.ofNullable(args[1] instanceof MissingArgEval ? false : OperandResolver.coerceValueToBoolean((ValueEval)args[1], (boolean)false)).orElse(false) : (byCol = false);
                boolean occursOnce = nIncomingArgs == 3 ? Optional.ofNullable(args[2] instanceof MissingArgEval ? false : OperandResolver.coerceValueToBoolean((ValueEval)args[2], (boolean)false)).orElse(false) : false;
                LinkedHashMap<Object, ValueEval> once = occursOnce ? new LinkedHashMap<Object, ValueEval>() : Collections.emptyMap();
                LinkedHashMap<Object, ValueEval> all = new LinkedHashMap<Object, ValueEval>();
                if (byCol) {
                    int lastCol = aeRange.getLastColumn();
                    for (int col = aeRange.getFirstColumn(); col <= lastCol; ++col) {
                        int lastRow = aeRange.getLastRow();
                        for (int row = aeRange.getFirstRow(); row <= lastRow; ++row) {
                            ValueEval absoluteValue = aeRange.getAbsoluteValue(row, col);
                            Object value = Unique.getValue(absoluteValue);
                            if (all.putIfAbsent(value, absoluteValue) == null) {
                                if (!occursOnce) continue;
                                once.put(value, absoluteValue);
                                continue;
                            }
                            if (!occursOnce) continue;
                            once.remove(value);
                        }
                    }
                } else {
                    int lastRow = aeRange.getLastRow();
                    for (int row = aeRange.getFirstRow(); row <= lastRow; ++row) {
                        int lastCol = aeRange.getLastColumn();
                        for (int col = aeRange.getFirstColumn(); col <= lastCol; ++col) {
                            ValueEval absoluteValue = aeRange.getAbsoluteValue(row, col);
                            Object value = Unique.getValue(absoluteValue);
                            if (all.putIfAbsent(value, absoluteValue) == null) {
                                if (!occursOnce) continue;
                                once.put(value, absoluteValue);
                                continue;
                            }
                            if (!occursOnce) continue;
                            once.remove(value);
                        }
                    }
                }
                int size = Math.max(0, occursOnce ? once.size() - 1 : all.size() - 1);
                int toColumnIndex = aeRange.isColumn() ? srcColumnIndex : srcColumnIndex + size;
                int n = toRowIndex = aeRange.isColumn() ? srcRowIndex + size : srcRowIndex;
                if (occursOnce) {
                    return new CacheAreaEval(srcRowIndex, srcColumnIndex, toRowIndex, toColumnIndex, once.values().toArray(new ValueEval[0]));
                }
                return new CacheAreaEval(srcRowIndex, srcColumnIndex, toRowIndex, toColumnIndex, all.values().toArray(new ValueEval[0]));
            }
            catch (EvaluationException ee) {
                return ee.getErrorEval();
            }
            catch (Throwable t) {
                return ErrorEval.VALUE_INVALID;
            }
        }

        private static AreaEval convertRangeArg(ValueEval eval) throws EvaluationException {
            if (eval instanceof AreaEval) {
                return (AreaEval)eval;
            }
            if (eval instanceof RefEval) {
                return ((RefEval)eval).offset(0, 0, 0, 0);
            }
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }

        private static Object getValue(ValueEval valEval) {
            if (valEval instanceof BlankEval) {
                return valEval;
            }
            if (valEval instanceof StringEval) {
                return ((StringEval)valEval).getStringValue();
            }
            if (valEval instanceof NumericValueEval) {
                return ((NumericValueEval)valEval).getNumberValue();
            }
            if (valEval instanceof BoolEval) {
                return ((BoolEval)valEval).getBooleanValue();
            }
            return valEval;
        }
    }
}

