/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.app.impl;

import io.keikai.api.model.Book;
import io.keikai.app.BookInfo;
import io.keikai.app.BookRepository;
import io.keikai.app.impl.BookManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;

public class BookManagerEx
extends BookManagerImpl {
    private static final long serialVersionUID = 3780790531468512803L;
    private static final Logger logger = LoggerFactory.getLogger(BookManagerEx.class);
    private Map<String, BookInfo> infos;
    private Map<String, Book> books;
    private final int DEFAULT_SAVE_PERIOD = 900;
    private ScheduledExecutorService scheduler;

    public BookManagerEx(BookRepository repo) {
        super(repo);
        int period;
        this.infos = new HashMap<String, BookInfo>(this.repo.list().size() + 5);
        this.books = new HashMap<String, Book>(this.repo.list().size() + 5);
        this.DEFAULT_SAVE_PERIOD = 900;
        String orgPeriod = Optional.ofNullable(Library.getProperty((String)"kkapp.save.period.second")).orElse(Library.getProperty((String)"zssapp.save.period.second"));
        int n = period = orgPeriod == null ? 900 : Integer.parseInt(orgPeriod);
        if (period > 0) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BookManagerEx.this.saveAll();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, 0L, period, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Book readBook(BookInfo info) throws IOException {
        Map<String, Book> map = this.books;
        synchronized (map) {
            String bookName = info.getName();
            if (this.books.containsKey(bookName)) {
                return this.books.get(bookName);
            }
            Book book = this.repo.load(info);
            book.setShareScope("application");
            this.books.put(bookName, book);
            this.infos.put(bookName, info);
            return book;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookInfo updateBook(BookInfo info, Book book) throws IOException {
        Map<String, Book> map = this.books;
        synchronized (map) {
            return this.repo.save(info, this.books.get(info.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookInfo saveBook(BookInfo info, Book book) throws IOException {
        Map<String, Book> map = this.books;
        synchronized (map) {
            String name = info.getName();
            if (this.books.containsKey(name)) {
                this.repo.save(info, this.books.get(info.getName()), true);
                return info;
            }
            BookInfo newInfo = this.repo.saveAs(info.getName(), book);
            return newInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBook(BookInfo info) throws IOException {
        Map<String, Book> map = this.books;
        synchronized (map) {
            String name = info.getName();
            this.books.remove(name);
            this.infos.remove(name);
            this.repo.delete(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBook(BookInfo info) throws IOException {
        Map<String, Book> map = this.books;
        synchronized (map) {
            String name = info.getName();
            this.updateBook(info, this.books.get(name));
            this.infos.remove(name);
            this.books.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBookAttached(BookInfo info) {
        Map<String, Book> map = this.books;
        synchronized (map) {
            return this.books.containsKey(info.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() throws IOException {
        HashSet<String> keys = null;
        Map<String, Book> map = this.books;
        synchronized (map) {
            keys = new HashSet<String>(this.books.keySet());
        }
        for (String name : keys) {
            Book book = this.books.get(name);
            if (book == null) continue;
            this.updateBook(this.infos.get(name), book);
        }
    }

    public void shutdownAutoFileSaving() {
        this.scheduler.shutdownNow();
    }
}

