'use client';

import React from 'react';

import type { DropdownMenuProps } from '@radix-ui/react-dropdown-menu';

import {setLineHeight} from '@udecode/plate-line-height';
import {
  useLineHeightDropdownMenu,
  useLineHeightDropdownMenuState,
} from '@udecode/plate-line-height/react';
import {TablePlugin} from '@udecode/plate-table/react';
import {useEditorRef, usePluginOption} from '@udecode/plate/react';
import { WrapText } from 'lucide-react';

import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuRadioGroup,
  DropdownMenuRadioItem,
  DropdownMenuTrigger,
  useOpenState,
} from './dropdown-menu';
import { ToolbarButton } from './toolbar';

export function LineHeightDropdownMenu({ ...props }: DropdownMenuProps) {
  const openState = useOpenState();
  const state = useLineHeightDropdownMenuState();
  const { radioGroupProps } = useLineHeightDropdownMenu(state);
  const editor = useEditorRef();
  const selectedCells = usePluginOption(TablePlugin, 'selectedCells');

  return (
      <DropdownMenu modal={false} {...openState} {...props}>
        <DropdownMenuTrigger asChild>
          <ToolbarButton
              pressed={openState.open}
              tooltip="Line height"
              isDropdown
          >
            <WrapText />
          </ToolbarButton>
        </DropdownMenuTrigger>

        <DropdownMenuContent className="min-w-0" align="start">
          <DropdownMenuRadioGroup
              {...radioGroupProps}
              onValueChange={(value) => {
                  /* Potix: Fix toolbar action after grid cell selection */
                  if (selectedCells && selectedCells.length > 0) {
                      selectedCells.forEach((cell) => {
                          const cellPath = editor.api.findPath(cell);
                          if (cellPath) setLineHeight(editor, {setNodesOptions: {at: cellPath}, value: Number(value)});
                      });
                  } else setLineHeight(editor, {value: Number(value)});
                  editor.tf.focus();
              }}>
            {state.values.map((_value) => (
                <DropdownMenuRadioItem
                    key={_value}
                    className="min-w-[180px]"
                    value={_value}
                >
                  {_value}
                </DropdownMenuRadioItem>
            ))}
          </DropdownMenuRadioGroup>
        </DropdownMenuContent>
      </DropdownMenu>
  );
}
