import DOMPurify from 'dompurify';

@zk.WrapClass('kkdoc.Document')
export class Document extends zul.Widget {
    /** @internal */
    _value?: string;
    /** @internal */
    _customConfigurationsPath?: string;
    /** @internal */
    _documentConfig?: kkdoc.DocumentConfig;
    /** @internal */
    _readonly?: boolean;

    /** @internal */
    _plate?: kkdoc.PlateObject;

    getValue(): string | undefined {
        return this._value;
    }

    override setHeight(height?: string): this {
        super.setHeight(height);
        if (this.desktop && !height)
            this.$n_('editor').style.removeProperty('height');
        return this;
    }

    setValue(value: string, opts?: Record<string, boolean>): this {
        const o = this._value;
        this._value = value = DOMPurify.sanitize(value);
        if (this.desktop && (o !== value || opts?.force)) {
            this._plate?.setValue(value);
        }
        return this;
    }

    isReadonly(): boolean {
        return !!this._readonly;
    }

    setReadonly(readonly: boolean): this {
        if (this._readonly !== readonly) {
            this._readonly = readonly;
            if (this.desktop) {
                this._plate?.setReadonly(readonly);
            }
        }
        return this;
    }

    getCustomConfigurationsPath(): string | undefined {
        return this._customConfigurationsPath;
    }
    setCustomConfigurationsPath(customConfigurationsPath: string): this {
        if (this._customConfigurationsPath !== customConfigurationsPath) {
            this._customConfigurationsPath = customConfigurationsPath;
            if (this._customConfigurationsPath != null) {
                void jq.getJSON(this._customConfigurationsPath, (data) => {
                    this.setDocumentConfig(data as kkdoc.DocumentConfig, {force: true});
                });
            } else {
                this.setDocumentConfig(this._customConfigurationsPath, {force: true});
            }
        }
        return this;
    }

    getDocumentConfig(): kkdoc.DocumentConfig | undefined {
        return this._documentConfig;
    }

    setDocumentConfig(documentConfig: kkdoc.DocumentConfig, opts?: Record<string, boolean>): this {
        const o = this._documentConfig;
        this._documentConfig = documentConfig;
        if (this.desktop && (o !== documentConfig || opts?.force)) {
            this._plate?.setDocumentConfig(documentConfig);
        }
        return this;
    }

    override bind_(desktop?: zk.Desktop, skipper?: zk.Skipper, after?: CallableFunction[]): void {
        super.bind_(desktop, skipper, after);
        this._plate = new kkdoc.PlateObject(this.uuid, /*safe*/ this.getZclass(), this.isReadonly(), this._value!, this._documentConfig!,
            this._onChange.bind(this), this._onChanging.bind(this));
    }

    override unbind_(skipper?: zk.Skipper, after?: CallableFunction[], keepRod?: boolean): void {
        this._plate?.destroy();
        this._plate = undefined;
        super.unbind_(skipper, after, keepRod);
    }

    override beforeSendAU_(wgt: zk.Widget, evt: zk.Event): void {
        super.beforeSendAU_(wgt, evt);
        if ((evt.name === 'onChange' || evt.name === 'onChanging') && this._plate) {
            evt.opts['waiting'] = true;
            this._plate.getValue((value) => {
                this._value = value;
                (evt.data as object)['value'] = value;
                delete evt.opts['waiting'];
                if (this.desktop) zAu.sendNow(this.desktop);
            });
        }
    }

    /** @internal */
    _onChange(): void {
        this.fire('onChange', {});
    }

    /** @internal */
    _onChanging(): void {
        this.fire('onChanging', {});
    }
}
