'use client';

import * as React from 'react';

import * as PopoverPrimitive from '@radix-ui/react-popover';
import { cn, withRef } from '@udecode/cn';
import { type VariantProps, cva } from 'class-variance-authority';
import {useEditorRef} from '@udecode/plate/react';

export const Popover = PopoverPrimitive.Root;

export const PopoverTrigger = PopoverPrimitive.Trigger;

export const PopoverAnchor = PopoverPrimitive.Anchor;

const createPopoverVariants = (zclass: string) => cva(
    `${zclass}-toolbar-pp w-72 rounded-md border bg-popover p-4 text-popover-foreground shadow-md outline-hidden print:hidden`,
    {
        defaultVariants: {
            animate: true,
        },
        variants: {
            animate: {
                true: 'data-[side=bottom]:slide-in-from-top-2 data-[side=left]:slide-in-from-right-2 data-[side=right]:slide-in-from-left-2 data-[side=top]:slide-in-from-bottom-2 data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=closed]:zoom-out-95 data-[state=open]:animate-in data-[state=open]:fade-in-0 data-[state=open]:zoom-in-95',
            },
        },
    }
);

export const popoverVariants = (zclass: string) => createPopoverVariants(zclass);

export const PopoverContent = withRef<
    typeof PopoverPrimitive.Content,
    VariantProps<ReturnType<typeof createPopoverVariants>>
>(({ align = 'center', animate, className, sideOffset = 4, ...props }, ref) => {
    const zclass = useEditorRef().zclass as string,
        popoverVariants = createPopoverVariants(zclass);
    return (
        <PopoverPrimitive.Portal>
            <PopoverPrimitive.Content
                ref={ref}
                className={cn(popoverVariants({ animate }), className)}
                align={align}
                sideOffset={sideOffset}
                {...props}
            />
        </PopoverPrimitive.Portal>
    );
});
