'use client';

import React from 'react';

import { withRef } from '@udecode/cn';
import {outdent} from '@udecode/plate-indent';
import { useOutdentButton } from '@udecode/plate-indent/react';
import {unindentListItems} from '@udecode/plate-list';
import {TablePlugin} from '@udecode/plate-table/react';
import {useEditorRef, usePluginOption} from '@udecode/plate/react';
import { Outdent } from 'lucide-react';

import { ToolbarButton } from './toolbar';

export const OutdentToolbarButton = withRef<typeof ToolbarButton>(
    (rest, ref) => {
        const { props } = useOutdentButton(),
            editor = useEditorRef(),
            selectedCells = usePluginOption(TablePlugin, 'selectedCells');

        return (
            <ToolbarButton ref={ref} tooltip="Outdent" {...props} {...rest}
                /* Potix: add list-indent-toolbar-button functionality */
                onClick={() => {
                    /* Potix: Fix toolbar action after grid cell selection */
                    if (selectedCells && selectedCells.length > 0) {
                        selectedCells.forEach((cell) => {
                            const cellPath = editor.api.findPath(cell);
                            if (cellPath) {
                                unindentListItems(editor, {at: cellPath})
                                || outdent(editor, {getNodesOptions: {at: cellPath}});
                            }
                        });
                    } else unindentListItems(editor) || outdent(editor);
                }}
            >
                <Outdent />
            </ToolbarButton>
        );
    }
);
