'use client';

import React, { useCallback, useState } from 'react';

import type { DropdownMenuProps } from '@radix-ui/react-dropdown-menu';

import { isUrl } from '@udecode/plate';
import {
    AudioPlugin,
    FilePlugin,
    ImagePlugin,
    VideoPlugin,
} from '@udecode/plate-media/react';
import { useEditorRef } from '@udecode/plate/react';
import {
    AudioLinesIcon,
    FileUpIcon,
    FilmIcon,
    ImageIcon,
    // LinkIcon,
} from 'lucide-react';
import { toast } from 'sonner';
// import { useFilePicker } from 'use-file-picker';

import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogCancel,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogFooter,
    AlertDialogHeader,
    AlertDialogTitle,
} from './alert-dialog';
import {
    // DropdownMenu,
    // DropdownMenuContent,
    // DropdownMenuGroup,
    // DropdownMenuItem,
    // DropdownMenuTrigger,
    useOpenState,
} from './dropdown-menu';
import { FloatingInput } from './input';
import {
    ToolbarSplitButton,
    ToolbarSplitButtonPrimary,
    // ToolbarSplitButtonSecondary,
} from './toolbar';

const MEDIA_CONFIG: Record<
    string,
    {
        accept: string[];
        icon: React.ReactNode;
        title: string;
        tooltip: string;
    }
> = {
    [AudioPlugin.key]: {
        accept: ['audio/*'],
        icon: <AudioLinesIcon className="size-4" />,
        title: 'Insert Audio',
        tooltip: 'Audio',
    },
    [FilePlugin.key]: {
        accept: ['*'],
        icon: <FileUpIcon className="size-4" />,
        title: 'Insert File',
        tooltip: 'File',
    },
    [ImagePlugin.key]: {
        accept: ['image/*'],
        icon: <ImageIcon className="size-4" />,
        title: 'Insert Image',
        tooltip: 'Image',
    },
    [VideoPlugin.key]: {
        accept: ['video/*'],
        icon: <FilmIcon className="size-4" />,
        title: 'Insert Video',
        tooltip: 'Video',
    },
};

export function MediaToolbarButton({
                                       children,
                                       nodeType,
                                       ...props
                                   }: DropdownMenuProps & { nodeType: string }) {
    const currentConfig = MEDIA_CONFIG[nodeType];

    const editor = useEditorRef();
    const openState = useOpenState();
    const [dialogOpen, setDialogOpen] = useState(false);

    // const { openFilePicker } = useFilePicker({
    //     accept: currentConfig.accept,
    //     multiple: true,
    //     onFilesSelected: ({ plainFiles: updatedFiles }) => {
    //         (editor as any).tf.insert.media(updatedFiles);
    //     },
    // });

    return (
        <>
            <ToolbarSplitButton
                data-plate-focus-id={editor.id}
                onClick={() => {
                    // openFilePicker();
                    setDialogOpen(true);
                }}
                onKeyDown={(e) => {
                    if (e.key === 'ArrowDown') {
                        e.preventDefault();
                        openState.onOpenChange(true);
                    }
                }}
                pressed={openState.open}
            >
                <ToolbarSplitButtonPrimary tooltip={currentConfig.tooltip}>
                    {currentConfig.icon}
                </ToolbarSplitButtonPrimary>

                {/*<DropdownMenu {...openState} modal={false} {...props}>*/}
                {/*    <DropdownMenuTrigger asChild>*/}
                {/*        <ToolbarSplitButtonSecondary />*/}
                {/*    </DropdownMenuTrigger>*/}

                {/*    <DropdownMenuContent*/}
                {/*        onClick={(e) => e.stopPropagation()}*/}
                {/*        align="start"*/}
                {/*        alignOffset={-32}*/}
                {/*    >*/}
                {/*        <DropdownMenuGroup>*/}
                            {/*<DropdownMenuItem onSelect={() => openFilePicker()}>*/}
                            {/*    {currentConfig.icon}*/}
                            {/*    Upload from computer*/}
                            {/*</DropdownMenuItem>*/}
                {/*            <DropdownMenuItem onSelect={() => setDialogOpen(true)}>*/}
                {/*                <LinkIcon />*/}
                {/*                Insert via URL*/}
                {/*            </DropdownMenuItem>*/}
                {/*        </DropdownMenuGroup>*/}
                {/*    </DropdownMenuContent>*/}
                {/*</DropdownMenu>*/}
            </ToolbarSplitButton>

            <AlertDialog
                open={dialogOpen}
                onOpenChange={(value) => {
                    setDialogOpen(value);
                }}
            >
                <AlertDialogContent
                    className="gap-6"
                    onCloseAutoFocus={e => {
                        e.preventDefault();
                        editor.tf.focus();
                    }}
                >
                    <MediaUrlDialogContent
                        currentConfig={currentConfig}
                        nodeType={nodeType}
                        setOpen={setDialogOpen}
                    />
                </AlertDialogContent>
            </AlertDialog>
        </>
    );
}

function MediaUrlDialogContent({
                                   currentConfig,
                                   nodeType,
                                   setOpen,
                               }: {
    currentConfig: (typeof MEDIA_CONFIG)[string];
    nodeType: string;
    setOpen: (value: boolean) => void;
}) {
    const editor = useEditorRef();
    const [url, setUrl] = useState('');

    const embedMedia = useCallback(() => {
        if (!isUrl(url)) return toast.error('Invalid URL');

        setOpen(false);
        editor.tf.insertNodes({
            children: [{ text: '' }],
            name: nodeType === FilePlugin.key ? url.split('/').pop() : undefined,
            type: nodeType,
            url,
        });
    }, [url, editor, nodeType, setOpen]);

    return (
        <>
            <AlertDialogHeader>
                <AlertDialogTitle>{currentConfig.title}</AlertDialogTitle>
            </AlertDialogHeader>

            <AlertDialogDescription className="group relative w-full">
                <FloatingInput
                    id="url"
                    className="w-full"
                    value={url}
                    onChange={(e) => setUrl(e.target.value)}
                    onKeyDown={(e) => {
                        if (e.key === 'Enter') embedMedia();
                    }}
                    label="URL"
                    placeholder=""
                    type="url"
                    autoFocus
                    data-plate-focus-id={editor.id}
                />
            </AlertDialogDescription>

            <AlertDialogFooter>
                <AlertDialogCancel>Cancel</AlertDialogCancel>
                <AlertDialogAction
                    onClick={(e) => {
                        e.preventDefault();
                        embedMedia();
                    }}
                >
                    Accept
                </AlertDialogAction>
            </AlertDialogFooter>
        </>
    );
}
