/* extensions.ts

	Purpose:
		
	Description:
		
	History:
		5:52 PM 2025/1/9, Created by jumperchen

Copyright (C) 2025 Potix Corporation. All Rights Reserved.
*/
import {SlatePlugin} from '@udecode/plate-core';
import {NodeComponent} from '@udecode/plate';

const pluginExtensions: Set<SlatePlugin> = new Set<SlatePlugin>(),
	componentExtensions: Record<string, NodeComponent> = {};

export const registerComponentExtension = (key: string, component: NodeComponent): void => {
	componentExtensions[key] = component;
};

export const getComponentExtensions = (): Record<string, NodeComponent> => componentExtensions;

export const registerPluginExtension = (plugin: SlatePlugin): void => {
	pluginExtensions.add(plugin);
};

export const getPluginExtensions = (): Set<SlatePlugin> => pluginExtensions;