import {HeadingElement} from '@plate/components/heading-element';
import {HighlightLeaf} from '@plate/components/highlight-leaf';
import {ParagraphElement} from '@plate/components/paragraph-element';
import {TableCellElement, TableCellHeaderElement} from '@plate/components/table-cell-element';
import {TableElement} from '@plate/components/table-element';
import {TableRowElement} from '@plate/components/table-row-element';
import {withProps} from '@udecode/cn';
import {NodeComponent} from '@udecode/plate';
import {
    BoldPlugin,
    CodePlugin,
    ItalicPlugin,
    StrikethroughPlugin,
    SubscriptPlugin,
    SuperscriptPlugin,
    UnderlinePlugin
} from '@udecode/plate-basic-marks/react';
import {HEADING_KEYS} from '@udecode/plate-heading';
import {HighlightPlugin} from '@udecode/plate-highlight/react';
import {TableCellHeaderPlugin, TableCellPlugin, TablePlugin, TableRowPlugin} from '@udecode/plate-table/react';
import {ParagraphPlugin, PlateElement, PlateLeaf} from '@udecode/plate/react';
import {TypedEmitter} from 'tiny-typed-emitter';
import {ImagePlugin} from '@udecode/plate-media/react';
import {ImageElement} from '@plate/components/image-element';
import {BulletedListPlugin, ListItemPlugin, NumberedListPlugin} from '@udecode/plate-list/react';
import {CodeLeaf} from '@plate/components/code-leaf';
import {ListElement} from '@plate/components/list-element';
import {LinkPlugin} from '@udecode/plate-link/react';
import {LinkElement} from '@plate/components/link-element';
import {BlockquotePlugin} from '@udecode/plate-block-quote/react';
import {BlockquoteElement} from '@plate/components/blockquote-element';

export const createPlateUI = (zclass: string, emitter: TypedEmitter): Record<string, NodeComponent> => {
    return {
        [ParagraphPlugin.key]: withProps(ParagraphElement, {className: `${zclass}-${ParagraphPlugin.key}`}),
        [HEADING_KEYS.h1]: withProps(HeadingElement, {variant: 'h1', className: `${zclass}-${HEADING_KEYS.h1}`}),
        [HEADING_KEYS.h2]: withProps(HeadingElement, {variant: 'h2', className: `${zclass}-${HEADING_KEYS.h2}`}),
        [HEADING_KEYS.h3]: withProps(HeadingElement, {variant: 'h3', className: `${zclass}-${HEADING_KEYS.h3}`}),
        [HEADING_KEYS.h4]: withProps(HeadingElement, {variant: 'h4', className: `${zclass}-${HEADING_KEYS.h4}`}),
        [HEADING_KEYS.h5]: withProps(HeadingElement, {variant: 'h5', className: `${zclass}-${HEADING_KEYS.h5}`}),
        [HEADING_KEYS.h6]: withProps(HeadingElement, {variant: 'h6', className: `${zclass}-${HEADING_KEYS.h6}`}),
        [BlockquotePlugin.key]: withProps(BlockquoteElement, {className: `${zclass}-${BlockquotePlugin.key}`}),
        [TablePlugin.key]: withProps(TableElement, {className: `${zclass}-${TablePlugin.key}`}),
        [TableRowPlugin.key]: withProps(TableRowElement, {className: `${zclass}-${TableRowPlugin.key}`}),
        [TableCellHeaderPlugin.key]: withProps(TableCellHeaderElement, {className: `${zclass}-${TableCellHeaderPlugin.key}`}),
        [TableCellPlugin.key]: withProps(TableCellElement, {className: `${zclass}-${TableCellPlugin.key}`}),

        [BoldPlugin.key]: withProps(PlateLeaf, {as: 'strong', className: `${zclass}-${BoldPlugin.key}`}),
        [ItalicPlugin.key]: withProps(PlateLeaf, {as: 'em', className: `${zclass}-${ItalicPlugin.key}`}),
        [StrikethroughPlugin.key]: withProps(PlateLeaf, {as: 's', className: `${zclass}-${StrikethroughPlugin.key}`}),
        [SubscriptPlugin.key]: withProps(PlateLeaf, {as: 'sub', className: `${zclass}-${SubscriptPlugin.key}`}),
        [SuperscriptPlugin.key]: withProps(PlateLeaf, {as: 'sup', className: `${zclass}-${SuperscriptPlugin.key}`}),
        [UnderlinePlugin.key]: withProps(PlateLeaf, {as: 'u', className: `${zclass}-${UnderlinePlugin.key}`}),
        [CodePlugin.key]: withProps(CodeLeaf, {className: `${zclass}-${CodePlugin.key}`}),
        [HighlightPlugin.key]: withProps(HighlightLeaf, {className: `${zclass}-${HighlightPlugin.key}`}),

        // media
        [ImagePlugin.key]: withProps(ImageElement, {className: `${zclass}-${ImagePlugin.key}`}),

        // list
        [BulletedListPlugin.key]: withProps(ListElement, { variant: 'ul', className: `${zclass}-${BulletedListPlugin.key}`}),
        [NumberedListPlugin.key]: withProps(ListElement, { variant: 'ol', className: `${zclass}-${NumberedListPlugin.key}`}),
        [ListItemPlugin.key]: withProps(PlateElement, {as: 'li', className: `${zclass}-${ListItemPlugin.key}`}),

        // link
        [LinkPlugin.key]: withProps(LinkElement, {className: `${zclass}-${LinkPlugin.key}`}),
    };
};
