import {PlateElement, withRef} from '@udecode/plate/react';
import { cn } from '@udecode/cn';
import * as React from 'react';

export const ParagraphElement = withRef<typeof PlateElement>(
    ({children, className, ...props}, ref) => {
        const ghost = React.useMemo(() => <span className='ghost' contentEditable={false}/>, []);
        return (
            <PlateElement ref={ref}
                          className={cn(className, 'm-0 px-0 py-1')}
                          {...props}>
                {ghost}
                {children}
            </PlateElement>
        );
    });
