/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.doc.ui;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Files;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.impl.AbstractWebApp;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.util.ObfuscatedString;
import org.zkoss.zul.impl.XulElement;

public class Document
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    private static LocalDate _JR3PFWXG0SAWQYJ8MYQ;
    private static final String _S9KP54GQCC46PFLJDYD;
    private static final String _3MBJEKXJFEMAYNCJG04;
    private static final String _HX77WWFJXKC6A3BFDJ4;
    private static final String _YH3SKDCS4AJ9UKUS3S7;
    private String _value = "";
    private String _customConfigurationsPath;
    private boolean _readonly = false;

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals(this._value, value)) {
            this._value = value;
            this.smartUpdate("value", this._value);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    public void setCustomConfigurationsPath(String url) {
        if (!Objects.equals(this._customConfigurationsPath, url)) {
            this._customConfigurationsPath = url;
            this.smartUpdate("customConfigurationsPath", this.getEncodedURL(this._customConfigurationsPath));
        }
    }

    private String getEncodedURL(String path) {
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(path) : "";
    }

    public String getCustomConfigurationsPath() {
        return this._customConfigurationsPath;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this._value);
        this.render(renderer, "readonly", this._readonly);
        if (this._customConfigurationsPath != null) {
            this.render(renderer, "customConfigurationsPath", this.getEncodedURL(this._customConfigurationsPath));
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd;
        Document.xq7LpZt3();
        switch (cmd = request.getCommand()) {
            case "onChange": {
                InputEvent event = InputEvent.getInputEvent((AuRequest)request, (Object)this._value);
                this._value = event.getValue();
                Events.postEvent((Event)event);
                break;
            }
            case "onChanging": {
                InputEvent event = InputEvent.getInputEvent((AuRequest)request, (Object)this._value);
                Events.postEvent((Event)event);
                break;
            }
            default: {
                super.service(request, everError);
            }
        }
    }

    private static synchronized void xq7LpZt3() {
        if (_JR3PFWXG0SAWQYJ8MYQ == null) {
            try (InputStream is = AbstractWebApp.class.getResourceAsStream(_3MBJEKXJFEMAYNCJG04);
                 InputStream inputStream = is;){
                String j7Q8RWR5IZ0IV2EE1TN = new String(Files.readAll((InputStream)is)).trim();
                DateTimeFormatter qPWEJFPA6K1VMXXMS7L = DateTimeFormatter.ofPattern(_YH3SKDCS4AJ9UKUS3S7);
                LocalDate n6018EEG34OWBTU99P9 = LocalDate.parse(j7Q8RWR5IZ0IV2EE1TN, qPWEJFPA6K1VMXXMS7L);
                _JR3PFWXG0SAWQYJ8MYQ = n6018EEG34OWBTU99P9.plusMonths(6L);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Object)_HX77WWFJXKC6A3BFDJ4);
            }
        }
        if (LocalDate.now().isAfter(_JR3PFWXG0SAWQYJ8MYQ)) {
            throw new UiException(_S9KP54GQCC46PFLJDYD);
        }
    }

    static {
        _S9KP54GQCC46PFLJDYD = new ObfuscatedString(new long[]{3746845835475908250L, 6390704523429425036L, -1521030926056096422L, 8938267152288030219L, -1687538094466939370L, -856424433148168086L, -6478289673443423767L, -8447848251503536706L, 6310656519678880432L, -39580471309915262L, -9080287265785897334L, -7427297441879301379L, 1644624367770043997L, 4891861303897564632L, -718438231553249366L, -2584285420606111061L, -5642149619838560973L, -3704436752856959514L, -4613136202154694749L, 6429847219699485178L, -7905258943750204456L, -8588710409873203506L, 2786018635341414164L, -1430929867932748390L}).toString();
        _3MBJEKXJFEMAYNCJG04 = new ObfuscatedString(new long[]{-4283175258067716053L, -2250746710825505929L, 6152593300887290883L, -3427002902467318534L, 3111531849627786459L}).toString();
        _HX77WWFJXKC6A3BFDJ4 = new ObfuscatedString(new long[]{-6095905810284063604L, -1887775871970236619L, 9052775677065871063L, -5103427756638849554L, -4686422718080333061L, 2796958504168232085L, 473871836239853474L}).toString();
        _YH3SKDCS4AJ9UKUS3S7 = new ObfuscatedString(new long[]{-1535496941084205578L, -6149313496609964298L}).toString();
        Document.addClientEvent(Document.class, (String)"onChange", (int)16385);
        Document.addClientEvent(Document.class, (String)"onChanging", (int)4096);
    }
}

