/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkforge.clipboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Base64;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zkforge.clipboard.ClipboardAction;
import org.zkoss.zkforge.clipboard.ClipboardError;
import org.zkoss.zkforge.clipboard.ClipboardImage;
import org.zkoss.zkforge.clipboard.ClipboardResult;
import org.zkoss.zkforge.clipboard.ClipboardText;

public class ClipboardEvent
extends Event {
    public static final String EVENT_NAME = "onClipboardAction";
    private ClipboardResult result;
    protected static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    public ClipboardEvent(ClipboardResult result, Component target) {
        super(EVENT_NAME, target);
        this.result = result;
    }

    public ClipboardEvent(ClipboardResult result) {
        this(result, null);
    }

    public static ClipboardEvent getEvent(AuRequest request) {
        Map data = request.getData();
        if (data == null) {
            ClipboardText errorResult = new ClipboardText();
            errorResult.setError(new ClipboardError(0, "No data received from request"));
            return new ClipboardEvent(errorResult);
        }
        ClipboardResult result = ClipboardEvent.parseResponse(data);
        if (result == null) {
            result = new ClipboardText();
            result.setError(new ClipboardError(0, "Failed to parse clipboard response"));
        }
        return new ClipboardEvent(result, request.getComponent());
    }

    public boolean isSuccess() {
        return this.result != null && this.result.isSuccess();
    }

    public ClipboardResult getResult() {
        return this.result;
    }

    public boolean isTextResult() {
        return this.result instanceof ClipboardText;
    }

    public ClipboardText getClipboardText() {
        return this.isTextResult() ? (ClipboardText)this.result : null;
    }

    public ClipboardImage getClipboardImage() {
        return this.result instanceof ClipboardImage ? (ClipboardImage)this.result : null;
    }

    protected static ClipboardResult parseResponse(Map<String, Object> data) {
        if (ClipboardEvent.isImageAction(data)) {
            return ClipboardEvent.parseImageResponse(data);
        }
        return ClipboardEvent.parseTextResponse(data);
    }

    private static boolean isImageAction(Map<String, Object> data) {
        return ClipboardAction.READ_IMAGE.toString().equals(data.get("action"));
    }

    private static ClipboardResult parseTextResponse(Map<String, Object> data) {
        return (ClipboardResult)GSON.fromJson(GSON.toJson(data), ClipboardText.class);
    }

    private static ClipboardImage parseImageResponse(Map<String, Object> data) {
        ClipboardImage result = (ClipboardImage)GSON.fromJson(GSON.toJson(data), ClipboardImage.class);
        ClipboardEvent.decodeImageData(data, result);
        return result;
    }

    private static void decodeImageData(Map<String, Object> data, ClipboardImage result) {
        if (data.get("imageData") != null) {
            try {
                String base64Data = data.get("imageData").toString();
                byte[] imageBytes = Base64.getDecoder().decode(base64Data);
                result.setImageData(imageBytes);
            }
            catch (IllegalArgumentException e) {
                ClipboardError error = new ClipboardError(0, "Invalid image data format");
                result.setError(error);
            }
        }
    }
}

