/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkforge.geolocation;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkforge.geolocation.GeoLocationAuService;
import org.zkoss.zul.Script;

public class GeolocationHelper {
    protected static final String GEOLOCATION_HELPER_KEY = "browserkit.geolocationhelper";
    protected static final String GEOLOCATION_HELPER_JS_PATH = "~./js/GeolocationHelper.js";
    protected static GeoLocationAuService auService;

    public static void getCurrentPosition() {
        if (Executions.getCurrent().getDesktop().getAttribute(GEOLOCATION_HELPER_KEY) == null) {
            return;
        }
        Clients.evalJavaScript((String)"GeolocationHelper.getCurrentPosition()");
    }

    public static void init() {
        GeolocationHelper.ensureExecutionAvailable();
        Desktop desktop = Executions.getCurrent().getDesktop();
        if (desktop.getAttribute(GEOLOCATION_HELPER_KEY) != null) {
            return;
        }
        desktop.setAttribute(GEOLOCATION_HELPER_KEY, (Object)true);
        GeolocationHelper.addAuService(desktop);
        GeolocationHelper.addHelperScript(desktop);
    }

    protected static void addHelperScript(Desktop desktop) {
        Script helperScript = new Script();
        helperScript.setId(GEOLOCATION_HELPER_KEY);
        helperScript.setSrc(GEOLOCATION_HELPER_JS_PATH);
        helperScript.setPage(desktop.getFirstPage());
    }

    protected static void addAuService(Desktop desktop) {
        if (auService == null) {
            auService = new GeoLocationAuService();
        }
        desktop.addListener((Object)auService);
    }

    public static void dispose() {
        GeolocationHelper.ensureExecutionAvailable();
        Desktop desktop = Executions.getCurrent().getDesktop();
        desktop.removeAttribute(GEOLOCATION_HELPER_KEY);
        if (auService != null) {
            desktop.removeListener((Object)auService);
        }
        Selectors.find((Page)desktop.getFirstPage(), (String)"#browserkit.geolocationhelper").forEach(Component::detach);
    }

    private static void ensureExecutionAvailable() {
        if (Executions.getCurrent() == null) {
            throw new IllegalStateException("This method can only be called when an Execution is available");
        }
    }
}

