/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkforge.geolocation;

import com.google.gson.Gson;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zkforge.geolocation.GeolocationPosition;
import org.zkoss.zkforge.geolocation.GeolocationPositionError;

public class GeolocationEvent
extends Event {
    public static final String EVENT_NAME = "onGetLocation";
    protected GeolocationPosition geoLocationPosition;
    protected GeolocationPositionError geoLocationPositionError;
    protected static final Gson GSON = new Gson();

    public GeolocationEvent(GeolocationPosition geolocationPosition) {
        super(EVENT_NAME, null);
        this.geoLocationPosition = geolocationPosition;
    }

    public GeolocationEvent(GeolocationPositionError geolocationPositionError) {
        super(EVENT_NAME, null);
        this.geoLocationPositionError = geolocationPositionError;
    }

    public static GeolocationEvent getEvent(AuRequest request) {
        GeolocationEvent event = null;
        Map data = request.getData();
        event = GeolocationEvent.isSuccess(data) ? new GeolocationEvent(GeolocationEvent.parsePosition(data)) : new GeolocationEvent(GeolocationEvent.parseError(data));
        return event;
    }

    protected static boolean isSuccess(Map data) {
        return data.get("position") != null;
    }

    protected static GeolocationPosition parsePosition(Map data) {
        return (GeolocationPosition)GSON.fromJson(data.get("position").toString(), GeolocationPosition.class);
    }

    protected static GeolocationPositionError parseError(Map data) {
        return (GeolocationPositionError)GSON.fromJson(data.get("error").toString(), GeolocationPositionError.class);
    }

    public boolean isSuccess() {
        return this.geoLocationPosition != null;
    }

    public GeolocationPosition getGeoLocationPosition() {
        return this.geoLocationPosition;
    }

    public GeolocationPositionError getGeoLocationPositionError() {
        return this.geoLocationPositionError;
    }
}

