/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkforge.clipboard;

import com.google.gson.annotations.Expose;
import org.zkoss.zkforge.clipboard.ClipboardResult;

public class ClipboardImage
extends ClipboardResult {
    @Expose
    private String mimeType;
    @Expose(deserialize=false)
    private byte[] imageData;
    @Expose
    private int width;
    @Expose
    private int height;
    @Expose
    private long size;

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public boolean hasImageData() {
        return this.isSuccess() && this.imageData != null && this.imageData.length > 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isSupportedFormat() {
        return this.isSupportedMimeType(this.mimeType);
    }

    void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private boolean isSupportedMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals("image/png") || mimeType.equals("image/jpeg") || mimeType.equals("image/jpg") || mimeType.equals("image/gif") || mimeType.equals("image/webp");
    }
}

