/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkforge.clipboard;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkforge.clipboard.ClipboardAuService;
import org.zkoss.zul.Script;

public class ClipboardHelper {
    protected static final String CLIPBOARD_HELPER_KEY = "browserkit.clipboardhelper";
    protected static final String CLIPBOARD_HELPER_JS_PATH = "~./js/ClipboardHelper.js";
    protected static ClipboardAuService auService;

    public static void writeText(String text) {
        if (text == null) {
            return;
        }
        String escapedText = text.replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
        Clients.evalJavaScript((String)("ClipboardHelper.writeText('" + escapedText + "')"));
    }

    public static void readText() {
        Clients.evalJavaScript((String)"ClipboardHelper.readText()");
    }

    public static void readImage() {
        Clients.evalJavaScript((String)"ClipboardHelper.readImage()");
    }

    public static void init() {
        ClipboardHelper.ensureExecutionAvailable();
        Desktop desktop = Executions.getCurrent().getDesktop();
        if (desktop.getAttribute(CLIPBOARD_HELPER_KEY) != null) {
            return;
        }
        desktop.setAttribute(CLIPBOARD_HELPER_KEY, (Object)true);
        ClipboardHelper.addAuService();
        ClipboardHelper.addHelperScript();
    }

    private static void addAuService() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        if (auService == null) {
            auService = new ClipboardAuService();
        }
        desktop.addListener((Object)auService);
    }

    protected static void addHelperScript() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        Script clipboardHelperScript = new Script();
        clipboardHelperScript.setId(CLIPBOARD_HELPER_KEY);
        clipboardHelperScript.setSrc(CLIPBOARD_HELPER_JS_PATH);
        clipboardHelperScript.setPage(desktop.getFirstPage());
    }

    public static void dispose() {
        ClipboardHelper.ensureExecutionAvailable();
        Desktop desktop = Executions.getCurrent().getDesktop();
        desktop.removeAttribute(CLIPBOARD_HELPER_KEY);
        if (auService != null) {
            desktop.removeListener((Object)auService);
        }
        Selectors.find((Page)desktop.getFirstPage(), (String)"#browserkit.clipboardhelper").forEach(Component::detach);
    }

    protected static void ensureExecutionAvailable() {
        if (Executions.getCurrent() == null) {
            throw new IllegalStateException("This method can only be called when an Execution is available");
        }
    }
}

