<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
.z-splitlayout {
  white-space: nowrap;
  overflow: hidden;
}
.z-splitlayout-cave-top,
.z-splitlayout-cave-bottom {
  position: relative;
  width: 100%;
  overflow: hidden;
  display: block;
}
.z-splitlayout-cave-left,
.z-splitlayout-cave-right {
  height: 100%;
  display: inline-block;
  position: relative;
  white-space: normal;
  vertical-align: top;
  overflow: hidden;
}
.z-splitlayout-splitter {
  border: 1px solid var(--zk-splitter-border-color);
  cursor: default;
  background-color: var(--zk-splitter-background-color);
}
.z-splitlayout-splitter:hover {
  background-color: var(--zk-splitter-hover-background-color);
}
.z-splitlayout-splitter:hover .z-splitlayout-splitter-button {
  color: var(--zk-splitter-button-text-hover-color);
}
.z-splitlayout-splitter-horizontal {
  display: inline-block;
  width: var(--zk-splitter-size);
  height: 100%;
  max-width: var(--zk-splitter-size);
  padding: 0;
  margin: 0;
  border-width: 0 1px;
  overflow: hidden;
}
.z-splitlayout-splitter-horizontal > .z-splitlayout-splitter-button {
  width: var(--zk-splitter-size);
  height: var(--zk-rem3-75);
  border-width: 1px 0;
}
.z-splitlayout-splitter-horizontal .z-splitlayout-splitter-icon {
  position: absolute;
  top: 8px;
  left: -2px;
}
.z-splitlayout-splitter-horizontal .z-splitlayout-splitter-icon.z-icon-ellipsis-v {
  top: -21px;
  left: 2px;
  visibility: hidden;
}
.z-splitlayout-splitter-horizontal .z-splitlayout-splitter-icon.z-icon-ellipsis-v ~ .z-splitlayout-splitter-icon.z-icon-ellipsis-v {
  top: 48px;
}
.z-splitlayout-splitter-vertical {
  width: 100%;
  height: var(--zk-splitter-size);
  max-height: var(--zk-splitter-size);
  padding: 0;
  border-width: 1px 0;
  overflow: hidden;
}
.z-splitlayout-splitter-vertical > .z-splitlayout-splitter-button {
  width: var(--zk-rem3-75);
  height: var(--zk-splitter-size);
  border-width: 0 1px;
}
.z-splitlayout-splitter-vertical .z-splitlayout-splitter-icon {
  line-height: normal;
  position: absolute;
  top: -4px;
  left: 8px;
}
.z-splitlayout-splitter-vertical .z-splitlayout-splitter-icon.z-icon-ellipsis-h {
  top: -2px;
  left: -16px;
  visibility: hidden;
}
.z-splitlayout-splitter-vertical .z-splitlayout-splitter-icon.z-icon-ellipsis-h ~ .z-splitlayout-splitter-icon.z-icon-ellipsis-h {
  left: 48px;
}
.z-splitlayout-splitter-button {
  font-size: var(--zk-splitter-button-text-size);
  color: var(--zk-splitter-button-text-color);
  display: inline-block;
  position: relative;
  vertical-align: top;
  cursor: pointer;
}
.z-splitlayout-splitter-button-disabled {
  border: 0;
}
.z-splitlayout-splitter-horizontal.z-splitlayout-splitter-draggable {
  cursor: col-resize;
}
.z-splitlayout-splitter-vertical.z-splitlayout-splitter-draggable {
  cursor: row-resize;
}
.z-splitlayout-splitter-nosplitter {
  cursor: default;
}
