<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
.z-linelayout {
  height: 100%;
  width: 100%;
}
.z-linelayout-first {
  flex: 1 0 0;
  display: flex;
  justify-content: space-around;
  align-items: flex-end;
  overflow: hidden;
}
.z-linelayout-cave {
  display: flex;
  justify-content: space-around;
  align-items: flex-end;
  position: relative;
}
.z-linelayout-last {
  flex: 1 0 0;
  display: flex;
  justify-content: space-around;
  align-items: flex-start;
  overflow: hidden;
}
.z-linelayout-line {
  background: var(--zk-linelayout-line-color);
  position: absolute;
  z-index: 99;
}
.z-linelayout-vertical {
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
}
.z-linelayout-vertical .z-linelayout-first {
  flex-direction: column;
}
.z-linelayout-vertical .z-linelayout-cave {
  padding: 0 var(--zk-linelayout-cave-padding);
  flex-direction: column;
}
.z-linelayout-vertical .z-linelayout-last {
  flex-direction: column;
}
.z-linelayout-vertical .z-linelayout-line {
  height: 100%;
  left: calc(50% - var(--zk-linelayout-line-width) / 2);
  width: var(--zk-linelayout-line-width);
}
.z-linelayout-vertical .z-lineitem {
  flex-direction: column;
}
.z-linelayout-horizontal {
  display: flex;
  flex-direction: column;
}
.z-linelayout-horizontal .z-linelayout-first {
  flex-direction: row;
}
.z-linelayout-horizontal .z-linelayout-cave {
  padding: var(--zk-linelayout-cave-padding) 0;
}
.z-linelayout-horizontal .z-linelayout-last {
  flex-direction: row;
}
.z-linelayout-horizontal .z-linelayout-line {
  width: 100%;
  top: calc(50% - var(--zk-linelayout-line-width) / 2);
  height: var(--zk-linelayout-line-width);
}
.z-lineitem {
  flex: 1 0 0;
  display: flex;
  overflow: hidden;
}
.z-lineitem > * {
  flex-shrink: 0;
  margin: auto;
}
.z-lineitem-stretch {
  width: 100%;
  height: 100%;
}
.z-lineitem-point {
  border: var(--zk-linelayout-point-border);
  border-radius: var(--zk-linelayout-point-radius);
  overflow: hidden;
  box-shadow: var(--zk-linelayout-point-shadow);
  height: var(--zk-linelayout-point-size);
  width: var(--zk-linelayout-point-size);
  font-size: var(--zk-linelayout-point-icon-size);
  color: var(--zk-linelayout-point-icon-color);
  z-index: 100;
  background: var(--zk-linelayout-point-background-color);
}
.z-lineitem-point-hidden {
  visibility: hidden;
}
.z-lineitem-point-image {
  vertical-align: baseline;
  display: inline-flex;
  height: inherit;
  width: inherit;
}
.z-lineitem-point-icon {
  height: inherit;
  width: inherit;
}
.z-lineitem-point-inner {
  height: inherit;
  width: inherit;
  background-size: cover;
  line-height: var(--zk-linelayout-point-size);
  text-align: center;
}
.z-lineitem-point-inner:before {
  position: relative;
  top: var(--zk-linelayout-point-icon-fix-top);
  left: var(--zk-linelayout-point-icon-fix-left);
}
