<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
.z-rangeslider {
  white-space: nowrap;
  overflow: visible;
  cursor: pointer;
  font-family: var(--zk-base-title-font-family);
}
.z-rangeslider-inner {
  position: relative;
}
.z-rangeslider-track {
  position: absolute;
  width: 100%;
  height: 100%;
  border-radius: var(--zk-rangeslider-border-radius);
  background-color: var(--zk-rangeslider-track-color);
}
.z-rangeslider-marks {
  position: relative;
}
.z-rangeslider-mark {
  position: absolute;
}
.z-rangeslider-mark-dot {
  position: absolute;
  width: var(--zk-rangeslider-dot-size);
  height: var(--zk-rangeslider-dot-size);
  background-color: var(--zk-rangeslider-empty-background-color);
  border: var(--zk-rangeslider-dot-border-width) solid var(--zk-rangeslider-track-color);
  border-radius: 50%;
}
.z-rangeslider-mark-active .z-rangeslider-mark-dot {
  border-color: var(--zk-rangeslider-button-color);
  z-index: 1;
}
.z-rangeslider-mark-label {
  position: absolute;
  color: var(--zk-text-color-default);
  text-align: center;
  font-size: var(--zk-rangeslider-label-font-size);
}
.z-rangeslider .z-sliderbuttons-button {
  width: var(--zk-rangeslider-button-size);
  height: var(--zk-rangeslider-button-size);
  background-color: var(--zk-rangeslider-button-color);
  border-width: var(--zk-rangeslider-button-border-width);
  border-color: var(--zk-rangeslider-button-color);
  border-radius: 50%;
  box-shadow: 0 0 4px 0 var(--zk-rangeslider-shadow-color);
  z-index: 2;
}
.z-rangeslider .z-sliderbuttons-tooltip {
  border-radius: var(--zk-rangeslider-tooltip-border-radius);
  background: var(--zk-rangeslider-tooltip-background-color);
  position: absolute;
}
.z-rangeslider .z-sliderbuttons-area {
  background-color: var(--zk-rangeslider-button-color);
}
.z-rangeslider-horizontal {
  width: var(--zk-rem37-5);
}
.z-rangeslider-horizontal .z-sliderbuttons-area {
  height: 100%;
}
.z-rangeslider-horizontal .z-sliderbuttons-button {
  margin-top: var(--zk-rangeslider-horizontal-button-margin-top);
  margin-left: var(--zk-rangeslider-horizontal-button-margin-left);
  top: 0;
}
.z-rangeslider-horizontal .z-sliderbuttons-tooltip {
  top: var(--zk-rangeslider-horizontal-tooltip-position-top);
  left: 50%;
  transform: translateX(-50%) translateY(-100%);
  padding: var(--zk-rangeslider-horizontal-tooltip-padding);
}
.z-rangeslider-horizontal .z-rangeslider-inner {
  margin: 40px 12px 32px;
  height: var(--zk-rangeslider-inner-size);
}
.z-rangeslider-horizontal .z-rangeslider-marks {
  width: 100%;
}
.z-rangeslider-horizontal .z-rangeslider-mark-dot {
  top: var(--zk-rangeslider-horizontal-mark-dot-position-top);
  transform: translateX(-50%);
}
.z-rangeslider-horizontal .z-rangeslider-mark-label {
  top: var(--zk-rangeslider-horizontal-mark-label-position-top);
  transform: translateX(-50%);
}
.z-rangeslider-vertical {
  height: var(--zk-rem37-5);
}
.z-rangeslider-vertical .z-sliderbuttons-area {
  width: 100%;
}
.z-rangeslider-vertical .z-sliderbuttons-button {
  margin-top: var(--zk-rangeslider-horizontal-button-margin-left);
  margin-left: var(--zk-rangeslider-horizontal-button-margin-top);
  left: 0;
}
.z-rangeslider-vertical .z-sliderbuttons-tooltip {
  left: var(--zk-rangeslider-vertical-tooltip-position-left);
  top: 50%;
  transform: translateY(-50%);
  padding: var(--zk-rangeslider-vertical-tooltip-padding);
}
.z-rangeslider-vertical .z-rangeslider-inner {
  margin: 12px 32px 12px 12px;
  width: var(--zk-rangeslider-inner-size);
  height: 100%;
}
.z-rangeslider-vertical .z-rangeslider-marks {
  height: 100%;
}
.z-rangeslider-vertical .z-rangeslider-mark-dot {
  left: var(--zk-rangeslider-horizontal-mark-dot-position-top);
  transform: translateY(-50%);
}
.z-rangeslider-vertical .z-rangeslider-mark-label {
  left: var(--zk-rangeslider-horizontal-mark-label-position-top);
  transform: translateY(-50%);
}
.z-rangeslider:not(.z-rangeslider-disabled) .z-sliderbuttons-button:hover {
  border-color: var(--zk-rangeslider-button-hover-color);
  background-color: var(--zk-rangeslider-button-hover-color);
}
.z-rangeslider:not(.z-rangeslider-disabled) .z-sliderbuttons-button:hover .z-sliderbuttons-tooltip {
  display: block;
}
.z-rangeslider:not(.z-rangeslider-disabled) .z-sliderbuttons-button:active {
  border-color: var(--zk-rangeslider-button-active-color);
  background-color: var(--zk-rangeslider-button-active-color);
}
.z-rangeslider:not(.z-rangeslider-disabled) .z-sliderbuttons-button:focus {
  border-color: var(--zk-rangeslider-button-focus-border-color);
}
.z-rangeslider-disabled .z-rangeslider-track {
  background-color: var(--zk-rangeslider-disabled-track-color);
}
.z-rangeslider-disabled {
  cursor: default;
}
.z-rangeslider-disabled .z-sliderbuttons-area {
  background-color: var(--zk-rangeslider-disabled-button-color);
}
.z-rangeslider-disabled .z-sliderbuttons-button {
  border-color: var(--zk-rangeslider-disabled-button-color);
  background-color: var(--zk-rangeslider-disabled-button-color);
  box-shadow: none;
}
.z-rangeslider-disabled .z-sliderbuttons-tooltip {
  background-color: var(--zk-rangeslider-disabled-tooltip-background-color);
}
.z-rangeslider-disabled .z-rangeslider-mark-dot {
  border-color: var(--zk-rangeslider-disabled-track-color);
}
.z-rangeslider-disabled .z-rangeslider-mark-active .z-rangeslider-mark-dot {
  border-color: var(--zk-rangeslider-disabled-button-color);
}
