<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
.z-paging {
  height: var(--zk-paging-height);
  padding: 4px 16px 2px;
  background: var(--zk-paging-background-color);
  position: relative;
}
.z-paging ul {
  display: inline-block;
  margin: 0;
  padding: 0;
}
.z-paging ul > li {
  display: inline;
  margin-left: 2px;
}
.z-paging ul > li:first-child {
  margin-left: 0;
}
.z-paging-button {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-paging-button-font-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-paging-color);
  display: inline-block;
  min-width: var(--zk-paging-button-min-width);
  height: var(--zk-paging-button-height);
  border: none;
  -webkit-border-radius: var(--zk-border-radius-small);
  -moz-border-radius: var(--zk-border-radius-small);
  -o-border-radius: var(--zk-border-radius-small);
  -ms-border-radius: var(--zk-border-radius-small);
  border-radius: var(--zk-border-radius-small);
  padding: var(--zk-paging-button-padding);
  margin: var(--zk-paging-button-margin);
  line-height: normal;
  background-color: transparent;
  text-align: center;
  vertical-align: top;
  cursor: pointer;
  text-decoration: none;
  white-space: nowrap;
}
.z-paging-button:focus-visible {
  box-shadow: var(--zk-paging-button-focus-box-shadow);
  transition: unset;
  border-radius: var(--zk-paging-button-focus-border-radius);
}
.z-paging-button:hover {
  background-color: var(--zk-paging-item-hover-background-color);
}
.z-paging-button:active {
  color: var(--zk-paging-item-active-color);
  background-color: var(--zk-paging-item-active-background-color);
}
.z-paging-button[disabled] {
  color: var(--zk-disabled-color);
  opacity: var(--zk-disabled-opacity);
  cursor: default;
}
.z-paging-button[disabled]:hover {
  background-color: transparent;
}
.z-paging .z-paging-icon {
  font-size: var(--zk-paging-icon-size);
  line-height: var(--zk-paging-icon-line-height);
}
.z-paging-noborder {
  border-color: transparent;
}
.z-paging-noborder:hover,
.z-paging-noborder:active {
  border-color: transparent;
}
.z-paging-selected {
  color: var(--zk-paging-item-selected-color);
  background: var(--zk-paging-item-selected-background-color);
}
.z-paging-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-font-size-medium);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-paging-color);
  width: 42px;
  height: var(--zk-paging-input-height);
  border: 1px solid var(--zk-paging-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  background: var(--zk-input-background-color);
  margin-left: 6px;
  padding: var(--zk-input-padding);
  line-height: var(--zk-base-line-height);
  vertical-align: baseline;
}
.z-paging-input:hover {
  border-color: var(--zk-input-hover-border-color);
}
.z-paging-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-paging-input[disabled] {
  color: var(--zk-disabled-color);
  opacity: var(--zk-disabled-opacity);
  cursor: default;
}
.z-paging-input[disabled]:hover,
.z-paging-input[disabled]:focus {
  border-color: var(--zk-paging-border-color);
}
.z-paging-text {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-font-size-medium);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-paging-color);
  margin-right: 6px;
}
.z-paging-text-disabled {
  color: var(--zk-disabled-color);
}
.z-paging-info {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-font-size-medium);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-text-color-lighter);
  padding: 8px 0;
  position: absolute;
  top: 4px;
  right: 16px;
}
.z-paging-os {
  border-bottom: none;
  padding-bottom: 4px;
}
.z-paging-os ul > li {
  margin-left: 4px;
}
.z-paging-os ul > li.z-paging-navigate + li,
.z-paging-os ul > li + li.z-paging-navigate {
  margin-left: 8px;
}
.z-paging-os ul > li.z-paging-navigate + li.z-paging-navigate {
  margin-left: 4px;
}
.z-paging-os .z-paging-button {
  font-size: var(--zk-font-size-medium);
  padding: var(--zk-paging-os-button-padding);
}
