/**
 * @{zprefix} v2.31 - A lightweight WYSIWYG editor
 * Default stylesheet for Trumbowyg editor
 * ------------------------
 * @link https://alex-d.github.io/Trumbowyg/
 * @license MIT
 * @author Alexandre Demode (Alex-D)
 *         Twitter : @AlexandreDemode
 *         Website : alex-d.fr
 */
<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
#z-tbeditor-icons {
  overflow: hidden;
  visibility: hidden;
  height: 0;
  width: 0;
}
#z-tbeditor-icons svg {
  height: 0;
  width: 0;
}
.z-tbeditor-box *,
.z-tbeditor-box *::before,
.z-tbeditor-box *::after {
  box-sizing: border-box;
}
.z-tbeditor-box svg {
  width: var(--zk-rem2-125);
  height: 100%;
  fill: #222;
}
.z-tbeditor-box {
  display: flex;
  flex-direction: column;
  position: relative;
  width: 100%;
  min-height: var(--zk-rem3-75);
  margin: 0px auto;
  border: 1px solid #DDD;
}
.z-tbeditor-editor-box {
  display: block;
  flex: 1;
  position: relative;
  width: 100%;
  border: 1px solid #DDD;
}
.z-tbeditor-box .z-tbeditor-editor,
.z-tbeditor-editor-box {
  margin: 0 auto;
}
.z-tbeditor-editor-box .z-tbeditor-editor p {
  margin: 0 0 1em;
}
.z-tbeditor-box.z-tbeditor-fullscreen {
  background: #FEFEFE;
  border: none !important;
}
.z-tbeditor-editor-box > .z-tbeditor-editor,
.z-tbeditor-textarea {
  position: relative;
  box-sizing: border-box;
  padding: 16px;
  min-height: var(--zk-rem3-75);
  width: 100%;
  border-style: none;
  resize: none;
  outline: none;
  overflow: auto;
}
.z-tbeditor-editor.z-tbeditor-autogrow-on-enter,
.z-tbeditor-textarea.z-tbeditor-autogrow-on-enter {
  transition: height 300ms ease-out;
}
.z-tbeditor-box-blur .z-tbeditor-editor *,
.z-tbeditor-box-blur .z-tbeditor-editor::before {
  color: transparent !important;
  text-shadow: 0 0 7px #333;
}
@media screen and (min-width: 0 \0) {
  .z-tbeditor-box-blur .z-tbeditor-editor *,
  .z-tbeditor-box-blur .z-tbeditor-editor::before {
    color: rgba(200, 200, 200, 0.6) !important;
  }
}
@supports (-ms-accelerator: true) {
  .z-tbeditor-box-blur .z-tbeditor-editor *,
  .z-tbeditor-box-blur .z-tbeditor-editor::before {
    color: rgba(200, 200, 200, 0.6) !important;
  }
}
.z-tbeditor-box-blur .z-tbeditor-editor img,
.z-tbeditor-box-blur .z-tbeditor-editor hr {
  opacity: 0.2;
}
.z-tbeditor-editor-box,
.z-tbeditor-textarea {
  position: relative;
  display: block;
  overflow: auto;
  border: none;
  white-space: normal;
  font-size: var(--zk-font-size-small);
  font-family: "Inconsolata", "Consolas", "Courier", "Courier New", sans-serif;
  line-height: var(--zk-rem2-25);
}
.trumbowyg-editor-box {
  padding: 0;
}
.trumbowyg-editor-box {
  padding: 0;
}
.z-tbeditor-box.z-tbeditor-editor-visible .z-tbeditor-textarea {
  height: 1px !important;
  width: 25%;
  min-height: 0 !important;
  padding: 0 !important;
  background: none;
  opacity: 0 !important;
}
.z-tbeditor-box.z-tbeditor-editor-hidden .z-tbeditor-textarea {
  display: block;
}
.z-tbeditor-box.z-tbeditor-editor-hidden .z-tbeditor-editor {
  display: none;
}
.z-tbeditor-box.z-tbeditor-disabled .z-tbeditor-textarea {
  opacity: 0.8;
  background: none;
}
.z-tbeditor-editor-box[contenteditable=true]:empty:not(:focus)::before {
  content: attr(placeholder);
  color: #999;
  pointer-events: none;
}
.z-tbeditor-button-pane {
  width: 100%;
  min-height: var(--zk-rem4-5);
  background: #ecf0f1;
  border-bottom: 1px solid #d7e0e2;
  margin: 0;
  padding: 0 4px;
  position: relative;
  list-style-type: none;
  line-height: var(--zk-rem1-25);
  -webkit-backface-visibility: hidden;
  backface-visibility: hidden;
  z-index: 11;
}
.z-tbeditor-button-pane::after {
  content: " ";
  display: block;
  position: absolute;
  top: 32px;
  left: 0;
  right: 0;
  width: 100%;
  height: 1px;
  background: #d7e0e2;
}
.z-tbeditor-button-pane .z-tbeditor-button-group {
  display: inline-block;
}
.z-tbeditor-button-pane .z-tbeditor-button-group .z-tbeditor-fullscreen-button svg {
  color: transparent;
}
.z-tbeditor-button-pane .z-tbeditor-button-group:not(:empty) + .z-tbeditor-button-group::before {
  content: " ";
  display: inline-block;
  width: 1px;
  background: #d7e0e2;
  margin: 0 4px;
  height: var(--zk-rem4-375);
  vertical-align: top;
}
.z-tbeditor-button-pane button {
  display: inline-block;
  position: relative;
  width: var(--zk-rem4-375);
  height: var(--zk-rem4-375);
  padding: 1px 6px !important;
  margin-bottom: 1px;
  overflow: hidden;
  border: none;
  cursor: pointer;
  background: none;
  vertical-align: baseline;
  transition: background-color 150ms, opacity 150ms;
}
.z-tbeditor-button-pane button.z-tbeditor-textual-button {
  width: auto;
  line-height: var(--zk-rem4-375);
}
.z-tbeditor-button-pane.z-tbeditor-disable button:not(.z-tbeditor-not-disable):not(.z-tbeditor-active),
.z-tbeditor-disabled .z-tbeditor-button-pane button:not(.z-tbeditor-not-disable):not(.z-tbeditor-viewHTML-button) {
  opacity: 0.2;
  cursor: default;
}
.z-tbeditor-button-pane.z-tbeditor-disable .z-tbeditor-button-group::before,
.z-tbeditor-disabled .z-tbeditor-button-pane .z-tbeditor-button-group::before {
  background: #e3e9eb;
}
.z-tbeditor-button-pane button:not(.z-tbeditor-disable):hover,
.z-tbeditor-button-pane button:not(.z-tbeditor-disable):focus,
.z-tbeditor-button-pane button.z-tbeditor-active {
  background-color: #FFF;
  outline: none;
}
.z-tbeditor-button-pane .z-tbeditor-open-dropdown::after {
  display: block;
  content: " ";
  position: absolute;
  top: 25px;
  right: 2px;
  height: 0;
  width: 0;
  border: 3px solid transparent;
  border-top-color: #555;
}
.z-tbeditor-button-pane .z-tbeditor-open-dropdown.z-tbeditor-textual-button {
  padding-left: 8px !important;
  padding-right: 16px !important;
}
.z-tbeditor-button-pane .z-tbeditor-open-dropdown.z-tbeditor-textual-button::after {
  top: 17px;
  right: 6px;
}
.z-tbeditor-button-pane .z-tbeditor-right {
  float: right;
}
.z-tbeditor-button-pane .z-tbeditor-right::before {
  display: none !important;
}
.z-tbeditor-dropdown {
  width: var(--zk-rem25);
  border: 1px solid #ecf0f1;
  padding: 4px 0;
  border-top: none;
  background: #FFF;
  margin-left: -1px;
  box-shadow: rgba(0, 0, 0, 0.1) 0 2px 3px;
  z-index: 11;
}
.z-tbeditor-dropdown button {
  display: block;
  width: 100%;
  height: var(--zk-rem4-375);
  line-height: var(--zk-rem4-375);
  text-decoration: none;
  background: #FFF;
  padding: 0 8px;
  color: #333 !important;
  border: none;
  cursor: pointer;
  text-align: left;
  font-size: var(--zk-font-size-small);
  transition: all 150ms;
}
.z-tbeditor-dropdown button:hover,
.z-tbeditor-dropdown button:focus {
  background: #ecf0f1;
}
.z-tbeditor-dropdown button svg {
  float: left;
  margin-right: 12px;
}
/* Modal box */
.z-tbeditor-modal {
  position: absolute;
  top: 0;
  left: 50%;
  -webkit-transform: translateX(-50%);
  transform: translateX(-50%);
  max-width: var(--zk-rem65);
  width: 100%;
  height: var(--zk-rem43-75);
  z-index: 11;
  overflow: hidden;
  -webkit-backface-visibility: hidden;
  backface-visibility: hidden;
}
.z-tbeditor-modal-box {
  position: absolute;
  top: 0;
  left: 50%;
  -webkit-transform: translateX(-50%);
  transform: translateX(-50%);
  padding-bottom: 45px;
  max-width: var(--zk-rem62-5);
  width: calc(100% - var(--zk-rem2-5));
  z-index: 1;
  background-color: #FFF;
  text-align: center;
  font-size: var(--zk-font-size-small);
  box-shadow: rgba(0, 0, 0, 0.2) 0 2px 3px;
  -webkit-backface-visibility: hidden;
  backface-visibility: hidden;
}
.z-tbeditor-modal-box .z-tbeditor-modal-title {
  font-size: var(--zk-font-size-large);
  font-weight: bold;
  margin: 0 0 20px;
  padding: 15px 0 13px;
  display: block;
  border-bottom: 1px solid #EEE;
  color: #333;
  background: #fbfcfc;
}
.z-tbeditor-modal-box .z-tbeditor-progress {
  width: 100%;
  height: var(--zk-rem0-375);
  position: absolute;
  top: 58px;
}
.z-tbeditor-modal-box .z-tbeditor-progress .z-tbeditor-progress-bar {
  background: #2BC06A;
  height: 100%;
  transition: width 150ms linear;
}
.z-tbeditor-modal-box label {
  display: block;
  position: relative;
  margin: 16px 12px;
  height: var(--zk-rem3-625);
  line-height: var(--zk-rem3-625);
  overflow: hidden;
}
.z-tbeditor-modal-box label .z-tbeditor-input-infos {
  display: block;
  text-align: left;
  height: var(--zk-rem3-125);
  line-height: var(--zk-rem3-125);
  transition: all 150ms;
}
.z-tbeditor-modal-box label .z-tbeditor-input-infos span {
  display: block;
  color: #69878f;
  background-color: #fbfcfc;
  border: 1px solid #DEDEDE;
  padding: 0 6px;
  width: var(--zk-rem18-75);
}
.z-tbeditor-modal-box label .z-tbeditor-input-infos span.z-tbeditor-msg-error {
  color: #e74c3c;
}
.z-tbeditor-modal-box label.z-tbeditor-input-error input,
.z-tbeditor-modal-box label.z-tbeditor-input-error textarea {
  border: 1px solid #e74c3c;
}
.z-tbeditor-modal-box label.z-tbeditor-input-error .z-tbeditor-input-infos {
  margin-top: -27px;
}
.z-tbeditor-modal-box label input {
  position: absolute;
  top: 0;
  right: 0;
  height: var(--zk-rem3-375);
  line-height: var(--zk-rem3-375);
  border: 1px solid #DEDEDE;
  background: #fff;
  font-size: var(--zk-font-size-small);
  max-width: var(--zk-rem41-25);
  width: 70%;
  padding: 0 6px;
  transition: all 150ms;
}
.z-tbeditor-modal-box label input:hover,
.z-tbeditor-modal-box label input:focus {
  outline: none;
  border: 1px solid #95a5a6;
}
.z-tbeditor-modal-box label input:focus {
  background: #fbfcfc;
}
.z-tbeditor-modal-box .error {
  margin-top: 25px;
  display: block;
  color: red;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button {
  position: absolute;
  bottom: 8px;
  right: 0;
  text-decoration: none;
  color: #FFF;
  display: block;
  width: var(--zk-rem12-5);
  height: var(--zk-rem4-375);
  line-height: var(--zk-rem4-125);
  margin: 0 8px;
  background-color: #333;
  border: none;
  cursor: pointer;
  font-family: "Trebuchet MS", Helvetica, Verdana, sans-serif;
  font-size: var(--zk-font-size-medium);
  transition: all 150ms;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit {
  right: 110px;
  background: #2bc06a;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:hover,
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:focus {
  background: #40d47e;
  outline: none;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:active {
  background: #25a25a;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset {
  color: #555;
  background: #e6e6e6;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:hover,
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:focus {
  background: #fbfbfb;
  outline: none;
}
.z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:active {
  background: #d5d5d5;
}
.z-tbeditor-overlay {
  position: absolute;
  background-color: rgba(255, 255, 255, 0.5);
  height: 100%;
  width: 100%;
  left: 0;
  display: none;
  top: 0;
  z-index: 10;
}
/**
 * Fullscreen
 */
body.z-tbeditor-body-fullscreen {
  overflow: hidden;
}
.z-tbeditor-fullscreen {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  margin: 0;
  padding: 0;
  z-index: 99999;
}
.z-tbeditor-fullscreen.z-tbeditor-box,
.z-tbeditor-fullscreen .z-tbeditor-editor-box,
.z-tbeditor-fullscreen .z-tbeditor-editor {
  border: none;
}
.z-tbeditor-fullscreen .z-tbeditor-editor,
.z-tbeditor-fullscreen .z-tbeditor-editor-box,
.z-tbeditor-fullscreen .z-tbeditor-textarea {
  height: calc(100% - 37px) !important;
  overflow: auto;
}
.z-tbeditor-fullscreen .z-tbeditor-overlay {
  height: 100% !important;
}
.z-tbeditor-fullscreen .z-tbeditor-button-group .z-tbeditor-fullscreen-button svg {
  color: #222;
  fill: transparent;
}
.z-tbeditor-editor {
  /*
     * lset for resetCss option
     */
}
.z-tbeditor-editor object,
.z-tbeditor-editor embed,
.z-tbeditor-editor video,
.z-tbeditor-editor img {
  max-width: 100%;
}
.z-tbeditor-editor video,
.z-tbeditor-editor img {
  height: auto;
}
.z-tbeditor-editor img {
  cursor: move;
}
.z-tbeditor-editor.z-tbeditor-reset-css {
  background: #FEFEFE !important;
  font-family: "Trebuchet MS", Helvetica, Verdana, sans-serif !important;
  font-size: var(--zk-font-size-small) !important;
  line-height: 1.45em !important;
  white-space: normal !important;
  color: #333;
}
.z-tbeditor-editor.z-tbeditor-reset-css a {
  color: #15c !important;
  text-decoration: underline !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css div,
.z-tbeditor-editor.z-tbeditor-reset-css p,
.z-tbeditor-editor.z-tbeditor-reset-css ul,
.z-tbeditor-editor.z-tbeditor-reset-css ol,
.z-tbeditor-editor.z-tbeditor-reset-css blockquote {
  box-shadow: none !important;
  background: none !important;
  margin: 0 !important;
  margin-bottom: 15px !important;
  line-height: 1.4em !important;
  font-family: "Trebuchet MS", Helvetica, Verdana, sans-serif !important;
  font-size: var(--zk-font-size-small) !important;
  border: none;
}
.z-tbeditor-editor.z-tbeditor-reset-css iframe,
.z-tbeditor-editor.z-tbeditor-reset-css object,
.z-tbeditor-editor.z-tbeditor-reset-css hr {
  margin-bottom: 15px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css blockquote {
  margin-left: 32px !important;
  font-style: italic !important;
  color: #555;
}
.z-tbeditor-editor.z-tbeditor-reset-css ul,
.z-tbeditor-editor.z-tbeditor-reset-css ol {
  padding-left: 20px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css ul ul,
.z-tbeditor-editor.z-tbeditor-reset-css ol ol,
.z-tbeditor-editor.z-tbeditor-reset-css ul ol,
.z-tbeditor-editor.z-tbeditor-reset-css ol ul {
  border: none;
  margin: 2px !important;
  padding: 0 !important;
  padding-left: 24px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css hr {
  display: block;
  height: 1px;
  border: none;
  border-top: 1px solid #CCC;
}
.z-tbeditor-editor.z-tbeditor-reset-css h1,
.z-tbeditor-editor.z-tbeditor-reset-css h2,
.z-tbeditor-editor.z-tbeditor-reset-css h3,
.z-tbeditor-editor.z-tbeditor-reset-css h4 {
  color: #111;
  background: none;
  margin: 0 !important;
  padding: 0 !important;
  font-weight: bold;
}
.z-tbeditor-editor.z-tbeditor-reset-css h1 {
  font-size: var(--zk-font-size-large) !important;
  line-height: var(--zk-rem4-75) !important;
  margin-bottom: 20px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css h2 {
  font-size: var(--zk-font-size-large) !important;
  line-height: var(--zk-rem4-25) !important;
  margin-bottom: 15px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css h3 {
  font-size: var(--zk-font-size-large) !important;
  line-height: var(--zk-rem3-5) !important;
  margin-bottom: 6px !important;
}
.z-tbeditor-editor.z-tbeditor-reset-css h4 {
  font-size: var(--zk-font-size-medium) !important;
  line-height: var(--zk-rem2-75) !important;
  margin-bottom: 6px !important;
}
/*
 * Dark theme
 */
.z-tbeditor-dark .z-tbeditor-textarea {
  background: #111;
  color: #ddd;
}
.z-tbeditor-dark .z-tbeditor-box {
  border: 1px solid #343434;
}
.z-tbeditor-dark .z-tbeditor-box.z-tbeditor-fullscreen {
  background: #111;
}
.z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor *,
.z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor::before {
  text-shadow: 0 0 7px #ccc;
}
@media screen and (min-width: 0 \0 ) {
  .z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor *,
  .z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor::before {
    color: rgba(20, 20, 20, 0.6) !important;
  }
}
@supports (-ms-accelerator: true) {
  .z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor *,
  .z-tbeditor-dark .z-tbeditor-box.z-tbeditor-box-blur .z-tbeditor-editor::before {
    color: rgba(20, 20, 20, 0.6) !important;
  }
}
.z-tbeditor-dark .z-tbeditor-box svg {
  fill: #ecf0f1;
  color: #ecf0f1;
}
.z-tbeditor-dark .z-tbeditor-button-pane {
  background-color: #222;
  border-bottom-color: #343434;
}
.z-tbeditor-dark .z-tbeditor-button-pane::after {
  background: #343434;
}
.z-tbeditor-dark .z-tbeditor-button-pane .z-tbeditor-button-group:not(:empty)::before {
  background-color: #343434;
}
.z-tbeditor-dark .z-tbeditor-button-pane .z-tbeditor-button-group:not(:empty) .z-tbeditor-fullscreen-button svg {
  color: transparent;
}
.z-tbeditor-dark .z-tbeditor-button-pane.z-tbeditor-disable .z-tbeditor-button-group::before {
  background-color: #2a2a2a;
}
.z-tbeditor-dark .z-tbeditor-button-pane button:not(.z-tbeditor-disable):hover,
.z-tbeditor-dark .z-tbeditor-button-pane button:not(.z-tbeditor-disable):focus,
.z-tbeditor-dark .z-tbeditor-button-pane button.z-tbeditor-active {
  background-color: #333;
}
.z-tbeditor-dark .z-tbeditor-button-pane .z-tbeditor-open-dropdown::after {
  border-top-color: #fff;
}
.z-tbeditor-dark .z-tbeditor-fullscreen .z-tbeditor-button-group .z-tbeditor-fullscreen-button svg {
  color: #ecf0f1;
  fill: transparent;
}
.z-tbeditor-dark .z-tbeditor-dropdown {
  border-color: #222;
  background: #333;
  box-shadow: rgba(0, 0, 0, 0.3) 0 2px 3px;
}
.z-tbeditor-dark .z-tbeditor-dropdown button {
  background: #333;
  color: #fff !important;
}
.z-tbeditor-dark .z-tbeditor-dropdown button:hover,
.z-tbeditor-dark .z-tbeditor-dropdown button:focus {
  background: #222;
}
.z-tbeditor-dark .z-tbeditor-modal-box {
  background-color: #222;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-title {
  border-bottom: 1px solid #555;
  color: #fff;
  background: #3c3c3c;
}
.z-tbeditor-dark .z-tbeditor-modal-box label {
  display: block;
  position: relative;
  margin: 15px 12px;
  height: var(--zk-rem3-375);
  line-height: var(--zk-rem3-375);
  overflow: hidden;
}
.z-tbeditor-dark .z-tbeditor-modal-box label .z-tbeditor-input-infos span {
  color: #eee;
  background-color: #2f2f2f;
  border-color: #222;
}
.z-tbeditor-dark .z-tbeditor-modal-box label .z-tbeditor-input-infos span.z-tbeditor-msg-error {
  color: #e74c3c;
}
.z-tbeditor-dark .z-tbeditor-modal-box label.z-tbeditor-input-error input,
.z-tbeditor-dark .z-tbeditor-modal-box label.z-tbeditor-input-error textarea {
  border-color: #e74c3c;
}
.z-tbeditor-dark .z-tbeditor-modal-box label input {
  border-color: #222;
  color: #eee;
  background: #333;
}
.z-tbeditor-dark .z-tbeditor-modal-box label input:hover,
.z-tbeditor-dark .z-tbeditor-modal-box label input:focus {
  border-color: #626262;
}
.z-tbeditor-dark .z-tbeditor-modal-box label input:focus {
  background-color: #2f2f2f;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit {
  background: #1b7943;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:hover,
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:focus {
  background: #25a25a;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-submit:active {
  background: #176437;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset {
  background: #333;
  color: #ccc;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:hover,
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:focus {
  background: #444;
}
.z-tbeditor-dark .z-tbeditor-modal-box .z-tbeditor-modal-button.z-tbeditor-modal-reset:active {
  background: #111;
}
.z-tbeditor-dark .z-tbeditor-overlay {
  background-color: rgba(15, 15, 15, 0.6);
}
