<%@ taglib uri="http://www.zkoss.org/dsp/web/core" prefix="c" %>
<%@ taglib uri="http://www.zkoss.org/dsp/zk/core" prefix="z" %>
<%@ taglib uri="http://www.zkoss.org/dsp/web/theme" prefix="t" %>
.z-combobox {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-combobox-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-combobox-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-combobox-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-combobox-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-combobox-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-combobox-input.z-combobox-hover,
.z-combobox-input.z-combobox-hover + .z-combobox-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-combobox-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-combobox-input:focus + .z-combobox-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-combobox-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-combobox-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-combobox-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-combobox-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-combobox-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-combobox-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-combobox-disabled > a,
.z-combobox-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-combobox-disabled .z-combobox-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-combobox-button.z-combobox-disabled {
  display: none;
}
.z-combobox-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-combobox-invalid + .z-combobox-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-combobox-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-combobox-readonly .z-combobox-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-combobox-inplace .z-combobox-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-combobox-inplace .z-combobox-button {
  visibility: hidden;
}
.z-bandbox {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-bandbox-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-bandbox-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-bandbox-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-bandbox-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-bandbox-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-bandbox-input.z-bandbox-hover,
.z-bandbox-input.z-bandbox-hover + .z-bandbox-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-bandbox-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-bandbox-input:focus + .z-bandbox-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-bandbox-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-bandbox-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-bandbox-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-bandbox-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-bandbox-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-bandbox-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-bandbox-disabled > a,
.z-bandbox-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-bandbox-disabled .z-bandbox-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-bandbox-button.z-bandbox-disabled {
  display: none;
}
.z-bandbox-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-bandbox-invalid + .z-bandbox-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-bandbox-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-bandbox-readonly .z-bandbox-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-bandbox-inplace .z-bandbox-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-bandbox-inplace .z-bandbox-button {
  visibility: hidden;
}
.z-datebox {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-datebox-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-datebox-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-datebox-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-datebox-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-datebox-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-datebox-input.z-datebox-hover,
.z-datebox-input.z-datebox-hover + .z-datebox-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-datebox-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-datebox-input:focus + .z-datebox-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-datebox-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-datebox-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-datebox-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-datebox-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-datebox-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-datebox-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-datebox-disabled > a,
.z-datebox-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-datebox-disabled .z-datebox-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-datebox-button.z-datebox-disabled {
  display: none;
}
.z-datebox-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-datebox-invalid + .z-datebox-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-datebox-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-datebox-readonly .z-datebox-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-datebox-inplace .z-datebox-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-datebox-inplace .z-datebox-button {
  visibility: hidden;
}
.z-timebox {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-timebox-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-timebox-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-timebox-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-timebox-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-timebox-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-timebox-input.z-timebox-hover,
.z-timebox-input.z-timebox-hover + .z-timebox-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-timebox-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-timebox-input:focus + .z-timebox-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-timebox-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-timebox-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-timebox-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-timebox-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-timebox-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-timebox-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-timebox-disabled > a,
.z-timebox-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-timebox-disabled .z-timebox-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-timebox-button.z-timebox-disabled {
  display: none;
}
.z-timebox-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-timebox-invalid + .z-timebox-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-timebox-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-timebox-readonly .z-timebox-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-timebox-inplace .z-timebox-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-timebox-inplace .z-timebox-button {
  visibility: hidden;
}
.z-spinner {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-spinner-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-spinner-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-spinner-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-spinner-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-spinner-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-spinner-input.z-spinner-hover,
.z-spinner-input.z-spinner-hover + .z-spinner-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-spinner-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-spinner-input:focus + .z-spinner-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-spinner-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-spinner-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-spinner-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-spinner-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-spinner-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-spinner-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-spinner-disabled > a,
.z-spinner-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-spinner-disabled .z-spinner-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-spinner-button.z-spinner-disabled {
  display: none;
}
.z-spinner-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-spinner-invalid + .z-spinner-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-spinner-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-spinner-readonly .z-spinner-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-spinner-inplace .z-spinner-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-spinner-inplace .z-spinner-button {
  visibility: hidden;
}
.z-doublespinner {
  display: inline-block;
  height: var(--zk-combo-input-height);
  font-size: var(--zk-input-text-size);
  line-height: normal;
  white-space: nowrap;
  position: relative;
}
.z-doublespinner-input {
  font-family: var(--zk-base-content-font-family);
  font-size: var(--zk-input-text-size);
  font-weight: normal;
  font-style: normal;
  color: var(--zk-input-color);
  width: 100%;
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  margin: 0;
  padding: var(--zk-input-padding);
  padding-right: var(--zk-combo-input-padding-right);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
}
.z-doublespinner-input::-webkit-input-placeholder {
  color: var(--zk-input-placeholder-color);
}
.z-doublespinner-input:-moz-placeholder {
  /* FF 4-18 */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-doublespinner-input::-moz-placeholder {
  /* FF 19+ */
  color: var(--zk-input-placeholder-color);
  opacity: 1;
}
.z-doublespinner-input:-ms-input-placeholder {
  /* IE 10+ */
  color: var(--zk-input-placeholder-color);
}
.z-doublespinner-input.z-doublespinner-hover,
.z-doublespinner-input.z-doublespinner-hover + .z-doublespinner-button {
  border-color: var(--zk-input-hover-border-color);
}
.z-doublespinner-input:focus {
  border-color: var(--zk-input-focus-border-color);
}
.z-doublespinner-input:focus + .z-doublespinner-button {
  border-left: 1px solid var(--zk-input-focus-border-color);
}
.z-doublespinner-input-full {
  padding-right: var(--zk-input-padding-right);
}
.z-doublespinner-button {
  font-size: var(--zk-combo-button-icon-size);
  color: var(--zk-combo-button-icon-color);
  display: inline-block;
  position: absolute;
  top: 0;
  right: 0;
  min-width: var(--zk-combo-button-min-width);
  height: var(--zk-combo-input-height);
  border: 1px solid var(--zk-input-border-color);
  -webkit-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -moz-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -o-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  -ms-border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  border-radius: 0 var(--zk-base-border-radius) var(--zk-base-border-radius) 0;
  padding: var(--zk-combo-button-padding);
  line-height: var(--zk-base-line-height);
  background: var(--zk-input-background-color);
  text-align: center;
  vertical-align: middle;
  overflow: hidden;
  cursor: pointer;
}
.z-doublespinner-button:hover {
  border-color: var(--zk-combo-button-hover-border-color);
  background: var(--zk-combo-button-hover-background-color);
}
.z-doublespinner-button:active {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background-color: var(--zk-combo-button-active-background-color);
}
.z-doublespinner-disabled {
  opacity: var(--zk-disabled-opacity);
}
.z-doublespinner-disabled > input {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-doublespinner-disabled > a,
.z-doublespinner-disabled > span {
  color: var(--zk-input-disable-color) !important;
  background: var(--zk-input-disable-background-color) !important;
  cursor: default !important;
}
.z-doublespinner-disabled .z-doublespinner-button:hover {
  border-color: var(--zk-input-border-color);
}
.z-doublespinner-button.z-doublespinner-disabled {
  display: none;
}
.z-doublespinner-invalid {
  border-color: var(--zk-invalid-border-color) !important;
}
.z-doublespinner-invalid + .z-doublespinner-button {
  border-left: 1px solid var(--zk-invalid-border-color) !important;
}
.z-doublespinner-readonly > input {
  color: var(--zk-input-readonly-color);
  background: var(--zk-input-readonly-background-color);
}
.z-doublespinner-readonly .z-doublespinner-button {
  color: var(--zk-input-readonly-color);
  background-color: var(--zk-input-background-color);
}
.z-doublespinner-inplace .z-doublespinner-input {
  border: 0;
  padding: 4px;
  background: none;
}
.z-doublespinner-inplace .z-doublespinner-button {
  visibility: hidden;
}
.z-combobox-readonly > input,
.z-bandbox-readonly > input,
.z-datebox-readonly > input {
  cursor: pointer;
}
.z-datebox-button,
.z-bandbox-button,
.z-combobox-button {
  font-size: var(--zk-combo-button-icon-size-large);
  min-height: var(--zk-base-button-height);
}
.z-datebox-button,
.z-bandbox-button {
  text-align: center;
}
.z-combobox-open .z-combobox-button,
.z-bandbox-open .z-bandbox-button,
.z-datebox-open .z-datebox-button {
  border-color: var(--zk-input-focus-border-color);
}
.z-timebox-disabled a,
.z-spinner-disabled a,
.z-doublespinner-disabled a {
  color: var(--zk-disabled-color);
}
.z-timebox-disabled a:hover,
.z-spinner-disabled a:hover,
.z-doublespinner-disabled a:hover {
  background: 0;
}
.z-timebox-disabled span > i,
.z-spinner-disabled span > i,
.z-doublespinner-disabled span > i {
  display: none;
}
.z-timebox-button,
.z-spinner-button,
.z-doublespinner-button {
  width: var(--zk-spinner-button-width);
  padding: 0;
}
.z-timebox-button:hover,
.z-spinner-button:hover,
.z-doublespinner-button:hover,
.z-timebox-button:active,
.z-spinner-button:active,
.z-doublespinner-button:active {
  background: var(--zk-input-background-color);
}
.z-timebox-button > i,
.z-spinner-button > i,
.z-doublespinner-button > i {
  z-index: 2;
}
.z-timebox-button > a,
.z-spinner-button > a,
.z-doublespinner-button > a {
  display: block;
  color: var(--zk-text-color-default);
  height: var(--zk-spinner-button-icon-height);
  padding: var(--zk-spinner-button-padding);
  overflow: hidden;
  text-decoration: none;
}
.z-timebox-disabled .z-timebox-button > a,
.z-timebox-disabled .z-spinner-button > a,
.z-timebox-disabled .z-doublespinner-button > a,
.z-spinner-disabled .z-timebox-button > a,
.z-spinner-disabled .z-spinner-button > a,
.z-spinner-disabled .z-doublespinner-button > a,
.z-doublespinner-disabled .z-timebox-button > a,
.z-doublespinner-disabled .z-spinner-button > a,
.z-doublespinner-disabled .z-doublespinner-button > a {
  color: var(--zk-disabled-color);
}
.z-timebox-button > a > i,
.z-spinner-button > a > i,
.z-doublespinner-button > a > i {
  -webkit-transform: var(--zk-spinner-button-icon-transform);
  -moz-transform: var(--zk-spinner-button-icon-transform);
  -o-transform: var(--zk-spinner-button-icon-transform);
  -ms-transform: var(--zk-spinner-button-icon-transform);
  transform: var(--zk-spinner-button-icon-transform);
}
.z-timebox-button > a:hover,
.z-spinner-button > a:hover,
.z-doublespinner-button > a:hover {
  background: var(--zk-combo-button-hover-background-color);
}
.z-timebox-button:hover > i,
.z-spinner-button:hover > i,
.z-doublespinner-button:hover > i {
  width: 100%;
  height: 1px;
  border-top: 1px solid var(--zk-combo-button-hover-border-color);
  position: absolute;
  top: var(--zk-spinner-button-icon-position-top);
  left: 0;
}
.z-timebox-active.z-timebox-icon,
.z-timebox-active.z-timebox-icon:hover {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background: var(--zk-combo-button-active-background-color);
}
.z-spinner-active.z-spinner-icon,
.z-spinner-active.z-spinner-icon:hover {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background: var(--zk-combo-button-active-background-color);
}
.z-doublespinner-active.z-doublespinner-icon,
.z-doublespinner-active.z-doublespinner-icon:hover {
  color: var(--zk-combo-button-active-icon-color);
  border-color: var(--zk-combo-button-active-border-color);
  background: var(--zk-combo-button-active-background-color);
}
.z-combobox-empty-search-message {
  display: block;
  padding: 4px 8px;
  position: relative;
  min-height: calc(var(--zk-combo-popup-item-size) + 2px + 4px * 2);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  color: var(--zk-disabled-color);
}
.z-combobox-empty-search-message-hidden {
  display: none;
}
.z-comboitem,
.z-comboitem-button {
  font-size: var(--zk-combo-popup-item-size);
  white-space: nowrap;
  cursor: pointer;
}
.z-comboitem {
  display: block;
  padding: var(--zk-comboitem-padding);
  position: relative;
  min-height: var(--zk-comboitem-empty-height);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
}
.z-comboitem-inner,
.z-comboitem-content {
  font-size: var(--zk-comboitem-inner-font-size);
  color: var(--zk-combo-popup-desc-color);
}
.z-comboitem,
.z-comboitem a,
.z-comboitem a:visited {
  font-size: var(--zk-combo-popup-item-size);
  font-weight: normal;
  color: var(--zk-combo-popup-item-color);
  text-decoration: none;
}
.z-comboitem:hover {
  background-color: var(--zk-combo-popup-item-hover-background-color);
}
.z-comboitem-selected {
  color: var(--zk-combo-popup-item-selected-color);
}
.z-comboitem-text {
  line-height: calc(var(--zk-combo-popup-item-size) + 2px);
}
.z-comboitem-image {
  margin-top: -4px;
  margin-right: 4px;
  float: left;
}
.z-comboitem-image:empty {
  margin-right: 0;
}
.z-comboitem-icon {
  font-size: var(--zk-combo-popup-icon-size);
  color: var(--zk-combo-popup-icon-color);
  padding-right: 4px;
}
.z-combobox-popup,
.z-bandbox-popup,
.z-datebox-popup,
.z-timebox-popup {
  font-family: var(--zk-base-content-font-family);
  font-weight: normal;
  font-size: var(--zk-font-size-medium);
  color: var(--zk-text-color-default);
  display: block;
  border: 1px solid var(--zk-combo-popup-border-color);
  -webkit-border-radius: var(--zk-base-border-radius);
  -moz-border-radius: var(--zk-base-border-radius);
  -o-border-radius: var(--zk-base-border-radius);
  -ms-border-radius: var(--zk-base-border-radius);
  border-radius: var(--zk-base-border-radius);
  padding: var(--zk-comboitem-padding);
  background: var(--zk-popup-background-color);
  position: absolute;
  overflow: hidden;
}
.z-combobox-popup {
  overflow: auto;
  min-height: var(--zk-rem1-25);
}
.z-bandbox-popup {
  overflow: auto;
  padding: 8px;
  min-height: var(--zk-rem1-25);
}
.z-combobox-content {
  border: 0;
  padding: 0;
  margin: 0;
  background: transparent none repeat 0 0;
  position: relative;
  list-style: none outside none;
  min-width: 100%;
  display: inline-block;
}
.z-combobox-shadow,
.z-bandbox-shadow,
.z-datebox-shadow {
  -webkit-box-shadow: 0 3px 6px 0 rgba(0,0,0,0.16), 0 2px 4px 0 rgba(0,0,0,0.24);
  -moz-box-shadow: 0 3px 6px 0 rgba(0,0,0,0.16), 0 2px 4px 0 rgba(0,0,0,0.24);
  -o-box-shadow: 0 3px 6px 0 rgba(0,0,0,0.16), 0 2px 4px 0 rgba(0,0,0,0.24);
  -ms-box-shadow: 0 3px 6px 0 rgba(0,0,0,0.16), 0 2px 4px 0 rgba(0,0,0,0.24);
  box-shadow: 0 3px 6px 0 rgba(0,0,0,0.16), 0 2px 4px 0 rgba(0,0,0,0.24);
}
