/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.util.Maps;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Templates;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zuti.zul.CollectionTemplateResolver;
import org.zkoss.zuti.zul.ForEach;

public class CollectionTemplate
implements DynamicPropertied,
Serializable {
    private static final long serialVersionUID = -2153217142078824636L;
    private boolean _autodrop;
    private Component _host;
    private ForEachEx _forEach;
    private Map<String, Object> _props;
    private String _template;
    private String _templateURI;
    private ExecutionTemplate _execTemplate;

    public CollectionTemplate(boolean autodrop) {
        this._autodrop = autodrop;
        this.init();
    }

    private void init() {
        this._props = new LinkedHashMap<String, Object>();
        this._forEach = new ForEachEx();
        this._execTemplate = new ExecutionTemplate();
    }

    public Component getShadowHost() {
        return this._host;
    }

    public void setModel(ListModel model) {
        this._forEach.setItems(model);
    }

    public ListModel getModel() {
        return (ListModel)this._forEach.getItems();
    }

    public void setTemplateResolver(CollectionTemplateResolver templateResolver) {
        this._execTemplate.setTemplateResolver(templateResolver);
    }

    public String getTemplate() {
        return this._template;
    }

    public void setTemplate(String template) {
        this._template = template;
        this._execTemplate.setTemplateResolver(new CollectionTemplateResolverImpl(template));
    }

    public void setTemplateURI(String templateURI) {
        this._templateURI = templateURI;
        this._execTemplate.setTemplateResolver(new CollectionTemplateResolverImpl(templateURI, this._props));
    }

    public String getTemplateURI() {
        return this._templateURI;
    }

    public void apply(Component host) {
        if (this._autodrop) {
            this.applyDropTrue(host);
        } else {
            this.applyDropFalse(host);
        }
    }

    private void applyDropTrue(Component host) {
        if (host == null) {
            Component firstInsertion = this._forEach.getFirstInsertion();
            if (firstInsertion != null) {
                Component lastInsertion = this._forEach.getLastInsertion();
                Component next = firstInsertion;
                Component end = lastInsertion.getNextSibling();
                while (next != end) {
                    Component tmp = next.getNextSibling();
                    next.detach();
                    next = tmp;
                }
            }
            this._forEach.mergeSubTree();
            this._forEach.detach();
            this._host = null;
            return;
        }
        if (this._host != null) {
            if (this._host != host) {
                throw new UiException("The shadow element cannot change its host, if existed. [" + String.valueOf(this) + "], please apply with null first!.");
            }
        } else {
            this._host = host;
            this._forEach.setShadowHost(this._host, null);
        }
        if (this._forEach.getAfterCompose()) {
            this._forEach.recreate();
        } else {
            this._forEach.afterCompose();
        }
    }

    private void applyDropFalse(Component host) {
        if (host == null) {
            throw new UiException("The shadow host cannot be null. [" + String.valueOf(this) + "].");
        }
        this._host = host;
        this._forEach.setShadowHost(this._host, null);
        if (this._forEach.getAfterCompose()) {
            this._forEach.recreate();
        } else {
            this._forEach.afterCompose();
        }
        this._forEach.mergeSubTree();
        this._forEach.detach();
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._props.put(name, value);
    }

    private class CollectionTemplateResolverImpl
    implements CollectionTemplateResolver {
        private String _templateName;
        private String _uri;
        private Map _arg;
        Map<String, Template> _templateCache = new HashMap<String, Template>(4);

        public CollectionTemplateResolverImpl(String templateName) {
            this._templateName = templateName;
        }

        public CollectionTemplateResolverImpl(String uri, Map<?, ?> arg) {
            this._uri = uri;
            this._arg = arg;
        }

        private Template lookupTemplate(Component comp, ForEachEx base, String name) {
            Template templateFromeCache = this._templateCache.get(name);
            if (templateFromeCache != null) {
                return templateFromeCache;
            }
            Template t = Templates.lookup((Component)comp, (Component)base, (String)name, null, (boolean)true);
            if (t != null) {
                this._templateCache.put(name, t);
            }
            return t;
        }

        private Template getTemplateURI() {
            if (this._uri != null && this._uri.length() > 0) {
                String uri = this._uri;
                int queryStart = uri.indexOf(63);
                String queryString = null;
                if (queryStart >= 0) {
                    queryString = uri.substring(queryStart + 1);
                    uri = uri.substring(0, queryStart);
                }
                Map map = Maps.parse(null, (String)queryString, (char)'&', (char)'=', (boolean)false);
                HashMap arg = new HashMap();
                arg.putAll(this._arg);
                arg.putAll(map);
                return new Template(){

                    public Component[] create(Component parent, Component insertBefore, VariableResolver resolver, Composer composer) {
                        Execution exec = Executions.getCurrent();
                        return exec.createComponents(CollectionTemplateResolverImpl.this._uri, parent, insertBefore, resolver, CollectionTemplateResolverImpl.this._arg);
                    }

                    public Map<String, Object> getParameters() {
                        return null;
                    }
                };
            }
            return null;
        }

        public Template resolve(Object o) {
            if (this._templateName != null && this._templateName.length() > 0) {
                return this.lookupTemplate((Component)CollectionTemplate.this._forEach, CollectionTemplate.this._forEach, this._templateName);
            }
            return this.getTemplateURI();
        }
    }

    private class ExecutionTemplate
    implements Template {
        CollectionTemplateResolver _templateResolver;

        public ExecutionTemplate() {
        }

        public ExecutionTemplate(CollectionTemplateResolver templateResolver) {
            this._templateResolver = templateResolver;
        }

        public void setTemplateResolver(CollectionTemplateResolver templateResolver) {
            this._templateResolver = templateResolver;
        }

        public CollectionTemplateResolver getTemplateResolver() {
            return this._templateResolver;
        }

        public Component[] create(Component parent, Component insertBefore, VariableResolver resolver, Composer composer) {
            Template resolvedTemplate = this._templateResolver.resolve(resolver.resolveVariable(CollectionTemplate.this._forEach.getVar()));
            if (resolvedTemplate != null) {
                return resolvedTemplate.create(parent, insertBefore, resolver, composer);
            }
            return null;
        }

        public Map<String, Object> getParameters() {
            return null;
        }
    }

    private class ForEachEx
    extends ForEach {
        private ForEachEx() {
        }

        @Override
        public void detach() {
            if (CollectionTemplate.this._autodrop) {
                ((ListModel)this.getItems()).removeListDataListener((ListDataListener)this._dataListener);
            }
            super.detach();
        }

        public Template getTemplate(String name) {
            if (name != null && name.length() > 0) {
                return super.getTemplate(name);
            }
            return CollectionTemplate.this._execTemplate;
        }

        public Object resolveVariable(Component child, String name, boolean recurse) {
            Object result = CollectionTemplate.this._props.get(name);
            if (result == null) {
                return super.resolveVariable(child, name, recurse);
            }
            return result;
        }

        public void mergeSubTree() {
            super.mergeSubTree();
        }

        public boolean getAfterCompose() {
            return this._afterComposed;
        }
    }
}

