/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/A.ts":
/*!****************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/A.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.A_) window.zul.wgt.A_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.A = void 0;
/* A.ts

    Purpose:

    Description:

    History:
        Thu Aug  6 14:31:48     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** The basic widgets, such as button and div.
 */
//zk.$package('zul.wgt');
/**
 * The same as HTML A tag.
 * @defaultValue {@link getZclass}: z-a.
 */
var A = /** @class */function (_super) {
  __extends(A, _super);
  function A() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._dir = 'normal';
    return _this;
  }
  //_tabindex: 0,
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  A.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  A.prototype.setDisabled = function (disabled, opts) {
    var _this = this;
    var o = this._disabled;
    // eslint-disable-next-line zk/preferStrictBooleanType
    var value = disabled;
    // Refer from Button.js for the following changes
    // B60-ZK-1176
    // Autodisable should not re-enable when setDisabled(true) is called during onClick
    if (opts === null || opts === void 0 ? void 0 : opts.adbs)
      // called from zul.wgt.ADBS.autodisable
      this._adbs = true; // Start autodisabling
    else if (!opts || opts.adbs === undefined)
      // called somewhere else (including server-side)
      this._adbs = false; // Stop autodisabling
    if (!value) {
      if (this._adbs) {
        // autodisable is still active, allow enabling
        this._adbs = false;
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
      } else if (opts && opts.adbs === false)
        // ignore re-enable by autodisable mechanism
        value = this._disabled;
    }
    this._disabled = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var doDisable = function () {
        if (_this.desktop) {
          jq(_this.$n()).attr('disabled', value ? 'disabled' : null); // use jQuery's attr() instead of dom.disabled for non-button element. Bug ZK-2146
        }
      };
      doDisable();
    }
    return this;
  };
  /**
   * @returns the direction.
   * @defaultValue `"normal"`.
   */
  A.prototype.getDir = function () {
    return this._dir;
  };
  /**
   * Sets the direction.
   * @param dir - either "normal" or "reverse".
   */
  A.prototype.setDir = function (dir, opts) {
    var o = this._dir;
    this._dir = dir;
    if (o !== dir || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = DOMPurify.sanitize(this.domContent_());
    }
    return this;
  };
  /**
   * @returns the href that the browser shall jump to, if an user clicks
   * this button.
   * @defaultValue `null`. If null, the button has no function unless you
   * specify the onClick event listener.
   * <p>If it is not null, the onClick event won't be sent.
   */
  A.prototype.getHref = function () {
    return this._href;
  };
  /**
   * Sets the href.
   */
  A.prototype.setHref = function (href, opts) {
    var o = this._href;
    this._href = href;
    if (o !== href || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.href = href || '';
    }
    return this;
  };
  /**
   * @returns the target frame or window.
   *
   * <p>Note: it is useful only if href ({@link setHref}) is specified
   * (i.e., use the onClick listener).
   *
   * @defaultValue `null`.
   */
  A.prototype.getTarget = function () {
    return this._target;
  };
  /**
   * Sets the target frame or window.
   * @param target - the name of the frame or window to hyperlink.
   */
  A.prototype.setTarget = function (target, opts) {
    var o = this._target;
    this._target = target;
    if (o !== target || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.target = target || '';
    }
    return this;
  };
  /**
   * @returns a list of component IDs that shall be disabled when the user
   * clicks this anchor.
   *
   * <p>To represent the anchor itself, the developer can specify `self`.
   * For example,
   * ```ts
   * anchor.setId('ok');
   * wgt.setAutodisable('self,cancel');
   * ```
   * is the same as
   * ```ts
   * anchor.setId('ok');
   * wgt.setAutodisable('ok,cancel');
   * ```
   * that will disable
   * both the ok and cancel anchors when an user clicks it.
   *
   * <p>The anchor being disabled will be enabled automatically
   * once the client receives a response from the server.
   * In other words, the server doesn't notice if a anchor is disabled
   * with this method.
   *
   * <p>However, if you prefer to enable them later manually, you can
   * prefix with '+'. For example,
   * ```ts
   * anchor.setId('ok');
   * wgt.setAutodisable('+self,+cancel');
   * ```
   *
   * <p>Then, you have to enable them manually such as
   * ```ts
   * if (something_happened){
   *  ok.setDisabled(false);
   *  cancel.setDisabled(false);
   * }
   * ```
   *
   * @defaultValue `null`.
   */
  A.prototype.getAutodisable = function () {
    return this._autodisable;
  };
  /**
   * Sets whether to disable the anchor after the user clicks it.
   */
  A.prototype.setAutodisable = function (autodisable) {
    this._autodisable = autodisable;
    return this;
  };
  /** @internal */
  A.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (!this._disabled) {
      var n = this.$n();
      this.domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_');
    }
  };
  /** @internal */
  A.prototype.unbind_ = function (skipper, after, keepRod) {
    var n = this.$n();
    this.domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  A.prototype.domContent_ = function () {
    var label = zUtl.encodeXML(this.getLabel()),
      /*safe*/img = this.domImage_(),
      /*safe*/iconSclass = this.domIcon_();
    if (!img && !iconSclass) return label;
    if (!img) {
      img = iconSclass;
    } else img += "".concat(iconSclass ? ' ' + iconSclass : '');
    return this.getDir() == 'reverse' ? label + img : img + label;
  };
  /** @internal */
  A.prototype.domAttrs_ = function (no) {
    var /*safe*/attr = _super.prototype.domAttrs_.call(this, no),
      v;
    if (v = this.getTarget()) attr += " target=\"".concat(zUtl.encodeXMLAttribute(v), "\"");
    if (v = this.getHref()) attr += " href=\"".concat(zUtl.encodeXMLAttribute(v), "\"");else attr += ' href="javascript:;"';
    if (this._disabled) attr += ' disabled="disabled"';
    return attr;
  };
  /** @internal */
  A.prototype.doClick_ = function (evt) {
    var href = this.getHref();
    // ZK-2506: use iframe to open a 'mailto' href
    if (href && href.toLowerCase().startsWith('mailto:')) {
      var ifrm = jq.newFrame('mailtoFrame', href, undefined);
      if (zk.chrome)
        // ZK-3646: for chrome, it need to let iframe exist for a longer time.
        setTimeout(function () {
          jq(ifrm).remove();
        }, 100);else jq(ifrm).remove();
      evt.stop({
        propagation: true
      }); // ZK-5785: mailto link doesn't work
    }
    if (this._disabled) evt.stop(); // Prevent browser default
    else {
      this.fireX(evt);
      zul.wgt.ADBS.autodisable(this);
      if (!evt.stopped) _super.prototype.doClick_.call(this, evt, true);
    }
    // Unlike DOM, we don't propagate to parent (so do not call $supers)
  };
  A = __decorate([zk.WrapClass('zul.wgt.A')], A);
  return A;
}(zul.LabelImageWidget);
exports.A = A;
window.zul.wgt.A_.A = A;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Area.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Area.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Area_) window.zul.wgt.Area_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Area = void 0;
/* Area.ts

    Purpose:

    Description:

    History:
        Thu Mar 26 15:54:35     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An area of a {@link Imagemap}.
 */
var Area = /** @class */function (_super) {
  __extends(Area, _super);
  function Area() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the shape of this area.
   * @defaultValue `null` (means rectangle).
   */
  Area.prototype.getShape = function () {
    return this._shape;
  };
  /**
   * Sets the shape of this area.
   *
   * @param shape - the shape only allows one of
   * null, "rect", "rectangle", "circle", "circ", "ploygon", and "poly".
   */
  Area.prototype.setShape = function (shape, opts) {
    var o = this._shape;
    this._shape = shape;
    if (o !== shape || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.shape = shape || '';
    }
    return this;
  };
  /**
   * @returns the coordination of this area.
   */
  Area.prototype.getCoords = function () {
    return this._coords;
  };
  /**
   * Sets the coords of this area.
   * Its content depends on {@link getShape}:
   * <dl>
   * <dt>circle</dt>
   * <dd>coords="x,y,r"</dd>
   * <dt>polygon</dt>
   * <dd>coords="x1,y1,x2,y2,x3,y3..."<br/>
   * The polygon is automatically closed, so it is not necessary to repeat
   * the first coordination.</dd>
   * <dt>rectangle</dt>
   * <dd>coords="x1,y1,x2,y2"</dd>
   * </dl>
   *
   * <p>Note: (0, 0) is the upper-left corner.
   */
  Area.prototype.setCoords = function (coords, opts) {
    var o = this._coords;
    this._coords = coords;
    if (o !== coords || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      // ZK-1892 rename the argument
      var n = this.$n();
      if (n) n.coords = coords || '';
    }
    return this;
  };
  /** @internal */
  Area.prototype.doClick_ = function (evt) {
    if (zul.wgt.Imagemap._toofast()) return;
    var area = this.id || this.uuid;
    this.parent.fire('onClick', {
      area: area
    }, {
      ctl: true
    });
    evt.stop();
  };
  /** @internal */
  Area.prototype.domAttrs_ = function (no) {
    var /*safe*/attr = _super.prototype.domAttrs_.call(this, no) + ' href="javascript:;"',
      v;
    if (v = this._coords) attr += ' coords="' + zUtl.encodeXMLAttribute(v) + '"';
    if (v = this._shape) attr += ' shape="' + zUtl.encodeXMLAttribute(v) + '"';
    return attr;
  };
  Area = __decorate([zk.WrapClass('zul.wgt.Area')], Area);
  return Area;
}(zk.Widget);
exports.Area = Area;
window.zul.wgt.Area_.Area = Area;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Button.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Button.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Button.ts

    Purpose:

    Description:

    History:
        Sat Nov  8 22:58:16     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Button_) window.zul.wgt.Button_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ADBS = exports.Button = void 0;
window.zul.wgt.Button_._initUpld = function (wgt) {
  var v;
  if (v = wgt._upload) wgt._uplder = new zul.Upload(wgt, undefined, v);
};
window.zul.wgt.Button_._cleanUpld = function (wgt) {
  var v;
  if (v = wgt._uplder) {
    wgt._uplder = undefined;
    v.destroy();
  }
};
/**
 * A button.
 * @defaultValue {@link getZclass}: z-button.
 */
var Button = /** @class */function (_super) {
  __extends(Button, _super);
  function Button() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._dir = 'normal';
    /** @internal */
    _this._type = 'button';
    return _this;
  }
  /**
   * @returns the href that the browser shall jump to, if an user clicks
   * this button.
   * @defaultValue `null`. If null, the button has no function unless you
   * specify the onClick event listener.
   * <p>If it is not null, the onClick event won't be sent.
   */
  Button.prototype.getHref = function () {
    return this._href;
  };
  /**
   * Sets the href.
   */
  Button.prototype.setHref = function (href) {
    this._href = href;
    return this;
  };
  /**
   * @returns the target frame or window.
   *
   * <p>Note: it is useful only if href ({@link setHref}) is specified
   * (i.e., use the onClick listener).
   *
   * @defaultValue `null`.
   */
  Button.prototype.getTarget = function () {
    return this._target;
  };
  /**
   * Sets the target frame or window.
   * @param target - the name of the frame or window to hyperlink.
   */
  Button.prototype.setTarget = function (target) {
    this._target = target;
    return this;
  };
  /**
   * @returns the direction.
   * @defaultValue `"normal"`.
   */
  Button.prototype.getDir = function () {
    return this._dir;
  };
  /**
   * Sets the direction.
   * @param dir - either "normal" or "reverse".
   */
  Button.prototype.setDir = function (dir, opts) {
    var o = this._dir;
    this._dir = dir;
    if (o !== dir || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Button.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @param orient - either "horizontal" or "vertical".
   */
  Button.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the button type.
   * @defaultValue `"button"`.
   */
  Button.prototype.getType = function () {
    return this._type;
  };
  /**
   * Sets the button type.
   * @param type - either "button", "submit" or "reset".
   */
  Button.prototype.setType = function (type, opts) {
    var o = this._type;
    this._type = type;
    if (o !== type || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Button.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Button.prototype.setDisabled = function (disabled, opts) {
    var _this = this;
    var oldDisabled = this._disabled;
    // eslint-disable-next-line zk/preferStrictBooleanType
    var value = disabled;
    // B60-ZK-1176
    // Autodisable should not re-enable when setDisabled(true) is called during onClick
    if (opts === null || opts === void 0 ? void 0 : opts.adbs)
      // called from zul.wgt.ADBS.autodisable
      this._adbs = true; // Start autodisabling
    else if (!opts || opts.adbs === undefined)
      // called somewhere else (including server-side)
      this._adbs = false; // Stop autodisabling
    if (!value) {
      if (this._adbs) {
        // autodisable is still active, allow enabling
        this._adbs = false;
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
      } else if (opts && opts.adbs === false)
        // ignore re-enable by autodisable mechanism
        value = this._disabled;
    }
    this._disabled = value;
    if (oldDisabled !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var doDisable = function () {
        if (_this.desktop) {
          jq(_this.$n()).attr('disabled', value ? 'disabled' : null); // use jQuery's attr() instead of dom.disabled for non-button element. Bug ZK-2146
          // B70-ZK-2059: Initialize or clear upload when disabled attribute changes.
          if (_this._upload) value ? window.zul.wgt.Button_._cleanUpld(_this) : window.zul.wgt.Button_._initUpld(_this);
        }
      };
      // ZK-2042: delay the setting when the button's type is submit
      if (this._type == 'submit') setTimeout(doDisable, 50);else doDisable();
    }
    return this;
  };
  /*     B70-ZK-2031: Use LabelImageWidget's define instead
   image: function (v) {
   if (v && this._preloadImage) zUtl.loadImage(v);
   var n = this.getImageNode();
   if (n)
   n.src = v || '';
   },*/
  Button.prototype.setAutodisable = function (autodisable) {
    this._autodisable = autodisable;
    return this;
  };
  /**
   * @returns a list of component IDs that shall be disabled when the user
   * clicks this button.
   *
   * <p>To represent the button itself, the developer can specify `self`.
   * For example,
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('self,cancel');
   * ```
   * is the same as
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('ok,cancel');
   * ```
   * that will disable
   * both the ok and cancel buttons when an user clicks it.
   *
   * <p>The button being disabled will be enabled automatically
   * once the client receives a response from the server.
   * In other words, the server doesn't notice if a button is disabled
   * with this method.
   *
   * <p>However, if you prefer to enable them later manually, you can
   * prefix with '+'. For example,
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('+self,+cancel');
   * ```
   *
   * <p>Then, you have to enable them manually such as
   * ```ts
   * if (something_happened) {
   *  ok.setDisabled(false);
   *  cancel.setDisabled(false);
   * }
   * ```
   *
   * @defaultValue `null`.
   */
  Button.prototype.getAutodisable = function () {
    return this._autodisable;
  };
  /**
   * @returns non-null if this button is used for file upload, or null otherwise.
   * Refer to {@link setUpload} for more details.
   */
  Button.prototype.getUpload = function () {
    return this._upload;
  };
  /**
   * Sets the JavaScript class at the client to handle the upload if this
   * button is used for file upload.
   * @defaultValue `null`.
   *
   * <p>For example, the following example declares a button for file upload:
   * ```ts
   * button.setLabel('Upload');
   * button.setUpload('true');
   * ```
   *
   * <p>If you want to customize the handling of the file upload at
   * the client, you can specify a JavaScript class when calling
   * this method:
   * `button.setUpload('foo.Upload');`
   *
   * <p> Another options for the upload can be specified as follows:
   * ```ts
   * button.setUpload('true,maxsize=-1,native');
   * ```
   *  <ul>
   *  <li>maxsize: the maximal allowed upload size of the component, in kilobytes, or
   * a negative value if no limit.</li>
   *  <li>native: treating the uploaded file(s) as binary, i.e., not to convert it to
   * image, audio or text files.</li>
   *  </ul>
   *
   * @param upload - a JavaScript class to handle the file upload
   * at the client, or "true" if the default class is used,
   * or null or "false" to disable the file download (and then
   * this button behaves like a normal button).
   */
  Button.prototype.setUpload = function (upload, opts) {
    var o = this._upload;
    this._upload = upload;
    if (o !== upload || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n && !this._disabled) {
        window.zul.wgt.Button_._cleanUpld(this);
        if (upload && upload != 'false') window.zul.wgt.Button_._initUpld(this);
      }
    }
    return this;
  };
  /**
   * @returns the file(s) belongs to this button if any.
   * @since 10.0.0
   */
  Button.prototype.getFile = function () {
    return this._uplder.getFile();
  };
  /** @internal */
  Button.prototype.focus_ = function (timeout) {
    var _this = this;
    // Bug ZK-1295 and ZK-2935: Disabled buttons cannot regain focus by re-enabling and then setting focus
    var btn = this.$n();
    if (btn && btn.disabled) {
      if (!this._delayFocus) {
        this._delayFocus = true;
        zk.currentFocus = this;
        setTimeout(function () {
          // ZK-4865: do not focus if currentFocus has been changed during delay
          if (_this.desktop && !_this.isDisabled() && zk.currentFocus == _this) {
            if (!zk.focusBackFix || !_this._upload) {
              zk(_this.$n()).focus(timeout);
            }
          }
          _this._delayFocus = undefined;
        }, 0);
      }
      return false;
    }
    // Bug ZK-354: refer to _docMouseDown in mount.js for details
    if (!zk.focusBackFix || !this._upload) {
      zk(btn).focus(timeout);
    }
    return true;
  };
  /** @internal */
  Button.prototype.domContent_ = function () {
    var label = zUtl.encodeXML(this.getLabel()),
      img = this.getImage(),
      /*safe*/iconSclass = this.domIcon_();
    if (!img && !iconSclass) return label;
    if (!img) img = iconSclass;else img = "<img class=\"".concat(this.$s('image'), "\" src=\"").concat(zUtl.encodeXMLAttribute(img), "\" alt=\"\" aria-hidden=\"true\" />").concat(iconSclass ? ' ' + iconSclass : '');
    var space = 'vertical' == this.getOrient() ? '<br/>' : ' ';
    return this.getDir() == 'reverse' ? label + space + img : img + space + label;
  };
  Button.prototype.onShow = function () {
    // ZK-2233: should sync upload position when button showed
    if (this.$n() && !this._disabled && this._uplder) {
      this._uplder.sync();
    }
  };
  /** @internal */
  Button.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n();
    this.domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_');
    zWatch.listen({
      onShow: this
    });
    if (!this._disabled && this._upload) window.zul.wgt.Button_._initUpld(this);
  };
  /** @internal */
  Button.prototype.unbind_ = function (skipper, after, keepRod) {
    window.zul.wgt.Button_._cleanUpld(this);
    var n = this.$n();
    this.domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    zWatch.unlisten({
      onShow: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Button.prototype.doClick_ = function (evt) {
    if (!evt.domEvent)
      // mobile will trigger doClick twice
      return;
    if (!this._disabled) {
      this.fireX(evt);
      if (!this._upload) zul.wgt.ADBS.autodisable(this);else this._uplder.openFileDialog();
      if (!evt.stopped) {
        var href = this._href,
          isMailTo = href ? href.toLowerCase().startsWith('mailto:') : false;
        if (href) {
          // ZK-2506: use iframe to open a 'mailto' href
          if (isMailTo) {
            var ifrm = jq.newFrame('mailtoFrame', href, undefined);
            jq(ifrm).remove();
          } else {
            zUtl.go(href, {
              target: this._target || (evt.data.ctrlKey ? '_blank' : '')
            });
          }
        }
        _super.prototype.doClick_.call(this, evt, true);
      }
    }
    //Unlike DOM, we don't proprogate to parent (otherwise, onClick
    //will fired)
  };
  /** @internal */
  Button.prototype.setFlexSize_ = function (flexSize) {
    var n = this.$n();
    if (flexSize.height !== undefined) {
      if (flexSize.height == 'auto') n.style.height = '';else if (flexSize.height != '') n.style.height = jq.px0(parseInt(flexSize.height));else n.style.height = this._height ? this._height : '';
    }
    if (flexSize.width !== undefined) {
      if (flexSize.width == 'auto') n.style.width = '';else if (flexSize.width != '') n.style.width = jq.px0(parseInt(flexSize.width));else n.style.width = this._width ? this._width : '';
    }
  };
  /** @internal */
  Button.prototype.shallIgnoreClick_ = function (_evt) {
    // ZK-5806, if disabled by autodisable, shouldn't ignore click
    return this.isDisabled() ? !this._adbs : false;
  };
  Button = __decorate([zk.WrapClass('zul.wgt.Button')], Button);
  return Button;
}(zul.LabelImageWidget);
exports.Button = Button;
//handle autodisabled buttons
var ADBS = /** @class */function (_super) {
  __extends(ADBS, _super);
  function ADBS(ads) {
    var _this = _super.call(this) || this;
    _this._ads = ads;
    return _this;
  }
  ADBS.prototype.onResponse = function () {
    for (var ads = this._ads, ad; ad = ads.shift();) {
      // B60-ZK-1176: distinguish from other usages
      ad.setDisabled(false, {
        adbs: false,
        skip: true
      });
      if (zk.chrome) ad.domListen_(ad.$n(), 'onBlur', 'doBlur_'); //ZK-2739: prevent chrome fire onBlur event after autodisabled
    }
    zWatch.unlisten({
      onResponse: this
    });
  };
  /* Disable Targets and re-enable after response
   * @param zk.Widget wgt
   */
  ADBS.autodisable = function (wgt) {
    var ads = wgt._autodisable,
      aded,
      uplder;
    if (ads) {
      if (zk.chrome) wgt.domUnlisten_(wgt.$n(), 'onBlur', 'doBlur_'); //ZK-2739: prevent chrome fire onBlur event after autodisabled
      ads = ads.split(',');
      for (var j = ads.length; j--;) {
        var ad = ads[j].trim();
        if (ad) {
          var perm = ad.startsWith('+');
          if (perm) ad = ad.substring(1);
          // eslint-disable-next-line @typescript-eslint/non-nullable-type-assertion-style
          ad = 'self' == ad ? wgt : wgt.$f(ad);
          //B50-3304877: autodisable and Upload
          if (ad == wgt) {
            //backup uploader before disable
            uplder = wgt._uplder;
            wgt._uplder = undefined;
            wgt._autodisable_self = true;
          }
          if (ad && !ad._disabled) {
            // B60-ZK-1176: distinguish from other usages
            ad.setDisabled(true, {
              adbs: true,
              skip: true
            });
            if (wgt.inServer) {
              if (perm) ad.smartUpdate('disabled', true);else if (!aded) aded = [ad];else aded.push(ad);
            }
          }
        }
      }
    }
    if (aded) {
      var adbs_1 = new zul.wgt.ADBS(aded);
      if (uplder) {
        uplder._aded = adbs_1;
        wgt._uplder = uplder; //zul.Upload.sendResult came on it.
      } else if (wgt.isListen('onClick', {
        asapOnly: true
      })) zWatch.listen({
        onResponse: adbs_1
      });else setTimeout(function () {
        return adbs_1.onResponse();
      }, 800);
    }
  };
  ADBS = __decorate([zk.WrapClass('zul.wgt.ADBS')], ADBS);
  return ADBS;
}(zk.Object);
exports.ADBS = ADBS;
window.zul.wgt.Button_.Button = Button;
window.zul.wgt.Button_.ADBS = ADBS;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/ButtonRenderer.ts":
/*!*****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/ButtonRenderer.ts ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports) {



if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.ButtonRenderer_) window.zul.wgt.ButtonRenderer_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ButtonRenderer = void 0;
/* ButtonRenderer.ts

    Purpose:

    Description:

    History:
        Fri Jun 12 14:45:38 CST 2020, Created by rudyhuang

Copyright (C) 2020 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** @class zul.wgt.ButtonRenderer
 * The renderer used to render buttons of a window.
 * It is designed to be overridden
 * @since 9.5.0
 */
exports.ButtonRenderer = {
  /**
   * Redraws the collapse button HTML.
   *
   * @param wgt - the panel
   * @param out - the buffer
   * @param tabindex - the tabindex, can be omitted
   */
  redrawCollapseButton: function (wgt, out, tabindex) {
    var uuid = wgt.uuid,
      icon = wgt.$s('icon'),
      isOpen = wgt._open,
      openIcon = isOpen ? wgt.getCollapseOpenIconClass_() : wgt.getCollapseCloseIconClass_(),
      collapsibleLabel = isOpen ? msgzul.PANEL_COLLAPSE : msgzul.PANEL_EXPAND;
    out.push('<button id="', /*safe*/uuid, '-exp" class="', /*safe*/icon, ' ', wgt.$s('expand'), '"');
    if (tabindex != undefined) out.push(' tabindex="', tabindex, '"');
    out.push(' title="', /*safe*/collapsibleLabel, '" aria-label="', /*safe*/collapsibleLabel, '">');
    out.push('<i class="', /*safe*/openIcon, '" aria-hidden="true"></i></button>');
  },
  /**
   * Redraws the minimize button HTML.
   *
   * @param wgt - the window
   * @param out - the buffer
   * @param tabindex - the tabindex, can be omitted
   */
  redrawMinimizeButton: function (wgt, out, tabindex) {
    var uuid = wgt.uuid,
      icon = wgt.$s('icon'),
      minLabel = msgzul.PANEL_MINIMIZE;
    out.push('<button id="', /*safe*/uuid, '-min" class="', /*safe*/icon, ' ', wgt.$s('minimize'), '"');
    if (tabindex != undefined) out.push(' tabindex="', tabindex, '"');
    out.push(' title="', /*safe*/minLabel, '" aria-label="', /*safe*/minLabel, '">');
    out.push('<i class="', /*safe*/wgt.getMinimizableIconClass_(), '" aria-hidden="true"></i></button>');
  },
  /**
   * Redraws the maximize button HTML.
   *
   * @param wgt - the window
   * @param out - the buffer
   * @param tabindex - the tabindex, can be omitted
   */
  redrawMaximizeButton: function (wgt, out, tabindex) {
    var uuid = wgt.uuid,
      icon = wgt.$s('icon'),
      maxd = wgt._maximized,
      maxLabel = msgzul.PANEL_MAXIMIZE;
    out.push('<button id="', /*safe*/uuid, '-max" class="', /*safe*/icon, ' ', wgt.$s('maximize'));
    if (maxd) out.push(' ', wgt.$s('maximized'));
    var maxIcon = maxd ? wgt.getMaximizedIconClass_() : wgt.getMaximizableIconClass_();
    if (tabindex != undefined) out.push('" tabindex="', tabindex);
    out.push('" title="', /*safe*/maxLabel, '" aria-label="', /*safe*/maxLabel, '">');
    out.push('<i class="', /*safe*/maxIcon, '" aria-hidden="true"></i></button>');
  },
  /**
   * Redraws the close button HTML.
   *
   * @param wgt - the window
   * @param out - the buffer
   * @param tabindex - the tabindex, can be omitted
   */
  redrawCloseButton: function (wgt, out, tabindex) {
    var uuid = wgt.uuid,
      icon = wgt.$s('icon'),
      closeLabel = msgzul.PANEL_CLOSE;
    out.push('<button id="', /*safe*/uuid, '-close" class="', /*safe*/icon, ' ', wgt.$s('close'), '"');
    if (tabindex != undefined) out.push(' tabindex="', tabindex, '"');
    out.push(' title="', /*safe*/closeLabel, '" aria-label="', /*safe*/closeLabel, '">');
    out.push('<i class="', /*safe*/wgt.getClosableIconClass_(), '" aria-hidden="true"></i></button>');
  }
};
zul.wgt.ButtonRenderer = exports.ButtonRenderer;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Captcha.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Captcha.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Captcha_) window.zul.wgt.Captcha_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Captcha = void 0;
/* Captcha.ts

    Purpose:

    Description:

    History:
        Fri Mar 27 14:53:11     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The generic captcha component.
 */
var Captcha = /** @class */function (_super) {
  __extends(Captcha, _super);
  function Captcha() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Captcha = __decorate([zk.WrapClass('zul.wgt.Captcha')], Captcha);
  return Captcha;
}(zul.wgt.Image);
exports.Captcha = Captcha;
window.zul.wgt.Captcha_.Captcha = Captcha;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Caption.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Caption.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Caption_) window.zul.wgt.Caption_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Caption = void 0;
/* Caption.ts

    Purpose:

    Description:

    History:
        Sun Nov 16 13:01:17     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 *  A header for a {@link Groupbox}.
 * It may contain either a text label, using {@link setLabel},
 * or child elements for a more complex caption.
 * @defaultValue {@link getZclass}: z-caption.
 *
 */
var Caption = /** @class */function (_super) {
  __extends(Caption, _super);
  function Caption() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this.domDependent_ = true;
    return _this;
  }
  Caption.prototype.rerender = function (skipper) {
    var p = this.parent;
    if (p) p.clearCache(); // B50-ZK-244
    return _super.prototype.rerender.call(this, skipper);
  };
  /** @internal */
  Caption.prototype.domContent_ = function () {
    var label = this.getLabel(),
      img = this.getImage(),
      title = this.parent ? this.parent._title : '',
      /*safe*/iconSclass = this.domIcon_();
    if (title) label = label ? title + ' - ' + label : title;
    label = zUtl.encodeXML(label);
    if (!img && !iconSclass) return label;
    if (!img) img = iconSclass;else /*safe*/
      img = '<img id="' + this.uuid + '-img" src="' + zUtl.encodeXMLAttribute(img) + '" class="' + this.$s('image') + '" alt="" aria-hidden="true" />' + (iconSclass ? ' ' + /*safe*/iconSclass : '');
    return label ? img + ' ' + '<span class="' + this.$s('label') + '">' + label + '</span>' : img;
  };
  /** @internal */
  Caption.prototype.updateDomContent_ = function () {
    var /*safe*/cnt = this.domContent_(),
      dn = this.$n('cave');
    if (dn) {
      var firstWgtDom;
      if (this.firstChild) {
        firstWgtDom = this.firstChild.$n();
      }
      // eslint-disable-next-line zk/noNull
      for (var child = dn.firstChild, nextChild; child && child !== firstWgtDom; child = nextChild) {
        nextChild = child.nextSibling;
        jq(child).remove();
      }
      this.clearCache(); //B70-ZK-2370: clearCache after remove dom content
      jq(dn).prepend(cnt ? cnt : '&nbsp;');
    }
  };
  /** @internal */
  Caption.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no),
      parent = this.parent;
    if (!(parent instanceof zul.wgt.Groupbox)) return sc;
    return sc + (parent._closable ? '' : ' ' + this.$s('readonly'));
  };
  /** @internal */
  Caption.prototype.doClick_ = function (evt, popupOnly) {
    if (this.parent instanceof zul.wgt.Groupbox && this.parent.isClosable()) this.parent.setOpen(!this.parent.isOpen());
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  //private//
  /** @internal */
  Caption.prototype._getBlank = function () {
    return '&nbsp;';
  };
  /** Whether to generate a collapsible button (determined by parent only). @internal */
  Caption.prototype._isCollapsibleVisible = function () {
    var parent = this.parent;
    return !!(parent.isCollapsible && parent.getCollapseOpenIconClass_ && parent.isCollapsible());
  };
  /** Whether to generate a close button (determined by parent only). @internal */
  Caption.prototype._isCloseVisible = function () {
    var parent = this.parent;
    return !!(parent.isClosable && parent.getClosableIconClass_ && parent.isClosable());
  };
  /** Whether to generate a minimize button (determined by parent only). @internal */
  Caption.prototype._isMinimizeVisible = function () {
    var parent = this.parent;
    return !!(parent.isMinimizable && parent.getMinimizableIconClass_ && parent.isMinimizable());
  };
  /** Whether to generate a maximize button (determined by parent only). @internal */
  Caption.prototype._isMaximizeVisible = function () {
    var parent = this.parent;
    return !!(parent.isMaximizable && parent.getMaximizableIconClass_ && parent.isMaximizable());
  };
  /** @internal */
  Caption.prototype.beforeMinFlex_ = function (o) {
    // FIXME: Div has no property width. Setting it in the console has no effect.
    // Dead code?
    if (o == 'w') this.$n_().width = '';
    return undefined;
  };
  // override for the bug ZK-1799
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Caption.prototype.setFlexSizeW_ = function (flexSizeW, zkn, width, isFlexMin) {
    if (isFlexMin) {
      if (this._isCloseVisible()) {
        var close = this.parent.$n_('close');
        width += close.offsetWidth + zk(close).marginWidth();
      }
      if (this._isMaximizeVisible()) {
        var max = this.parent.$n_('max');
        width += max.offsetWidth + zk(max).marginWidth();
      }
      if (this._isMinimizeVisible()) {
        var min = this.parent.$n_('min');
        width += min.offsetWidth + zk(min).marginWidth();
      }
      if (this._isCollapsibleVisible()) {
        var exp = this.parent.$n_('exp');
        width += exp.offsetWidth + zk(exp).marginWidth();
      }
    }
    _super.prototype.setFlexSizeW_.call(this, flexSizeW, zkn, width, isFlexMin);
  };
  // override
  // ZK-786
  Caption.prototype.getImageNode = function () {
    if (!this._eimg && this._image) {
      var n = this.$n('img');
      if (n) this._eimg = n;
    }
    return this._eimg;
  };
  Caption = __decorate([zk.WrapClass('zul.wgt.Caption')], Caption);
  return Caption;
}(zul.LabelImageWidget);
exports.Caption = Caption;
window.zul.wgt.Caption_.Caption = Caption;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Cell.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Cell.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Cell_) window.zul.wgt.Cell_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Cell = void 0;
/* Cell.ts

    Purpose:

    Description:

    History:
        Mon Aug 31 16:50:22     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The generic cell component to be embedded into {@link Row} or
 * {@link zul.box.Box} for fully control style and layout.
 *
 * @defaultValue {@link getZclass}: z-cell.
 * @import zul.grid.*
 * @import zul.box.*
 */
var Cell = /** @class */function (_super) {
  __extends(Cell, _super);
  function Cell() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._colspan = 1;
    /** @internal */
    _this._rowspan = 1;
    /** @internal */
    _this._rowType = 0;
    /** @internal */
    _this._boxType = 1;
    return _this;
  }
  /**
   * @returns number of columns to span.
   * @defaultValue `1`.
   */
  Cell.prototype.getColspan = function () {
    return this._colspan;
  };
  /**
   * Sets the number of columns to span.
   * It is the same as the colspan attribute of HTML TD tag.
   */
  Cell.prototype.setColspan = function (colspan, opts) {
    var o = this._colspan;
    this._colspan = colspan;
    if (o !== colspan || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.colSpan = colspan;
    }
    return this;
  };
  /**
   * @returns number of rows to span.
   * @defaultValue `1`.
   */
  Cell.prototype.getRowspan = function () {
    return this._rowspan;
  };
  /**
   * Sets the number of rows to span.
   * <p>It is the same as the rowspan attribute of HTML TD tag.
   */
  Cell.prototype.setRowspan = function (rowspan, opts) {
    var o = this._rowspan;
    this._rowspan = rowspan;
    if (o !== rowspan || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.rowSpan = rowspan;
    }
    return this;
  };
  /**
   * @returns the horizontal alignment.
   * @defaultValue `null` (system default: left unless CSS specified).
   */
  Cell.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the horizontal alignment.
   */
  Cell.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.align = align;
    }
    return this;
  };
  /**
   * @returns the vertical alignment.
   * @defaultValue `null` (system default: top).
   */
  Cell.prototype.getValign = function () {
    return this._valign;
  };
  /**
   * Sets the vertical alignment of this grid.
   */
  Cell.prototype.setValign = function (valign, opts) {
    var o = this._valign;
    this._valign = valign;
    if (o !== valign || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.vAlign = valign;
    }
    return this;
  };
  /** @internal */
  Cell.prototype._getParentType = function () {
    var isRow = zk.isLoaded('zul.grid') && this.parent instanceof zul.grid.Row;
    if (!isRow) {
      return zk.isLoaded('zul.box') && this.parent instanceof zul.box.Box ? this._boxType : undefined;
    }
    return this._rowType;
  };
  /** @internal */
  Cell.prototype._getRowAttrs = function () {
    return this.parent._childAttrs(this, this.getChildIndex());
  };
  /** @internal */
  Cell.prototype._getBoxAttrs = function () {
    return this.parent._childInnerAttrs(this);
  };
  /** @internal */
  Cell.prototype._colHtmlPre = function () {
    var s = '',
      p = this.parent;
    if (zk.isLoaded('zkex.grid') && p instanceof zkex.grid.Group && this == p.firstChild) s += p.domContent_();
    return s;
  };
  /** @internal */
  Cell.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (this._getParentType() == this._rowType) {
      if (this._headerVisible === false) scls += ' ' + this.$s('hidden-column');
    }
    return scls;
  };
  /** @internal */
  Cell.prototype.domStyle_ = function (no) {
    var style = '';
    if (this._align) style += ' text-align:' + this._align + ';';
    if (this._valign) style += ' vertical-align:' + this._valign + ';';
    if (this._getParentType() == this._rowType && this._headerVisible === false) no = zk.copy(no, {
      visible: true
    });
    return _super.prototype.domStyle_.call(this, no) + style;
  };
  /** @internal */
  Cell.prototype.domAttrs_ = function (no) {
    var /*safe*/s = _super.prototype.domAttrs_.call(this, no),
      v;
    if ((v = this._colspan) != 1) s += ' colspan="' + v + '"';
    if ((v = this._rowspan) != 1) s += ' rowspan="' + v + '"';
    var m1,
      m2 = zUtl.parseMap(s, ' ', '"');
    switch (this._getParentType()) {
      case this._rowType:
        m1 = zUtl.parseMap(this._getRowAttrs(), ' ', '"');
        break;
      case this._boxType:
        m1 = zUtl.parseMap(this._getBoxAttrs(), ' ', '"');
        break;
    }
    if (m1) {
      //Bug ZK-1349: merge user style and row style instead of override
      var s1 = m1.style,
        s2 = m2.style,
        style;
      if (s1 && s2) {
        s1 = zUtl.parseMap(s1.replace(/"/g, '').replace(/:/g, '='), ';');
        s2 = zUtl.parseMap(s2.replace(/"/g, '').replace(/:/g, '='), ';');
        zk.copy(s1, s2);
        style = zUtl.mapToString(s1, ':', ';');
      }
      zk.copy(m1, m2);
      if (style) m1.style = '"' + style + '"';
    }
    return ' ' + zUtl.mapToString(m1); // FIXME: m1 could be undefined
  };
  /** @internal */
  Cell.prototype.deferRedrawHTML_ = function (out) {
    out.push('<td', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></td>');
  };
  /** @internal */
  Cell.prototype.getFlexContainer_ = function () {
    return undefined;
  };
  Cell = __decorate([zk.WrapClass('zul.wgt.Cell')], Cell);
  return Cell;
}(zul.Widget);
exports.Cell = Cell;
window.zul.wgt.Cell_.Cell = Cell;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Chart.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Chart.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Chart_) window.zul.wgt.Chart_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Chart = void 0;
/* Chart.ts

    Purpose:

    Description:

    History:
        Thu Mar 26 16:11:12     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The generic chart component.
 */
var Chart = /** @class */function (_super) {
  __extends(Chart, _super);
  function Chart() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Chart = __decorate([zk.WrapClass('zul.wgt.Chart')], Chart);
  return Chart;
}(zul.wgt.Imagemap);
exports.Chart = Chart;
window.zul.wgt.Chart_.Chart = Chart;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Checkbox.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Checkbox.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Checkbox.ts

    Purpose:

    Description:

    History:
        Wed Dec 10 16:17:14     2008, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Checkbox_) window.zul.wgt.Checkbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Checkbox = void 0;
//Two onclick are fired if clicking on label, so ignore it if so
window.zul.wgt.Checkbox_._shallIgnore = function (evt) {
  var v = evt.domEvent;
  // B96-ZK-4821: shall ignore if target is not the real input checkbox (label or span)
  return !!(v && !jq.nodeName(v.target, 'input'));
};
/**
 * A checkbox.
 *
 * <p>Event:
 * <ol>
 * <li>onCheck is sent when a checkbox
 * is checked or unchecked by user.</li>
 * </ol>
 */
var Checkbox = /** @class */function (_super) {
  __extends(Checkbox, _super);
  // eslint-disable-next-line @typescript-eslint/no-unsafe-declaration-merging
  function Checkbox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    //_tabindex: 0,
    /** @internal */
    _this._checked = false;
    /** @internal */
    _this._disabled = false; // disabled by default
    return _this;
  }
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Checkbox.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /** Sets whether it is disabled.
   */
  Checkbox.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    if (opts === null || opts === void 0 ? void 0 : opts.adbs)
      // called from zul.wgt.ADBS.autodisable
      this._adbs = true; // Start autodisabling
    else if (!opts || opts.adbs === undefined)
      // called somewhere else (including server-side)
      this._adbs = false; // Stop autodisabling
    if (!disabled) {
      if (this._adbs) {
        // autodisable is still active, allow enabling
        this._adbs = false;
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
      } else if (opts && opts.adbs === false)
        // ignore re-enable by autodisable mechanism
        disabled = !!this._disabled;
    }
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) {
        n.disabled = disabled;
        jq(this.$n()).toggleClass(this.$s(this.getMoldPrefix_() + 'disabled'), disabled);
        if (!this._isDefaultMold()) {
          this._setTabIndexForMold();
        }
      }
    }
    return this;
  };
  /**
   * @returns whether it is checked.
   * @defaultValue `false`.
   */
  Checkbox.prototype.isChecked = function () {
    return this._checked;
  };
  /** Sets whether it is checked,
   * changing checked will set indeterminate to false.
   */
  Checkbox.prototype.setChecked = function (checked, opts) {
    var o = this._checked;
    this._checked = checked;
    if (o !== checked || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) {
        //B70-ZK-2057: prop() method can access right property values;
        jq(n).prop('checked', checked);
        this.clearStateClassName_();
        jq(this.$n()).addClass(this.getClassNameByState_());
      }
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   */
  Checkbox.prototype.getName = function () {
    return this._name;
  };
  /** Sets the name of this component.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   *
   * @param name - the name of this component.
   */
  Checkbox.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) n.name = name || '';
    }
    return this;
  };
  /**
   * @returns the tab order of this component.
   * @defaultValue -1 (means the same as browser's default).
   */
  Checkbox.prototype.getTabindex = function () {
    return this._tabindex;
  };
  /**
   * Sets the tab order of this component.
   */
  Checkbox.prototype.setTabindex = function (tabindex, opts) {
    var o = this._tabindex;
    this._tabindex = tabindex;
    if (o !== tabindex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) {
        if (tabindex == null) n.removeAttribute('tabindex');else n.tabIndex = tabindex;
      }
    }
    return this;
  };
  /**
   * @returns the value.
   * @defaultValue `""`.
   * @since 5.0.4
   */
  Checkbox.prototype.getValue = function () {
    return this._value;
  };
  /** Sets the value.
   * @param value - the value; If null, it is considered as empty.
   * @since 5.0.4
   */
  Checkbox.prototype.setValue = function (value, opts) {
    var o = this._value;
    this._value = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) n.value = value || '';
    }
    return this;
  };
  /**
   * @returns a list of checkbox component IDs that shall be disabled when the user
   * clicks this checkbox.
   *
   * <p>To represent the checkbox itself, the developer can specify `self`.
   * For example,
   * ```ts
   * checkbox.setId('ok');
   * wgt.setAutodisable('self,cancel');
   * ```
   * is the same as
   * ```ts
   * checkbox.setId('ok');
   * wgt.setAutodisable('ok,cancel');
   * ```
   * that will disable
   * both the ok and cancel checkboxes when an user clicks it.
   *
   * <p>The checkbox being disabled will be enabled automatically
   * once the client receives a response from the server or a fixed timeout.
   * In other words, the server doesn't notice if a checkbox is disabled
   * with this method.
   *
   * <p>However, if you prefer to enable them later manually, you can
   * prefix with '+'. For example,
   * ```ts
   * checkbox.setId('ok');
   * wgt.setAutodisable('+self,+cancel');
   * ```
   *
   * <p>Then, you have to enable them manually such as
   * ```ts
   * if (something_happened) {
   *  ok.setDisabled(false);
   *  cancel.setDisabled(false);
   * }
   * ```
   *
   * @defaultValue `null`.
   */
  Checkbox.prototype.getAutodisable = function () {
    return this._autodisable;
  };
  /** Sets whether to disable the checkbox after the user clicks it.
   */
  Checkbox.prototype.setAutodisable = function (autodisable) {
    this._autodisable = autodisable;
    return this;
  };
  /**
   * @returns whether checkbox is in indeterminate state.
   * @defaultValue `false`.
   * @since 8.6.0
   */
  Checkbox.prototype.isIndeterminate = function () {
    return !!this._indeterminate;
  };
  /**
   * Set whether checkbox is in indeterminate state.
   *
   * @param indeterminate - whether checkbox is indeterminate
   * @since 8.6.0
   */
  Checkbox.prototype.setIndeterminate = function (indeterminate, opts) {
    var o = this._indeterminate;
    this._indeterminate = indeterminate;
    if (o !== indeterminate || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n('real');
      if (n) {
        jq(n).prop('indeterminate', indeterminate);
        if (!this._isDefaultMold()) {
          this.clearStateClassName_();
          jq(this.$n()).addClass(this.getClassNameByState_());
        }
      }
    }
    return this;
  };
  /**
   * @returns the current state according to isIndeterminate() and isChecked().
   * @since 9.0.0
   */
  // eslint-disable-next-line zk/preferStrictBooleanType
  Checkbox.prototype.getState = function () {
    if (this.isIndeterminate()) return undefined;else return this.isChecked();
  };
  /** @internal */
  Checkbox.prototype.focus_ = function (timeout) {
    zk(this.$n('real') || this.$n()).focus(timeout);
    return true;
  };
  /** @internal */
  Checkbox.prototype.contentAttrs_ = function () {
    var out = [],
      name = this.getName(); // cannot use this._name for radio
    if (name) out.push("name=\"".concat(zUtl.encodeXMLAttribute(name), "\""));
    if (this._disabled) out.push('disabled="disabled"');
    if (this._checked) out.push('checked="checked"');
    if (this._tabindex) out.push("tabindex=\"".concat(this._tabindex, "\""));
    var value = this.getValue();
    if (value) out.push("value=\"".concat(zUtl.encodeXMLAttribute(value), "\""));
    return out.join(' ');
  };
  /** @internal */
  Checkbox.prototype._moldA11yAttrs = function () {
    return '';
  };
  /** @internal */
  Checkbox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n('real'),
      mold = this.$n('mold');
    // Bug 2383106
    n.checked = n.defaultChecked;
    if (this.isIndeterminate()) n.indeterminate = true;
    this.domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_').domListen_(mold, 'onMouseDown', '_doMoldMouseDown')._setTabIndexForMold();
  };
  /** @internal */
  Checkbox.prototype.unbind_ = function (skipper, after, keepRod) {
    var n = this.$n('real'),
      mold = this.$n('mold');
    this.domUnlisten_(mold, 'onMouseDown', '_doMoldMouseDown').domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Checkbox.prototype._setTabIndexForMold = function () {
    var mold = this.$n('mold');
    if (mold) mold.tabIndex = this._canTabOnMold() ? 0 : -1;
  };
  /** @internal */
  Checkbox.prototype._canTabOnMold = function () {
    return !this._isDefaultMold() && !this.isDisabled();
  };
  /** @internal */
  Checkbox.prototype.doSelect_ = function (evt) {
    if (!window.zul.wgt.Checkbox_._shallIgnore(evt)) _super.prototype.doSelect_.call(this, evt);
  };
  /** @internal */
  Checkbox.prototype.doClick_ = function (evt, popupOnly) {
    var _a;
    // B96-ZK-4821: shall not doClick if the checkbox is disabled
    if (!window.zul.wgt.Checkbox_._shallIgnore(evt) && !this.isDisabled()) {
      // F55-ZK-12: Checkbox automatically disable itself after clicked
      // use the autodisable handler of button directly
      zul.wgt.ADBS.autodisable(this);
      if (this._isTristateMold()) {
        this.nextState_();
        this.fireOnCheck_(this.getState());
      } else {
        var real = this.$n_('real'),
          checked = real.checked;
        if (checked != this._checked) {
          //changed
          this.setChecked(checked); //so Radio has a chance to override it
          this.setIndeterminate(false);
          this.fireOnCheck_(checked);
        }
        if (zk.webkit && !zk.mobile) zk(real).focus();
        // B65-ZK-1837: should stop propagation
        evt.stop({
          propagation: true
        });
        _super.prototype.doClick_.call(this, evt, popupOnly);
        // B85-ZK-3866: do extra click, if it's a radio
        if (this instanceof zul.wgt.Radio) {
          (_a = this.getRadiogroup()) === null || _a === void 0 ? void 0 : _a.doClick_(evt);
        }
      }
    }
  };
  /** @internal */
  Checkbox.prototype._doMoldMouseDown = function (evt) {
    if (this.isDisabled()) evt.stop();
  };
  /** @internal */
  // eslint-disable-next-line zk/preferStrictBooleanType
  Checkbox.prototype.fireOnCheck_ = function (checked) {
    this.fire('onCheck', checked);
  };
  /** @internal */
  Checkbox.prototype.beforeSendAU_ = function (wgt, evt) {
    if (evt.name != 'onClick')
      //don't stop event if onClick (otherwise, check won't work)
      _super.prototype.beforeSendAU_.call(this, wgt, evt);
  };
  Checkbox.prototype.getTextNode = function () {
    return this.$n('cnt');
  };
  /** @internal */
  Checkbox.prototype.shallIgnoreClick_ = function () {
    return this.isDisabled();
  };
  /** @internal */
  Checkbox.prototype.domClass_ = function (no) {
    var out = [_super.prototype.domClass_.call(this, no), this.$s(this.getMold()), this.getClassNameByState_()];
    if (this.isDisabled()) out.push(this.$s(this.getMoldPrefix_() + 'disabled'));
    return out.join(' ');
  };
  /** @internal */
  Checkbox.prototype._isDefaultMold = function () {
    return this.getMold() == 'default';
  };
  /** @internal */
  Checkbox.prototype._isTristateMold = function () {
    return this.getMold() == 'tristate';
  };
  /** @internal */
  Checkbox.prototype.nextState_ = function () {
    if (this._indeterminate) {
      this.setIndeterminate(false);
      this.setChecked(true);
    } else if (this._checked) {
      this.setChecked(false);
    } else {
      this.setIndeterminate(true);
    }
  };
  /** @internal */
  Checkbox.prototype.getMoldPrefix_ = function () {
    return this._isDefaultMold() ? '' : this.getMold() + '-';
  };
  /** @internal */
  Checkbox.prototype.getClassNameByState_ = function () {
    var moldPrefix = this.getMoldPrefix_();
    if (this._indeterminate) {
      return this.$s(moldPrefix + 'indeterminate');
    } else {
      return this.$s(moldPrefix + (this._checked ? 'on' : 'off'));
    }
  };
  /** @internal */
  Checkbox.prototype.clearStateClassName_ = function () {
    var n = jq(this.$n()),
      moldPrefix = this.getMoldPrefix_();
    if (n) {
      n.removeClass(this.$s(moldPrefix + 'off')).removeClass(this.$s(moldPrefix + 'indeterminate')).removeClass(this.$s(moldPrefix + 'on'));
    }
  };
  /** @internal */
  Checkbox.prototype.doKeyDown_ = function (evt) {
    var _a;
    _super.prototype.doKeyDown_.call(this, evt);
    var spaceKeyCode = 32;
    if (evt.domTarget == this.$n('mold') && evt.keyCode == spaceKeyCode) {
      // B103-ZK-5918: should prevent default space key action: scroll down the page
      (_a = evt.domEvent) === null || _a === void 0 ? void 0 : _a.preventDefault();
      if (this._isTristateMold()) {
        this.nextState_();
        this.fireOnCheck_(this.getState());
        return;
      }
      var checked = !this.isChecked();
      this.setChecked(checked);
      this.fireOnCheck_(checked);
    }
  };
  Checkbox = __decorate([zk.WrapClass('zul.wgt.Checkbox')
  // eslint-disable-next-line @typescript-eslint/no-unsafe-declaration-merging
  ], Checkbox);
  return Checkbox;
}(zul.LabelImageWidget);
exports.Checkbox = Checkbox;
window.zul.wgt.Checkbox_.Checkbox = Checkbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Combobutton.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Combobutton.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Combobutton_) window.zul.wgt.Combobutton_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Combobutton = void 0;
/* Combobutton.ts

    Purpose:

    Description:

    History:
        Wed May 18 17:32:15     2011, Created by benbai

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
//called when user mouseout some element,
//for prevent duplicate state change
window.zul.wgt.Combobutton_._setCloseTimer = function (wgt) {
  if (!wgt._tidclose) wgt._tidclose = setTimeout(function () {
    if (!wgt._bover) {
      if (wgt._autodrop && wgt.isOpen()) wgt.close({
        sendOnOpen: true
      });
    }
    wgt._tidclose = undefined;
  }, 200);
};
window.zul.wgt.Combobutton_._fireOnOpen = function (wgt, opts, o) {
  jq(wgt.$n_()).toggleClass(wgt.$s('open'), o);
  if (opts && opts.sendOnOpen) wgt.fire('onOpen', {
    open: o,
    value: wgt.getLabel()
  }, {
    rtags: {
      onOpen: 1
    }
  });
}; // called by open method
window.zul.wgt.Combobutton_._attachPopup = function (wgt, bListen) {
  var pp = wgt.firstChild;
  // just attach if not attached
  if (!wgt._oldppclose && pp) {
    var $pp = jq(pp),
      wd = jq(wgt).width();
    if ($pp.width() < wd) {
      $pp.width(wd - zk(pp).padBorderWidth());
      // If the width of combobutton is larger than that of its popup, resize the popup and its children.
      zWatch.fireDown('onSize', pp);
      var openInfo = pp._openInfo;
      if (openInfo) {
        pp.position.apply(pp, openInfo);
        // B50-ZK-391
        // should keep openInfo, maybe used in onResponse later.
      }
    }
    wgt._oldppclose = pp.close;
    // listen to onmouseover and onmouseout events of popup child
    if (bListen) wgt.domListen_(pp.$n_(), 'onMouseOver').domListen_(pp.$n_(), 'onMouseOut');
    // override close function of popup widget for clear objects
    pp.close = function (opts) {
      wgt._oldppclose.call(pp, opts);
      window.zul.wgt.Combobutton_._fireOnOpen(wgt, opts, false);
      if (bListen) wgt.domUnlisten_(pp.$n_(), 'onMouseOver').domUnlisten_(pp.$n_(), 'onMouseOut');
      pp.close = wgt._oldppclose;
      delete wgt._oldppclose;
    };
  }
};
/**
 * A combo button. A combo button consists of a button ({@link zul.wgt.Combobutton}) and
 * a popup window ({@link zul.wgt.Popup}).
 * It is similar to {@link zul.inp.Bandbox} except the input box is substituted by a button.
 * @since 6.0.0
 * @defaultValue {@link getZclass}: z-combobutton.
 */
var Combobutton = /** @class */function (_super) {
  __extends(Combobutton, _super);
  function Combobutton() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns whether to automatically drop the list if users is changing this text box.
   * @defaultValue `false`.
   */
  Combobutton.prototype.isAutodrop = function () {
    return !!this._autodrop;
  };
  /**
   * Sets whether to automatically drop the list if users is changing
   * this text box.
   */
  Combobutton.prototype.setAutodrop = function (autodrop) {
    this._autodrop = autodrop;
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Combobutton.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   * If disabled is true, user cannot tab into the element.
   */
  Combobutton.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        jq(n).attr('disabled', disabled ? 'disabled' : null);
        jq(n).attr('tabindex', disabled ? null : this._tabindex | 0);
      }
    }
    return this;
  };
  Combobutton.prototype.getZclass = function () {
    return 'z-combobutton';
  };
  /** @internal */
  Combobutton.prototype.domContent_ = function () {
    var label = '<span id="' + this.uuid + '-txt" class="' + this.$s('text') + '">' + zUtl.encodeXML(this.getLabel()) + '</span>',
      /*safe*/img = this.domImage_(),
      /*safe*/iconSclass = this.domIcon_();
    if (!img && !iconSclass) return label;
    if (!img) img = iconSclass;else img += iconSclass ? ' ' + iconSclass : '';
    var space = 'vertical' == this.getOrient() ? '<br/>' : ' ';
    return this.getDir() == 'reverse' ? label + space + img : img + space + label;
  };
  /** @internal */
  Combobutton.prototype.domImage_ = function () {
    var img = this._image;
    return img ? '<img class="' + this.$s('image') + '" src="' + img + '" alt="" aria-hidden="true">' : '';
  };
  /** @internal */
  Combobutton.prototype.domClass_ = function (no) {
    var /*safe*/cls = _super.prototype.domClass_.call(this, no);
    if (!this._isDefault()) cls += ' z-combobutton-toolbar';
    return cls;
  };
  /** @internal */
  Combobutton.prototype._isDefault = function () {
    return this._mold == 'default';
  };
  /**
   * @returns whether the list of combo items is open
   */
  Combobutton.prototype.isOpen = function () {
    var pp = this.firstChild;
    return !!pp && pp.isOpen();
  };
  /**
   * Drops down or closes the child popup ({@link zul.wgt.Popup})
   * ({@link zul.menu.Menupopup}).
   * 	It will fire the onOpen event if no opts are provided.
   * @see {@link open}
   * @see {@link close}
   */
  Combobutton.prototype.setOpen = function (open, opts) {
    if (!this._disabled && !zk.animating()) this[open ? 'open' : 'close'](opts || {
      sendOnOpen: true
    }); // ZK-5835: need to update its child popup's visible state by triggering the onOpen event
    return this;
  };
  /** @internal */
  Combobutton.prototype.renderInner_ = function (out) {
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
  };
  /** @internal */
  Combobutton.prototype.isTableLayout_ = function () {
    return true;
  };
  /** @internal */
  Combobutton.prototype.unbind_ = function (skipper, after, keepRod) {
    var _a;
    var pp = (_a = this.firstChild) === null || _a === void 0 ? void 0 : _a.$n();
    // ZK-983
    if (pp) this.domUnlisten_(pp, 'onMouseOver').domUnlisten_(pp, 'onMouseOut');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Combobutton.prototype.doFocus_ = function (evt) {
    if (this == evt.target)
      // not change style if mouse down in popup node
      _super.prototype.doFocus_.call(this, evt);
  };
  /**
   * Open the dropdown widget of the Combobutton.
   */
  Combobutton.prototype.open = function (opts) {
    var pp = this.firstChild;
    if (pp && !this.isOpen()) {
      if (pp instanceof zul.wgt.Popup) {
        pp.open(this.uuid, undefined, 'after_start', opts);
        window.zul.wgt.Combobutton_._fireOnOpen(this, opts, true);
      }
      window.zul.wgt.Combobutton_._attachPopup(this, !(zul.menu && pp instanceof zul.menu.Menupopup));
    }
  };
  /**
   * Close the dropdown widget of the Combobutton.
   */
  Combobutton.prototype.close = function (opts) {
    if (this.isOpen()) this.firstChild.close(opts);
  };
  /** @internal */
  Combobutton.prototype.doClick_ = function (evt) {
    var d = evt.domTarget;
    // click will fired twice, one with dom target, another with undefined,
    // see _fixClick in Button.js
    if (d) {
      // open it if click on right side,
      // close it if click on both left and right side
      var open = !this.isOpen();
      if (this == evt.target) {
        if (this.$n('btn') == d || this.$n('icon') == d || !open) this.setOpen(open, {
          sendOnOpen: true
        });else _super.prototype.doClick_.call(this, evt);
      }
    }
  };
  /** @internal */
  Combobutton.prototype.doMouseDown_ = function (evt) {
    if (this == evt.target)
      // not change style if mouse down in popup node
      _super.prototype.doMouseDown_.call(this, evt);
  };
  /** @internal */
  Combobutton.prototype.doMouseOver_ = function (evt) {
    this._bover = true;
    if (this == evt.target) {
      var d = evt.domTarget;
      // not change style and call open method if mouse over popup node
      if (this._autodrop && (this.$n('btn') == d || this.$n('icon') == d) && !this.isOpen()) this.open({
        sendOnOpen: true
      });
      _super.prototype.doMouseOver_.call(this, evt);
    }
  };
  /** @internal */
  Combobutton.prototype.doMouseOut_ = function (evt) {
    this._bover = false;
    window.zul.wgt.Combobutton_._setCloseTimer(this);
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /** @internal */
  Combobutton.prototype._doMouseOver = function (evt) {
    // should not close popup if mouse out combobutton but over popup
    this._bover = true;
  };
  /** @internal */
  Combobutton.prototype._doMouseOut = function (evt) {
    // should close it if mouse out popup
    this._bover = false;
    window.zul.wgt.Combobutton_._setCloseTimer(this);
  };
  /** @internal */
  Combobutton.prototype.doKeyDown_ = function (evt) {
    this._doKeyDown(evt);
    if (!evt.stopped) _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Combobutton.prototype._doKeyDown = function (evt) {
    if (this.isDisabled()) {
      return false;
    }
    var keyCode = evt.keyCode,
      bOpen = this.isOpen();
    if (keyCode == 40 && !bOpen) this.open({
      sendOnOpen: true
    });else if (keyCode == 13 || keyCode == 32) {
      this.fire('onClick');
    } else if (keyCode == 27 && bOpen) this.close();
  };
  /** @internal */
  Combobutton.prototype.focus_ = function (timeout) {
    if (this.isDisabled()) return false;
    if (!zk.focusBackFix || !this._upload) {
      var self = this,
        n = this.$n_();
      zk.afterAnimate(function () {
        try {
          n.focus();
          zk.currentFocus = self;
          zjq.fixInput(n);
        } catch (e) {
          zk.debugLog(e.message || e);
        }
      }, timeout);
    }
    return true;
  };
  /** @internal */
  Combobutton.prototype.ignoreDescendantFloatUp_ = function (des) {
    return des && des instanceof zul.wgt.Popup;
  };
  // B60-ZK-1216
  // Combobutton has problems with label-change if its popup did not close beforehand
  // Override rerender should also work for the case of image-change
  Combobutton.prototype.rerender = function (skipper) {
    if (this.isOpen()) {
      this.close();
    }
    return _super.prototype.rerender.call(this, skipper);
  };
  Combobutton = __decorate([zk.WrapClass('zul.wgt.Combobutton')], Combobutton);
  return Combobutton;
}(zul.wgt.Button);
exports.Combobutton = Combobutton;
window.zul.wgt.Combobutton_.Combobutton = Combobutton;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Div.ts":
/*!******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Div.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Div_) window.zul.wgt.Div_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Div = void 0;
/* Div.ts

    Purpose:

    Description:

    History:
        Sun Oct  5 00:20:23     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

    This program is distributed under LGPL Version 2.1 in the hope that
    it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The same as HTML DIV tag.
 * <p>Note: a {@link zul.wnd.Window} without title and caption has the same visual effect
 * as {@link Div}, but {@link Div} doesn't implement IdSpace.
 * In other words, {@link Div} won't affect the uniqueness of identifiers.
 */
var Div = /** @class */function (_super) {
  __extends(Div, _super);
  function Div() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the alignment.
   * @defaultValue `null` (use browser default).
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Div.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the alignment: one of left, center, right, ustify,
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Div.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.align = align;
    }
    return this;
  };
  /** @internal */
  Div.prototype.domAttrs_ = function (no) {
    var align = this._align,
      /*safe*/attr = _super.prototype.domAttrs_.call(this, no);
    return align != null ? attr + ' align="' + zUtl.encodeXML(align) + '"' : attr;
  };
  Div = __decorate([zk.WrapClass('zul.wgt.Div')], Div);
  return Div;
}(zul.Widget);
exports.Div = Div;
window.zul.wgt.Div_.Div = Div;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Fileupload.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Fileupload.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Fileupload_) window.zul.wgt.Fileupload_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Fileupload = void 0;
/* Fileupload.ts

    Purpose:

    Description:

    History:
        Thu Jul 16 17:13:30     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A fileupload widget is the same as {@link zul.wgt.Button}
 */
var Fileupload = /** @class */function (_super) {
  __extends(Fileupload, _super);
  function Fileupload() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Fileupload.prototype.getZclass = function () {
    return this._zclass == null ? 'z-button' : this._zclass;
  };
  Fileupload = __decorate([zk.WrapClass('zul.wgt.Fileupload')], Fileupload);
  return Fileupload;
}(zul.wgt.Button);
exports.Fileupload = Fileupload;
window.zul.wgt.Fileupload_.Fileupload = Fileupload;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Groupbox.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Groupbox.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Groupbox_) window.zul.wgt.Groupbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Groupbox = void 0;
/* Groupbox.ts

    Purpose:

    Description:

    History:
        Sun Nov 16 12:39:24     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Groups a set of child elements to have a visual effect.
 * @defaultValue {@link getZclass}: "z-groupbox". If {@link getMold} is 3d,
 * "z-groupbox-3d" is assumed.
 *
 * <p>Events: onOpen.
 *
 */
var Groupbox = /** @class */function (_super) {
  __extends(Groupbox, _super);
  function Groupbox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._open = true;
    /** @internal */
    _this._closable = true;
    /** @internal */
    _this._nativebar = true;
    return _this;
  }
  /**
   * Opens or closes this groupbox.
   */
  Groupbox.prototype.setOpen = function (open, fromServer, opts) {
    var o = this._open;
    this._open = open;
    if (o !== open || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var node = this.$n();
      if (node && this._closable) {
        var caveNode = this.getCaveNode();
        if (open) {
          jq(node).removeClass(this.$s('collapsed'));
          zk(this).redoCSS(-1, {
            'fixFontIcon': true
          });
        }
        if (zk(this).getAnimationSpeed() === 0) {
          jq(caveNode)[open ? 'show' : 'hide']();
          this._afterOpen(open);
        } else zk(caveNode)[open ? 'slideDown' : 'slideUp'](this);
        if (!fromServer) this.fire('onOpen', {
          open: open
        });
      }
    }
    return this;
  };
  /**
   * @returns whether this groupbox is open.
   * @defaultValue `true`.
   */
  Groupbox.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * @returns whether user can open or close the group box.
   * In other words, if false, users are no longer allowed to
   * change the open status (by clicking on the title).
   *
   * @defaultValue `true`.
   */
  Groupbox.prototype.isClosable = function () {
    return this._closable;
  };
  /**
   * Sets whether user can open or close the group box.
   */
  Groupbox.prototype.setClosable = function (closable, opts) {
    var o = this._closable;
    this._closable = closable;
    if (o !== closable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updDomOuter();
    }
    return this;
  };
  /**
   * @returns the CSS style for the content block of the groupbox.
   * Used only if {@link getMold} is not default.
   */
  Groupbox.prototype.getContentStyle = function () {
    return this._contentStyle;
  };
  /**
   * Sets the CSS style for the content block of the groupbox.
   * Used only if {@link getMold} is not default.
   *
   * @defaultValue `null`.
   */
  Groupbox.prototype.setContentStyle = function (contentStyle, opts) {
    var o = this._contentStyle;
    this._contentStyle = contentStyle;
    if (o !== contentStyle || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updDomOuter();
    }
    return this;
  };
  /**
   * @returns the style class used for the content block of the groupbox.
   * Used only if {@link getMold} is not default.
   */
  Groupbox.prototype.getContentSclass = function () {
    return this._contentSclass;
  };
  /**
   * Sets the style class used for the content block.
   */
  Groupbox.prototype.setContentSclass = function (contentSclass, opts) {
    var o = this._contentSclass;
    this._contentSclass = contentSclass;
    if (o !== contentSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updDomOuter();
    }
    return this;
  };
  /**
   * @returns the title of the groupbox.
   * @since 6.0.0
   */
  Groupbox.prototype.getTitle = function () {
    return this._title;
  };
  /**
   * Sets the title of the groupbox.
   * @since 6.0.0
   */
  Groupbox.prototype.setTitle = function (title, opts) {
    var o = this._title;
    this._title = title;
    if (o !== title || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updDomOuter();
    }
    return this;
  };
  /** @internal */
  Groupbox.prototype._isDefault = function () {
    return this._mold == 'default';
  };
  /** @internal */
  Groupbox.prototype._updDomOuter = function () {
    this.rerender(zk.Skipper.nonCaptionSkipper);
  };
  /** @internal */
  Groupbox.prototype._contentAttrs = function () {
    var html = ' class="',
      s = this._contentSclass;
    if (s) html += /*safe*/s + ' ';
    html += this.$s('content') + '"';
    s = this._contentStyle;
    if (this.caption || this.getTitle())
      // B60-ZK-987
      s = 'border-top:0;' + (zUtl.encodeXMLAttribute(s) || '');
    if (!this._open) s = 'display:none;' + (zUtl.encodeXMLAttribute(s) || '');
    if (s) html += ' style="' + zUtl.encodeXMLAttribute(s) + '"';
    return html;
  };
  /** @internal */
  Groupbox.prototype._redrawCave = function (out, skipper) {
    out.push('<div id="', this.uuid, '-cave"', /*safe*/this._contentAttrs(), '>');
    if (!skipper) for (var w = this.firstChild, cap = this.caption; w; w = w.nextSibling) if (w != cap) w.redraw(out);
    out.push('</div>');
  };
  Groupbox.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) this._fixHgh();
    return this;
  };
  /** @internal */
  Groupbox.prototype._fixHgh = function () {
    var n = this.$n_(),
      hgh = n.style.height;
    if (!hgh && this._cssflex && this._vflex)
      // due to css flex, need to use offsetHeight
      hgh = n.offsetHeight;
    if (hgh && hgh != 'auto' && this.isOpen()) {
      var n_1 = this.$n('cave');
      if (n_1) {
        var $n = zk(n_1);
        // B50-ZK-487: height isuue in the groupbox (with specified caption)
        n_1.style.height = $n.revisedHeight($n.vflexHeight(), true) - (this._isDefault() ? parseInt(jq(this).css('padding-top')) : 0) + 'px';
        //if (zk.gecko) setTimeout(fix, 0);
        //Gecko bug: height is wrong if the browser visits the page first time
        //(reload won't reproduce the problem) test case: test/z5.zul
      }
    }
    if (this._isDefault()) {
      var title = this.$n('title'),
        cap = this.caption;
      if (cap) cap.$n_().style.top = jq.px(zk(cap.$n('cave')).offsetHeight() / 2 * -1);
      if (title) title.style.top = jq.px(zk(this.$n('title-cnt')).offsetHeight() / 2 * -1);
    }
  };
  // B60-ZK-562: Groupbox vflex=min is wrong
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Groupbox.prototype.setFlexSizeH_ = function (flexSizeH, zkn, height, isFlexMin) {
    if (isFlexMin && (this.caption || this._title)) {
      // B60-ZK-562
      height = this._isDefault() ? parseInt(jq(this).css('padding-top')) : 0;
      for (var c = flexSizeH.firstChild; c; c = c.nextSibling) height += jq(c).outerHeight();
    }
    _super.prototype.setFlexSizeH_.call(this, flexSizeH, zkn, height, isFlexMin);
  };
  //watch//
  Groupbox.prototype.onSize = function () {
    this._fixHgh();
    // B50-ZK-487
    // classicblue is deprecated and
    // shadow not used in breeze, sapphire and silvertail,
  };
  /** @internal */
  Groupbox.prototype.clearCachedSize_ = function () {
    _super.prototype.clearCachedSize_.call(this);
    this.$n_('cave').style.height = '';
  };
  /** @internal */
  Groupbox.prototype.updateDomStyle_ = function () {
    _super.prototype.updateDomStyle_.call(this);
    if (this.desktop) this.onSize();
  };
  /** @internal */
  Groupbox.prototype.focus_ = function (timeout) {
    var cap = this.caption;
    for (var w = this.firstChild; w; w = w.nextSibling) if (w.desktop && w != cap && w.focus_(timeout)) return true;
    return !!(cap === null || cap === void 0 ? void 0 : cap.focus_(timeout));
  };
  /** @internal */
  Groupbox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this
    });
    var tt;
    if (this.getTitle() && (tt = this.$n('title'))) this.domListen_(tt, 'onClick', '_doTitleClick');
  };
  /** @internal */
  Groupbox.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this
    });
    var tt = this.$n('title');
    if (tt) this.domUnlisten_(tt, 'onClick', '_doTitleClick');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  // will be called while click on title and title exists but no caption
  /** @internal */
  Groupbox.prototype._doTitleClick = function (evt, popupOnly) {
    if (this._closable) this.setOpen(!this.isOpen());
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Groupbox.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.wgt.Caption) {
      this.caption = child;
      this.rerender();
    }
  };
  /** @internal */
  Groupbox.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.caption) {
      this.caption = undefined;
      this.rerender();
    }
  };
  //@Override, Bug ZK-1524: caption children should not considered.
  /** @internal */
  Groupbox.prototype.getChildMinSize_ = function (attr, wgt) {
    if (!(wgt instanceof zul.wgt.Caption)) return _super.prototype.getChildMinSize_.call(this, attr, wgt);
    return 0; // FIXME: prior to TS migration, it returns nothing here.
  };
  /** @internal */
  Groupbox.prototype.domClass_ = function (no) {
    var clsHTML = _super.prototype.domClass_.call(this, no);
    if (!this._isDefault()) {
      if (clsHTML) clsHTML += ' ';
      clsHTML += this.$s('3d');
    }
    if (!this.caption && !this.getTitle()) {
      if (clsHTML) clsHTML += ' ';
      clsHTML += ' ' + this.$s('notitle');
    }
    if (!this._open && this._isDefault()) {
      if (clsHTML) clsHTML += ' ';
      clsHTML += this.$s('collapsed');
    }
    return clsHTML;
  };
  /** @internal */
  Groupbox.prototype.afterAnima_ = function (visible) {
    _super.prototype.afterAnima_.call(this, visible);
    this._afterOpen(visible);
  };
  /** @internal */
  Groupbox.prototype._afterOpen = function (visible) {
    if (!visible && this._isDefault()) jq(this.$n()).addClass(this.$s('collapsed'));
    var p = this.parent;
    if (p) {
      var parentHasFlex = p.getHflex && p.getHflex() != 'min' || p.getVflex && p.getVflex() != 'min';
      if (parentHasFlex) {
        // ZK-3248: parent should resize if parent itself has flex
        zUtl.fireSized(p);
      } else {
        // ZK-2138: parent should resize if parent has child with vflex
        for (var c = p.firstChild; c; c = c.nextSibling) {
          if (c == this) continue;
          var vflex = c.getVflex();
          if (vflex && vflex != 'min') {
            zUtl.fireSized(p);
            break;
          }
        }
      }
    }
    // ZK-2978: should appear zul.Scrollbar after setOpen
    this.doResizeScroll_();
  };
  Groupbox = __decorate([zk.WrapClass('zul.wgt.Groupbox')], Groupbox);
  return Groupbox;
}(zul.ContainerWidget);
exports.Groupbox = Groupbox;
window.zul.wgt.Groupbox_.Groupbox = Groupbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Html.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Html.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Html_) window.zul.wgt.Html_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Html = void 0;
/* Html.ts

    Purpose:

    Description:

    History:
        Sun Nov 23 20:35:12     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A component used to embed the browser native content (i.e., HTML tags)
 * into the output sent to the browser.
 * The browser native content is specified by {@link setContent}.
 *
 * <p>Notice that {@link Html} generates HTML SPAN to enclose
 * the embedded HTML tags. Thus, you can specify the style
 * ({@link getStyle}), tooltip {@link getTooltip} and so on.
 */
var Html = /** @class */function (_super) {
  __extends(Html, _super);
  function Html() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._content = '';
    return _this;
  }
  /**
   * @returns the embedded content (i.e., HTML tags).
   * @defaultValue empty ("").
   * <p>Deriving class can override it to return whatever it wants
   * other than null.
   */
  Html.prototype.getContent = function () {
    return this._content;
  };
  /**
   * Sets the embedded content (i.e., HTML tags).
   */
  Html.prototype.setContent = function (content, opts) {
    var o = this._content;
    this._content = content;
    if (o !== content || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // Allow HTML and Script tag here according to Component reference guide.
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = /*safe*/content || '';
    }
    return this;
  };
  /** @internal */
  Html.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (Array.isArray(this._content))
      //zk().detachChildren() is used
      for (var ctn = this._content, n = this.$n_(), j = 0; j < ctn.length; ++j) n.appendChild(ctn[j]);
  };
  /** @internal */
  Html.prototype.unbind_ = function (skipper, after, keepRod) {
    if (Array.isArray(this._content))
      //zk().detachChildren() is used
      for (var n = this.$n_(); n.firstChild;) n.removeChild(n.firstChild);
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Html = __decorate([zk.WrapClass('zul.wgt.Html')], Html);
  return Html;
}(zul.Widget);
exports.Html = Html;
window.zul.wgt.Html_.Html = Html;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Idspace.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Idspace.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Idspace_) window.zul.wgt.Idspace_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Idspace = void 0;
/* Idspace.ts

    Purpose:

    Description:

    History:
        Thu Nov 03 12:15:49     2011, Created by benbai

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Just like DIV tag but implements IdSpace.
 * @since 6.0.0
 */
var Idspace = /** @class */function (_super) {
  __extends(Idspace, _super);
  function Idspace() {
    var _this = _super.call(this) || this; // FIXME: params?
    _this._fellows = {};
    return _this;
    // NOTE: Prior to TS migration, super is called after `_fellows` is initialized.
    // In this case, it's safe to initialize `_fellows` after calling super, as
    // the none in the chain of super constructors will access `_fellows`.
  }
  Idspace = __decorate([zk.WrapClass('zul.wgt.Idspace')], Idspace);
  return Idspace;
}(zul.wgt.Div);
exports.Idspace = Idspace;
//ZK-3255: support nodom mold
zk.$intercepts(zul.wgt.Idspace, zk.NoDOM);
window.zul.wgt.Idspace_.Idspace = Idspace;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Image.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Image.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Image_) window.zul.wgt.Image_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Image = void 0;
/* Image.ts

    Purpose:

    Description:

    History:
        Thu Mar 26 15:07:07     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An image.
 *
 * <p>See also <a href="http://books.zkoss.org/wiki/ZK_Client-side_Reference/Customization/Alphafix_for_IE6">how to fix the alpha transparency problem of PNG files found in IE6?</a>
 */
var Image = /** @class */function (_super) {
  __extends(Image, _super);
  function Image() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the source URI of the image.
   * @defaultValue `null`.
   */
  Image.prototype.getSrc = function () {
    return this._src;
  };
  /**
   * Sets the source URI of the image.
   * @param src - the URI of the image source
   */
  Image.prototype.setSrc = function (src, opts) {
    var o = this._src;
    this._src = src;
    if (o !== src || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (src && this._preloadImage) zUtl.loadImage(src);
      var n = this.getImageNode();
      if (n) n.src = src || '';
    }
    return this;
  };
  // for stateless to treat as "src" attribute at client side
  Image.prototype.getContent = function () {
    return this.getSrc();
  };
  // for stateless to treat as "src" attribute at client side
  Image.prototype.setContent = function (content, opts) {
    return this.setSrc(content, opts);
  };
  /**
   * @returns the URI of the hover image.
   * The hover image is used when the mouse is moving over this component.
   * @defaultValue `null`.
   */
  Image.prototype.getHover = function () {
    return this._hover;
  };
  /**
   * Sets the image URI.
   * The hover image is used when the mouse is moving over this component.
   */
  Image.prototype.setHover = function (hover) {
    this._hover = hover;
    return this;
  };
  /**
   * @returns the alignment.
   * @defaultValue `null` (use browser default).
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the alignment: one of top, texttop, middle, absmiddle,
   * bottom, absbottom, baseline, left, right and center.
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.getImageNode();
      if (n) n.align = align || '';
    }
    return this;
  };
  /**
   * @returns number of pixels of extra space to the left and right
   * side of the image.
   * @defaultValue `null` (use browser default).
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.getHspace = function () {
    return this._hspace;
  };
  /**
   * Sets number of pixels of extra space to the left and right side of the image.
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.setHspace = function (hspace, opts) {
    var o = this._hspace;
    this._hspace = hspace;
    if (o !== hspace || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.getImageNode();
      if (n) n.hspace = hspace;
    }
    return this;
  };
  /**
   * @returns number of pixels of extra space to the top and bottom side of the image.
   * @defaultValue `null` (use browser default).
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.getVspace = function () {
    return this._vspace;
  };
  /**
   * Sets number of pixels of extra space to the top and bottom side of the image.
   * @deprecated as of release 6.0.0, use CSS instead.
   */
  Image.prototype.setVspace = function (vspace, opts) {
    var o = this._vspace;
    this._vspace = vspace;
    if (o !== vspace || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.getImageNode();
      if (n) n.vspace = vspace;
    }
    return this;
  };
  /**
   * @returns the image node if any.
   */
  Image.prototype.getImageNode = function () {
    return this.$n();
  };
  //super
  /** @internal */
  Image.prototype.doMouseOver_ = function (evt) {
    var hover = this._hover;
    if (hover) {
      var img = this.getImageNode();
      if (img) img.src = hover;
    }
    _super.prototype.doMouseOver_.call(this, evt);
  };
  /** @internal */
  Image.prototype.doMouseOut_ = function (evt) {
    if (this._hover) {
      var img = this.getImageNode();
      if (img) img.src = this._src || '';
    }
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /** @internal */
  Image.prototype.domAttrs_ = function (no) {
    var attrHTML = _super.prototype.domAttrs_.call(this, no);
    if (!no || !no.content) attrHTML += /*safe*/this.contentAttrs_();
    return attrHTML;
  };
  /**
   * This method is required only if IMG is placed in the inner.
   * And, it also has to specify `{content:true}` when calling {@link domAttrs_}
   * @internal
   */
  Image.prototype.contentAttrs_ = function () {
    var attr = ' src="' + zUtl.encodeXMLAttribute(this._src || '') + '"',
      v;
    if (v = this._align) attr += ' align="' + zUtl.encodeXMLAttribute(v) + '"';
    if (v = this._hspace) attr += ' hspace="' + zUtl.encodeXMLAttribute(v) + '"';
    if (v = this._vspace) attr += ' vspace="' + zUtl.encodeXMLAttribute(v) + '"';
    return attr;
  };
  Image = __decorate([zk.WrapClass('zul.wgt.Image')], Image);
  return Image;
}(zul.Widget);
exports.Image = Image;
window.zul.wgt.Image_.Image = Image;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Imagemap.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Imagemap.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Imagemap_) window.zul.wgt.Imagemap_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Imagemap = void 0;
/* Imagemap.ts

    Purpose:

    Description:

    History:
        Thu Mar 26 15:54:00     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An image map.
 */
var Imagemap = /** @class */function (_super) {
  __extends(Imagemap, _super);
  function Imagemap() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Imagemap.prototype.getWidth = function () {
    return this._width;
  };
  Imagemap.prototype.setWidth = function (width, opts) {
    var o = this._width;
    this._width = width;
    if (o !== width || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      // B50-ZK-478
      var n = this.getImageNode();
      if (n) n.style.width = width;
    }
    return this;
  };
  Imagemap.prototype.getHeight = function () {
    return this._height;
  };
  Imagemap.prototype.setHeight = function (height, opts) {
    var o = this._height;
    this._height = height;
    if (o !== height || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      // B50-ZK-478
      var n = this.getImageNode();
      if (n) n.style.height = height;
    }
    return this;
  };
  /** @internal */
  Imagemap.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (!jq('#zk_hfr_')[0]) jq.newFrame('zk_hfr_', undefined, zk.webkit ? 'position:absolute;top:-1000px;left:-1000px;width:0;height:0;display:inline' : undefined /*invisible*/);
    //creates a hidden frame. However, in safari, we cannot use invisible frame
    //otherwise, safari will open a new window
  };
  Imagemap.prototype.getImageNode = function () {
    return this.$n('real');
  };
  Imagemap.prototype.getCaveNode = function () {
    return this.$n('map');
  };
  /** @internal */
  Imagemap.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.desktop && this.firstChild == this.lastChild)
      //first child
      this._fixchd(true);
  };
  /** @internal */
  Imagemap.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (this.desktop && !this.firstChild)
      //remove last
      this._fixchd(false);
  };
  /** @internal */
  Imagemap.prototype._fixchd = function (bArea) {
    var mapid = this.uuid + '-map',
      img = this.getImageNode();
    img.useMap = bArea ? '#' + mapid : '';
    img.isMap = !bArea;
  };
  /** @internal */
  Imagemap.prototype.contentAttrs_ = function () {
    var attr = _super.prototype.contentAttrs_.call(this),
      w = this._width,
      h = this._height;
    if (w || h) {
      // B50-ZK-478
      attr += ' style="';
      if (w) attr += 'width:' + zUtl.encodeXMLAttribute(w) + ';';
      if (h) attr += 'height:' + zUtl.encodeXMLAttribute(h) + ';';
      attr += '"';
    }
    return attr + (this.firstChild ? ' usemap="#' + this.uuid + '-map"' : ' ismap="ismap"');
  };
  Imagemap.prototype.fromPageCoord = function (x, y) {
    //2997402: Imagemap rightclick/doubleclick wrong coordinates
    var ofs = zk(this.getImageNode()).revisedOffset();
    return [x - ofs[0], y - ofs[1]];
  };
  /** @internal */
  Imagemap.prototype._doneURI = function () {
    var Imagemap = zul.wgt.Imagemap,
      url = Imagemap._doneURI;
    return url ? url : Imagemap._doneURI = zk.IMAGEMAP_DONE_URI ? zk.IMAGEMAP_DONE_URI : zk.ajaxURI('/web/zul/html/imagemap-done.html', {
      desktop: this.desktop,
      au: true
    });
  };
  /** Called by imagemap-done.html. */
  Imagemap.onclick = function (href) {
    if (zul.wgt.Imagemap._toofast()) return;
    var j = href.indexOf('?');
    if (j < 0) return;
    var k = href.indexOf('?', ++j);
    if (k < 0) return;
    var id = href.substring(j, k),
      wgt = zk.Widget.$(id);
    if (!wgt) return; //component might be removed
    j = href.indexOf(',', ++k);
    if (j < 0) return;
    wgt.fire('onClick', {
      x: zk.parseInt(href.substring(k, j)),
      y: zk.parseInt(href.substring(j + 1))
    }, {
      ctl: true
    });
  };
  /** @internal */
  Imagemap._toofast = function () {
    if (zk.gecko) {
      //bug 1510374
      var Imagemap = zul.wgt.Imagemap,
        now = jq.now();
      if (Imagemap._stamp && now - Imagemap._stamp < 800) return true;
      Imagemap._stamp = now;
    }
    return false;
  };
  Imagemap = __decorate([zk.WrapClass('zul.wgt.Imagemap')], Imagemap);
  return Imagemap;
}(zul.wgt.Image);
exports.Imagemap = Imagemap;
window.zul.wgt.Imagemap_.Imagemap = Imagemap;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Include.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Include.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Include_) window.zul.wgt.Include_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Include = void 0;
/* Include.ts

    Purpose:

    Description:

    History:
        Tue Oct 14 15:23:17     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

    This program is distributed under LGPL Version 2.1 in the hope that
    it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An include widget
 */
var Include = /** @class */function (_super) {
  __extends(Include, _super);
  function Include() {
    var _this = _super.call(this) || this; // FIXME: params?
    //F70-ZK-2455: a way to change enclosing tag
    /** @internal */
    _this._enclosingTag = 'div';
    _this._fellows = {};
    return _this;
    // NOTE: Prior to TS migration, super is called after `_fellows` is initialized.
    // In this case, it's safe to initialize `_fellows` after calling super, as
    // the none in the chain of super constructors will access `_fellows`.
  }
  /**
   * @returns whether to generate the included content inside the HTML comment.
   * @defaultValue `false`.
   */
  Include.prototype.isComment = function () {
    return !!this._comment;
  };
  /**
   * Sets whether to generate the included content inside the HTML comment.
   */
  Include.prototype.setComment = function (comment) {
    this._comment = comment;
    return this;
  };
  /**
   * @returns the enclosing tag
   * @since 7.0.4
   */
  Include.prototype.getEnclosingTag = function () {
    return this._enclosingTag;
  };
  /**
   * Sets the enclosing tag
   * @since 7.0.4
   */
  Include.prototype.setEnclosingTag = function (enclosingTag) {
    this._enclosingTag = enclosingTag;
    return this;
  };
  /** @internal */
  Include.prototype.domStyle_ = function (no) {
    var styleHTML = _super.prototype.domStyle_.call(this, no);
    if (!this.previousSibling && !this.nextSibling) {
      //if it is only child, the default is 100%
      if ((!no || !no.width) && !this.getWidth()) styleHTML += 'width:100%;';
      if ((!no || !no.height) && !this.getHeight()) styleHTML += 'height:100%;';
    }
    return styleHTML;
  };
  /** @internal */
  Include.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var ctn = this._childjs;
    if (ctn) {
      ctn();
      this._childjs = this._xcnt = undefined;
      //only once since the content has been created as child widgets
    }
    var xcnt = this._xcnt;
    if (Array.isArray(xcnt))
      //array -> zk().detachChildren() used
      for (var n = this.$n_(), j = 0; j < xcnt.length; ++j) n.appendChild(xcnt[j]);
  };
  /** @internal */
  Include.prototype.unbind_ = function (skipper, after, keepRod) {
    if (Array.isArray(this._xcnt))
      //array -> zk().detachChildren() used
      for (var n = this.$n_(); n.firstChild;) n.removeChild(n.firstChild);
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Include = __decorate([zk.WrapClass('zul.wgt.Include')], Include);
  return Include;
}(zul.Widget);
exports.Include = Include;
window.zul.wgt.Include_.Include = Include;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Inputgroup.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Inputgroup.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Inputgroup_) window.zul.wgt.Inputgroup_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Inputgroup = void 0;
/* Inputgroup.ts

        Purpose:

        Description:

        History:
                Thu Mar 07 16:51:36 CST 2019, Created by charlesqiu

Copyright (C) 2019 Potix Corporation. All Rights Reserved.

*/
/**
 * An inputgroup.
 *
 * Inspired by Bootstrap’s Input group and Button group.
 * By prepending or appending some components to the input component,
 * you can merge them like a new form-input component.
 *
 * <h3>Accepted child components</h3>
 * <ul>
 *     <li>Label</li>
 *     <li>InputElement</li>
 *     <li>LabelImageElement</li>
 * </ul>
 *
 * @defaultValue {@link getZclass}: z-inputgroup.
 *
 * @since 9.0.0
 * @author charlesqiu, rudyhuang
 */
var Inputgroup = /** @class */function (_super) {
  __extends(Inputgroup, _super);
  function Inputgroup() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._vertical = false;
    return _this;
  }
  /**
   * @returns whether it is a vertical orientation.
   * @defaultValue `false`
   */
  Inputgroup.prototype.isVertical = function () {
    return this._vertical;
  };
  /**
   * Sets whether it is a vertical orientation.
   * @param vertical - whether it is a vertical orientation
   */
  Inputgroup.prototype.setVertical = function (vertical, opts) {
    var o = this._vertical;
    this._vertical = vertical;
    if (o !== vertical || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        jq(this.$n()).toggleClass(this.$s('vertical'), vertical);
      }
    }
    return this;
  };
  // treat this as setVertical(boolean) for stateless
  Inputgroup.prototype.setOrient = function (orient) {
    return this.setVertical(orient == 'vertical');
  };
  /** @internal */
  Inputgroup.prototype.domClass_ = function (no) {
    var classesHTML = _super.prototype.domClass_.call(this, no);
    return classesHTML + (this._vertical ? ' ' + this.$s('vertical') : '');
  };
  /** @internal */
  Inputgroup.prototype.insertChildHTML_ = function (child, before, desktop) {
    if (before) jq(before.$n('chdex') || before.$n()).before( /*safe*/this.encloseChildHTML_({
      child: child
    }));else jq(this.getCaveNode()).append( /*safe*/this.encloseChildHTML_({
      child: child
    }));
    child.bind(desktop);
  };
  /** @internal */
  Inputgroup.prototype.removeChildHTML_ = function (child, ignoreDom) {
    _super.prototype.removeChildHTML_.call(this, child, ignoreDom);
    jq(child.uuid + '-chdex', zk).remove();
  };
  /** @internal */
  Inputgroup.prototype.encloseChildHTML_ = function (opts) {
    var out = opts.out || new zk.Buffer(),
      w = opts.child;
    if (!(w instanceof zul.wgt.Button) && !(w instanceof zul.wgt.Toolbarbutton) && (!zul.inp || !(w instanceof zul.inp.InputWidget))) {
      out.push('<div id="', /*safe*/w.uuid, '-chdex" class="', this.$s('text'), '">');
      w.redraw(out);
      out.push('</div>');
    } else {
      w.redraw(out);
    }
    if (!opts.out) return out.join('');
  };
  Inputgroup = __decorate([zk.WrapClass('zul.wgt.Inputgroup')], Inputgroup);
  return Inputgroup;
}(zul.Widget);
exports.Inputgroup = Inputgroup;
window.zul.wgt.Inputgroup_.Inputgroup = Inputgroup;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Label.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Label.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Label.ts

    Purpose:

    Description:

    History:
        Sun Oct  5 00:22:03     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

    This program is distributed under LGPL Version 2.1 in the hope that
    it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Label_) window.zul.wgt.Label_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Label = void 0;
/**
 * A label.
 *
 * @defaultValue {@link getZclass}: z-label.
 */
var Label = /** @class */function (_super) {
  __extends(Label, _super);
  function Label() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._value = '';
    /** @internal */
    _this._maxlength = 0;
    return _this;
  }
  /**
   * @returns the value.
   * @defaultValue `""`.
   * <p>Deriving class can override it to return whatever it wants
   * other than null.
   */
  Label.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets the value.
   */
  Label.prototype.setValue = function (value, opts) {
    var o = this._value;
    this._value = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = /*safe*/this.getEncodedText();
    }
    return this;
  };
  /**
   * @returns whether to preserve the new line and the white spaces at the
   * begining of each line.
   */
  Label.prototype.isMultiline = function () {
    return !!this._multiline;
  };
  /**
   * Sets whether to preserve the new line and the white spaces at the
   * begining of each line.
   */
  Label.prototype.setMultiline = function (multiline, opts) {
    var o = this._multiline;
    this._multiline = multiline;
    if (o !== multiline || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = /*safe*/this.getEncodedText();
    }
    return this;
  };
  /**
   * @returns whether to preserve the white spaces, such as space,
   * tab and new line.
   *
   * <p>It is the same as style="white-space:pre". However, IE has a bug when
   * handling such style if the content is updated dynamically.
   * Refer to Bug 1455584.
   *
   * <p>Note: the new line is preserved either {@link isPre} or
   * {@link isMultiline} returns true.
   * In other words, `pre` implies `multiline`
   */
  Label.prototype.isPre = function () {
    return !!this._pre;
  };
  /**
   * Sets whether to preserve the white spaces, such as space, tab and new line.
   */
  Label.prototype.setPre = function (pre, opts) {
    var o = this._pre;
    this._pre = pre;
    if (o !== pre || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = /*safe*/this.getEncodedText();
    }
    return this;
  };
  /**
   * @returns the maximal length of the label.
   * @defaultValue `0` (means no limitation)
   */
  Label.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maximal length of the label.
   */
  Label.prototype.setMaxlength = function (maxlength, opts) {
    var o = this._maxlength;
    this._maxlength = maxlength;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      // eslint-disable-next-line @microsoft/sdl/no-inner-html
      if (n) n.innerHTML = /*safe*/this.getEncodedText();
    }
    return this;
  };
  /**
   * @returns the encoded text.
   * @see zUtl#encodeXML
   */
  Label.prototype.getEncodedText = function () {
    return zUtl.encodeXML(this._value, {
      multiline: this._multiline,
      pre: this._pre,
      maxlength: this._maxlength
    });
  };
  // fix for HTML5 doctype that give a special gap between top and button
  /** @internal */
  Label.prototype.getMarginSize_ = function (attr) {
    var o = _super.prototype.getMarginSize_.call(this, attr);
    if (attr == 'h') {
      var n = this.$n(),
        oh = zk(n).offsetHeight();
      return o + oh - n.offsetHeight;
    }
    return o;
  };
  Label = __decorate([zk.WrapClass('zul.wgt.Label')], Label);
  return Label;
}(zul.Widget);
exports.Label = Label;
window.zul.wgt.Label_.Label = Label;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Nodom.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Nodom.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Nodom_) window.zul.wgt.Nodom_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Nodom = void 0;
/* Nodom.ts

    Purpose:

    Description:

    History:
        Tue Jul 19 15:21:48 2016, Created by jameschu

Copyright (C) 2016 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A no-dom widget with comment scope
 * @since 8.0.3
 */
var Nodom = /** @class */function (_super) {
  __extends(Nodom, _super);
  function Nodom() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    _this.z_virnd = true;
    return _this;
  }
  Nodom.prototype.getMold = function () {
    return 'nodom';
  };
  Nodom = __decorate([zk.WrapClass('zul.wgt.Nodom')], Nodom);
  return Nodom;
}(zk.Widget);
exports.Nodom = Nodom;
zk.$intercepts(zul.wgt.Nodom, zk.NoDOM);
window.zul.wgt.Nodom_.Nodom = Nodom;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Notification.ts":
/*!***************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Notification.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Notification_) window.zul.wgt.Notification_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Notification = void 0;
/* Notification.ts

    Purpose:

    Description:

    History:
        Thu Mar 15 17:12:46     2012, Created by simon

Copyright (C) 2012 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
var _iconMap = {
    'warning': 'z-icon-exclamation-circle',
    'info': 'z-icon-info-circle',
    'error': 'z-icon-times-circle'
  },
  _dirMap = {
    'u': 'up',
    'd': 'down',
    'l': 'left',
    'r': 'right'
  };
/**
 * A notification widget.
 * @since 6.0.1
 */
var Notification = /** @class */function (_super) {
  __extends(Notification, _super);
  function Notification(msg, opts) {
    // @ts-expect-error: doesn't match zk.Widget.prototype.constructor
    var _this = _super.call(this, msg, opts) || this;
    /** @internal */
    _this._keepVisible = true;
    _this._msg = msg;
    _this._type = opts.type;
    _this._ref = opts.ref;
    _this._dur = opts.dur;
    _this._closable = opts.closable;
    return _this;
  }
  Notification.prototype.redraw = function (out) {
    var uuidHTML = this.uuid,
      iconHTML = this.$s('icon');
    out.push('<div', this.domAttrs_(), '>');
    if (this._ref)
      //output arrow if reference exist
      out.push('<div id="', uuidHTML, '-p" class="', this.$s('pointer'), '"></div>');
    out.push('<i id="', uuidHTML, '-icon" class="', iconHTML, ' ', /*safe*/_iconMap[this._type], '"></i>');
    out.push('<div id="', uuidHTML, '-cave" class="', this.$s('content'), '">', DOMPurify.sanitize(this._msg), '</div>');
    if (this._closable) out.push('<div id="', uuidHTML, '-cls" class="', this.$s('close'), '"><i id="', uuidHTML, '-clsIcon" class="', iconHTML, ' z-icon-times"></i></div>');
    out.push('</div>'); // not encoded to support HTML
  };
  /** @internal */
  Notification.prototype.domClass_ = function (no) {
    var type = this._type,
      /*safe*/s = _super.prototype.domClass_.call(this, no);
    if (type) s += ' ' + this.$s(zUtl.encodeXML(type));
    return s;
  };
  /** @internal */
  Notification.prototype.doClick_ = function (evt, popupOnly) {
    var p = evt.domTarget;
    if (p == this.$n('cls') || p == this.$n('clsIcon'))
      //may click on font-icon
      this.close();else _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  Notification.prototype.onFloatUp = function (ctl, opts) {
    if (opts && opts.triggerByFocus)
      //only mouse click should close notification
      return;
    if (!this.isVisible()) return;
    var wgt = ctl.origin;
    for (var floatFound = false; wgt; wgt = wgt.parent) {
      if (wgt == this) {
        if (!floatFound) this.setTopmost();
        return;
      }
      if (wgt == this.parent && wgt.ignoreDescendantFloatUp_(this)) return;
      floatFound = floatFound !== null && floatFound !== void 0 ? floatFound : wgt.isFloating_();
    }
    if (!this._closable && this._dur <= 0) this.close({
      sendOnOpen: true
    });
  };
  Notification.prototype.open = function (ref, offset, position, opts) {
    _super.prototype.open.call(this, ref, offset, position, opts);
    this._fixarrow(ref); //ZK-1583: modify arrow position based on reference component
    zk(this).redoCSS(-1, {
      'fixFontIcon': true
    });
  };
  Notification.prototype.position = function (ref, offset, position, opts) {
    if (ref && !ref.$n()) return;
    _super.prototype.position.call(this, ref, offset, position, opts);
    this._fixarrow(ref); //ZK-1583: modify arrow position based on reference component
  };
  /** @internal */
  Notification.prototype._posInfo = function (ref, offset, position, opts) {
    this._fixPadding(position);
    return _super.prototype._posInfo.call(this, ref, offset, position, opts);
  };
  /** @internal */
  Notification.prototype._fixPadding = function (position) {
    var p = this.$n('p');
    if (!p) return;
    var n = this.$n(),
      pw = 2 + zk(p).borderWidth() / 2 || 0,
      ph = 2 + zk(p).borderHeight() / 2 || 0;
    n.style.padding = '0';
    // cache arrow direction for _fixarrow() later
    switch (position) {
      case 'before_start':
      case 'before_center':
      case 'before_end':
        this._dir = 'd';
        n.style.paddingBottom = ph + 'px';
        break;
      case 'after_start':
      case 'after_center':
      case 'after_end':
        this._dir = 'u';
        n.style.paddingTop = ph + 'px';
        break;
      case 'end_before':
      case 'end_center':
      case 'end_after':
        this._dir = 'l';
        n.style.paddingLeft = pw + 'px';
        break;
      case 'start_before':
      case 'start_center':
      case 'start_after':
        this._dir = 'r';
        n.style.paddingRight = pw + 'px';
        break;
      case 'top_left':
      case 'top_center':
      case 'top_right':
      case 'middle_left':
      case 'middle_center':
      case 'middle_right':
      case 'bottom_left':
      case 'bottom_center':
      case 'bottom_right':
      case 'overlap':
      case 'overlap_end':
      case 'overlap_before':
      case 'overlap_after':
        this._dir = 'n';
        break;
      // at_pointer, after_pointer, etc.
      default:
        this._dir = 'n';
    }
  };
  /** @internal */
  Notification.prototype._fixarrow = function (ref) {
    var p = this.$n('p');
    if (!p) return;
    var /*safe*/pzcls = this.$s('pointer'),
      n = this.$n(),
      refn = ref.$n(),
      dir = this._dir,
      zkp = zk(p),
      pw = zkp.borderWidth(),
      ph = zkp.borderHeight(),
      nOffset = zk(n).revisedOffset(),
      refOffset = zk(refn).revisedOffset(),
      arrXOffset = (refn.offsetWidth - pw) / 2,
      arrYOffset = (refn.offsetHeight - ph) / 2;
    if (dir != 'n') {
      // positioning
      if (dir == 'u' || dir == 'd') {
        var b = dir == 'u',
          l1 = (n.offsetWidth - pw) / 2 || 0,
          l2 = refOffset[0] - nOffset[0] + arrXOffset || 0;
        p.style.left = (refn.offsetWidth >= n.offsetWidth ? l1 : l2) + 'px'; //ZK-1583: assign arrow position to reference widget if it is smaller than notification
        p.style[b ? 'top' : 'bottom'] = (2 - ph / 2 || 0) + 'px';
        p.style[b ? 'bottom' : 'top'] = '';
      } else {
        var b = dir == 'l',
          t1 = (n.offsetHeight - ph) / 2 || 0,
          t2 = refOffset[1] - nOffset[1] + arrYOffset || 0;
        p.style.top = (refn.offsetHeight >= n.offsetHeight ? t1 : t2) + 'px'; //ZK-1583: assign arrow position to reference widget if it is smaller than notification
        p.style[b ? 'left' : 'right'] = (2 - pw / 2 || 0) + 'px';
        p.style[b ? 'right' : 'left'] = '';
      }
      /*safe*/
      p.className = pzcls + (_dirMap[dir] ? ' ' + this.$s(_dirMap[dir]) : '');
      jq(p).show();
    } else {
      p.className = pzcls;
      jq(p).hide();
    }
  };
  /** @internal */
  Notification.prototype.openAnima_ = function (ref, offset, position, opts) {
    var self = this;
    jq(this.$n()).fadeIn(500, function () {
      self.afterOpenAnima_(ref, offset, position, opts);
    });
  };
  /** @internal */
  Notification.prototype.closeAnima_ = function (opts) {
    var self = this;
    jq(this.$n()).fadeOut(500, function () {
      self.afterCloseAnima_(opts);
    });
  };
  /** @internal */
  Notification.prototype.afterCloseAnima_ = function (opts) {
    if (opts && opts.keepVisible) {
      this.setVisible(false);
      this.setFloating_(false);
      if (opts.sendOnOpen) this.fire('onOpen', {
        open: false
      });
    } else {
      this.detach();
    }
  };
  /** @internal */
  Notification.prototype.getPositionArgs_ = function () {
    return [this._fakeParent, undefined, this._nftPos, undefined];
  };
  Notification.prototype.reposition = function () {
    _super.prototype.reposition.call(this);
    if (this._ref) this._fixarrow(this._ref);
  };
  /**
   * Shows a notification.
   * TODO
   */
  Notification.show = function (msg, pid, opts) {
    if (!opts) opts = {};
    var ref = opts.ref,
      pos = opts.pos,
      dur = opts.dur,
      ntf = new zul.wgt.Notification(msg, opts),
      off = opts.off,
      n,
      isInView = true;
    if (ref) {
      n = ref.$n('real') || ref.$n();
      isInView = zk(n).isRealScrollIntoView();
    }
    // TODO: allow user to specify arrow direction?
    //ZK-2687, don't show notification if wgt is not in view
    if (!isInView) return;
    if (!pos && !off) pos = ref ? 'end_center' : 'middle_center';
    jq(document.body).append(ntf);
    ntf._nftPos = pos;
    ntf.open(ref, off, pos);
    // auto dismiss
    if (dur > 0) setTimeout(function () {
      if (ntf.desktop) ntf.close();
    }, dur);
  };
  Notification = __decorate([zk.WrapClass('zul.wgt.Notification')], Notification);
  return Notification;
}(zul.wgt.Popup);
exports.Notification = Notification;
window.zul.wgt.Notification_._iconMap = _iconMap;
window.zul.wgt.Notification_._dirMap = _dirMap;
window.zul.wgt.Notification_.Notification = Notification;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Popup.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Popup.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Popup.ts

    Purpose:

    Description:

    History:
        Wed Dec 17 19:15:59     2008, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Popup_) window.zul.wgt.Popup_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Popup = void 0;
/**
 * A container that is displayed as a popup.
 * The popup window does not have any special frame.
 * Popups can be displayed when an element is clicked by assigning
 * the id of the popup to either the {@link setPopup},
 * {@link setContext} or {@link setTooltip} attribute of the element.
 *
 * @defaultValue {@link getZclass}: z-popup.
 */
var Popup = /** @class */function (_super) {
  __extends(Popup, _super);
  function Popup() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._visible = false;
    return _this;
  }
  /**
   * @returns whether the popup is visible.
   */
  Popup.prototype.isOpen = function () {
    return this.isVisible();
  };
  // a delegator for open() in stateless.
  Popup.prototype.setOpen = function (open) {
    var _this = this;
    if (this.desktop || this.z_rod) {
      this.open.apply(this, open);
    } else {
      zk.afterMount(function () {
        if (_this.desktop || _this.z_rod) {
          // just in case if removed.
          _this.open.apply(
          // just in case if removed.
          _this, open);
        }
      });
    }
    return this;
  };
  // a delegator for close() in stateless.
  Popup.prototype.setClose = function (close) {
    var _this = this;
    if (close != this.isOpen()) return this; // do nothing.
    if (this.desktop || this.z_rod) {
      this.close();
    } else {
      zk.afterMount(function () {
        if (_this.desktop || _this.z_rod) {
          _this.close();
        }
      });
    }
    return this;
  };
  /**
   * Opens the popup.
   * <p>Note: the ref with the position parameter is prior to the offset parameter,
   * if any.
   * @param ref - the referred widget or its uuid.
   * @param offset - the offset of x and y
   * @param position - Possible values for the position attribute are:
   * <ul>
   * 	<li><b>before_start</b><br/> the popup appears above the anchor, aligned to the left.</li>
   * 	<li><b>before_center</b><br/> the popup appears above the anchor, aligned to the center.</li>
   *  <li><b>before_end</b><br/> the popup appears above the anchor, aligned to the right.</li>
   *  <li><b>after_start</b><br/> the popup appears below the anchor, aligned to the left.</li>
   *  <li><b>after_center</b><br/> the popup appears below the anchor, aligned to the center.</li>
   *  <li><b>after_end</b><br/> the popup appears below the anchor, aligned to the right.</li>
   *  <li><b>start_before</b><br/> the popup appears to the left of the anchor, aligned to the top.</li>
   *  <li><b>start_center</b><br/> the popup appears to the left of the anchor, aligned to the middle.</li>
   *  <li><b>start_after</b><br/> the popup appears to the left of the anchor, aligned to the bottom.</li>
   *  <li><b>end_before</b><br/> the popup appears to the right of the anchor, aligned to the top.</li>
   *  <li><b>end_center</b><br/> the popup appears to the right of the anchor, aligned to the middle.</li>
   *  <li><b>end_after</b><br/> the popup appears to the right of the anchor, aligned to the bottom.</li>
   *  <li><b>overlap/top_left</b><br/> the popup overlaps the anchor, with anchor and popup aligned at top-left.</li>
   *  <li><b>top_center</b><br/> the popup overlaps the anchor, with anchor and popup aligned at top-center.</li>
   *  <li><b>overlap_end/top_right</b><br/> the popup overlaps the anchor, with anchor and popup aligned at top-right.</li>
   *  <li><b>middle_left</b><br/> the popup overlaps the anchor, with anchor and popup aligned at middle-left.</li>
   *  <li><b>middle_center</b><br/> the popup overlaps the anchor, with anchor and popup aligned at middle-center.</li>
   *  <li><b>middle_right</b><br/> the popup overlaps the anchor, with anchor and popup aligned at middle-right.</li>
   *  <li><b>overlap_before/bottom_left</b><br/> the popup overlaps the anchor, with anchor and popup aligned at bottom-left.</li>
   *  <li><b>bottom_center</b><br/> the popup overlaps the anchor, with anchor and popup aligned at bottom-center.</li>
   *  <li><b>overlap_after/bottom_right</b><br/> the popup overlaps the anchor, with anchor and popup aligned at bottom-right.</li>
   *  <li><b>at_pointer</b><br/> the popup appears with the upper-left aligned with the mouse cursor.</li>
   *  <li><b>after_pointer</b><br/> the popup appears with the top aligned with
   *  	the bottom of the mouse cursor, with the left side of the popup at the horizontal position of the mouse cursor.</li>
   * </ul>
   * @param opts - if opts.sendOnOpen exists, it will fire onOpen event. If opts.disableMask exists,
   *  it will show a disable mask. If opts.overflow exists, it allows the popup to appear
   *  out of the screen range. If opts.dodgeRef exists, it will avoid covering the reference
   *  element.
   */
  Popup.prototype.open = function (ref, offset, position, opts) {
    var _a;
    this._fakeParent = zk.$(ref);
    (_a = this._fakeParent) === null || _a === void 0 ? void 0 : _a.listen({
      'onUnbindNow': this.proxy(this._fakeParentOnUnbind)
    });
    var posInfo = this._posInfo(ref, offset, position),
      node = this.$n(),
      $n = jq(node);
    // the top is depend on children's height, if child will re-size after onSize/onShow,
    // popup need to re-position top after children height has calculated.
    // B50-ZK-391
    // should keep openInfo each time,
    // maybe have to reposition in onResponse if the child changed with onOpen event,
    if (arguments.length != 0)
      //do not update _openInfo when just call open()
      this._openInfo = arguments;
    //F70-ZK-2007: Check if it is toggle type.
    this._shallToggle = opts && opts.type == 'toggle';
    $n.css({
      position: 'absolute'
    }).zk.makeVParent();
    // F70-ZK-2007: Fire to all the widgets that listen onVParent.
    zWatch.fire('onVParent', this);
    if (posInfo) $n.zk.position(posInfo.dim, posInfo.pos, opts);
    this.setFloating_(true); // B50-ZK-280: setFloating_ first
    this.setTopmost();
    this.openAnima_(ref, offset, position, opts);
  };
  /**
   * The effect for opening the popup. Override this function to provide
   * opening effect. afterOpenAnima_ needs to be called after the effect.
   * @since 6.0.1
   * @internal
   */
  Popup.prototype.openAnima_ = function (ref, offset, position, opts) {
    this.afterOpenAnima_(ref, offset, position, opts);
  };
  /**
   * The handling after the opening effect of popup.
   * @since 6.0.1
   * @internal
   */
  Popup.prototype.afterOpenAnima_ = function (ref, _offset, _position, opts) {
    var node = this.$n(),
      sendOnOpen = opts && opts.sendOnOpen;
    // B85-ZK-3606: for adjusting popup position
    // B86-ZK-4030: because afterSize, in setVisible would use the this._adjustLeft property.
    ref = zk.Widget.$(ref); // just in case, if ref is not a kind of zul.Widget.
    this._adjustOffsets(ref);
    this.setVisible(true);
    if ((!opts || !opts.disableMask) && this.isListen('onOpen', {
      asapOnly: true
    })) {
      //Racing? Previous onResponse has not been fired and user triggers open again
      if (this.mask) this.mask.destroy();
      //ZK-2775, only trigger open() with doClick_ will set sendOnOpen to true
      if (sendOnOpen) {
        // use a progress bar to hide the popup
        this.mask = new zk.eff.Mask({
          id: this.uuid + '-mask',
          anchor: node
        });
        // register onResponse to remove the progress bar after receiving
        // the response from server.
        zWatch.listen({
          onResponse: this
        });
      }
    }
    // resync position if the content is not calculated. Bug ZK-2257
    var openInfo = this._openInfo;
    if (openInfo) {
      this.position.apply(this, openInfo);
      this._adjustOffsets(ref);
    }
    // B30-1819264 : should skip null
    if (this.shallStackup_() && node) {
      if (!this._stackup) this._stackup = jq.newStackup(node, node.id + '-stk');else {
        var dst = void 0,
          src = void 0;
        (dst = this._stackup.style).top = (src = node.style).top;
        dst.left = src.left;
        dst.zIndex = src.zIndex;
        dst.display = 'block';
      }
    }
    if (sendOnOpen) this.fire('onOpen', {
      open: true,
      reference: ref
    });
    //add extra CSS class for easy customize
    jq(node).addClass(this.$s('open'));
  };
  /** @internal */
  Popup.prototype._adjustOffsets = function (ref) {
    if (ref && ref.desktop && this.desktop) {
      var refDim = zk(ref).dimension(true),
        thisDim = zk(this).dimension(true);
      if (refDim && thisDim) {
        this._adjustLeft = thisDim.left - refDim.left;
        this._adjustTop = thisDim.top - refDim.top;
      }
      this._keepVisible = true;
    }
  };
  /**
   * @returns whether to instantiate a stackup when {@link open}
   * is called.
   * <p>If the derive class created its own stackup (such as creating
   * a shadow), it shall override this method to return false.
   * @internal
   */
  Popup.prototype.shallStackup_ = function () {
    return zk.eff.shallStackup();
  };
  /**
   * Sets the popup position.
   * <p>Note: the ref with the position parameter is prior to the offset parameter,
   * if any.
   * @param ref - the referred widget.
   * @param offset - the offset of x and y
   * @param position - Possible values for the position attribute refer to {@link open}.
   * @param opts - a map of addition options. Allowed values: refer to {@link zjq.position}.
   */
  Popup.prototype.position = function (ref, offset, position, opts) {
    var posInfo = this._posInfo(ref, offset, position);
    if (posInfo) zk(this.$n()).position(posInfo.dim, posInfo.pos, opts);
  };
  /**
   * Reset the position on scroll
   * @internal
   */
  Popup.prototype._onSyncScroll = function (evt) {
    if (evt && (!this._fakeParent || zUtl.isAncestor(evt.origin, this._fakeParent))) {
      if (this.isInView_()) {
        var args = this.getPositionArgs_();
        if (!this.isOpen() && this._keepVisible) {
          this.open.apply(this, args);
        } else {
          this.position.apply(this, args);
        }
      } else if (this.isOpen()) {
        this.close({
          keepVisible: true
        });
      }
    }
  };
  /** @internal */
  Popup.prototype._posInfo = function (ref, offset, position, _opts) {
    var pos, dim;
    if (position) {
      if (ref) {
        if (typeof ref == 'string') ref = zk.Widget.$(ref);
        if (ref) {
          var refn = ref instanceof zul.Widget ? ref.$n() : ref;
          // B65-ZK-1934: Make sure refn is not null
          if (refn) {
            pos = position;
            dim = zk(refn).dimension(true);
          } else return {
            pos: position
          };
        }
      } else return {
        pos: position
      };
    } else if (Array.isArray(offset)) {
      dim = {
        left: zk.parseInt(offset[0]),
        top: zk.parseInt(offset[1]),
        width: 0,
        height: 0
      };
    }
    if (dim) {
      // we should include margin in this case for customizing theme. (since ZK 7.0.0)
      var $n = zk(this.$n());
      dim.top += $n.sumStyles('t', jq.margins);
      dim.left += $n.sumStyles('l', jq.margins);
      return {
        pos: pos,
        dim: dim
      };
    }
  };
  Popup.prototype.onResponse = function () {
    if (this.mask) this.mask.destroy();
    // B50-ZK-391: Tooltip loses "position=after_end" positioning if onOpen eventlistener added to popup
    var openInfo = this._openInfo;
    if (openInfo) {
      this.position.apply(this, openInfo);
    }
    zWatch.unlisten({
      onResponse: this
    });
    this.mask = undefined;
  };
  /**
   * Closes this popup at the client.
   *
   * <p>In most cases, the popup is closed automatically when the user
   * clicks outside of the popup.
   * @param opts - if opts.sendOnOpen exists, it will fire onOpen event.
   */
  Popup.prototype.close = function (opts) {
    if (this._stackup) this._stackup.style.display = 'none';
    // F70-ZK-2007: Clear toggle type.
    this._shallToggle = false;
    try {
      //fix firefox, safari and ie issue
      if ((zk.ff || zk.safari) && zk.currentFocus) {
        // Bug ZK-2922, check ancestor first.
        var n = zk.currentFocus.getInputNode ? zk.currentFocus.getInputNode() : zk.currentFocus.$n();
        if (jq.nodeName(n, 'input')) {
          if ((zk.ff || zk.safari) && jq.isAncestor(this.$n(), n)) {
            jq(n).blur(); // trigger a missing blur event.
          }
        }
      }
    } catch (e) {
      zk.debugLog(e.message || e);
    }
    this.closeAnima_(opts); // Bug ZK-1124: should pass arguments to closeAnima_ function
    // remove visible flag
    if (!opts || !opts.keepVisible) {
      this._keepVisible = false;
      if (this._fakeParent) {
        this._fakeParent.unlisten({
          'onUnbindNow': this.proxy(this._fakeParentOnUnbind)
        });
      }
      this._fakeParent = undefined;
    }
  };
  /**
   * The effect for closing the popup. Override this function to provide
   * closing effect. afterCloseAnima_ needs to be called after the effect.
   * @since 6.0.1
   * @internal
   */
  Popup.prototype.closeAnima_ = function (opts) {
    this.afterCloseAnima_(opts);
  };
  /**
   * The handling after the closing effect of popup.
   * @since 6.0.1
   * @internal
   */
  Popup.prototype.afterCloseAnima_ = function (opts) {
    this.setVisible(false);
    var node = this.$n();
    zk(node).undoVParent();
    zWatch.fireDown('onVParent', this);
    this.setFloating_(false);
    if (opts && opts.sendOnOpen) this.fire('onOpen', {
      open: false
    });
    //remove extra CSS class
    jq(node).removeClass(this.$s('open'));
  };
  Popup.prototype.onFloatUp = function (ctl, opts) {
    this._keepVisible = false;
    if (!this.isVisible()) return;
    var openInfo = this._openInfo;
    // F70-ZK-2007: If popup belongs to widget's ascendant then return.
    if (this._shallToggle && openInfo && opts && (opts.triggerByClick === undefined || openInfo[3].which == opts.triggerByClick && zUtl.isAncestor(openInfo[0], ctl.origin))) {
      return;
    }
    this._doFloatUp(ctl);
  };
  /** @internal */
  Popup.prototype._fakeParentOnUnbind = function () {
    if (this._fakeParent) {
      this._fakeParent.unlisten({
        'onUnbindNow': this.proxy(this._fakeParentOnUnbind)
      });
    }
    this._fakeParent = undefined;
  };
  /** @internal */
  Popup.prototype._doFloatUp = function (ctl) {
    if (!this.isVisible()) return;
    var wgt = ctl.origin;
    for (var floatFound = false; wgt; wgt = wgt.parent) {
      if (wgt == this) {
        if (!floatFound) this.setTopmost();
        return;
      }
      if (wgt == this.parent && wgt.ignoreDescendantFloatUp_(this)) return;
      floatFound = floatFound || wgt.isFloating_();
    }
    this.close({
      sendOnOpen: true
    });
  };
  // ZK-2990: should also change the zIndex of the stackup of the widget
  /** @internal */
  Popup.prototype.setFloatZIndex_ = function (floatZIndex, zi) {
    _super.prototype.setFloatZIndex_.call(this, floatZIndex, zi);
    if (this._stackup) {
      this._stackup.style.zIndex = zi;
    }
  };
  /** @internal */
  Popup.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onFloatUp: this,
      onShow: this,
      afterSize: this,
      _onSyncScroll: this
    });
    this.setFloating_(true);
  };
  /** @internal */
  Popup.prototype.unbind_ = function (skipper, after, keepRod) {
    zk(this.$n()).undoVParent(); //Bug 3079480
    if (this._stackup) {
      jq(this._stackup).remove();
      this._stackup = undefined;
    }
    if (this._openInfo) this._openInfo = undefined;
    this._shallToggle = undefined;
    zWatch.unlisten({
      onFloatUp: this,
      onShow: this,
      afterSize: this,
      _onSyncScroll: this
    });
    this.setFloating_(false);
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Popup.prototype.afterSize = function () {
    this.reposition();
  };
  /**
   * Reposition popup
   * @since 8.0.3
   */
  Popup.prototype.reposition = function () {
    if (this._fakeParent) {
      // B85-ZK-3606: reposition based on the current position of the item
      this.position.apply(this, this.getPositionArgs_());
    } else {
      var openInfo = this._openInfo;
      //once opened
      if (openInfo) {
        //openInfo: ref, offset, position, opts
        var posInfo = this._posInfo(openInfo[0], openInfo[1], openInfo[2]);
        if (posInfo) jq(this.$n()).zk.position(posInfo.dim, posInfo.pos, openInfo[3]);
      }
    }
  };
  Popup.prototype.onShow = function (ctl) {
    //bug 3034505: call children's onShow to calculate the height first
    ctl.fire(this.firstChild);
    zk(this).redoCSS(-1, {
      'fixFontIcon': true
    });
  };
  Popup.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) zUtl.fireShown(this);
    return this;
  };
  Popup.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) zWatch.fireDown('onShow', this);
    return this;
  };
  /** @internal */
  Popup.prototype.prologHTML_ = function (_out) {
    // empty on purpose
  };
  /** @internal */
  Popup.prototype.epilogHTML_ = function (_out) {
    // empty on purpose
  };
  /** @internal */
  Popup.prototype.isInView_ = function () {
    return this._fakeParent ? zk(this._fakeParent).isRealScrollIntoView(true) : false;
  };
  /** @internal */
  Popup.prototype.getPositionArgs_ = function () {
    var p = this._fakeParent,
      dim = zk(p).dimension(true);
    return [p, [dim.left + this._adjustLeft, dim.top + this._adjustTop], undefined, {
      dodgeRef: false
    }];
  };
  Popup = __decorate([zk.WrapClass('zul.wgt.Popup')], Popup);
  return Popup;
}(zul.Widget);
exports.Popup = Popup;
window.zul.wgt.Popup_.Popup = Popup;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Progressmeter.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Progressmeter.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Progressmeter_) window.zul.wgt.Progressmeter_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Progressmeter = void 0;
/* Progressmeter.ts

    Purpose:

    Description:

    History:
        Thu May 14 10:17:24     2009, Created by kindalu

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A progress meter is a bar that indicates how much of a task has been completed.
 *
 * @defaultValue {@link getZclass}: z-progressmeter.
 */
var Progressmeter = /** @class */function (_super) {
  __extends(Progressmeter, _super);
  function Progressmeter() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._value = 0;
    /** @internal */
    _this._indeterminate = false;
    /** @internal */
    _this._indeterminateAnimation = false;
    return _this;
  }
  /**
   * @returns the current value of the progress meter.
   */
  Progressmeter.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets the current value of the progress meter.
   * <p>Range: 0~100.
   */
  Progressmeter.prototype.setValue = function (value, opts) {
    var o = this._value;
    this._value = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.$n()) this._fixImgWidth();
    }
    return this;
  };
  /**
   * @returns the indeterminate state of the progress meter.(default false)
   */
  Progressmeter.prototype.isIndeterminate = function () {
    return this._indeterminate;
  };
  /**
   * Sets the indeterminate state of the progress meter.
   */
  Progressmeter.prototype.setIndeterminate = function (indeterminate, opts) {
    var o = this._indeterminate;
    this._indeterminate = indeterminate;
    if (o !== indeterminate || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.$n()) {
        jq(this.$n()).toggleClass(this.$s('indeterminate'), indeterminate);
      }
    }
    return this;
  };
  /** @internal */
  Progressmeter.prototype._fixImgWidth = function () {
    var n = this.$n(),
      img = this.$n('img');
    if (img) {
      //B70-ZK-2453 remember to add brackets
      if (zk(n).isRealVisible() && !this._indeterminateAnimation) {
        //Bug 3134159
        var $img = jq(img);
        $img.animate({
          width: this._value + '%'
        }, {
          duration: $img.zk.getAnimationSpeed('slow'),
          queue: false,
          easing: 'linear'
        }); //ZK-4079: progressmeter animation not catching up with actual value
      }
    }
  };
  Progressmeter.prototype.onSize = function () {
    this._fixImgWidth();
  };
  /** @internal */
  Progressmeter.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._fixImgWidth();
    zWatch.listen({
      onSize: this
    });
  };
  /** @internal */
  Progressmeter.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Progressmeter.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    this._fixImgWidth();
    return this;
  };
  /** @internal */
  Progressmeter.prototype.domClass_ = function (no) {
    var sclsHTML = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      if (this._indeterminate) sclsHTML += ' ' + this.$s('indeterminate');
    }
    return sclsHTML;
  };
  Progressmeter = __decorate([zk.WrapClass('zul.wgt.Progressmeter')], Progressmeter);
  return Progressmeter;
}(zul.Widget);
exports.Progressmeter = Progressmeter;
window.zul.wgt.Progressmeter_.Progressmeter = Progressmeter;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Radio.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Radio.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Radio_) window.zul.wgt.Radio_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Radio = void 0;
/* Radio.ts

    Purpose:

    Description:

    History:
        Tue Dec 16 11:17:26     2008, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A radio button.
 *
 * <p>Radio buttons without an ancestor {@link Radiogroup} is considered
 * as the same group.
 * The nearest ancestor {@link Radiogroup} is the group that the radio
 * belongs to. See also {@link getRadiogroup}.
 *
 * <p>Event:
 * <ol>
 * <li>onCheck event is sent when a checkbox
 * is checked or unchecked by user.</li>
 * </ol>
 *
 */
var Radio = /** @class */function (_super) {
  __extends(Radio, _super);
  function Radio() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._attachExternal = undefined;
    return _this;
  }
  /**
   * @returns {@link Radiogroup} that this radio button belongs to.
   * It is the nearest ancestor {@link Radiogroup}.
   * In other words, it searches up the parent, parent's parent
   * and so on for any {@link Radiogroup} instance.
   * If found this radio belongs the found radiogroup.
   * If not, this radio itself is a group.
   */
  Radio.prototype.getRadiogroup = function (parent) {
    if (!parent && this._group) return this._group;
    var wgt = parent !== null && parent !== void 0 ? parent : this.parent;
    for (; wgt; wgt = wgt.parent) if (wgt instanceof zul.wgt.Radiogroup) return wgt;
    return undefined;
  };
  /**
   * Sets {@link Radiogroup} that this radio button belongs to.
   * The radio automatically belongs to the nearest ancestral radiogroup.
   * Use this method only if the radio group is not one of its ancestors.
   * @param radiogroup - the radio group, or null to dis-associate
   * @since 5.0.4
   */
  Radio.prototype.setRadiogroup = function (radiogroup) {
    var old = this._group;
    // for stateless to support set radiogroup by id
    if (typeof radiogroup == 'string') radiogroup = zk.$('$' + radiogroup);
    if (old !== radiogroup) {
      if (old && this._attachExternal) old._rmExtern(this);
      this._group = radiogroup;
      if (radiogroup && this.desktop) {
        radiogroup._addExtern(this);
        this._attachExternal = true;
      }
      this._fixName();
    }
    return this;
  };
  /** @internal */
  Radio.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this._group && this.desktop && !this._attachExternal) {
      this._group._addExtern(this);
      this._attachExternal = true;
    }
  };
  /** @internal */
  Radio.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this._group && this._attachExternal) {
      this._group._rmExtern(this);
      this._attachExternal = false;
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /**
   * Sets the radio is checked and unchecked the others in the same radio
   * group ({@link Radiogroup}
   * @returns Radio
   */
  Radio.prototype.setChecked = function (checked, opts) {
    if (checked != this._checked) {
      this._checked = checked;
      var n = this.$n('real');
      if (n) {
        n.checked = checked || false;
        checked ? jq(n).attr('checked', 'checked') : jq(n).removeAttr('checked');
        this.clearStateClassName_();
        jq(this.$n_()).addClass(this.getClassNameByState_());
        // Bug ZK-622
        if (!n.checked) jq(n).removeAttr('checked');
        var group = this.getRadiogroup();
        if (group) {
          // bug #1893575 : we have to clean all of the radio at the same group.
          if (checked) {
            for (var items = group.getItems(), i = items.length; i--;) {
              if (items[i] != this) {
                var item = items[i].$n('real');
                if (item) {
                  item.checked = false;
                  jq(item).removeAttr('checked');
                }
                items[i].clearStateClassName_();
                jq(items[i].$n_()).addClass(this.$s(this.getMoldPrefix_() + 'off'));
                items[i]._checked = false;
              }
            }
          }
          group._fixSelectedIndex();
        }
      }
    }
    return this;
  };
  /**
   * Sets whether it is selected.
   * <p>Don't override this. Override {@link setChecked} instead.
   * <p>The same as {@link setChecked}.
   */
  Radio.prototype.setSelected = function (selected, opts) {
    return this.setChecked(selected, opts);
  };
  /**
   * @returns whether it is selected.
   * @defaultValue `false`.
   * <p>Don't override this. Override {@link isChecked} instead.
   */
  Radio.prototype.isSelected = function () {
    return this.isChecked();
  };
  /**
   * @returns the name of this radio button.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * <p>It is readonly, and it is generated automatically
   * to be the same as its parent's name ({@link Radiogroup#getName}).
   */
  Radio.prototype.getName = function () {
    var group = this.getRadiogroup();
    return group != null ? group.getName() : this.uuid;
  };
  /** @internal */
  Radio.prototype._fixName = function () {
    var n = this.$n('real');
    if (n) n.name = this.getName();
  };
  /** @internal */
  Radio.prototype.beforeParentChanged_ = function (newParent) {
    var oldGroup = this.getRadiogroup(),
      newGroup = newParent ? this.getRadiogroup(newParent) : undefined;
    if (oldGroup != newGroup || !newParent) {
      if (oldGroup && oldGroup instanceof zul.wgt.Radiogroup) {
        oldGroup._fixOnRemove(this);
        if (this._attachExternal) {
          oldGroup._rmExtern(this);
          this._attachExternal = false;
        }
      }
      if (newGroup && newGroup instanceof zul.wgt.Radiogroup) {
        if (!this._attachExternal && newGroup == this._group) {
          newGroup._addExtern(this);
          this._attachExternal = true;
        }
        newGroup._fixOnAdd(this);
      }
    }
    _super.prototype.beforeParentChanged_.call(this, newParent);
  };
  /** @internal */
  Radio.prototype.fireOnCheck_ = function (checked) {
    // if Radiogroup listens to onCheck, we shall fire the event too.
    var group = this.getRadiogroup();
    this.fire('onCheck', checked);
    // send event to group at client instead of server side. in ZK 10 for stateless
    if (group) {
      group.fire('onCheck', checked);
    }
  };
  Radio = __decorate([zk.WrapClass('zul.wgt.Radio')], Radio);
  return Radio;
}(zul.wgt.Checkbox);
exports.Radio = Radio;
window.zul.wgt.Radio_.Radio = Radio;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Radiogroup.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Radiogroup.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Radiogroup_) window.zul.wgt.Radiogroup_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Radiogroup = void 0;
/* Radiogroup.ts

    Purpose:

    Description:

    History:
        Wed Dec 17 09:25:17     2008, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.wgt.Radiogroup_._concatItem = function (group) {
  var sum = window.zul.wgt.Radiogroup_._concatItem0(group);
  sum.$addAll(group._externs);
  return sum;
};
window.zul.wgt.Radiogroup_._concatItem0 = function (cmp) {
  var sum = [];
  for (var wgt = cmp.firstChild; wgt; wgt = wgt.nextSibling) {
    if (wgt instanceof zul.wgt.Radio) sum.push(wgt);else if (!(wgt instanceof zul.wgt.Radiogroup))
      //skip nested radiogroup
      sum = sum.concat(window.zul.wgt.Radiogroup_._concatItem0(wgt));
  }
  return sum;
};
window.zul.wgt.Radiogroup_._getAt = function (group, cur, index) {
  var r = window.zul.wgt.Radiogroup_._getAt0(group, cur, index);
  if (!r) for (var extns = group._externs, j = 0, l = extns.length; j < l; ++j) if (!window.zul.wgt.Radiogroup_._redudant(group, extns[j]) && cur.value++ == index) return extns[j];
  return r;
};
window.zul.wgt.Radiogroup_._getAt0 = function (cmp, cur, index) {
  for (var wgt = cmp.firstChild; wgt; wgt = wgt.nextSibling) {
    if (wgt instanceof zul.wgt.Radio) {
      if (cur.value++ == index) return wgt;
    } else if (!(wgt instanceof zul.wgt.Radiogroup)) {
      var r = window.zul.wgt.Radiogroup_._getAt0(wgt, cur, index);
      if (r != null) return r;
    }
  }
};
window.zul.wgt.Radiogroup_._fixSelIndex = function (group, cur) {
  var jsel = window.zul.wgt.Radiogroup_._fixSelIndex0(group, cur);
  if (jsel < 0) for (var extns = group._externs, j = 0, l = extns.length; j < l; ++j) {
    var radio = extns[j];
    if (!window.zul.wgt.Radiogroup_._redudant(group, radio)) {
      if (radio.isSelected()) return cur.value;
      ++cur.value;
    }
  }
  return jsel;
};
window.zul.wgt.Radiogroup_._fixSelIndex0 = function (cmp, cur) {
  for (var wgt = cmp.firstChild; wgt; wgt = wgt.nextSibling) {
    if (wgt instanceof zul.wgt.Radio) {
      if (wgt.isSelected()) return cur.value;
      ++cur.value;
    } else if (!(wgt instanceof zul.wgt.Radiogroup)) {
      var jsel = window.zul.wgt.Radiogroup_._fixSelIndex0(wgt, cur);
      if (jsel >= 0) return jsel;
    }
  }
  return -1;
};
window.zul.wgt.Radiogroup_._redudant = function (group, radio) {
  for (var p = radio.parent; p != null; p = p.parent) if (p instanceof zul.wgt.Radiogroup) return p == group;
  return false;
};
/**
 * A radio group.
 *
 * <p>Note: To support the versatile layout, a radio group accepts any kind of
 * children, including {@link Radio}. On the other hand, the parent of
 * a radio, if any, must be a radio group.
 *
 */
var Radiogroup = /** @class */function (_super) {
  __extends(Radiogroup, _super);
  function Radiogroup() {
    var _this = _super.call(this) || this; // FIXME: params?
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._jsel = -1;
    _this._externs = [];
    return _this;
  }
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Radiogroup.prototype.getOrient = function () {
    return this._orient;
  };
  Radiogroup.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the name of this group of radio buttons.
   * All child radio buttons shared the same name ({@link Radio#getName}).
   * @defaultValue automatically generated an unique name
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   */
  Radiogroup.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this group of radio buttons.
   * All child radio buttons shared the same name ({@link Radio#getName}).
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   */
  Radiogroup.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      for (var items = this.getItems(), i = items.length; i--;) items[i].setName(name);
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   * @since 10.0.0
   */
  Radiogroup.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.getItems().forEach(function (r) {
        if (r.desktop) {
          r.setDisabled(disabled);
        }
      });
    }
    return this;
  };
  /**
   * Sets whether to disable all radios.
   * @defaultValue `false`.
   * @since 10.0.0
   */
  Radiogroup.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * @returns the radio button at the specified index.
   */
  Radiogroup.prototype.getItemAtIndex = function (index) {
    return index >= 0 ? window.zul.wgt.Radiogroup_._getAt(this, {
      value: 0
    }, index) : undefined;
  };
  /**
   * @returns (int) the number of radio buttons in this group.
   */
  Radiogroup.prototype.getItemCount = function () {
    return this.getItems().length;
  };
  /**
   * @returns the all of radio buttons in this group.
   */
  Radiogroup.prototype.getItems = function () {
    return window.zul.wgt.Radiogroup_._concatItem(this);
  };
  /**
   * @returns (int) the index of the selected radio button (-1 if no one is selected).
   */
  Radiogroup.prototype.getSelectedIndex = function () {
    return this._jsel;
  };
  /**
   * Deselects all the currently selected radio button and selects
   * the radio button with the given index.
   */
  Radiogroup.prototype.setSelectedIndex = function (selectedIndex) {
    if (selectedIndex < 0) selectedIndex = -1;
    if (this._jsel != selectedIndex) {
      if (this.desktop) {
        if (selectedIndex < 0) {
          this.getSelectedItem().setSelected(false);
        } else {
          this.getItemAtIndex(selectedIndex).setSelected(true);
        }
      }
      this._jsel = selectedIndex;
    }
    return this;
  };
  /**
   * @returns the selected radio button.
   */
  Radiogroup.prototype.getSelectedItem = function () {
    return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : undefined;
  };
  /**
   * Deselects all of the currently selected radio buttons and selects
   * the given radio button.
   */
  Radiogroup.prototype.setSelectedItem = function (selectedItem) {
    if (selectedItem == null) this.setSelectedIndex(-1);else if (selectedItem instanceof zul.wgt.Radio) selectedItem.setSelected(true);
    return this;
  };
  Radiogroup.prototype.appendItem = function (label, value) {
    var item = new zul.wgt.Radio();
    item.setLabel(label);
    item.setValue(value);
    this.appendChild(item);
    return item;
  };
  /**
   * Removes the child radio button in the list box at the given index.
   * @returns Radio the removed radio button.
   */
  Radiogroup.prototype.removeItemAt = function (index) {
    var item = this.getItemAtIndex(index);
    if (item && !this._rmExtern(item)) {
      var p = item.parent;
      if (p) p.removeChild(item);
    }
    return item;
  };
  /** @internal */
  Radiogroup.prototype._fixSelectedIndex = function () {
    this._jsel = window.zul.wgt.Radiogroup_._fixSelIndex(this, {
      value: 0
    });
  };
  /** @internal */
  Radiogroup.prototype._fixOnAdd = function (child) {
    if (this._jsel >= 0 && child.isSelected() && this.getItemAtIndex(this._jsel) != child) {
      child.setSelected(false); //it will call _fixSelectedIndex()
    } else {
      this._fixSelectedIndex();
    }
    // handle this disabled state for stateless.
    if (this.isDisabled()) {
      child.setDisabled(true);
    }
  };
  /** @internal */
  Radiogroup.prototype._fixOnRemove = function (child) {
    if (child.isSelected()) {
      this._jsel = -1;
    } else if (this._jsel > 0) {
      //excluding 0
      this._fixSelectedIndex();
    }
  };
  /** @internal */
  Radiogroup.prototype._addExtern = function (radio) {
    this._externs.push(radio);
    if (!window.zul.wgt.Radiogroup_._redudant(this, radio)) this._fixOnAdd(radio);
  };
  /** @internal */
  Radiogroup.prototype._rmExtern = function (radio) {
    if (this._externs.$remove(radio)) {
      if (!window.zul.wgt.Radiogroup_._redudant(this, radio)) this._fixOnRemove(radio);
      return true;
    }
    return false;
  };
  // ZK-4989
  /** @internal */
  Radiogroup.prototype.domClass_ = function (no) {
    var sclsHTML = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      var added = this.$s(this.getOrient());
      if (added) sclsHTML += (sclsHTML ? ' ' : '') + /*safe*/added;
    }
    return sclsHTML;
  };
  /** @internal */
  Radiogroup.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this.listen({
      onCheck: this
    });
  };
  /** @internal */
  Radiogroup.prototype.unbind_ = function (skipper, after, keepRod) {
    this.unlisten({
      onCheck: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Radiogroup.prototype.onCheck = function (evt) {
    this._fixSelectedIndex();
  };
  Radiogroup = __decorate([zk.WrapClass('zul.wgt.Radiogroup')], Radiogroup);
  return Radiogroup;
}(zul.Widget);
exports.Radiogroup = Radiogroup;
window.zul.wgt.Radiogroup_.Radiogroup = Radiogroup;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Rating.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Rating.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Rating.ts

    Purpose:

    Description:

    History:
        Thu Jul 12 10:24:21 CST 2018, Created by wenninghsu

Copyright (C) 2018 Potix Corporation. All Rights Reserved.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Rating_) window.zul.wgt.Rating_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Rating = void 0;
/**
 * An icon based rating component.
 *
 * @author wenninghsu
 * @since 8.6.0
 */
var Rating = /** @class */function (_super) {
  __extends(Rating, _super);
  function Rating() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._rating = 0;
    /** @internal */
    _this._cancelable = true;
    /** @internal */
    _this._max = 5;
    /** @internal */
    _this._disabled = false;
    /** @internal */
    _this._iconSclass = 'z-icon-star';
    return _this;
  }
  /**
   * Sets the iconSclass.
   */
  Rating.prototype.setIconSclass = function (iconSclass, opts) {
    var o = this._iconSclass;
    this._iconSclass = iconSclass;
    if (o !== iconSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this.rerender();
      }
    }
    return this;
  };
  /**
   * @returns the iconSclass.
   */
  Rating.prototype.getIconSclass = function () {
    return this._iconSclass;
  };
  /**
   * Sets the rating.
   */
  Rating.prototype.setRating = function (rating, opts) {
    var o = this._rating;
    this._rating = rating;
    if (o !== rating || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this._toggleClass('selected', rating);
      }
    }
    return this;
  };
  /**
   * @returns the rating.
   */
  Rating.prototype.getRating = function () {
    return this._rating;
  };
  /**
   * Sets whether this widget is disabled
   */
  Rating.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        jq(this).children().toggleClass(this.$s('disabled'), disabled);
      }
    }
    return this;
  };
  /**
   * @returns whether this widget is disabled
   */
  Rating.prototype.isDisabled = function () {
    return this._disabled;
  };
  /**
   * Sets whether this widget is readonly
   */
  Rating.prototype.setReadonly = function (readonly, opts) {
    var o = this._readonly;
    this._readonly = readonly;
    if (o !== readonly || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        jq(this).children().toggleClass(this.$s('readonly'), readonly);
      }
    }
    return this;
  };
  /**
   * @returns whether this widget is readonly
   */
  Rating.prototype.isReadonly = function () {
    return !!this._readonly;
  };
  /** @internal */
  Rating.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var wgt = this,
      isVertical = 'vertical' == wgt._orient;
    jq(wgt).children().each(function (i) {
      jq(this).data('rate', isVertical ? wgt._max - i : i + 1);
      wgt.domListen_(this, 'onMouseOver', '_doMouseOver').domListen_(this, 'onMouseOut', '_doMouseOut');
    });
  };
  /** @internal */
  Rating.prototype.unbind_ = function (skipper, after, keepRod) {
    var wgt = this;
    jq(wgt).children().each(function () {
      wgt.domUnlisten_(this, 'onMouseOver', '_doMouseOver').domUnlisten_(this, 'onMouseOut', '_doMouseOut');
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Rating.prototype.domClass_ = function (no) {
    var scHTML = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      scHTML += ' ' + this.$s(zUtl.encodeXML(this._orient));
    }
    return scHTML;
  };
  /** @internal */
  Rating.prototype.doSelect_ = function (evt) {
    if (this._disabled || this._readonly) return;
    this._changeRating(evt);
  };
  /** @internal */
  Rating.prototype._changeRating = function (evt) {
    var rating = jq(evt.domTarget).data('rate'),
      isCanceling = this._cancelable && this._rating == rating;
    jq(this).children().removeClass(this.$s('hover'));
    this.setRating(isCanceling ? 0 : rating);
    this.fire('onChange', {
      rating: this._rating
    });
  };
  /** @internal */
  Rating.prototype._doMouseOver = function (evt) {
    if (this._disabled || this._readonly) return;
    this._toggleClass('hover', jq(evt.domTarget).data('rate'));
  };
  /** @internal */
  Rating.prototype._doMouseOut = function (evt) {
    if (this._disabled || this._readonly) return;
    jq(this).children().removeClass(this.$s('hover'));
  };
  /** @internal */
  Rating.prototype._toggleClass = function (name, rate) {
    var wgt = this;
    jq(wgt).children().each(function () {
      var jqCh = jq(this);
      jqCh.toggleClass(wgt.$s(name), jqCh.data('rate') <= rate);
    });
  };
  Rating = __decorate([zk.WrapClass('zul.wgt.Rating')], Rating);
  return Rating;
}(zul.Widget);
exports.Rating = Rating;
window.zul.wgt.Rating_.Rating = Rating;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Selectbox.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Selectbox.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Selectbox_) window.zul.wgt.Selectbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Selectbox = void 0;
/* Selectbox.ts

    Purpose:

    Description:

    History:
        Fri Sep 30 10:51:52 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A light weight dropdown list.
 * @defaultValue {@link getZclass}: z-selectbox.
 * @author jumperchen
 * @since 6.0.0
 */
var Selectbox = /** @class */function (_super) {
  __extends(Selectbox, _super);
  function Selectbox() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the index of the selected item (-1 if no one is selected).
   */
  Selectbox.prototype.getSelectedIndex = function () {
    return this._selectedIndex;
  };
  /**
   * Selects the item with the given index.
   */
  Selectbox.prototype.setSelectedIndex = function (selectedIndex, opts) {
    var o = this._selectedIndex;
    this._selectedIndex = selectedIndex;
    if (o !== selectedIndex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.selectedIndex = selectedIndex;
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * <p>
   * @defaultValue `false`.
   */
  Selectbox.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Selectbox.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.disabled = disabled;
    }
    return this;
  };
  /**
   * @returns whether it is multiple selections.
   * @defaultValue `false`.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.isMultiple = function () {
    return !!this._multiple;
  };
  /**
   * Sets whether multiple selections are allowed.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.setMultiple = function (multiple, opts) {
    var o = this._multiple;
    this._multiple = multiple;
    if (o !== multiple || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.multiple = multiple;
    }
    return this;
  };
  /**
   * @returns the maximal length of each item's label.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maximal length of each option's label.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.setMaxlength = function (maxlength, opts) {
    var o = this._maxlength;
    this._maxlength = maxlength;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns all the selected indexes or null if no selections.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.getSelectedIndexes = function () {
    return this._selectedIndexes;
  };
  /**
   * Sets all the selected indexes.
   * @since 10.0.0 for Stateless
   */
  Selectbox.prototype.setSelectedIndexes = function (selectedIndexes, opts) {
    var _this = this;
    function doSelection(node, selectedIndexes) {
      node.selectedIndex = -1; // deselected all options
      var options = node.options,
        n = options.length;
      for (var _i = 0, selectedIndexes_1 = selectedIndexes; _i < selectedIndexes_1.length; _i++) {
        var i = selectedIndexes_1[_i];
        if (i < n) {
          options[i].selected = true;
        }
      }
    }
    var o = this._selectedIndexes;
    this._selectedIndexes = selectedIndexes;
    if (o !== selectedIndexes || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!this.isMultiple()) return this;
      if (this.desktop) {
        doSelection(this.$n_(), selectedIndexes);
      } else {
        zk.afterMount(function () {
          return doSelection(_this.$n_(), selectedIndexes);
        });
      }
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   */
  Selectbox.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this component.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   *
   * @param name - the name of this component.
   */
  Selectbox.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.name = name;
    }
    return this;
  };
  /** @internal */
  Selectbox.prototype._fixSelIndex = function () {
    if (this._selectedIndex < 0) this.$n_().selectedIndex = -1;
  };
  /** @internal */
  Selectbox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n_();
    this.domListen_(n, 'onChange').domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_');
    if (!zk.gecko) {
      var fn = [this, this._fixSelIndex];
      zWatch.listen({
        onRestore: fn,
        onVParent: fn
      });
    }
    this._fixSelIndex();
  };
  /** @internal */
  Selectbox.prototype.unbind_ = function (skipper, after, keepRod) {
    var n = this.$n_();
    this.domUnlisten_(n, 'onChange').domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
    var fn = [this, this._fixSelIndex];
    zWatch.unlisten({
      onRestore: fn,
      onVParent: fn
    });
  };
  /** @internal */
  Selectbox.prototype._doChange = function (evt) {
    var n = this.$n_();
    if (!this._multiple) {
      var v = n.selectedIndex;
      if (zk.opera) n.selectedIndex = v; //ZK-396: opera displays it wrong (while it is actually -1)
      if (this._selectedIndex == v) return;
      this.setSelectedIndex(n.selectedIndex);
      this.fire('onSelect', n.selectedIndex);
    } else {
      var n_1 = this.$n_(),
        opts = n_1.options,
        selIndexes = [],
        oldSelIndexes = this.getSelectedIndexes();
      for (var j = 0, ol = opts.length; j < ol; ++j) {
        var opt = opts[j];
        if (opt.selected) {
          selIndexes.push(j);
        }
      }
      selIndexes.sort(function (a, b) {
        return a - b;
      });
      oldSelIndexes.sort(function (a, b) {
        return a - b;
      });
      if (JSON.stringify(selIndexes) == JSON.stringify(oldSelIndexes)) return;
      this._selectedIndexes = selIndexes;
      this.fire('onSelect', selIndexes);
    }
  };
  //Bug 3304408: IE does not fire onchange
  /** @internal */
  Selectbox.prototype.doBlur_ = function (evt) {
    this._doChange(evt);
    return _super.prototype.doBlur_.call(this, evt);
  };
  //Bug 1756559: ctrl key shall fore it to be sent first
  /** @internal */
  Selectbox.prototype.beforeCtrlKeys_ = function (evt) {
    this._doChange(evt);
  };
  /** @internal */
  Selectbox.prototype.domAttrs_ = function (no) {
    var index = this.getSelectedIndex(),
      name = this.getName();
    return _super.prototype.domAttrs_.call(this, no) + (this.isDisabled() ? ' disabled="disabled"' : '') + (index > -1 ? " selectedIndex=\"".concat(index, "\"") : '') + (name ? ' name="' + name + '"' : '') + (this._multiple ? ' multiple="multiple" style="height: auto; padding: 0;"' : '');
  };
  Selectbox = __decorate([zk.WrapClass('zul.wgt.Selectbox')], Selectbox);
  return Selectbox;
}(zul.Widget);
exports.Selectbox = Selectbox;
window.zul.wgt.Selectbox_.Selectbox = Selectbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Separator.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Separator.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Separator.ts

    Purpose:

    Description:

    History:
        Wed Nov  5 16:58:56     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Separator_) window.zul.wgt.Separator_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Separator = void 0;
window.zul.wgt.Separator_._shallFixPercent = function (wgt) {
  var _a;
  return !!(zk.gecko && ((_a = wgt._spacing) === null || _a === void 0 ? void 0 : _a.endsWith('%')));
};
/**
 * A separator.
 * @defaultValue {@link getZclass} is "z-separator".
 */
var Separator = /** @class */function (_super) {
  __extends(Separator, _super);
  function Separator() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._bar = false;
    return _this;
  }
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Separator.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @param orient - either "horizontal" or "vertical".
   */
  Separator.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomClass_();
    }
    return this;
  };
  /**
   * @returns whether to display a visual bar as the separator.
   * @defaultValue `false`
   */
  Separator.prototype.isBar = function () {
    return this._bar;
  };
  /**
   * Sets  whether to display a visual bar as the separator.
   */
  Separator.prototype.setBar = function (bar, opts) {
    var o = this._bar;
    this._bar = bar;
    if (o !== bar || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomClass_();
    }
    return this;
  };
  /**
   * @returns the spacing.
   * @defaultValue `null` (depending on CSS).
   */
  Separator.prototype.getSpacing = function () {
    return this._spacing;
  };
  /**
   * Sets the spacing.
   * @param spacing - the spacing (such as "0", "5px", "3pt" or "1em")
   */
  Separator.prototype.setSpacing = function (spacing, opts) {
    var o = this._spacing;
    this._spacing = spacing;
    if (o !== spacing || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomStyle_();
    }
    return this;
  };
  /**
   * @returns whether it is a vertical separator.
   */
  Separator.prototype.isVertical = function () {
    return this._orient == 'vertical';
  };
  /** @internal */
  Separator.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
  };
  Separator.prototype.getZclass = function () {
    return 'z-separator';
  };
  /** @internal */
  Separator.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no),
      bar = this.isBar();
    if (!no || !no.zclass) {
      sc += ' ' + this.$s(this.isVertical() ? 'vertical' + (bar ? '-bar' : '') : 'horizontal' + (bar ? '-bar' : ''));
    }
    return sc;
  };
  /** @internal */
  Separator.prototype.domStyle_ = function (no) {
    var /*safe*/s = _super.prototype.domStyle_.call(this, no);
    if (!window.zul.wgt.Separator_._shallFixPercent(this)) return s;
    //_spacing contains %
    var space = this._spacing,
      v = zk.parseInt(space.substring(0, space.length - 1).trim());
    if (v <= 0) return s;
    var percent = "".concat(v >= 2 ? v / 2 : 1, "%");
    return 'margin:' + (this.isVertical() ? '0 ' + percent : percent + ' 0') + ';' + s;
  };
  Separator.prototype.getWidth = function () {
    var wd = _super.prototype.getWidth.call(this);
    return !this.isVertical() || wd != null && wd.length > 0 || window.zul.wgt.Separator_._shallFixPercent(this) ? wd : this._spacing;
  };
  Separator.prototype.getHeight = function () {
    var hgh = _super.prototype.getHeight.call(this);
    return this.isVertical() || hgh != null && hgh.length > 0 || window.zul.wgt.Separator_._shallFixPercent(this) ? hgh : this._spacing;
  };
  Separator = __decorate([zk.WrapClass('zul.wgt.Separator')], Separator);
  return Separator;
}(zul.Widget);
exports.Separator = Separator;
window.zul.wgt.Separator_.Separator = Separator;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Space.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Space.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Space_) window.zul.wgt.Space_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Space = void 0;
/* Space.js

    Purpose:

    Description:

    History:
        Mon Nov 17 09:33:07     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Space is a {@link Separator} with the orient default to "vertical".
 */
var Space = /** @class */function (_super) {
  __extends(Space, _super);
  function Space() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'vertical';
    return _this;
  }
  Space = __decorate([zk.WrapClass('zul.wgt.Space')], Space);
  return Space;
}(zul.wgt.Separator);
exports.Space = Space;
window.zul.wgt.Space_.Space = Space;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Span.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Span.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Span_) window.zul.wgt.Span_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Span = void 0;
/* Span.js

    Purpose:

    Description:

    History:
        Fri Mar 27 15:19:16     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The same as HTML SPAN tag.
 */
var Span = /** @class */function (_super) {
  __extends(Span, _super);
  function Span() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Span = __decorate([zk.WrapClass('zul.wgt.Span')], Span);
  return Span;
}(zul.Widget);
exports.Span = Span;
window.zul.wgt.Span_.Span = Span;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Toolbar.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Toolbar.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Toolbar.ts

    Purpose:

    Description:

    History:
        Sat Dec 24 12:58:43	 2008, Created by Flyworld

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Toolbar_) window.zul.wgt.Toolbar_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Toolbar = void 0;
/**
 * A toolbar.
 *
 * <p>Mold:
 * <ol>
 * <li>default</li>
 * <li>panel: this mold is used for {@link zul.wnd.Panel} component as its
 * foot toolbar.</li>
 * </ol>
 * @defaultValue {@link getZclass}: z-toolbar
 */
var Toolbar = /** @class */function (_super) {
  __extends(Toolbar, _super);
  function Toolbar() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._align = 'start';
    /** @internal */
    _this._overflowPopupIconSclass = 'z-icon-ellipsis-h';
    return _this;
  }
  /**
   * @returns the alignment of any children added to this toolbar. Valid values
   * are "start", "end" and "center".
   * @defaultValue `"start"`
   */
  Toolbar.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the alignment of any children added to this toolbar. Valid values
   * are "start", "end" and "center".
   * @defaultValue `"start"`, if null, "start" is assumed.
   */
  Toolbar.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Toolbar.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @param orient - either "horizontal" or "vertical".
   */
  Toolbar.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether toolbar has a button that shows a popup
   * which contains those content weren't able to fit in the toolbar.
   * If overflowPopup is false, toolbar will display multiple rows when content is wider than toolbar.
   * @defaultValue `false`.
   * @since 8.6.0
   */
  Toolbar.prototype.isOverflowPopup = function () {
    return !!this._overflowPopup;
  };
  /**
   * Set whether toolbar has a button that shows a popup
   * which contains those content weren't able to fit in the toolbar.
   * If overflowPopup is false, toolbar will display multiple rows when content is wider than toolbar.
   *
   * @param overflowPopup - whether toolbar has a button that shows a popup
   * @since 8.6.0
   */
  Toolbar.prototype.setOverflowPopup = function (overflowPopup, opts) {
    var o = this._overflowPopup;
    this._overflowPopup = overflowPopup;
    if (o !== overflowPopup || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the overflow sclass name of overflow popup icon of this toolbar.
   * @defaultValue `"z-icon-ellipsis-h"`.
   * @since 9.6.0
   */
  Toolbar.prototype.getOverflowPopupIconSclass = function () {
    return this._overflowPopupIconSclass;
  };
  /**
   * Sets the overflow sclass name of overflow popup icon of this toolbar.
   * When overflowPopup is true, toolbar has a button that shows a popup
   * users can customize the overflow popup icon.
   * @param overflowPopupIconSclass - the overflow sclass name of overflow popup icon of this toolbar
   * @since 9.6.0
   */
  Toolbar.prototype.setOverflowPopupIconSclass = function (overflowPopupIconSclass, opts) {
    var o = this._overflowPopupIconSclass;
    this._overflowPopupIconSclass = overflowPopupIconSclass;
    if (o !== overflowPopupIconSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var icon = this.$n('overflowpopup-button');
      if (this.desktop && icon) icon.className = this._getOverflowPopupBtnClass();
    }
    return this;
  };
  /** @internal */
  Toolbar.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this.isOverflowPopup()) {
      zWatch.listen({
        onFloatUp: this,
        onCommandReady: this,
        onSize: this
      });
      this.domListen_(this.$n_('overflowpopup-button'), 'onClick', '_openPopup');
    }
  };
  /** @internal */
  Toolbar.prototype.unbind_ = function (skipper, after, keepRod) {
    var popup = this.$n('pp');
    if (popup) {
      this.domUnlisten_(this.$n_('overflowpopup-button'), 'onClick', '_openPopup');
      zWatch.unlisten({
        onFloatUp: this,
        onCommandReady: this,
        onSize: this
      });
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Toolbar.prototype._getOverflowPopupBtnClass = function () {
    return this.$s('overflowpopup-button') + ' ' + this.getOverflowPopupIconSclass() + ' z-icon-fw';
  };
  /** @internal */
  Toolbar.prototype._openPopup = function (evt) {
    if (this._open) return;
    this._open = true;
    var popup = this.$n_('pp');
    this.setFloating_(true, {
      node: popup
    });
    zWatch.fire('onFloatUp', this);
    var topZIndex = this.setTopmost();
    popup.style.zIndex = String(topZIndex > 0 ? topZIndex : 1);
    jq(popup).removeClass(this.$s('popup-close')).addClass(this.$s('popup-open')).zk.makeVParent();
    this._syncPopupPosition();
  };
  /** @internal */
  Toolbar.prototype._syncPopupPosition = function () {
    zk(this.$n('pp')).position(this.$n_(), 'after_end');
  };
  Toolbar.prototype.onFloatUp = function (ctl) {
    if (!zUtl.isAncestor(this, ctl.origin)) this._closePopup();
  };
  /** @internal */
  Toolbar.prototype._closePopup = function () {
    if (!this._open) return;
    this._open = false;
    var jqPopup = jq(this.$n_('pp'));
    jqPopup.removeClass(this.$s('popup-open')).addClass(this.$s('popup-close')).zk.undoVParent();
    this.setFloating_(false);
  };
  Toolbar.prototype.onCommandReady = function () {
    if (this.desktop && this.isOverflowPopup()) this._adjustContent();
  };
  Toolbar.prototype.onSize = function () {
    _super.prototype.onSize.call(this);
    if (this.desktop && this.isOverflowPopup()) {
      this._adjustContent();
      if (this._open) this._syncPopupPosition();
    }
  };
  /** @internal */
  Toolbar.prototype._adjustContent = function () {
    if (zUtl.isImageLoading()) {
      setTimeout(this.proxy(this._adjustContent), 20);
      return;
    }
    var jqToolbar = jq(this),
      contentWidth = jqToolbar.width() - jq(this.$n_('overflowpopup-button')).width(),
      popup = this.$n_('pp'),
      cave = this.$n_('cave'),
      oldToolbarChildren = jq(cave).children().toArray(),
      oldPopupChildren = jq(popup).children().toArray(),
      children = oldToolbarChildren.concat(oldPopupChildren),
      childrenAmount = children.length;
    var tempChildrenWidth = 0,
      newPopupChildrenAmount = 0;
    // Calculate width to decide how many children should be displayed on popup.
    for (var i = 0; i < childrenAmount; i++) {
      tempChildrenWidth += jq(children[i]).outerWidth(true);
      if (tempChildrenWidth >= contentWidth) {
        newPopupChildrenAmount = childrenAmount - i;
        break;
      }
    }
    var popupChildrenDiff = newPopupChildrenAmount - oldPopupChildren.length;
    if (!popupChildrenDiff) return;
    // Start to move children
    var overflowpopupOn = this.$s('overflowpopup-on'),
      overflowpopupOff = this.$s('overflowpopup-off');
    if (newPopupChildrenAmount) {
      jqToolbar.removeClass(overflowpopupOff).addClass(overflowpopupOn);
      if (popupChildrenDiff > 0) {
        for (var i = 0; i < popupChildrenDiff; i++) popup.insertBefore(oldToolbarChildren.pop(), popup.children[0]);
      } else {
        for (var i = 0; i < -popupChildrenDiff; i++) cave.appendChild(oldPopupChildren.shift());
      }
    } else {
      jqToolbar.removeClass(overflowpopupOn).addClass(overflowpopupOff);
      if (this._open) this._closePopup();
      while (oldPopupChildren.length) cave.appendChild(oldPopupChildren.shift());
    }
  };
  // super
  /** @internal */
  Toolbar.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no);
    if (!(no === null || no === void 0 ? void 0 : no.zclass)) {
      var tabs = this.parent && zk.isLoaded('zul.tab') && this.parent instanceof zul.tab.Tabbox ? this.$s('tabs') : '';
      if (tabs) sc += ' ' + tabs;
      if (this.inPanelMold()) sc += ' ' + this.$s('panel');
      if ('vertical' == this.getOrient()) sc += ' ' + this.$s('vertical');
      if (this.isOverflowPopup()) sc += ' ' + this.$s('overflowpopup') + ' ' + this.$s('overflowpopup-off');
    }
    return sc;
  };
  // Bug ZK-1706 issue: we have to expand the width of the content div when
  // align="left", others won't support
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Toolbar.prototype.setFlexSizeW_ = function (flexSizeW, zkn, width, isFlexMin) {
    _super.prototype.setFlexSizeW_.call(this, flexSizeW, zkn, width, isFlexMin);
    if (!isFlexMin && this.getAlign() == 'start') {
      var cave = this.$n('cave');
      if (cave) cave.style.width = jq.px0(zk(this.$n()).contentWidth());
    }
  };
  /**
   * @returns whether is in panel mold or not.
   */
  Toolbar.prototype.inPanelMold = function () {
    return this._mold == 'panel';
  };
  Toolbar.prototype.appendChild = function (child, ignoreDom) {
    _super.prototype.appendChild.call(this, child, ignoreDom);
    var popup = this.$n('pp');
    if (popup && popup.children.length > 0) popup.appendChild(child.$n_());
    return false;
  };
  Toolbar.prototype.removeChild = function (child, ignoreDom) {
    var popupNode = this.$n('pp'),
      childNode = child.$n();
    if (popupNode && childNode) {
      var childOnPopup = childNode.parentNode == popupNode;
      if (childOnPopup && popupNode.children.length == 1) {
        jq(this.$n_()).removeClass(this.$s('overflowpopup-on')).addClass(this.$s('overflowpopup-off'));
        this._closePopup(); // should close popup if overflowpopup turns off
      }
    }
    _super.prototype.removeChild.call(this, child, ignoreDom);
    return false;
  };
  // protected
  /** @internal */
  Toolbar.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.inPanelMold()) this.rerender();
  };
  /** @internal */
  Toolbar.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (!this.childReplacing_ && this.inPanelMold()) this.rerender();
  };
  Toolbar = __decorate([zk.WrapClass('zul.wgt.Toolbar')], Toolbar);
  return Toolbar;
}(zul.Widget);
exports.Toolbar = Toolbar;
window.zul.wgt.Toolbar_.Toolbar = Toolbar;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/Toolbarbutton.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/Toolbarbutton.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wgt) window.zul.wgt = {};
if (!window.zul.wgt.Toolbarbutton_) window.zul.wgt.Toolbarbutton_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Toolbarbutton = void 0;
/* Toolbarbutton.ts

    Purpose:

    Description:

    History:
        Sat Dec 22 12:58:43	 2008, Created by Flyworld

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.wgt.Toolbarbutton_._initUpld = function (wgt) {
  zWatch.listen({
    onSize: wgt
  });
  var v = wgt._upload;
  if (v) wgt._uplder = new zul.Upload(wgt, undefined, v);
};
window.zul.wgt.Toolbarbutton_._cleanUpld = function (wgt) {
  var v = wgt._uplder;
  if (v) {
    zWatch.unlisten({
      onSize: wgt
    });
    wgt._uplder = undefined;
    v.destroy();
  }
};
/**
 * A toolbar button.
 *
 * <p>Non-xul extension: Toolbarbutton supports {@link getHref}. If {@link getHref}
 * is not null, the onClick handler is ignored and this element is degenerated
 * to HTML's A tag.
 *
 * @defaultValue {@link getZclass}: z-toolbarbutton.
 */
var Toolbarbutton = /** @class */function (_super) {
  __extends(Toolbarbutton, _super);
  function Toolbarbutton() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._dir = 'normal';
    /** @internal */
    _this._mode = 'default';
    /** @internal */
    _this._checked = false;
    /** @internal */
    _this._tabindex = 0;
    return _this;
  }
  /**
   * @returns the mode.
   */
  Toolbarbutton.prototype.getMode = function () {
    return this._mode;
  };
  /**
   * Sets the mode. (default/toggle)
   */
  Toolbarbutton.prototype.setMode = function (mode, opts) {
    var o = this._mode;
    this._mode = mode;
    if (o !== mode || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether it is checked. (Note:It's only available in toggle mode.)
   * @defaultValue `false`.
   */
  Toolbarbutton.prototype.isChecked = function () {
    return this._checked;
  };
  /**
   * Sets whether it is checked. (Note:It's only available in toggle mode.)
   */
  Toolbarbutton.prototype.setChecked = function (checked, opts) {
    var o = this._checked;
    this._checked = checked;
    if (o !== checked || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop && this._mode == 'toggle') jq(this.$n_())[checked ? 'addClass' : 'removeClass'](this.$s('checked'));
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Toolbarbutton.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Toolbarbutton.prototype.setDisabled = function (disabled, opts) {
    var _this = this;
    var o = this._disabled;
    // eslint-disable-next-line zk/preferStrictBooleanType
    var value = disabled;
    //B60-ZK-1176
    // Autodisable should not re-enable when setDisabled(true) is called during onClick
    if (opts === null || opts === void 0 ? void 0 : opts.adbs)
      // called from zul.wgt.ADBS.autodisable
      this._adbs = true; // Start autodisabling
    else if (!opts || opts.adbs === undefined)
      // called somewhere else (including server-side)
      this._adbs = false; // Stop autodisabling
    if (!value) {
      if (this._adbs)
        // autodisable is still active, enable allowed
        this._adbs = false;
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
      else if (opts && opts.adbs === false)
        // ignore re-enable by autodisable mechanism
        value = this._disabled;
    }
    this._disabled = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var doDisable = function () {
        if (_this.desktop) {
          jq(_this.$n_()).attr('disabled', value ? 'disabled' : null); // use jQuery's attr() instead of dom.disabled for non-button element. Bug ZK-2146
          if (_this._upload) value ? window.zul.wgt.Toolbarbutton_._cleanUpld(_this) : window.zul.wgt.Toolbarbutton_._initUpld(_this);
        }
      };
      if (this._type == 'submit') setTimeout(doDisable, 50);else doDisable();
    }
    return this;
  };
  /**
   * @returns the href that the browser shall jump to, if an user clicks
   * this button.
   * @defaultValue `null`. If null, the button has no function unless you
   * specify the onClick event listener.
   * <p>If it is not null, the onClick event won't be sent.
   */
  Toolbarbutton.prototype.getHref = function () {
    return this._href;
  };
  /**
   * Sets the href.
   */
  Toolbarbutton.prototype.setHref = function (href) {
    this._href = href;
    return this;
  };
  /**
   * @returns the target frame or window.
   *
   * <p>Note: it is useful only if href ({@link setHref}) is specified
   * (i.e., use the onClick listener).
   *
   * @defaultValue `null`.
   */
  Toolbarbutton.prototype.getTarget = function () {
    return this._target;
  };
  /**
   * Sets the target frame or window.
   * @param target - the name of the frame or window to hyperlink.
   */
  Toolbarbutton.prototype.setTarget = function (target) {
    this._target = target;
    return this;
  };
  /**
   * @returns the direction.
   * @defaultValue `"normal"`.
   */
  Toolbarbutton.prototype.getDir = function () {
    return this._dir;
  };
  /**
   * Sets the direction.
   * @param dir - either "normal" or "reverse".
   */
  Toolbarbutton.prototype.setDir = function (dir, opts) {
    var o = this._dir;
    this._dir = dir;
    if (o !== dir || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Toolbarbutton.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @param orient - either "horizontal" or "vertical".
   */
  Toolbarbutton.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns a list of component IDs that shall be disabled when the user
   * clicks this button.
   *
   * <p>To represent the button itself, the developer can specify `self`.
   * For example,
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('self,cancel');
   * ```
   * is the same as
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('ok,cancel');
   * ```
   * that will disable
   * both the ok and cancel buttons when an user clicks it.
   *
   * <p>The button being disabled will be enabled automatically
   * once the client receives a response from the server.
   * In other words, the server doesn't notice if a button is disabled
   * with this method.
   *
   * <p>However, if you prefer to enable them later manually, you can
   * prefix with '+'. For example,
   * ```ts
   * button.setId('ok');
   * wgt.setAutodisable('+self,+cancel');
   * ```
   *
   * <p>Then, you have to enable them manually such as
   * ```ts
   * if (something_happened) {
   *  ok.setDisabled(false);
   *  cancel.setDisabled(false);
   * }
   *```
   *
   * @defaultValue `null`.
   */
  Toolbarbutton.prototype.getAutodisable = function () {
    return this._autodisable;
  };
  /**
   * Sets whether to disable the button after the user clicks it.
   */
  Toolbarbutton.prototype.setAutodisable = function (autodisable) {
    this._autodisable = autodisable;
    return this;
  };
  /**
   * @returns non-null if this button is used for file upload, or null otherwise.
   * Refer to {@link setUpload} for more details.
   */
  Toolbarbutton.prototype.getUpload = function () {
    return this._upload;
  };
  /**
   * Sets the JavaScript class at the client to handle the upload if this
   * button is used for file upload.
   * @defaultValue `null`.
   *
   * <p>For example, the following example declares a button for file upload:
   * ```ts
   * button.setLabel('Upload');
   * button.setUpload('true');
   * ```
   *
   * <p>If you want to customize the handling of the file upload at
   * the client, you can specify a JavaScript class when calling
   * this method:
   * `button.setUpload('foo.Upload');`
   *
   * <p> Another options for the upload can be specified as follows:
   * ```ts
   * button.setUpload('true,maxsize=-1,native');
   * ```
   *  <ul>
   *  <li>maxsize: the maximal allowed upload size of the component, in kilobytes, or
   * a negative value if no limit.</li>
   *  <li>native: treating the uploaded file(s) as binary, i.e., not to convert it to
   * image, audio or text files.</li>
   *  </ul>
   *
   * @param upload - a JavaScript class to handle the file upload
   * at the client, or "true" if the default class is used,
   * or null or "false" to disable the file download (and then
   * this button behaves like a normal button).
   */
  Toolbarbutton.prototype.setUpload = function (upload, opts) {
    var o = this._upload;
    this._upload = upload;
    if (o !== upload || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        window.zul.wgt.Toolbarbutton_._cleanUpld(this);
        if (upload && upload != 'false' && !this._disabled) window.zul.wgt.Toolbarbutton_._initUpld(this);
      }
    }
    return this;
  };
  Toolbarbutton.prototype.getTextNode = function () {
    return this.$n('cnt');
  };
  /** @internal */
  Toolbarbutton.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (!this._disabled) {
      var n = this.$n_();
      this.domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_');
    }
    if (!this._disabled && this._upload) window.zul.wgt.Toolbarbutton_._initUpld(this);
  };
  /** @internal */
  Toolbarbutton.prototype.unbind_ = function (skipper, after, keepRod) {
    window.zul.wgt.Toolbarbutton_._cleanUpld(this);
    var n = this.$n_();
    this.domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Toolbarbutton.prototype.domContent_ = function () {
    var labelHTML = zUtl.encodeXML(this.getLabel()),
      imgHTML = this.domImage_(),
      iconSclassHTML = this.domIcon_();
    if (!imgHTML && !iconSclassHTML) return labelHTML;
    if (!imgHTML) imgHTML = iconSclassHTML;else imgHTML += iconSclassHTML ? ' ' + iconSclassHTML : '';
    // B50-ZK-640: toolbarbutton with no label will display larger width blur box
    var spaceHTML = labelHTML ? 'vertical' == this.getOrient() ? '<br/>' : '&nbsp;' : '';
    return this.getDir() == 'reverse' ? labelHTML + spaceHTML + imgHTML : imgHTML + spaceHTML + labelHTML;
  };
  /** @internal */
  Toolbarbutton.prototype.domClass_ = function (no) {
    var sclsHTML = _super.prototype.domClass_.call(this, no),
      zclsHTML = this.getZclass(),
      nozcls = !no || !no.zclass;
    if (this._mode == 'toggle' && this._checked && nozcls && zclsHTML) {
      sclsHTML += ' ' + this.$s('checked');
    }
    return sclsHTML;
  };
  /** @internal */
  Toolbarbutton.prototype.domAttrs_ = function (no) {
    var attrHTML = _super.prototype.domAttrs_.call(this, no);
    if (this._disabled) attrHTML += ' disabled="disabled"';
    return attrHTML;
  };
  Toolbarbutton.prototype.onSize = function () {
    if (this._uplder) this._uplder.sync();
  };
  /** @internal */
  Toolbarbutton.prototype.doClick_ = function (evt, popupOnly) {
    if (!this._disabled) {
      this.fireX(evt);
      if (!this._upload) zul.wgt.ADBS.autodisable(this);else this._uplder.openFileDialog();
      if (!evt.stopped) {
        var href = this._href,
          isMailTo = href ? href.toLowerCase().startsWith('mailto:') : false;
        if (href) {
          // ZK-2506: use iframe to open a 'mailto' href
          if (isMailTo) {
            var ifrm = jq.newFrame('mailtoFrame', href, undefined);
            jq(ifrm).remove();
          } else {
            zUtl.go(href, {
              target: this._target || (evt.data.ctrlKey ? '_blank' : '')
            });
          }
        }
        _super.prototype.doClick_.call(this, evt, true);
        if (this._mode == 'toggle') {
          this.setChecked(!this.isChecked());
          this.fire('onCheck', this.isChecked());
        }
      }
    }
  };
  /** @internal */
  Toolbarbutton.prototype.focus_ = function (timeout) {
    var _this = this;
    if (this._tabindex != undefined || this._href || this._upload) {
      var n_1 = this.$n_();
      zk.afterAnimate(function () {
        try {
          n_1.focus();
          zk.currentFocus = _this;
          zjq.fixInput(n_1);
        } catch (e) {
          zk.debugLog(e.message || e);
        }
      }, timeout);
      return true;
    }
    return false;
  };
  Toolbarbutton = __decorate([zk.WrapClass('zul.wgt.Toolbarbutton')], Toolbarbutton);
  return Toolbarbutton;
}(zul.LabelImageWidget);
exports.Toolbarbutton = Toolbarbutton;
window.zul.wgt.Toolbarbutton_.Toolbarbutton = Toolbarbutton;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wgt/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wgt/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./ButtonRenderer */ "./zul/src/main/resources/web/js/zul/wgt/ButtonRenderer.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./A */ "./zul/src/main/resources/web/js/zul/wgt/A.ts"), exports);
__exportStar(__webpack_require__(/*! ./Cell */ "./zul/src/main/resources/web/js/zul/wgt/Cell.ts"), exports);
__exportStar(__webpack_require__(/*! ./Div */ "./zul/src/main/resources/web/js/zul/wgt/Div.ts"), exports);
__exportStar(__webpack_require__(/*! ./Span */ "./zul/src/main/resources/web/js/zul/wgt/Span.ts"), exports);
__exportStar(__webpack_require__(/*! ./Idspace */ "./zul/src/main/resources/web/js/zul/wgt/Idspace.ts"), exports);
__exportStar(__webpack_require__(/*! ./Include */ "./zul/src/main/resources/web/js/zul/wgt/Include.ts"), exports);
__exportStar(__webpack_require__(/*! ./Label */ "./zul/src/main/resources/web/js/zul/wgt/Label.ts"), exports);
__exportStar(__webpack_require__(/*! ./Button */ "./zul/src/main/resources/web/js/zul/wgt/Button.ts"), exports);
__exportStar(__webpack_require__(/*! ./Separator */ "./zul/src/main/resources/web/js/zul/wgt/Separator.ts"), exports);
__exportStar(__webpack_require__(/*! ./Space */ "./zul/src/main/resources/web/js/zul/wgt/Space.ts"), exports);
__exportStar(__webpack_require__(/*! ./Caption */ "./zul/src/main/resources/web/js/zul/wgt/Caption.ts"), exports);
__exportStar(__webpack_require__(/*! ./Checkbox */ "./zul/src/main/resources/web/js/zul/wgt/Checkbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Groupbox */ "./zul/src/main/resources/web/js/zul/wgt/Groupbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Html */ "./zul/src/main/resources/web/js/zul/wgt/Html.ts"), exports);
__exportStar(__webpack_require__(/*! ./Popup */ "./zul/src/main/resources/web/js/zul/wgt/Popup.ts"), exports);
__exportStar(__webpack_require__(/*! ./Radio */ "./zul/src/main/resources/web/js/zul/wgt/Radio.ts"), exports);
__exportStar(__webpack_require__(/*! ./Radiogroup */ "./zul/src/main/resources/web/js/zul/wgt/Radiogroup.ts"), exports);
__exportStar(__webpack_require__(/*! ./Toolbar */ "./zul/src/main/resources/web/js/zul/wgt/Toolbar.ts"), exports);
__exportStar(__webpack_require__(/*! ./Toolbarbutton */ "./zul/src/main/resources/web/js/zul/wgt/Toolbarbutton.ts"), exports);
__exportStar(__webpack_require__(/*! ./Nodom */ "./zul/src/main/resources/web/js/zul/wgt/Nodom.ts"), exports);
__exportStar(__webpack_require__(/*! ./Image */ "./zul/src/main/resources/web/js/zul/wgt/Image.ts"), exports);
__exportStar(__webpack_require__(/*! ./Imagemap */ "./zul/src/main/resources/web/js/zul/wgt/Imagemap.ts"), exports);
__exportStar(__webpack_require__(/*! ./Area */ "./zul/src/main/resources/web/js/zul/wgt/Area.ts"), exports);
__exportStar(__webpack_require__(/*! ./Chart */ "./zul/src/main/resources/web/js/zul/wgt/Chart.ts"), exports);
__exportStar(__webpack_require__(/*! ./Captcha */ "./zul/src/main/resources/web/js/zul/wgt/Captcha.ts"), exports);
__exportStar(__webpack_require__(/*! ./Progressmeter */ "./zul/src/main/resources/web/js/zul/wgt/Progressmeter.ts"), exports);
__exportStar(__webpack_require__(/*! ./Fileupload */ "./zul/src/main/resources/web/js/zul/wgt/Fileupload.ts"), exports);
__exportStar(__webpack_require__(/*! ./Combobutton */ "./zul/src/main/resources/web/js/zul/wgt/Combobutton.ts"), exports);
__exportStar(__webpack_require__(/*! ./Selectbox */ "./zul/src/main/resources/web/js/zul/wgt/Selectbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Notification */ "./zul/src/main/resources/web/js/zul/wgt/Notification.ts"), exports);
__exportStar(__webpack_require__(/*! ./Rating */ "./zul/src/main/resources/web/js/zul/wgt/Rating.ts"), exports);
__exportStar(__webpack_require__(/*! ./Inputgroup */ "./zul/src/main/resources/web/js/zul/wgt/Inputgroup.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/wgt/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;