/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.AbstractSimpleDateTimeConstraint;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.impl.FormatInputElement;

public abstract class DateTimeFormatInputElement
extends FormatInputElement {
    protected Locale _locale;
    protected TimeZone _tzone = TimeZones.getCurrent();
    private static Map<String, PropertyAccess> _properties = new HashMap<String, PropertyAccess>(5);
    private static final Map<String, String> _javaSystemVOldTimeZoneMappings;
    private static final Pattern _gmtWholeHourPositive;
    private static final Pattern _gmtWholeHourNegative;

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals((Object)this._locale, (Object)locale)) {
            this._locale = locale;
            this.invalidate();
        }
    }

    public void setLocale(String locale) {
        this.setLocale(locale != null && locale.length() > 0 ? Locales.getLocale((String)locale) : null);
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        if (this._tzone != tzone) {
            this._tzone = tzone;
            Constraint cst = this.getConstraint();
            if (cst instanceof AbstractSimpleDateTimeConstraint) {
                ((AbstractSimpleDateTimeConstraint)cst).setTimeZone(this._tzone);
            }
            this.smartUpdate("timeZone", this.getFormattedTimeZone());
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    public void setTimeZone(String id) {
        this.setTimeZone(TimeZone.getTimeZone(id));
    }

    protected ZoneId getZoneId() {
        return Optional.ofNullable(this.getTimeZone()).map(TimeZone::toZoneId).orElse(ZoneId.systemDefault());
    }

    @Override
    public void setConstraint(Constraint constr) {
        if (constr instanceof AbstractSimpleDateTimeConstraint) {
            ((AbstractSimpleDateTimeConstraint)constr).setTimeZone(this._tzone);
        }
        super.setConstraint(constr);
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getTargetValue();
    }

    public void setValue(Date value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public ZonedDateTime getValueInZonedDateTime() throws WrongValueException {
        return this.toZonedDateTime((Date)this.getTargetValue());
    }

    public void setValueInZonedDateTime(ZonedDateTime value) throws WrongValueException {
        if (value != null) {
            this.setTimeZone(TimeZone.getTimeZone(value.getZone()));
        }
        this.setValue(value == null ? null : Date.from(value.toInstant()));
    }

    public LocalDateTime getValueInLocalDateTime() throws WrongValueException {
        ZonedDateTime value = this.getValueInZonedDateTime();
        return value == null ? null : value.toLocalDateTime();
    }

    public void setValueInLocalDateTime(LocalDateTime value) throws WrongValueException {
        this.setValue(this.toDate(value));
    }

    public LocalDate getValueInLocalDate() throws WrongValueException {
        ZonedDateTime value = this.getValueInZonedDateTime();
        return value == null ? null : value.toLocalDate();
    }

    public void setValueInLocalDate(LocalDate value) throws WrongValueException {
        this.setValue(this.toDate(value));
    }

    public LocalTime getValueInLocalTime() throws WrongValueException {
        ZonedDateTime value = this.getValueInZonedDateTime();
        return value == null ? null : value.toLocalTime();
    }

    public void setValueInLocalTime(LocalTime value) throws WrongValueException {
        this.setValue(this.toDate(value));
    }

    protected ZonedDateTime toZonedDateTime(Date value) {
        return value == null ? null : ZonedDateTime.ofInstant(value.toInstant(), this.getZoneId());
    }

    protected Date toDate(LocalDateTime value) {
        return value == null ? null : Date.from(value.atZone(this.getZoneId()).toInstant());
    }

    protected Date toDate(LocalDate value) {
        return value == null ? null : this.toDate(value.atStartOfDay());
    }

    protected Date toDate(LocalTime value) {
        Date rawValue = (Date)this.getRawValue();
        return value == null ? null : this.toDate(value.atDate(rawValue == null ? LocalDate.now(this.getZoneId()) : this.toZonedDateTime(rawValue).toLocalDate()));
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._tzone != null) {
            renderer.render("timeZone", this.getFormattedTimeZone());
        }
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    private String getFormattedTimeZone() {
        Object zoneID = this._tzone.toZoneId().getId();
        if (_javaSystemVOldTimeZoneMappings.containsKey(zoneID)) {
            zoneID = _javaSystemVOldTimeZoneMappings.get(zoneID);
        } else if (_gmtWholeHourPositive.matcher((CharSequence)zoneID).matches()) {
            zoneID = "Etc/GMT-" + Integer.parseInt(((String)zoneID).substring(4, 6));
        } else if (_gmtWholeHourNegative.matcher((CharSequence)zoneID).matches()) {
            zoneID = "Etc/GMT+" + Integer.parseInt(((String)zoneID).substring(4, 6));
        }
        return zoneID;
    }

    static {
        _properties.put("value", (PropertyAccess)new PropertyAccess<Date>(){

            public void setValue(Component cmp, Date value) {
                ((DateTimeFormatInputElement)cmp).setValue(value);
            }

            public Class<Date> getType() {
                return Date.class;
            }

            public Date getValue(Component cmp) {
                return ((DateTimeFormatInputElement)cmp).getValue();
            }
        });
        _properties.put("valueInZonedDateTime", (PropertyAccess)new PropertyAccess<ZonedDateTime>(){

            public void setValue(Component cmp, ZonedDateTime val) {
                ((DateTimeFormatInputElement)cmp).setValueInZonedDateTime(val);
            }

            public Class<ZonedDateTime> getType() {
                return ZonedDateTime.class;
            }

            public ZonedDateTime getValue(Component cmp) {
                return ((DateTimeFormatInputElement)cmp).getValueInZonedDateTime();
            }
        });
        _properties.put("valueInLocalDateTime", (PropertyAccess)new PropertyAccess<LocalDateTime>(){

            public void setValue(Component cmp, LocalDateTime val) {
                ((DateTimeFormatInputElement)cmp).setValueInLocalDateTime(val);
            }

            public Class<LocalDateTime> getType() {
                return LocalDateTime.class;
            }

            public LocalDateTime getValue(Component cmp) {
                return ((DateTimeFormatInputElement)cmp).getValueInLocalDateTime();
            }
        });
        _properties.put("valueInLocalDate", (PropertyAccess)new PropertyAccess<LocalDate>(){

            public void setValue(Component cmp, LocalDate val) {
                ((DateTimeFormatInputElement)cmp).setValueInLocalDate(val);
            }

            public Class<LocalDate> getType() {
                return LocalDate.class;
            }

            public LocalDate getValue(Component cmp) {
                return ((DateTimeFormatInputElement)cmp).getValueInLocalDate();
            }
        });
        _properties.put("valueInLocalTime", (PropertyAccess)new PropertyAccess<LocalTime>(){

            public void setValue(Component cmp, LocalTime val) {
                ((DateTimeFormatInputElement)cmp).setValueInLocalTime(val);
            }

            public Class<LocalTime> getType() {
                return LocalTime.class;
            }

            public LocalTime getValue(Component cmp) {
                return ((DateTimeFormatInputElement)cmp).getValueInLocalTime();
            }
        });
        _javaSystemVOldTimeZoneMappings = new HashMap<String, String>(Map.ofEntries(Map.entry("SystemV/AST4", "America/Puerto_Rico"), Map.entry("SystemV/AST4ADT", "America/Puerto_Rico"), Map.entry("SystemV/EST5", "America/New_York"), Map.entry("SystemV/EST5EDT", "America/New_York"), Map.entry("SystemV/CST6", "America/Chicago"), Map.entry("SystemV/CST6CDT", "America/Chicago"), Map.entry("SystemV/MST7", "America/Denver"), Map.entry("SystemV/MST7MDT", "America/Denver"), Map.entry("SystemV/PST8", "America/Los_Angeles"), Map.entry("SystemV/PST8PDT", "America/Los_Angeles"), Map.entry("SystemV/YST9", "America/Anchorage"), Map.entry("SystemV/YST9YDT", "America/Anchorage"), Map.entry("SystemV/HST10", "Pacific/Honolulu")));
        _gmtWholeHourPositive = Pattern.compile("^GMT\\+(0\\d|1[0-2]):00$", 2);
        _gmtWholeHourNegative = Pattern.compile("^GMT-(0\\d|1[0-4]):00$", 2);
    }
}

