/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ArrayComparator;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemComparator;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.impl.Utils;

public class Treecol
extends HeaderElement {
    private static final long serialVersionUID = 20110131122933L;
    private String _sortDir = "natural";
    private transient Comparator<?> _sortAsc;
    private transient Comparator<?> _sortDsc;
    private String _sortAscNm = "none";
    private String _sortDscNm = "none";
    private int _maxlength;
    private boolean _ignoreSort = false;
    private boolean _isCustomAscComparator = false;
    private boolean _isCustomDscComparator = false;

    public Treecol() {
    }

    public Treecol(String label) {
        super(label);
    }

    public Treecol(String label, String src) {
        super(label, src);
    }

    public Treecol(String label, String src, String width) {
        super(label, src);
        this.setWidth(width);
    }

    public Tree getTree() {
        Component comp = this.getParent();
        return comp != null ? (Tree)comp.getParent() : null;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            Tree tree;
            this._sortDir = sortDir;
            if (!"natural".equals(sortDir) && !this._ignoreSort && (tree = this.getTree()) != null && tree.isAutosort()) {
                this.doSort("ascending".equals(sortDir));
            }
            this.smartUpdate("sortDirection", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (type == null) {
            return;
        }
        if (type.startsWith("client")) {
            try {
                this.setSortAscending(type);
                this.setSortDescending(type);
                return;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        } else if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new TreeitemComparator(this, true, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new TreeitemComparator(this, false, true));
            return;
        } else if (!Strings.isBlank((String)type) && type.startsWith("auto")) {
            char cc;
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String name = type.substring(j + 1, k);
            int index = -1;
            if (name.length() > 0 && (cc = name.charAt(0)) >= '0' && cc <= '9' && (index = Integer.parseInt(name)) < 0) {
                throw new IllegalArgumentException("Nonnegative number is required: " + name);
            }
            if (this.getSortAscending() == null || !this._isCustomAscComparator) {
                if (index < 0) {
                    this.setSortAscending(new FieldComparator(name, true));
                } else {
                    this.setSortAscending(new ArrayComparator(index, true));
                }
                this._isCustomAscComparator = false;
            }
            if (this.getSortDescending() != null && this._isCustomDscComparator) return;
            if (index < 0) {
                this.setSortDescending(new FieldComparator(name, false));
            } else {
                this.setSortDescending(new ArrayComparator(index, false));
            }
            this._isCustomDscComparator = false;
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator<?> getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator<?> sorter) {
        if (!Objects.equals(this._sortAsc, sorter)) {
            String nm;
            this._sortAsc = sorter;
            this._isCustomAscComparator = this._sortAsc != null;
            String string = nm = this._isCustomAscComparator ? "fromServer" : "none";
            if (!this._sortAscNm.equals(nm)) {
                this._sortAscNm = nm;
                this.smartUpdate("sortAscending", this._sortAscNm);
            }
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortAscNm.equals(clsnm)) {
            this._sortAscNm = clsnm;
            this.smartUpdate("sortAscending", clsnm);
        } else {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public Comparator<?> getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator<?> sorter) {
        if (!Objects.equals(this._sortDsc, sorter)) {
            String nm;
            this._sortDsc = sorter;
            this._isCustomDscComparator = this._sortDsc != null;
            String string = nm = this._isCustomDscComparator ? "fromServer" : "none";
            if (!this._sortDscNm.equals(nm)) {
                this._sortDscNm = nm;
                this.smartUpdate("sortDescending", this._sortDscNm);
            }
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm) && clsnm.startsWith("client") && !this._sortDscNm.equals(clsnm)) {
            this._sortDscNm = clsnm;
            this.smartUpdate("sortDescending", clsnm);
        } else {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private Comparator<?> toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public boolean sort(boolean ascending) {
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        return this.doSort(ascending);
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSort(boolean ascending) {
        Comparator<?> cmpr;
        Comparator<?> comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Tree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            int activePg;
            TreeModel model = tree.getModel();
            boolean isPagingMold = tree.inPagingMold();
            int n = activePg = isPagingMold ? tree.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (!(model instanceof Sortable)) {
                    throw new UiException(String.valueOf(Sortable.class) + " must be implemented in " + model.getClass().getName());
                }
                ((Sortable)((Object)model)).sort(cmpr, ascending);
            } else {
                Treecol.sort0(tree.getTreechildren(), cmpr);
            }
            if (isPagingMold) {
                tree.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        this._ignoreSort = true;
        Iterator it = tree.getTreecols().getChildren().iterator();
        while (it.hasNext()) {
            Treecol col;
            col.setSortDirection((col = (Treecol)((Object)it.next())) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        this._ignoreSort = false;
        tree.invalidate();
        return true;
    }

    private static void sort0(Treechildren treechildren, Comparator cmpr) {
        if (treechildren == null) {
            return;
        }
        Components.sort((List)treechildren.getChildren(), (Comparator)cmpr);
        for (Treeitem item : treechildren.getChildren()) {
            Treecol.sort0(item.getTreechildren(), cmpr);
        }
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-treecol" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"none".equals(this._sortDscNm)) {
            this.render(renderer, "sortDescending", this._sortDscNm);
        }
        if (!"none".equals(this._sortAscNm)) {
            this.render(renderer, "sortAscending", this._sortAscNm);
        }
        if (!"natural".equals(this._sortDir)) {
            this.render(renderer, "sortDirection", this._sortDir);
        }
        if (this._maxlength > 0) {
            renderer.render("maxlength", this._maxlength);
        }
        Utils.renderCrawlableText(this.getLabel());
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Treecols)) {
            throw new UiException("Wrong parent: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    @Override
    public Object clone() {
        Treecol clone = (Treecol)((Object)super.clone());
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        TreeitemComparator c;
        if (this._sortAsc instanceof TreeitemComparator && (c = (TreeitemComparator)this._sortAsc).getTreecol() == this && c.isAscending()) {
            this._sortAsc = new TreeitemComparator(this, true, c.shallIgnoreCase());
        }
        if (this._sortDsc instanceof TreeitemComparator && (c = (TreeitemComparator)this._sortDsc).getTreecol() == this && !c.isAscending()) {
            this._sortDsc = new TreeitemComparator(this, false, c.shallIgnoreCase());
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        TreeitemComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof TreeitemComparator && (c = (TreeitemComparator)this._sortAsc).getTreecol() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            if (this._sortAsc instanceof Serializable) {
                s.writeObject(this._sortAsc);
            } else {
                if (this._sortAsc != null) {
                    throw new NotSerializableException(this._sortAsc.getClass().getName());
                }
                s.writeObject(null);
            }
        }
        written = false;
        if (this._sortDsc instanceof TreeitemComparator && (c = (TreeitemComparator)this._sortDsc).getTreecol() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            s.writeBoolean(c.byValue());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            if (this._sortDsc instanceof Serializable) {
                s.writeObject(this._sortDsc);
            } else {
                if (this._sortDsc != null) {
                    throw new NotSerializableException(this._sortDsc.getClass().getName());
                }
                s.writeObject(null);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean byval;
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortAsc = new TreeitemComparator(this, true, igcs, byval);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            byval = s.readBoolean();
            this._sortDsc = new TreeitemComparator(this, false, igcs, byval);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }

    static {
        Treecol.addClientEvent(Treecol.class, (String)"onSort", (int)8192);
    }
}

