/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.GroupRendererExt;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.GroupsDataEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.GroupingInfo;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.LoadStatus;
import org.zkoss.zul.impl.Utils;

public class GridDataLoader
implements DataLoader,
Cropper {
    private Grid _grid;
    private int INVALIDATE_THRESHOLD = -1;
    private Boolean SELECTIVE_COMPONENT_UPDATE = null;
    private static final RowRenderer _defRend = new RowRenderer(){

        public void render(Row row, final Object data, final int index) {
            Template tm2;
            Rows rows = (Rows)row.getParent();
            final Grid grid = (Grid)rows.getParent();
            Template tm = GridDataLoader.getTemplate(grid, rows, "model");
            GroupingInfo info = null;
            if (row instanceof Group) {
                tm2 = GridDataLoader.getTemplate(grid, rows, "model:group");
                if (tm2 != null) {
                    tm = tm2;
                }
                if (grid.getModel() instanceof GroupsListModel) {
                    GroupsListModel gmodel = (GroupsListModel)grid.getModel();
                    info = gmodel.getDataInfo(index);
                }
            } else if (row instanceof Groupfoot && (tm2 = GridDataLoader.getTemplate(grid, rows, "model:groupfoot")) != null) {
                tm = tm2;
            }
            if (tm == null) {
                Label label = GridDataLoader.newRenderLabel(Objects.toString((Object)data));
                label.applyProperties();
                label.setParent((Component)row);
                row.setValue(data);
            } else {
                final GroupingInfo groupingInfo = info;
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create((Component)rows, (Component)row, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return grid.getModel().getSize();
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        if ("groupingInfo".equals(name)) {
                            return groupingInfo;
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one row, not " + items.length);
                }
                Row nr = (Row)items[0];
                if (nr instanceof Group && row instanceof Group) {
                    ((Group)nr).setOpen(((Group)row).isOpen());
                }
                if (nr.getValue() == null) {
                    nr.setValue(data);
                }
                row.setAttribute("org.zkoss.zul.model.renderAs", (Object)nr);
                row.detach();
            }
        }
    };

    @Override
    public void init(Component owner, int offset, int limit) {
        this._grid = (Grid)owner;
    }

    @Override
    public void reset() {
    }

    @Override
    public final Component getOwner() {
        return this._grid;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getLimit() {
        return 50;
    }

    @Override
    public int getTotalSize() {
        Rows rows = this._grid.getRows();
        ListModel model = this._grid.getModel();
        return model != null ? model.getSize() : (rows != null ? rows.getVisibleItemCount() : 0);
    }

    @Override
    public void doGroupsDataChange(GroupsDataEvent event) {
        if (event.getType() == 10) {
            GroupsListModel groupsListModel = (GroupsListModel)this._grid.getModel();
            int groupIndex = event.getGroupIndex();
            int offset = groupsListModel.getGroupOffset(groupIndex);
            ((Group)((Object)this._grid.getRows().getChildren().get(offset - this.getOffset()))).setOpen(event.getModel().isGroupOpened(groupIndex));
        }
    }

    @Override
    public void doListDataChange(ListDataEvent event) {
        if (this.INVALIDATE_THRESHOLD == -1) {
            this.INVALIDATE_THRESHOLD = Utils.getIntAttribute(this.getOwner(), "org.zkoss.zul.invalidateThreshold", 10, true);
        }
        if (this.SELECTIVE_COMPONENT_UPDATE == null) {
            this.SELECTIVE_COMPONENT_UPDATE = Utils.testAttribute(this.getOwner(), "org.zkoss.zul.model.selectiveComponentUpdate.enable", false, true);
        }
        Rows rows = this._grid.getRows();
        int newsz = event.getModel().getSize();
        int oldsz = rows.getChildren().size();
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                Component next;
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    this.syncModel(-1, -1);
                    return;
                }
                if (!(oldsz > 0 && cnt <= this.INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    rows.invalidate();
                }
                if (min < 0) {
                    min = max < 0 ? 0 : max - cnt + 1;
                }
                if (min > oldsz) {
                    min = oldsz;
                }
                RowRenderer renderer = null;
                Component component = next = min < oldsz ? (Component)rows.getChildren().get(min) : null;
                while (--cnt >= 0) {
                    if (renderer == null) {
                        renderer = (RowRenderer)this.getRealRenderer();
                    }
                    rows.insertBefore(this.newUnloadedItem(renderer, min++), next);
                }
                if (this.SELECTIVE_COMPONENT_UPDATE.booleanValue() || rows.isInvalidated()) break;
                this.syncModel(max, rows.getChildren().size() - (max - min));
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    this.syncModel(-1, -1);
                    return;
                }
                if (!(newsz > 0 && cnt <= this.INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    rows.invalidate();
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                Component comp = (Component)rows.getChildren().get(max);
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
                if (this.SELECTIVE_COMPONENT_UPDATE.booleanValue() || rows.isInvalidated()) break;
                this.syncModel(max, rows.getChildren().size() - (max - min));
                break;
            }
            default: {
                this.syncModel(min, max < 0 ? -1 : max - min + 1);
            }
        }
    }

    protected Component newUnloadedItem(Object renderer, int index) {
        RowRenderer renderer0 = (RowRenderer)renderer;
        ListModel model = ((Grid)this.getOwner()).getModel();
        Row row = null;
        if (model instanceof GroupsListModel) {
            GroupsListModel gmodel = (GroupsListModel)model;
            GroupingInfo info = gmodel.getDataInfo(index);
            switch (info.getType()) {
                case 0: {
                    row = this.newGroup(renderer0);
                    ((Group)row).setOpen(info.isOpen());
                    break;
                }
                case 1: {
                    row = this.newGroupfoot(renderer0);
                    break;
                }
                default: {
                    row = this.newRow(renderer0);
                    break;
                }
            }
        } else {
            row = this.newRow(renderer0);
        }
        ((LoadStatus)row.getExtraCtrl()).setLoaded(false);
        ((LoadStatus)row.getExtraCtrl()).setIndex(index);
        this.newUnloadedCell(renderer0, row);
        return row;
    }

    private Row newRow(RowRenderer renderer) {
        Row row = null;
        if (renderer instanceof RowRendererExt) {
            row = ((RowRendererExt)((Object)renderer)).newRow((Grid)this.getOwner());
        }
        if (row == null) {
            row = new Row();
            row.applyProperties();
        }
        return row;
    }

    private Group newGroup(RowRenderer renderer) {
        Group group = null;
        if (renderer instanceof GroupRendererExt) {
            group = ((GroupRendererExt)((Object)renderer)).newGroup((Grid)this.getOwner());
        }
        if (group == null) {
            group = new Group();
            group.applyProperties();
        }
        return group;
    }

    private Groupfoot newGroupfoot(RowRenderer renderer) {
        Groupfoot groupfoot = null;
        if (renderer instanceof GroupRendererExt) {
            groupfoot = ((GroupRendererExt)((Object)renderer)).newGroupfoot((Grid)this.getOwner());
        }
        if (groupfoot == null) {
            groupfoot = new Groupfoot();
            groupfoot.applyProperties();
        }
        return groupfoot;
    }

    private Component newUnloadedCell(RowRenderer renderer, Row row) {
        Object cell = null;
        if (renderer instanceof RowRendererExt) {
            cell = ((RowRendererExt)((Object)renderer)).newCell(row);
        }
        if (cell == null) {
            cell = GridDataLoader.newRenderLabel(null);
            cell.applyProperties();
        }
        cell.setParent((Component)row);
        return cell;
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }

    @Override
    public Object getRealRenderer() {
        RowRenderer renderer = this._grid.getRowRenderer();
        return renderer != null ? renderer : _defRend;
    }

    private static Template getTemplate(Grid grid, Rows rows, String name) {
        Template tm = grid.getTemplate(name);
        return tm != null ? tm : (rows != null ? rows.getTemplate(name) : null);
    }

    @Override
    public void syncModel(int offset, int limit) {
        int min = offset;
        int max = offset + limit - 1;
        ListModel model = this._grid.getModel();
        Rows rows = this._grid.getRows();
        int newsz = model.getSize();
        int oldsz = rows != null ? rows.getChildren().size() : 0;
        Paginal pgi = this._grid.getPaginal();
        boolean inPaging = this.inPagingMold();
        boolean shallInvalidated = !(min >= 0 && min != 0 || max >= 0 && max < newsz && max < oldsz);
        int newcnt = newsz - oldsz;
        int atg = pgi != null ? this._grid.getActivePage() : 0;
        RowRenderer renderer = null;
        Component next = null;
        if (oldsz > 0) {
            if (min < 0) {
                min = 0;
            } else if (min > oldsz - 1) {
                min = oldsz - 1;
            }
            if (max < 0) {
                max = oldsz - 1;
            } else if (max > oldsz - 1) {
                max = oldsz - 1;
            }
            if (min > max) {
                int t = min;
                min = max;
                max = t;
            }
            int cnt = max - min + 1;
            if (rows != null) {
                if (model instanceof GroupsListModel) {
                    if ((shallInvalidated || (newcnt += cnt) > this.INVALIDATE_THRESHOLD) && !inPaging) {
                        rows.invalidate();
                    }
                    Component comp = (Component)rows.getChildren().get(max);
                    next = comp.getNextSibling();
                    while (--cnt >= 0) {
                        Component p = comp.getPreviousSibling();
                        comp.detach();
                        comp = p;
                    }
                } else {
                    int addcnt = 0;
                    Component row = (Component)rows.getChildren().get(min);
                    while (--cnt >= 0) {
                        next = row.getNextSibling();
                        if (cnt < -newcnt) {
                            row.detach();
                        } else if (((LoadStatus)((Row)row).getExtraCtrl()).isLoaded()) {
                            if (renderer == null) {
                                renderer = (RowRenderer)this.getRealRenderer();
                            }
                            row.detach();
                            rows.insertBefore(this.newUnloadedItem(renderer, min), next);
                            ++addcnt;
                        }
                        ++min;
                        row = next;
                    }
                    if ((shallInvalidated || addcnt > this.INVALIDATE_THRESHOLD || addcnt + newcnt > this.INVALIDATE_THRESHOLD) && !inPaging) {
                        rows.invalidate();
                    }
                }
            }
        } else {
            min = 0;
            if (rows == null) {
                rows = new Rows();
                rows.setParent((Component)this._grid);
            }
        }
        while (--newcnt >= 0) {
            if (renderer == null) {
                renderer = (RowRenderer)this.getRealRenderer();
            }
            rows.insertBefore(this.newUnloadedItem(renderer, min), next);
            ++min;
        }
        if (pgi != null) {
            if (atg >= pgi.getPageCount()) {
                atg = pgi.getPageCount() - 1;
            }
            pgi.setActivePage(atg);
            if (pgi.getTotalSize() != newsz) {
                pgi.setTotalSize(newsz);
            }
        }
    }

    protected boolean inPagingMold() {
        return "paging".equals(this._grid.getMold());
    }

    @Override
    public void updateModelInfo() {
    }

    @Override
    public void setLoadAll(boolean b) {
    }

    public boolean isCropper() {
        return this._grid != null && this.inPagingMold() && this._grid.getPageSize() <= this.getTotalSize();
    }

    public Set<? extends Component> getAvailableAtClient() {
        if (!this.isCropper()) {
            return null;
        }
        Paginal pgi = this._grid.getPaginal();
        int pgsz = pgi.getPageSize();
        int ofs = pgi.getActivePage() * pgsz;
        return this.getAvailableAtClient(ofs, pgsz);
    }

    protected Set<? extends Component> getAvailableAtClient(int offset, int limit) {
        LinkedHashSet<Row> avail = new LinkedHashSet<Row>(32);
        Rows rows = this._grid.getRows();
        Row row = (Row)rows.getFirstChild();
        while (row != null && limit != 0) {
            Group g;
            if (row.isVisible() && --offset < 0) {
                --limit;
                avail.add(row);
            }
            if (row instanceof Group && !(g = (Group)row).isOpen()) {
                int len = g.getItemCount();
                for (int j = 0; j < len && row != null; row = (Row)row.getNextSibling(), ++j) {
                }
            }
            if (row == null) continue;
            row = (Row)row.getNextSibling();
        }
        return avail;
    }

    public Component getCropOwner() {
        return this._grid;
    }
}

