/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Tab;
import org.zkoss.zul.TabboxRenderer;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.TabboxEngine;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Tabbox
extends XulElement {
    private transient Tabs _tabs;
    private transient Toolbar _toolbar;
    private transient Tabpanels _tabpanels;
    private transient Tab _seltab;
    private String _panelSpacing;
    private String _orient = "top";
    private boolean _tabscroll = true;
    private boolean _maximalHeight = false;
    transient EventListener<Event> _listener;
    private transient ListModel<?> _model;
    private transient ListDataListener _dataListener;
    private transient TabboxRenderer<?> _renderer;
    private transient TabboxEngine _engine;

    public Tabbox() {
        this.init();
    }

    private void init() {
        this._listener = new Listener();
    }

    public TabboxEngine getEngine() throws UiException {
        if (this._engine == null) {
            this._engine = this.newTabboxEngine();
        }
        return this._engine;
    }

    public void setEngine(TabboxEngine engine) {
        if (this._engine != engine) {
            this._engine = engine;
        }
        this.postOnInitRender();
    }

    protected TabboxEngine newTabboxEngine() throws UiException {
        Object v;
        String PROP = "org.zkoss.zul.tabbox.engine.class";
        String klass = Library.getProperty((String)"org.zkoss.zul.tabbox.engine.class");
        if (klass == null) {
            throw new UiException("Library property,  org.zkoss.zul.tabbox.engine.class, required");
        }
        try {
            v = Classes.newInstanceByThread((String)klass);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        if (!(v instanceof TabboxEngine)) {
            throw new UiException(String.valueOf(TabboxEngine.class) + " must be implemented by " + String.valueOf(v));
        }
        return (TabboxEngine)v;
    }

    public Selectable<Object> getSelectableModel() {
        return (Selectable)((Object)this._model);
    }

    private static boolean disableFeature() {
        return !WebApps.getFeature((String)"ee");
    }

    public void setModel(ListModel<?> model) {
        if (Tabbox.disableFeature()) {
            throw new IllegalAccessError("ZK EE version only!");
        }
        if (model != null) {
            if (!(model instanceof Selectable)) {
                throw new UiException(String.valueOf(model.getClass()) + " must implement " + String.valueOf(Selectable.class));
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                }
                this._model = model;
                this._seltab = null;
                this.initDataListener();
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.invalidate();
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                @Override
                public void onChange(ListDataEvent event) {
                    Tabbox.this.getEngine().doDataChange(Tabbox.this, event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public <T> TabboxRenderer<T> getTabboxRenderer() {
        return this._renderer;
    }

    public void setTabboxRenderer(TabboxRenderer<?> renderer) {
        if (Tabbox.disableFeature()) {
            throw new IllegalAccessError("ZK EE version only!");
        }
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.postOnInitRender();
        }
    }

    public void setTabboxRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setTabboxRenderer((TabboxRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public void onInitRender() {
        if (Tabbox.disableFeature()) {
            throw new IllegalAccessError("ZK EE version only!");
        }
        this.removeAttribute("org.zkoss.zul.onInitLaterPosted");
        this.doInitRenderer();
        this.invalidate();
    }

    private void doInitRenderer() {
        if (Tabbox.disableFeature()) {
            throw new IllegalAccessError("ZK EE version only!");
        }
        this.getEngine().doInitRenderer(this);
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    public void postOnInitRender() {
        if (this.getAttribute("org.zkoss.zul.onInitLaterPosted") == null) {
            this.setAttribute("org.zkoss.zul.onInitLaterPosted", Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    boolean inAccordionMold() {
        return this.getMold().startsWith("accordion");
    }

    public Tabs getTabs() {
        return this._tabs;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public Tabpanels getTabpanels() {
        return this._tabpanels;
    }

    public boolean isTabscroll() {
        return this._tabscroll;
    }

    public void setTabscroll(boolean tabscroll) {
        if (this._tabscroll != tabscroll) {
            this._tabscroll = tabscroll;
            this.smartUpdate("tabscroll", this._tabscroll);
        }
    }

    public boolean isMaximalHeight() {
        return this._maximalHeight;
    }

    public void setMaximalHeight(boolean maximalHeight) {
        if (this._maximalHeight != maximalHeight) {
            this._maximalHeight = maximalHeight;
            this.smartUpdate("maximalHeight", this._maximalHeight);
        }
    }

    public String getPanelSpacing() {
        return this._panelSpacing;
    }

    public void setPanelSpacing(String panelSpacing) {
        if (panelSpacing != null && panelSpacing.length() == 0) {
            panelSpacing = null;
        }
        if (!Objects.equals((Object)this._panelSpacing, (Object)panelSpacing)) {
            this._panelSpacing = panelSpacing;
            this.smartUpdate("panelSpacing", this._panelSpacing);
        }
    }

    public int getSelectedIndex() {
        return this._seltab != null ? this._seltab.getIndex() : -1;
    }

    public void setSelectedIndex(int j) {
        Tabs tabs = this.getTabs();
        if (tabs == null) {
            throw new IllegalStateException("No tab at all");
        }
        if (j >= 0) {
            this.setSelectedTab((Tab)((Object)tabs.getChildren().get(j)));
        } else {
            this.setSelectedTab((Tab)tabs.getFirstChild());
        }
    }

    public Tabpanel getSelectedPanel() {
        return this._seltab != null ? this._seltab.getLinkedPanel() : null;
    }

    public void setSelectedPanel(Tabpanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("null tabpanel");
        }
        if (panel.getTabbox() != this) {
            throw new UiException("Not a child: " + String.valueOf((Object)panel));
        }
        Tab tab = panel.getLinkedTab();
        if (tab != null) {
            this.setSelectedTab(tab);
        }
    }

    public Tab getSelectedTab() {
        return this._seltab;
    }

    public void setSelectedTab(Tab tab) {
        this.selectTabDirectly(tab, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectTabDirectly(Tab tab, boolean byClient) {
        if (tab == null) {
            throw new IllegalArgumentException("null tab");
        }
        if (tab.getTabbox() != this) {
            throw new UiException("Not my child: " + String.valueOf((Object)tab));
        }
        if (tab != this._seltab) {
            if (this._seltab != null) {
                this._seltab.setSelectedDirectly(false);
            }
            try {
                if (this.getAttribute("org.zkoss.zul.tabbox.changingSelection") == null) {
                    Selectable<Object> sm;
                    this.setAttribute("org.zkoss.zul.tabbox.changingSelection", Boolean.TRUE);
                    this._seltab = tab;
                    this._seltab.setSelectedDirectly(true);
                    if (byClient && this._model != null && !(sm = this.getSelectableModel()).isSelected(this._model.getElementAt(this._seltab.getIndex()))) {
                        sm.clearSelection();
                        sm.addToSelection(this._model.getElementAt(this._seltab.getIndex()));
                    }
                }
            }
            finally {
                this.removeAttribute("org.zkoss.zul.tabbox.changingSelection");
            }
            if (!byClient) {
                this.smartUpdate("selectedTab", (Object)this._seltab);
            }
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("accordion")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!("horizontal".equals(orient) || "top".equals(orient) || "bottom".equals(orient) || "vertical".equals(orient) || "right".equals(orient) || "left".equals(orient))) {
            throw new WrongValueException("Unknow orient : " + orient);
        }
        if (this.inAccordionMold()) {
            throw new WrongValueException("Unsupported vertical orient in mold : " + this.getMold());
        }
        if (this._toolbar != null && ("vertical".equals(orient) || "right".equals(orient) || "left".equals(orient))) {
            throw new WrongValueException("Unsupported vertical orient when there is a toolbar");
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = "horizontal".equals(orient) ? "top" : ("vertical".equals(orient) ? "left" : orient);
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        String orient = this.getOrient();
        return "horizontal".equals(orient) || "top".equals(orient) || "bottom".equals(orient);
    }

    public boolean isTop() {
        String orient = this.getOrient();
        return "horizontal".equals(orient) || "top".equals(orient);
    }

    public boolean isBottom() {
        return "bottom".equals(this.getOrient());
    }

    public boolean isVertical() {
        String orient = this.getOrient();
        return "vertical".equals(orient) || "right".equals(orient) || "left".equals(orient);
    }

    public boolean isLeft() {
        String orient = this.getOrient();
        return "vertical".equals(orient) || "left".equals(orient);
    }

    public boolean isRight() {
        return "right".equals(this.getOrient());
    }

    public String getZclass() {
        return this._zclass == null ? "z-tabbox" : this._zclass;
    }

    boolean isNativeScrollbar() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.nativebar", true, true);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Toolbar) {
            if (this._toolbar != null && this._toolbar != child) {
                throw new UiException("Only one Toolbar is allowed: " + String.valueOf((Object)this));
            }
            if (this.isVertical()) {
                throw new UiException("Toolbar is allowed only when the tabbox is horizontal." + String.valueOf((Object)this));
            }
        } else if (child instanceof Tabs) {
            if (this._tabs != null && this._tabs != child) {
                throw new UiException("Only one tabs is allowed: " + String.valueOf((Object)this));
            }
        } else if (child instanceof Tabpanels) {
            if (this._tabpanels != null && this._tabpanels != child) {
                throw new UiException("Only one tabpanels is allowed: " + String.valueOf((Object)this));
            }
        } else {
            throw new UiException("Unsupported child for tabbox: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Tabs) {
            if (super.insertBefore(child, refChild)) {
                this._tabs = (Tabs)child;
                for (Tab tab : this._tabs.getChildren()) {
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                this.addTabsListeners();
                return true;
            }
        } else if (child instanceof Tabpanels) {
            if (super.insertBefore(child, refChild)) {
                this._tabpanels = (Tabpanels)child;
                return true;
            }
        } else if (child instanceof Toolbar) {
            if (super.insertBefore(child, refChild)) {
                this._toolbar = (Toolbar)child;
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (this._tabs == child) {
            this.removeTabsListeners();
            this._tabs = null;
            this._seltab = null;
        } else if (this._tabpanels == child) {
            this._tabpanels = null;
        } else if (this._toolbar == child) {
            this._toolbar = null;
        }
        super.onChildRemoved(child);
    }

    private void removeTabsListeners() {
        if (this._tabs != null) {
            for (Tab tab : this._tabs.getChildren()) {
                tab.removeEventListener("onSelect", this._listener);
            }
        }
    }

    private void addTabsListeners() {
        if (this._tabs != null) {
            for (Tab tab : this._tabs.getChildren()) {
                tab.addEventListener("onSelect", this._listener);
            }
        }
    }

    protected void clearSelectedTab() {
        this._seltab = null;
    }

    @Override
    public Object clone() {
        Tabbox clone = (Tabbox)((Object)super.clone());
        clone.removeTabsListeners();
        clone.init();
        int cnt = 0;
        if (clone._tabs != null) {
            ++cnt;
        }
        if (clone._toolbar != null) {
            ++cnt;
        }
        if (clone._tabpanels != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        for (Object child : this.getChildren()) {
            if (child instanceof Tabs) {
                this._tabs = (Tabs)((Object)child);
                for (Tab tab : this._tabs.getChildren()) {
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Toolbar) {
                this._toolbar = (Toolbar)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Tabpanels)) continue;
            this._tabpanels = (Tabpanels)((Object)child);
            if (--cnt != 0) continue;
            break;
        }
        this.addTabsListeners();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (TabboxRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal(-1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._panelSpacing != null) {
            this.render(renderer, "panelSpacing", this._panelSpacing);
        }
        if (!this.isTop()) {
            this.render(renderer, "orient", this._orient);
        }
        if (!this._tabscroll) {
            renderer.render("tabscroll", this._tabscroll);
        }
        if (this._maximalHeight) {
            renderer.render("z$rod", false);
            renderer.render("maximalHeight", this._maximalHeight);
        }
        if (!this.isNativeScrollbar()) {
            renderer.render("_nativebar", false);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this._model != null) {
            this.postOnInitRender();
            if (this._dataListener != null) {
                this._model.removeListDataListener(this._dataListener);
                this._model.addListDataListener(this._dataListener);
            }
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
        }
    }

    private class Listener
    implements EventListener<Event>,
    Deferrable {
        private Listener() {
        }

        public void onEvent(Event event) {
            Events.sendEvent((Component)Tabbox.this, (Event)event);
        }

        public boolean isDeferrable() {
            return !Events.isListened((Component)Tabbox.this, (String)"onSelect", (boolean)true);
        }
    }
}

