/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.theme;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.zkoss.lang.Strings;
import org.zkoss.web.theme.ThemeResolver;

public class CookieThemeResolver
implements ThemeResolver {
    private static final String THEME_COOKIE_KEY = "zktheme";

    public String getTheme(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        for (Cookie c : cookies) {
            String themeName;
            if (!THEME_COOKIE_KEY.equals(c.getName()) || !this.isValidName(themeName = c.getValue())) continue;
            return themeName;
        }
        return "";
    }

    private boolean isValidName(String themeName) {
        if (Strings.isBlank((String)themeName)) {
            return false;
        }
        int len = themeName.length();
        for (int j = 0; j < len; ++j) {
            char cc = themeName.charAt(j);
            if (cc != '/' && cc != '\\' && cc != '.' && cc != ':' && cc != '?' && cc != '&' && cc != '=' && cc != '%' && cc != '#' && cc != ' ') continue;
            return false;
        }
        return true;
    }

    public void setTheme(HttpServletRequest request, HttpServletResponse response, String themeName) {
        Cookie cookie = new Cookie(THEME_COOKIE_KEY, themeName);
        cookie.setHttpOnly(true);
        if (request.isSecure()) {
            cookie.setSecure(true);
        }
        cookie.setMaxAge(2592000);
        String cp = request.getContextPath();
        if (cp == null || "/".equals(cp)) {
            cp = "";
        }
        if (cp.length() == 0) {
            cp = "/";
        }
        cookie.setPath(cp);
        response.addCookie(cookie);
    }
}

