/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wnd/Panel.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wnd/Panel.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Panel.ts

    Purpose:

    Description:

    History:
        Mon Jan 12 18:31:03 2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.wnd) window.zul.wnd = {};
if (!window.zul.wnd.Panel_) window.zul.wnd.Panel_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PanelRenderer = exports.PanelSkipper = exports.Panel = void 0;
/**
 * Panel is a container that has specific functionality and structural components
 * that make it the perfect building block for application-oriented user interfaces.
 * The Panel contains bottom, top, and foot toolbars, along with separate header,
 * footer and body sections. It also provides built-in collapsible, closable,
 * maximizable, and minimizable behavior, along with a variety of pre-built tool
 * buttons that can be wired up to provide other customized behavior. Panels can
 * be easily embedded into any kind of ZUL component that is allowed to have children
 * or layout component. Panels also provide specific features like float and move.
 * Unlike {@link zul.wnd.Window}, Panels can only be floated and moved inside its parent
 * node, which is not using {@link _global_.jqzk#makeVParent} function. In other words,
 * if Panel's parent node is an relative position, the floated panel is only inside
 * its parent, not the whole page.
 * The second difference of {@link zul.wnd.Window} is that Panel is not an independent ID
 * space, so the ID of each child can be used throughout the panel.
 *
 * <p>Events:<br/>
 * onMove, onOpen, onZIndex, onMaximize, onMinimize, and onClose.<br/>
 *
 * @defaultValue {@link getZclass}: z-panel.
 *
 */
var Panel = /** @class */function (_super) {
  __extends(Panel, _super);
  function Panel() {
    var _this = _super.call(this) || this; // FIXME: params?
    /** @internal */
    _this._border = 'none';
    /** @internal */
    _this._title = '';
    /** @internal */
    _this._open = true;
    /** @internal */
    _this._minheight = 100;
    /** @internal */
    _this._minwidth = 200;
    /** @internal */
    _this._tabindex = 0;
    /** @internal */
    _this._nativebar = true;
    _this.listen({
      onMaximize: _this,
      onClose: _this,
      onMove: _this,
      onSize: _this.onSizeEvent
    }, -1000);
    _this._skipper = new zul.wnd.PanelSkipper(_this);
    return _this;
  }
  Panel_1 = Panel;
  /**
   * Sets the minimum height in pixels allowed for this panel.
   * If negative, 100 is assumed.
   * @defaultValue `100`.
   * <p>Note: Only applies when {@link isSizable} = true.
   */
  Panel.prototype.setMinheight = function (minheight) {
    this._minheight = minheight;
    return this;
  };
  /**
   * @returns (int) the minimum height.
   * @defaultValue `100`.
   */
  Panel.prototype.getMinheight = function () {
    return this._minheight;
  };
  /**
   * Sets the minimum width in pixels allowed for this panel. If negative,
   * 200 is assumed.
   * @defaultValue `200`.
   * <p>Note: Only applies when {@link isSizable} = true.
   */
  Panel.prototype.setMinwidth = function (minwidth) {
    this._minwidth = minwidth;
    return this;
  };
  /**
   * @returns (int) the minimum width.
   * @defaultValue `200`.
   */
  Panel.prototype.getMinwidth = function () {
    return this._minwidth;
  };
  /**
   * Sets whether the panel is sizable.
   * If true, an user can drag the border to change the panel width.
   * @defaultValue `false`.
   */
  Panel.prototype.setSizable = function (sizable, opts) {
    var o = this._sizable;
    this._sizable = sizable;
    if (o !== sizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        if (sizable) this._makeSizer();else if (this._sizer) {
          this._sizer.destroy();
          this._sizer = undefined;
        }
      }
    }
    return this;
  };
  /**
   * @returns whether the panel is sizable.
   */
  Panel.prototype.isSizable = function () {
    return !!this._sizable;
  };
  /**
   * Sets whether to move the panel to display it inline where it is rendered.
   *
   * @defaultValue `false`;
   * <p>Note that this method only applied when {@link isFloatable} is true.
   */
  Panel.prototype.setMovable = function (movable, opts) {
    var o = this._movable;
    this._movable = movable;
    if (o !== movable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to move the panel to display it inline where it is rendered.
   * @defaultValue `false`.
   */
  Panel.prototype.isMovable = function () {
    return !!this._movable;
  };
  /**
   * Sets whether to float the panel to display it inline where it is rendered.
   *
   * <p>Note that by default, setting floatable to true will cause the
   * panel to display at default offsets, which depend on the offsets of
   * the embedded panel from its element to <i>document.body</i> -- because the panel
   * is absolute positioned, the position must be set explicitly by {@link setTop}
   * and {@link setLeft}. Also, when floatable a panel you should always
   * assign a fixed width, otherwise it will be auto width and will expand to fill
   * to the right edge of the viewport.
   */
  Panel.prototype.setFloatable = function (floatable, opts) {
    var o = this._floatable;
    this._floatable = floatable;
    if (o !== floatable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to float the panel to display it inline where it is rendered.
   * @defaultValue `false`.
   */
  Panel.prototype.isFloatable = function () {
    return !!this._floatable;
  };
  /**
   * Sets whether to display the maximizing button and allow the user to maximize
   * the panel, when a panel is maximized, the button will automatically
   * change to a restore button with the appropriate behavior already built-in
   * that will restore the panel to its previous size.
   * @defaultValue `false`.
   *
   * <p>Note: the maximize button won't be displayed if no title or caption at all.
   */
  Panel.prototype.setMaximizable = function (maximizable, opts) {
    var o = this._maximizable;
    this._maximizable = maximizable;
    if (o !== maximizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to display the maximizing button and allow the user to maximize
   * the panel.
   * @defaultValue `false`.
   */
  Panel.prototype.isMaximizable = function () {
    return !!this._maximizable;
  };
  /**
   * Sets whether to display the minimizing button and allow the user to minimize
   * the panel. Note that this button provides no implementation -- the behavior
   * of minimizing a panel is implementation-specific, so the MinimizeEvent
   * event must be handled and a custom minimize behavior implemented for this
   * option to be useful.
   *
   * @defaultValue `false`.
   * <p>Note: the maximize button won't be displayed if no title or caption at all.
   */
  Panel.prototype.setMinimizable = function (minimizable, opts) {
    var o = this._minimizable;
    this._minimizable = minimizable;
    if (o !== minimizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to display the minimizing button and allow the user to minimize
   * the panel.
   * @defaultValue `false`.
   */
  Panel.prototype.isMinimizable = function () {
    return !!this._minimizable;
  };
  /**
   * Sets whether to show a toggle button on the title bar.
   * @defaultValue `false`.
   * <p>Note: the toggle button won't be displayed if no title or caption at all.
   */
  Panel.prototype.setCollapsible = function (collapsible, opts) {
    var o = this._collapsible;
    this._collapsible = collapsible;
    if (o !== collapsible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to show a toggle button on the title bar.
   * @defaultValue `false`.
   */
  Panel.prototype.isCollapsible = function () {
    return !!this._collapsible;
  };
  /**
   * Sets whether to show a close button on the title bar.
   * If closable, a button is displayed and the onClose event is sent
   * if an user clicks the button.
   *
   * @defaultValue `false`.
   *
   * <p>Note: the close button won't be displayed if no title or caption at all.
   */
  Panel.prototype.setClosable = function (closable, opts) {
    var o = this._closable;
    this._closable = closable;
    if (o !== closable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize; //Bug ZK-1500: remember last size before rerender
      this.rerender(this._skipper);
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns whether to show a close button on the title bar.
   */
  Panel.prototype.isClosable = function () {
    return !!this._closable;
  };
  /**
   * Sets the border.
   * Allowed values include `none` (default), `normal`,
   * `rounded` and `rounded+`.
   * For more information, please refer to
   * <a href="http://books.zkoss.org/wiki/ZK_Component_Reference/Containers/Panel#Border">ZK Component Reference: Panel</a>.
   * @param border - the border. If null or "0", "none" is assumed.
   */
  Panel.prototype.setBorder = function (border, opts) {
    var o = this._border;
    this._border = border;
    if (o !== border || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var last = this._lastSize;
      this.rerender(); // no skipper, as body DOM depends on border
      if (last) this._lastSize = last;
    }
    return this;
  };
  /**
   * @returns the border.
   *
   * @defaultValue `"none"`.
   */
  Panel.prototype.getBorder = function () {
    return this._border;
  };
  /**
   * Sets the title.
   */
  Panel.prototype.setTitle = function (title, opts) {
    var o = this._title;
    this._title = title;
    if (o !== title || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.caption) {
        this.caption.updateDomContent_(); // B50-ZK-313
      } else {
        var last = this._lastSize;
        this.rerender(this._skipper);
        if (last) this._lastSize = last;
      }
    }
    return this;
  };
  /**
   * @returns the title.
   * Besides this attribute, you could use {@link zul.wgt.Caption} to define
   * a more sophisticated caption (aka., title).
   * <p>If a panel has a caption whose label ({@link zul.wgt.Caption#getLabel})
   * is not empty, then this attribute is ignored.
   * @defaultValue empty.
   */
  Panel.prototype.getTitle = function () {
    return this._title;
  };
  /**
   * Opens or closes this Panel.
   */
  Panel.prototype.setOpen = function (open, fromServer, opts) {
    var o = this._open;
    this._open = open;
    if (o !== open || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var node = this.$n(),
        up = this.getCollapseOpenIconClass_(),
        down = this.getCollapseCloseIconClass_();
      if (node) {
        var $body = jq(this.$n_('body'));
        if ($body[0] && !$body.is(':animated')) {
          if (open) {
            jq(node).removeClass(this.$s('collapsed'));
            // `exp` might not exist
            jq(this.$n('exp')).attr('title', msgzul.PANEL_COLLAPSE).children('.' + down).removeClass(down).addClass(up);
            $body.zk.slideDown(this);
          } else {
            // `exp` might not exist
            jq(node).addClass(this.$s('collapsed'));
            jq(this.$n('exp')).attr('title', msgzul.PANEL_EXPAND).children('.' + up).removeClass(up).addClass(down);
            this._hideShadow();
            $body.zk.slideUp(this);
          }
          if (!fromServer) this.fire('onOpen', {
            open: open
          });
        }
      }
    }
    return this;
  };
  /**
   * @returns whether this Panel is open.
   * @defaultValue `true`.
   */
  Panel.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * Sets whether the panel is maximized, and then the size of the panel will depend
   * on it to show a appropriate size. In other words, if true, the size of the
   * panel will count on the size of its offset parent node whose position is
   * absolute (by {@link isFloatable}) or its parent node. Otherwise, its size
   * will be original size. Note that the maximized effect will run at client's
   * sizing phase not initial phase.
   *
   * @defaultValue `false`.
   */
  Panel.prototype.setMaximized = function (maximized, fromServer, opts) {
    var o = this._maximized;
    this._maximized = maximized;
    if (o !== maximized || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var node = this.$n();
      if (node) {
        var $n = zk(node),
          isRealVisible = $n.isRealVisible();
        if (!isRealVisible && maximized) return this;
        var l,
          t,
          w,
          h,
          s = node.style,
          up = this.getMaximizableIconClass_(),
          down = this.getMaximizedIconClass_();
        if (maximized) {
          jq(this.$n_('max')).addClass(this.$s('maximized')).attr('title', msgzul.PANEL_RESTORE).children('.' + up).removeClass(up).addClass(down);
          this._hideShadow();
          if (this._collapsible && !this._open) {
            $n.jq.removeClass(this.$s('collapsed'));
            var body = this.$n('body');
            if (body) body.style.display = '';
          }
          var floated = this.isFloatable(),
            $op = floated ? jq(node).offsetParent() : jq(node).parent(),
            sh = $op.zk.clientHeightDoubleValue();
          if (zk.isLoaded('zkmax.layout') && this.parent instanceof zkmax.layout.Portalchildren) {
            var layout = this.parent.parent;
            if (layout.getMaximizedMode() == 'whole') {
              this._inWholeMode = true;
              var p = layout.$n_(),
                ps = p.style;
              sh = p.clientHeight;
              var oldinfo = this._oldNodeInfo = {
                _scrollTop: p.parentNode.scrollTop
              };
              p.parentNode.scrollTop = 0;
              $n.makeVParent();
              zWatch.fireDown('onVParent', this);
              oldinfo._pos = s.position;
              oldinfo._ppos = ps.position;
              oldinfo._zIndex = s.zIndex;
              s.position = 'absolute';
              this.setFloating_(true);
              this.setTopmost();
              p.appendChild(node);
              ps.position = 'relative';
              if (!ps.height) {
                ps.height = jq.px0(sh);
                oldinfo._pheight = true;
              }
            }
          }
          var floated = this.isFloatable(),
            $op = floated ? jq(node).offsetParent() : jq(node).parent(),
            zkop = $op.zk;
          l = s.left;
          t = s.top;
          w = s.width;
          h = s.height;
          // prevent the scroll bar.
          s.top = '-10000px';
          s.left = '-10000px';
          var sw = zkop.clientWidthDoubleValue();
          if (!floated) {
            sw -= zkop.paddingWidth();
            sw = $n.revisedWidth(sw);
            sh -= zkop.paddingHeight();
            sh = $n.revisedHeight(sh);
          }
          s.width = jq.px0(sw);
          s.height = jq.px0(sh);
          if (!this._lastSize) this._lastSize = {
            l: l,
            t: t,
            w: w,
            h: h
          };
          // restore.
          s.top = '0';
          s.left = '0';
          // resync
          w = s.width;
          h = s.height;
        } else {
          var max = this.$n_('max'),
            $max = jq(max);
          $max.removeClass(this.$s('maximized')).attr('title', msgzul.PANEL_MAXIMIZE).children('.' + down).removeClass(down).addClass(up);
          if (this._lastSize) {
            s.left = this._lastSize.l;
            s.top = this._lastSize.t;
            s.width = this._lastSize.w;
            s.height = this._lastSize.h;
            this._lastSize = undefined;
          }
          l = s.left;
          t = s.top;
          w = s.width;
          h = s.height;
          if (this._collapsible && !this._open) {
            jq(node).addClass(this.$s('collapsed'));
            var body = this.$n('body');
            if (body) body.style.display = 'none';
          }
          var body = this.panelchildren ? this.panelchildren.$n() : undefined;
          if (body) body.style.width = body.style.height = '';
          if (this._inWholeMode) {
            $n.undoVParent();
            zWatch.fireDown('onVParent', this);
            var oldinfo_1 = this._oldNodeInfo;
            node.style.position = oldinfo_1 ? oldinfo_1._pos : '';
            this.setZIndex(oldinfo_1 ? oldinfo_1._zIndex : '', {
              fire: true
            });
            this.setFloating_(false);
            var p_1 = this.parent.parent.$n_();
            p_1.style.position = oldinfo_1 ? oldinfo_1._ppos : '';
            p_1.parentNode.scrollTop = oldinfo_1 ? oldinfo_1._scrollTop : 0;
            if (oldinfo_1 === null || oldinfo_1 === void 0 ? void 0 : oldinfo_1._pheight) p_1.style.height = '';
            this._oldNodeInfo = undefined;
            this._inWholeMode = false;
          }
        }
        if (!fromServer && isRealVisible) {
          this._visible = true;
          this.fire('onMaximize', {
            left: l,
            top: t,
            width: w,
            height: h,
            maximized: maximized,
            fromServer: fromServer
          });
        }
        if (isRealVisible) {
          // B50-ZK-324: always counts on onSize to do the work
          //this.__maximized = true;
          zUtl.fireSized(this);
        }
      }
    }
    return this;
  };
  /**
   * @returns whether the panel is maximized.
   */
  Panel.prototype.isMaximized = function () {
    return !!this._maximized;
  };
  /**
   * Sets whether the panel is minimized.
   * @defaultValue `false`.
   */
  Panel.prototype.setMinimized = function (minimized, fromServer, opts) {
    var o = this._minimized;
    this._minimized = minimized;
    if (o !== minimized || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._maximized) this.setMaximized(false);
      var node = this.$n();
      if (node) {
        var s = node.style;
        if (minimized) {
          zWatch.fireDown('onHide', this);
          jq(node).hide();
        } else {
          jq(node).show();
          zUtl.fireShown(this);
        }
        if (!fromServer) {
          this._visible = false;
          this.fire('onMinimize', {
            left: s.left,
            top: s.top,
            width: s.width,
            height: s.height,
            minimized: minimized
          });
        }
      }
    }
    return this;
  };
  /**
   * @returns whether the panel is minimized.
   * @defaultValue `false`.
   */
  Panel.prototype.isMinimized = function () {
    return !!this._minimized;
  };
  //server use only
  Panel.prototype.getTbar = function () {
    return this._tbar;
  };
  //server use only
  Panel.prototype.setTbar = function (tbar, opts) {
    var o = this._tbar;
    this._tbar = tbar;
    if (o !== tbar || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.tbar = zk.Widget.$(tbar);
      if (this.bbar == this.tbar) this.bbar = undefined;
      if (this.fbar == this.tbar) this.fbar = undefined;
      this.rerender();
    }
    return this;
  };
  //server use only
  Panel.prototype.getBbar = function () {
    return this._bbar;
  };
  //server use only
  Panel.prototype.setBbar = function (bbar, opts) {
    var o = this._bbar;
    this._bbar = bbar;
    if (o !== bbar || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.bbar = zk.Widget.$(bbar);
      if (this.tbar == this.bbar) this.tbar = undefined;
      if (this.fbar == this.bbar) this.fbar = undefined;
      this.rerender();
    }
    return this;
  };
  //server use only
  Panel.prototype.getFbar = function () {
    return this._fbar;
  };
  //server use only
  Panel.prototype.setFbar = function (fbar, opts) {
    var o = this._fbar;
    this._fbar = fbar;
    if (o !== fbar || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.fbar = zk.Widget.$(fbar);
      if (this.tbar == this.fbar) this.tbar = undefined;
      if (this.bbar == this.fbar) this.bbar = undefined;
      this.rerender();
    }
    return this;
  };
  Panel.prototype.setVflex = function (vflex) {
    _super.prototype.setVflex.call(this, vflex);
    if (this.desktop) {
      if (this.panelchildren) {
        this.panelchildren.setVflex(vflex);
      }
    }
    return this;
  };
  Panel.prototype.setHflex = function (hflex) {
    _super.prototype.setHflex.call(this, hflex);
    if (this.desktop) {
      if (this.panelchildren) {
        this.panelchildren.setHflex(hflex);
      }
    }
    return this;
  };
  Panel.prototype.setVisible = function (visible) {
    if (this._visible != visible) {
      if (this._maximized) {
        this.setMaximized(false);
      } else if (this._minimized) {
        this.setMinimized(false);
      }
      _super.prototype.setVisible.call(this, visible);
    }
    return this;
  };
  Panel.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) zUtl.fireSized(this);
    return this;
  };
  Panel.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) zUtl.fireSized(this);
    return this;
  };
  Panel.prototype.setTop = function (top) {
    this._hideShadow();
    _super.prototype.setTop.call(this, top);
    this.zsync();
    return this;
  };
  Panel.prototype.setLeft = function (left) {
    this._hideShadow();
    _super.prototype.setLeft.call(this, left);
    this.zsync();
    return this;
  };
  /** @internal */
  Panel.prototype.updateDomStyle_ = function () {
    _super.prototype.updateDomStyle_.call(this);
    if (this.desktop) zUtl.fireSized(this);
  };
  /**
   * Adds the toolbar of the panel by these names, "tbar", "bbar", and "fbar".
   * "tbar" is the name of top toolbar, and "bbar" the name of bottom toolbar,
   * and "fbar" the name of foot toolbar.
   *
   * @param name - "tbar", "bbar", and "fbar".
   */
  Panel.prototype.addToolbar = function (name, toolbar) {
    switch (name) {
      case 'tbar':
        this.tbar = toolbar;
        break;
      case 'bbar':
        this.bbar = toolbar;
        break;
      case 'fbar':
        this.fbar = toolbar;
        break;
      default:
        return false;
      // not match
    }
    return this.appendChild(toolbar);
  };
  //event handler//
  Panel.prototype.onClose = function () {
    if (!this.inServer || !this.isListen('onClose', {
      asapOnly: true
    }))
      //let server handle if in server
      this.parent.removeChild(this); //default: remove
  };
  Panel.prototype.onMove = function (evt) {
    this._left = evt.left;
    this._top = evt.top;
  };
  Panel.prototype.onMaximize = function (evt) {
    var data = evt.data;
    this._top = data.top;
    this._left = data.left;
    this._height = data.height;
    this._width = data.width;
  };
  Panel.prototype.onSizeEvent = function (evt) {
    var _this = this;
    var data = evt.data,
      node = this.$n_(),
      s = node.style;
    this._hideShadow();
    if (data.width != s.width) {
      this._width = s.width = data.width;
    }
    if (data.height != s.height) {
      this._height = s.height = data.height;
      this._fixHgh(true);
    }
    if (data.left != s.left || data.top != s.top) {
      s.left = data.left;
      s.top = data.top;
      this.fire('onMove', zk.copy({
        left: node.style.left,
        top: node.style.top
      }, evt.data), {
        ignorable: true
      });
    }
    this.zsync();
    setTimeout(function () {
      return zUtl.fireSized(_this);
    });
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Panel.prototype.setFlexSizeH_ = function (flexSizeH, zkn, height, isFlexMin) {
    if (isFlexMin) {
      height += this._titleHeight();
    }
    _super.prototype.setFlexSizeH_.call(this, flexSizeH, zkn, height, isFlexMin);
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Panel.prototype.setFlexSizeW_ = function (flexSizeW, zkn, width, isFlexMin) {
    if (isFlexMin && this.caption) {
      if (width == this.caption.$n_().offsetWidth) {
        width += zk(this.$n('head')).padBorderWidth();
      }
    }
    _super.prototype.setFlexSizeW_.call(this, flexSizeW, zkn, width, isFlexMin);
  };
  Panel.prototype.beforeSize = function () {
    // Bug ZK-334: Tablelayout with hflex won't resize its width after resizing
    // have to clear width here if not listen to flex
    if (!this._flexListened) this.$n_('body').style.width = '';
  };
  /** @internal */
  Panel.prototype.resetSize_ = function (orient) {
    // Bug ZK-334: Tablelayout with hflex won't resize its width after resizing
    // also reset the size of body
    _super.prototype.resetSize_.call(this, orient);
    this.$n_('body').style[orient == 'w' ? 'width' : 'height'] = '';
  };
  //watch//
  Panel.prototype.onSize = function (ctl) {
    function syncMaximized(wgt) {
      if (!wgt._lastSize) return;
      var node = wgt.$n_(),
        $n = zk(node),
        floated = wgt.isFloatable(),
        $op = floated ? jq(node).offsetParent() : jq(node).parent(),
        zkop = $op.zk,
        s = node.style,
        sw = zkop.clientWidthDoubleValue();
      if (!floated) {
        sw -= zkop.paddingWidth();
        sw = $n.revisedWidth(sw);
      }
      s.width = jq.px0(sw);
      if (wgt._open) {
        var sh = zkop.clientHeightDoubleValue();
        if (!floated) {
          sh -= zkop.paddingHeight();
          sh = $n.revisedHeight(sh);
        }
        s.height = jq.px0(sh);
      }
    }
    this._hideShadow();
    if (this._maximized) syncMaximized(this);
    if (this.tbar) ctl.fireDown(this.tbar);
    if (this.bbar) ctl.fireDown(this.bbar);
    if (this.fbar) ctl.fireDown(this.fbar);
    this._fixHgh(true);
    this._fixWdh(); // B55-ZK-328
    this.zsync();
  };
  Panel.prototype.onHide = function () {
    this._hideShadow();
  };
  /** @internal */
  Panel.prototype._fixHgh = function (ignoreRealVisible) {
    var pc = this.panelchildren;
    if (!pc || pc.z_rod || !ignoreRealVisible && !this.isRealVisible()) return;
    var n = this.$n_(),
      body = pc.$n_(),
      hgh = n.style.height;
    if (!hgh && this._cssflex && this._vflex)
      // due to css flex, need to use offsetHeight
      hgh = n.offsetHeight;
    if (hgh && hgh != 'auto') body.style.height = jq.px0(this._offsetHeight(n));
  };
  /** @internal */
  Panel.prototype._fixWdh = function () {
    var _a;
    var pc = this.panelchildren;
    if (!pc || pc.z_rod || !this.isRealVisible()) return;
    var pcst = (_a = pc.$n()) === null || _a === void 0 ? void 0 : _a.style,
      pcwd;
    if (pcst && (pcwd = pcst.width) && pcwd != 'auto') {
      var w = zk(this.$n()).contentWidth();
      pcst.width = "".concat(w - zk(this.$n('body')).padBorderWidth(), "px");
    }
  };
  //whether rounded border is required
  /** @internal */
  Panel.prototype._rounded = function () {
    return this._border.startsWith('rounded'); //rounded
  };
  //backward compatible with 5.0.6
  Panel.prototype.isFramable = function () {
    return this._rounded();
  };
  //whether inner border is required
  /** @internal */
  Panel.prototype._bordered = function () {
    var v = this._border;
    return v != 'none' && v != 'rounded';
  };
  /** @internal */
  Panel.prototype._offsetHeight = function (n) {
    var tHeight = this._titleHeight(),
      body = this.$n('body'),
      h = zk(tHeight ? n : body).contentHeight() - this._titleHeight();
    if (tHeight) h -= zk(body).padBorderHeight();
    var tb = this.tbar ? this.$n('tb') : undefined,
      bb = this.bbar ? this.$n('bb') : undefined,
      fb = this.fbar ? this.$n('fb') : undefined;
    if (tb) h -= tb.offsetHeight;
    if (bb) h -= bb.offsetHeight;
    if (fb) h -= fb.offsetHeight;
    return h;
  };
  /** @internal */
  Panel.prototype._titleHeight = function () {
    var head = this.getTitle() || this.caption ? this.$n('head') : undefined;
    return head ? head.offsetHeight : 0;
  };
  Panel.prototype.onFloatUp = function (ctl) {
    if (!this._visible || !this.isFloatable()) return; //just in case
    for (var wgt = ctl.origin; wgt; wgt = wgt.parent) {
      if (wgt == this) {
        this.setTopmost();
        return;
      }
      if (wgt.isFloating_()) return;
    }
  };
  /** @internal */
  Panel.prototype._makeSizer = function () {
    if (!this._sizer) {
      this.domListen_(this.$n_(), 'onMouseMove');
      this.domListen_(this.$n_(), 'onMouseOut');
      this._sizer = new zk.Draggable(this, undefined, {
        stackup: true,
        draw: Panel_1._drawsizing,
        snap: Panel_1._snapsizing,
        starteffect: Panel_1._startsizing,
        ghosting: Panel_1._ghostsizing,
        endghosting: Panel_1._endghostsizing,
        ignoredrag: Panel_1._ignoresizing,
        endeffect: Panel_1._aftersizing
      });
    }
  };
  /** @internal */
  Panel.prototype._initFloat = function () {
    var n = this.$n_();
    if (!n.style.top || !n.style.left) {
      var xy = zk(n).revisedOffset();
      n.style.left = jq.px(xy[0]);
      n.style.top = jq.px(xy[1]);
    }
    n.style.position = 'absolute';
    if (this.isMovable()) this._initMove();
    this.zsync();
    if (this.isRealVisible()) this.setTopmost();
  };
  /** @internal */
  Panel.prototype._initMove = function () {
    var handle = this.$n('head');
    if (handle && !this._drag) {
      jq(handle).addClass(this.$s('header-move'));
      this._drag = new zk.Draggable(this, undefined, {
        handle: handle,
        stackup: true,
        starteffect: Panel_1._startmove,
        ignoredrag: Panel_1._ignoremove,
        endeffect: Panel_1._aftermove
      });
    }
  };
  Panel.prototype.zsync = function (opts) {
    _super.prototype.zsync.call(this, opts);
    if (!this.isFloatable()) {
      if (this._shadow) {
        this._shadow.destroy();
        this._shadow = undefined;
      }
    } else {
      var body = this.$n('body');
      if (body && zk(body).isRealVisible()) {
        if (!this._shadow) this._shadow = new zk.eff.Shadow(this.$n_(), {
          left: -4,
          right: 4,
          top: -2,
          bottom: 3
        });
        if (this._maximized || this._minimized || !this._visible)
          //since action might be applied, we have to check _visible
          this._hideShadow();else this._shadow.sync();
      }
    }
  };
  /** @internal */
  Panel.prototype._hideShadow = function () {
    var shadow = this._shadow;
    if (shadow) shadow.hide();
  };
  /** @internal */
  Panel.prototype.afterAnima_ = function (visible) {
    _super.prototype.afterAnima_.call(this, visible);
    var p = this.parent;
    if (p) {
      var parentHasFlex = p.getHflex && p.getHflex() != 'min' || p.getVflex && p.getVflex() != 'min';
      if (parentHasFlex) {
        // ZK-3248: parent should resize if parent itself has flex
        zUtl.fireSized(p);
      } else {
        // ZK-2138: parent should resize if parent has child with vflex
        for (var c = p.firstChild; c; c = c.nextSibling) {
          if (c == this) continue;
          var vflex = c.getVflex();
          if (vflex && vflex != 'min') {
            zUtl.fireSized(p);
            break;
          }
        }
      }
    }
  };
  /** @internal */
  Panel.prototype.bind_ = function (desktop, skipper, after) {
    var _this = this;
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this,
      onHide: this
    });
    if (this._sizable) this._makeSizer();
    if (this.isFloatable()) {
      zWatch.listen({
        onFloatUp: this
      });
      this.setFloating_(true);
      this._initFloat();
      if (!zk.css3) jq.onzsync(this); //sync shadow if it is implemented with div
    }
    if (this._maximizable && this._maximized) {
      after.push(function () {
        _this._maximized = false;
        _this.setMaximized(true, true);
      });
    }
  };
  /** @internal */
  Panel.prototype.unbind_ = function (skipper, after, keepRod) {
    var _a, _b;
    if (this._inWholeMode) {
      var node = this.$n(),
        oldinfo;
      zk(node).undoVParent(); //no need to fire onVParent in unbind_
      var p = (_b = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent) === null || _b === void 0 ? void 0 : _b.$n();
      if (p && (oldinfo = this._oldNodeInfo)) {
        p.style.position = oldinfo._ppos;
        p.parentNode.scrollTop = oldinfo._scrollTop;
      }
      this._inWholeMode = false;
    }
    zWatch.unlisten({
      onSize: this,
      onHide: this,
      onFloatUp: this
    });
    this.setFloating_(false);
    if (!zk.css3) jq.unzsync(this);
    if (this._shadow) {
      this._shadow.destroy();
      this._shadow = undefined;
    }
    if (this._drag) {
      this._drag.destroy();
      this._drag = undefined;
    }
    // Bug ZK-1467: Resizable panels inside portallayout loses resizability after move
    if (this._sizer) {
      this._sizer.destroy();
      this._sizer = undefined;
    }
    this.domUnlisten_(this.$n_(), 'onMouseMove');
    this.domUnlisten_(this.$n_(), 'onMouseOut');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Panel.prototype._doMouseMove = function (evt) {
    var _a;
    if (this._sizer && zUtl.isAncestor(this, evt.target)) {
      var n = this.$n_(),
        c = Panel_1._insizer(n, zk(n).revisedOffset(), evt.pageX, evt.pageY),
        handle = this.isMovable() ? this.$n('head') : false;
      if (!this._maximized && this._open && c) {
        if (this._backupCursor == undefined) this._backupCursor = n.style.cursor;
        n.style.cursor = c == 1 ? 'n-resize' : c == 2 ? 'ne-resize' : c == 3 ? 'e-resize' : c == 4 ? 'se-resize' : c == 5 ? 's-resize' : c == 6 ? 'sw-resize' : c == 7 ? 'w-resize' : 'nw-resize';
        if (handle) jq(handle).removeClass(this.$s('header-move'));
      } else {
        n.style.cursor = (_a = this._backupCursor) !== null && _a !== void 0 ? _a : '';
        if (handle) jq(handle).addClass(this.$s('header-move'));
      }
    }
  };
  /** @internal */
  Panel.prototype._doMouseOut = function (evt) {
    this.$n_().style.cursor = this._backupCursor || '';
  };
  /** @internal */
  Panel.prototype.doClick_ = function (evt, popupOnly) {
    var maxBtn = this.$n('max'),
      minBtn = this.$n('min'),
      // eslint-disable-next-line zk/noNull
      n = evt.domTarget;
    if (!n.id)
      // eslint-disable-next-line zk/noNull
      n = n.parentNode;
    switch (n) {
      case this.$n('close'):
        this.fire('onClose');
        break;
      case maxBtn:
        this.setMaximized(!this._maximized);
        break;
      case minBtn:
        this.setMinimized(!this._minimized);
        break;
      case this.$n('exp'):
        var body = this.$n('body'),
          open = body ? zk(body).isVisible() : this._open;
        // force to open
        if (!open == this._open) this._open = open;
        this.setOpen(!open);
        break;
      default:
        _super.prototype.doClick_.call(this, evt, popupOnly);
        return;
    }
    evt.stop();
  };
  /** @internal */
  Panel.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      var added = this._bordered() ? '' : this.$s('noborder');
      if (added) scls += (scls ? ' ' : '') + added;
      added = this._open ? '' : this.$s('collapsed');
      if (added) scls += (scls ? ' ' : '') + added;
      if (!(this.getTitle() || this.caption)) scls += ' ' + this.$s('noheader');
      if (!this._rounded()) scls += ' ' + this.$s('noframe');
    }
    return scls;
  };
  /** @internal */
  Panel.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.wgt.Caption) this.caption = child;else if (child instanceof zul.wnd.Panelchildren) {
      this.panelchildren = child;
      this.panelchildren.setVflex(this.getVflex());
      this.panelchildren.setHflex(this.getHflex());
    } else if (child instanceof zul.wgt.Toolbar) {
      if (this.firstChild == child || this.nChildren == (this.caption ? 2 : 1)) this.tbar = child;else if (this.lastChild == child && child.previousSibling instanceof zul.wgt.Toolbar) this.fbar = child;else if (child.previousSibling instanceof zul.wnd.Panelchildren) this.bbar = child;
    }
    this.rerender();
  };
  /** @internal */
  Panel.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.caption) this.caption = undefined;else if (child == this.panelchildren) this.panelchildren = undefined;else if (child == this.tbar) this.tbar = undefined;else if (child == this.bbar) this.bbar = undefined;else if (child == this.fbar) this.fbar = undefined;
    if (!this.childReplacing_) this.rerender();
  };
  /** @internal */
  Panel.prototype.onChildVisible_ = function (child) {
    _super.prototype.onChildVisible_.call(this, child);
    if ((child == this.tbar || child == this.bbar || child == this.fbar) && this.$n()) this._fixHgh();
  };
  //@Override, Bug ZK-1524: caption children should not considered.
  /** @internal */
  Panel.prototype.getChildMinSize_ = function (attr, wgt) {
    var including = true;
    if (wgt == this.caption) {
      if (attr == 'w') {
        including = !!wgt.$n_().style.width;
      } else {
        including = !!wgt.$n_().style.height;
      }
    }
    if (including) {
      return _super.prototype.getChildMinSize_.call(this, attr, wgt);
    } else {
      return 0;
    }
  };
  /** @internal */
  Panel.prototype.isExcludedHflex_ = function () {
    if (zk.isLoaded('zkmax.layout') && this.parent instanceof zkmax.layout.Portalchildren) {
      var p = this.parent;
      if (p.parent) return p.parent.isVertical();
    }
    return false;
  };
  /** @internal */
  Panel.prototype.isExcludedVflex_ = function () {
    if (zk.isLoaded('zkmax.layout') && this.parent instanceof zkmax.layout.Portalchildren) {
      var p = this.parent;
      if (p.parent) return !p.parent.isVertical();
    }
    return false;
  };
  /** @internal */
  Panel.prototype.getCollapseOpenIconClass_ = function () {
    return 'z-icon-angle-up';
  };
  /** @internal */
  Panel.prototype.getCollapseCloseIconClass_ = function () {
    return 'z-icon-angle-down';
  };
  /** @internal */
  Panel.prototype.getClosableIconClass_ = function () {
    return 'z-icon-times';
  };
  /** @internal */
  Panel.prototype.getMaximizableIconClass_ = function () {
    return 'z-icon-expand';
  };
  /** @internal */
  Panel.prototype.getMaximizedIconClass_ = function () {
    return 'z-icon-compress';
  };
  /** @internal */
  Panel.prototype.getMinimizableIconClass_ = function () {
    return 'z-icon-minus';
  };
  //drag
  /** @internal */
  Panel._startmove = function (dg) {
    dg.control._hideShadow();
    //Bug #1568393: we have to change the percetage to the pixel.
    var el = dg.node;
    if (el.style.top && el.style.top.includes('%')) el.style.top = el.offsetTop + 'px';
    if (el.style.left && el.style.left.includes('%')) el.style.left = el.offsetLeft + 'px';
    //zkau.closeFloats(cmp, handle);
  };
  /** @internal */
  Panel._ignoremove = function (dg, pointer, evt) {
    var wgt = dg.control,
      tar = evt.domTarget;
    if (!tar.id) tar = tar.parentNode;
    switch (tar) {
      case wgt.$n('close'):
      case wgt.$n('max'):
      case wgt.$n('min'):
      case wgt.$n('exp'):
        return true;
      //ignore special buttons
    }
    return false;
  };
  /** @internal */
  Panel._aftermove = function (dg, evt) {
    var wgt = dg.control;
    wgt.zsync();
    zk(wgt).redoCSS(-1, {
      'fixFontIcon': true
    });
  };
  /** @internal */
  Panel._ignoresizing = function (dg, pointer, evt) {
    var el = dg.node,
      wgt = dg.control;
    if (wgt._maximized || !wgt._open) return true;
    var offs = zk(el).revisedOffset(),
      v = Panel_1._insizer(el, offs, pointer[0], pointer[1]);
    if (v) {
      wgt._hideShadow();
      dg.z_dir = v;
      dg.z_box = {
        top: offs[1],
        left: offs[0],
        height: el.offsetHeight,
        width: el.offsetWidth,
        minHeight: zk.parseInt(wgt.getMinheight()),
        minWidth: zk.parseInt(wgt.getMinwidth())
      };
      dg.z_orgzi = el.style.zIndex;
      return false;
    }
    return true;
  };
  var Panel_1;
  // drag sizing
  /** @internal */
  Panel._startsizing = zul.wnd.Window._startsizing;
  /** @internal */
  Panel._ghostsizing = zul.wnd.Window._ghostsizing;
  /** @internal */
  Panel._endghostsizing = zul.wnd.Window._endghostsizing;
  /** @internal */
  Panel._insizer = zul.wnd.Window._insizer;
  /** @internal */
  Panel._snapsizing = zul.wnd.Window._snapsizing;
  /** @internal */
  Panel._aftersizing = zul.wnd.Window._aftersizing;
  /** @internal */
  Panel._drawsizing = zul.wnd.Window._drawsizing;
  Panel = Panel_1 = __decorate([zk.WrapClass('zul.wnd.Panel')], Panel);
  return Panel;
}(zul.Widget);
exports.Panel = Panel;
var PanelSkipper = /** @class */function (_super) {
  __extends(PanelSkipper, _super);
  function PanelSkipper(p) {
    var _this = _super.call(this) || this;
    _this._p = p;
    return _this;
  }
  PanelSkipper.prototype.skip = function (wgt, skipId) {
    var skip = jq(skipId || wgt.uuid + '-body', zk)[0];
    if (skip) {
      skip.parentNode.removeChild(skip);
      //don't use jq to remove, since it unlisten events
      return skip;
    }
  };
  PanelSkipper.prototype.restore = function (wgt, skip) {
    _super.prototype.restore.call(this, wgt, skip);
    this._p.zsync();
  };
  PanelSkipper = __decorate([zk.WrapClass('zul.wnd.PanelSkipper')], PanelSkipper);
  return PanelSkipper;
}(zk.Skipper);
exports.PanelSkipper = PanelSkipper;
/** @class zul.wnd.PanelRenderer
 * The renderer used to render a panel.
 * It is designed to be overriden
 * @since 5.0.5
 */
exports.PanelRenderer = {
  /**
   * Check the panel whether to render the rounded frame.
   *
   * @param wgt - the window
   */
  isFrameRequired: function (wgt) {
    return true;
  }
};
zul.wnd.PanelRenderer = exports.PanelRenderer;
window.zul.wnd.Panel_.Panel = Panel;
window.zul.wnd.Panel_.PanelSkipper = PanelSkipper;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wnd/Panelchildren.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wnd/Panelchildren.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.wnd) window.zul.wnd = {};
if (!window.zul.wnd.Panelchildren_) window.zul.wnd.Panelchildren_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Panelchildren = void 0;
/* Panelchildren.ts

    Purpose:

    Description:

    History:
        Mon Jan 12 18:31:03     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Panelchildren is used for {@link zul.wnd.Panel} component to manage each
 * child who will be shown in the body of Panel.
 * Note that the size of Panelchildren is automatically calculated by Panel so both
 * {@link setWidth} and {@link setHeight} are read-only.
 *
 * @defaultValue {@link getZclass}: z-panelchildren.
 */
var Panelchildren = /** @class */function (_super) {
  __extends(Panelchildren, _super);
  function Panelchildren() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * This method is unsupported. Please use {@link zul.wnd.Panel.setHeight} instead.
   */
  Panelchildren.prototype.setHeight = function (height) {
    // Empty on purpose. Shoudn't do anything.
    return this;
  };
  /**
   * This method is unsupported. Please use {@link zul.wnd.Panel.setWidth} instead.
   */
  Panelchildren.prototype.setWidth = function (width) {
    // Empty on purpose. Shoudn't do anything.
    return this;
  };
  // super
  /** @internal */
  Panelchildren.prototype.domClass_ = function (no) {
    var out = [],
      /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (scls) out.push( /*safe*/scls);
    if (!(no === null || no === void 0 ? void 0 : no.zclass)) {
      var /*safe*/zcls = this.getZclass(),
        parent = this.parent;
      if (!parent.getTitle() && !parent.caption) out.push( /*safe*/zcls + '-noheader');
      if (!parent._bordered()) out.push( /*safe*/zcls + '-noborder');
    }
    return out.join(' ');
  };
  /** @internal */
  Panelchildren.prototype.updateDomStyle_ = function () {
    _super.prototype.updateDomStyle_.call(this);
    if (this.desktop) zUtl.fireSized(this.parent);
  };
  Panelchildren = __decorate([zk.WrapClass('zul.wnd.Panelchildren')], Panelchildren);
  return Panelchildren;
}(zul.ContainerWidget);
exports.Panelchildren = Panelchildren;
window.zul.wnd.Panelchildren_.Panelchildren = Panelchildren;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wnd/Window.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wnd/Window.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Window.ts

    Purpose:

    Description:

    History:
        Mon Nov 17 17:52:31     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** The window related widgets, such as window and panel.
 */
//zk.$package('zul.wnd');
if (!window.zul) window.zul = {};
if (!window.zul.wnd) window.zul.wnd = {};
if (!window.zul.wnd.Window_) window.zul.wnd.Window_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WindowRenderer = exports.Skipper = exports.Window = void 0;
var _modals = [],
  _lastfocus;
window.zul.wnd.Window_._syncMaximized = function (wgt) {
  if (!wgt._lastSize) return;
  var node = wgt.$n_(),
    floated = wgt._mode != 'embedded',
    $op = floated ? jq(node).offsetParent() : jq(node).parent(),
    zkop = $op.zk,
    s = node.style;
  s.width = jq.px0(zkop.clientWidthDoubleValue() - zkop.paddingWidth());
  s.height = jq.px0(zkop.clientHeightDoubleValue() - zkop.paddingHeight());
}; //drag move
window.zul.wnd.Window_._startmove = function (dg) {
  //Bug #1568393: we have to change the percetage to the pixel.
  var el = dg.node;
  if (el.style.top && el.style.top.includes('%')) el.style.top = el.offsetTop + 'px';
  if (el.style.left && el.style.left.includes('%')) el.style.left = el.offsetLeft + 'px';
  //ZK-1309: Add a flag to identify is dragging or not in onFloatUp()
  //ZK-1662: refix ZK-1309
  //dg.control._isDragging = true;
  zWatch.fire('onFloatUp', dg.control); //notify all
};
window.zul.wnd.Window_._ghostmove = function (dg, ofs, evt) {
  var wnd = dg.control,
    el = dg.node,
    $el = jq(el),
    $top = $el.find('>div:first'),
    top = $top[0],
    $fakeT = jq(top).clone(),
    fakeT = $fakeT[0],
    /*safe*/zcls = wnd.getZclass();
  window.zul.wnd.Window_._hideShadow(wnd);
  jq(document.body).prepend(DOMPurify.sanitize('<div id="zk_wndghost" class="' + zcls + '-move-ghost" style="position:absolute;' + 'top:' + jq.px(ofs[1]) + '; left:' + jq.px(ofs[0]) + ';' + 'width:' + jq.px($el.width() + zk(el).padBorderWidth()) + ';' + 'height:' + jq.px($el.height() + zk(el).padBorderHeight()) + ';' + 'z-index:' + /*safe*/el.style.zIndex + '"><dl></dl></div>'));
  dg._wndoffs = ofs;
  el.style.visibility = 'hidden';
  var h = el.offsetHeight - wnd._titleHeight();
  el = jq('#zk_wndghost')[0];
  var f = el.firstChild;
  f.style.height = jq.px0(zk(f).revisedHeight(h));
  el.insertBefore(fakeT, el.lastChild);
  return el;
};
window.zul.wnd.Window_._endghostmove = function (dg, origin) {
  var el = dg.node; //ghost
  origin.style.top = jq.px(origin.offsetTop + el.offsetTop - dg._wndoffs[1]);
  origin.style.left = jq.px(origin.offsetLeft + el.offsetLeft - dg._wndoffs[0]);
  document.body.style.cursor = '';
  zWatch.fire('onMove', undefined); //Bug ZK-1372: hide applet when overlapped
};
window.zul.wnd.Window_._ignoremove = function (dg, pointer, evt) {
  var el = dg.node,
    wgt = dg.control,
    tar = evt.domTarget;
  if (!tar.id) tar = tar.parentNode;
  switch (tar) {
    case wgt.$n('close'):
    case wgt.$n('max'):
    case wgt.$n('min'):
      return true;
    //ignore special buttons
  }
  var wtar = zk.Widget.$(tar);
  if (wgt != wtar && wgt.caption != wtar) return true; //ignore child widget of caption, Bug B50-3166874
  if (!wgt.isSizable() || el.offsetTop + 4 < pointer[1] && el.offsetLeft + 4 < pointer[0] && el.offsetLeft + el.offsetWidth - 4 > pointer[0]) return false; //accept if not sizable or not on border
  return true;
};
window.zul.wnd.Window_._aftermove = function (dg, evt) {
  dg.node.style.visibility = '';
  var wgt = dg.control;
  //ZK-1309: Add a flag to identify is dragging or not in onFloatUp()
  //ZK-1662: refix ZK-1309
  //delete wgt._isDragging;
  // Bug for ZK-385 clear position value after move
  // ZK-4007: shouldn't clear position if nocenter
  if (wgt._position && wgt._position != 'parent' && wgt._position != 'nocenter') {
    wgt._position = undefined;
  }
  wgt.zsync();
  wgt._fireOnMove(evt.data);
  zk(wgt).redoCSS(-1, {
    'fixFontIcon': true
  });
};
window.zul.wnd.Window_._doOverlapped = function (wgt) {
  var pos = wgt._position,
    n = wgt.$n_(),
    $n = zk(n);
  if (!pos && (!n.style.top || !n.style.left)) {
    var xy = $n.revisedOffset();
    //ZK-1391: use revisedOffset() only if style doesn't specify left/top value
    if (!n.style.left) {
      n.style.left = jq.px(xy[0]);
    }
    if (!n.style.top) {
      n.style.top = jq.px(xy[1]);
    }
  } else if (pos == 'parent') window.zul.wnd.Window_._posByParent(wgt);
  $n.makeVParent();
  // B70-ZK-2067: Should pass widget as parameter not DOM element.
  zWatch.fireDown('onVParent', wgt);
  wgt.zsync();
  window.zul.wnd.Window_._updDomPos(wgt);
  wgt.setTopmost();
  window.zul.wnd.Window_._makeFloat(wgt);
};
window.zul.wnd.Window_._doModal = function (wgt) {
  var pos = wgt._position,
    n = wgt.$n(),
    $n = zk(n);
  if (pos == 'parent') window.zul.wnd.Window_._posByParent(wgt);
  $n.makeVParent();
  // B70-ZK-2067: Should pass widget as parameter not DOM element.
  zWatch.fireDown('onVParent', wgt);
  wgt.zsync();
  window.zul.wnd.Window_._updDomPos(wgt, true, false, true);
  //Note: modal must be visible
  var realVisible = wgt.isRealVisible();
  wgt.setTopmost();
  if (!wgt._mask) {
    var anchor = wgt._shadowWgt ? wgt._shadowWgt.getBottomElement() : undefined;
    wgt._mask = new zk.eff.FullMask({
      id: wgt.uuid + '-mask',
      anchor: anchor ? anchor : wgt.$n(),
      //bug 1510218: we have to make it as a sibling
      zIndex: wgt._zIndex,
      visible: realVisible
    });
    jq('#' + wgt.uuid + '-mask').append( /*safe*/'<div id="' + /*safe*/wgt.uuid + '-mask-a" style="top:0;left:0" class="z-focus-a" aria-hidden="true" tabindex="-1"></div>');
    wgt._anchor = jq('#' + wgt.uuid + '-mask-a')[0];
  }
  if (realVisible) window.zul.wnd.Window_._markModal(wgt);
  window.zul.wnd.Window_._makeFloat(wgt);
};
window.zul.wnd.Window_._markModal = function (wgt) {
  zk.currentModal = wgt;
  var wnd = _modals[0],
    fc = zk.currentFocus;
  if (wnd) wnd._lastfocus = fc;else _lastfocus = fc;
  _modals.unshift(wgt);
  //We have to use setTimeout:
  //1) au's focus uses wgt.focus(0), i.e.,
  //   focus might have been changed to its decendant (Z30-focus.zul)
  //2) setVisible might use animation
  setTimeout(function () {
    zk.afterAnimate(function () {
      if (!zUtl.isAncestor(wgt, zk.currentFocus)) {
        wgt.focus();
      }
    }, -1);
  });
};
window.zul.wnd.Window_._unmarkModal = function (wgt) {
  _modals.$remove(wgt);
  if (zk.currentModal == wgt) {
    var wnd = zk.currentModal = _modals[0],
      fc = wnd ? wnd._lastfocus : _lastfocus;
    if (!wnd) _lastfocus = undefined;
    if (!fc || !fc.desktop) fc = wnd;
    if (fc) {
      if (wgt._updDOFocus === false) wgt._updDOFocus = fc; //let _updDomOuter handle it
      else fc.focus(0); // use timeout for the bug 3057311
      // use 0 instead of 10, otherwise it will cause this bug 1936366
    }
  }
  wgt._lastfocus = undefined;
};
/* Must be called before calling makeVParent. */
window.zul.wnd.Window_._posByParent = function (wgt) {
  var n = wgt.$n_(),
    ofs = zk(zk(n).vparentNode(true)).revisedOffset();
  wgt._offset = ofs;
  n.style.left = jq.px(ofs[0] + zk.parseInt(wgt._left));
  n.style.top = jq.px(ofs[1] + zk.parseInt(wgt._top));
};
window.zul.wnd.Window_._updDomOuter = function (wgt, opts) {
  // B50-ZK-462
  wgt._notSendMaximize = !opts || !opts.sendOnMaximize;
  wgt._updDOFocus = false; //it might be set by unbind_
  try {
    var last = wgt._lastSize;
    wgt.rerender(wgt._skipper);
    if (last) {
      wgt._lastSize = last;
      // ZK-1826: should restore width and height
      var n = wgt.$n();
      if (n) {
        var s = n.style;
        // ZK-2041: should skip undefined value, or throws exception in ie8
        if (last.h) s.height = last.h;
        if (last.w) s.width = last.w;
        wgt._fixHgh(false);
      }
    }
    // NOTE: At this point, unbind_ would have set _updDOFocus to a zk.Widget.
    var cf = wgt._updDOFocus;
    if (cf)
      //asked by unbind_
      cf.focus(10);
  } finally {
    delete wgt._updDOFocus;
    delete wgt._notSendMaximize;
  }
}; //minTop - whether to at most 100px
window.zul.wnd.Window_._updDomPos = function (wgt, force, posParent, minTop) {
  if (!wgt.desktop || wgt._mode == 'embedded') return;
  var n = wgt.$n_(),
    pos = wgt._position;
  if (pos == 'parent') {
    if (posParent) window.zul.wnd.Window_._posByParent(wgt);
    return;
  }
  if (!pos && !force) return;
  var st = n.style;
  st.position = 'absolute'; //just in case
  var ol = st.left,
    ot = st.top;
  if (pos != 'nocenter') zk(n).center(pos);
  var sdw = wgt._shadowWgt;
  if (pos && sdw) {
    var opts = sdw.opts,
      l = n.offsetLeft,
      t = n.offsetTop;
    if (pos.includes('left') && opts.left < 0) st.left = jq.px(l - opts.left);else if (pos.includes('right') && opts.right > 0) st.left = jq.px(l - opts.right);
    if (pos.includes('top') && opts.top < 0) st.top = jq.px(t - opts.top);else if (pos.includes('bottom') && opts.bottom > 0) st.top = jq.px(t - opts.bottom);
  }
  if (minTop && !pos) {
    //adjust y (to upper location)
    var top = zk.parseInt(n.style.top),
      y = jq.innerY();
    if (y) {
      var y1 = top - y;
      if (y1 > 100) n.style.top = jq.px0(top - (y1 - 100));
    } else if (top > 100) n.style.top = '100px';
  }
  wgt.zsync();
  if (ol != st.left || ot != st.top) wgt._fireOnMove();
};
window.zul.wnd.Window_._hideShadow = function (wgt) {
  var shadow = wgt._shadowWgt;
  if (shadow) shadow.hide();
};
window.zul.wnd.Window_._makeSizer = function (wgt) {
  if (!wgt._sizer) {
    wgt.domListen_(wgt.$n_(), 'onMouseMove');
    wgt.domListen_(wgt.$n_(), 'onMouseOut');
    wgt._sizer = new zk.Draggable(wgt, undefined, {
      stackup: true,
      overlay: true,
      // ZK-817
      draw: Window._drawsizing,
      snap: Window._snapsizing,
      initSensitivity: 0,
      starteffect: Window._startsizing,
      ghosting: Window._ghostsizing,
      endghosting: Window._endghostsizing,
      ignoredrag: Window._ignoresizing,
      endeffect: Window._aftersizing
    });
  }
};
window.zul.wnd.Window_._makeFloat = function (wgt) {
  var handle = wgt.$n('cap');
  if (handle && !wgt._drag) {
    jq(handle).addClass(wgt.getZclass() + '-header-move');
    wgt._drag = new zk.Draggable(wgt, undefined, {
      handle: handle,
      stackup: true,
      fireOnMove: false,
      starteffect: Window._startmove,
      ghosting: Window._ghostmove,
      endghosting: Window._endghostmove,
      ignoredrag: Window._ignoremove,
      endeffect: Window._aftermove,
      zIndex: '99999' //Bug 2929590
    });
  }
};
window.zul.wnd.Window_._isModal = function (mode) {
  return mode == 'modal' || mode == 'highlighted';
}; //Bug ZK-1689: get relative position to parent.
window.zul.wnd.Window_._getPosByParent = function (wgt, l, t) {
  var pos = wgt._position,
    left = zk.parseInt(l),
    top = zk.parseInt(t),
    x = 0,
    y = 0;
  if (pos == 'parent') {
    var vp = zk(wgt.$n()).vparentNode();
    if (vp) {
      var ofs = zk(vp).revisedOffset();
      x = ofs[0];
      y = ofs[1];
    }
  }
  return [jq.px(left - x), jq.px(top - y)];
};
/**
 * A window.
 *
 * <p>Unlike other elements, each {@link Window} is an independent ID space.
 * It means a window and all its descendants forms a ID space and
 * the ID of each of them is unique in this space.
 * You could retrieve any of them in this space by calling {@link Window.$f}.
 *
 * <p>If a window X is a descendant of another window Y, X's descendants
 * are not visible in Y's space. To retrieve a descendant, say Z, of X,
 * you have to invoke Y.$f('X').$f('Z').
 *
 * <p>Events:<br/>
 * onMove, onOpen, onMaximize, onMinimize, and onClose.<br/>
 * Note: to have better performance, onOpen is sent only if a
 * non-deferrable event listener is registered.
 *
 * <p>`onClose` is sent when the close button is pressed
 * (if {@link isClosable} is true). The window has to detach or hide
 * the window.
 *
 * <p>On the other hand, `onOpen` is sent when a popup
 * window (i.e., {@link getMode} is popup) is closed due to user's activity
 * (such as press ESC). This event is only a notification.
 * In other words, the popup is hidden before the event is sent to the server.
 * The application cannot prevent the window from being hidden.
 *
 * @defaultValue {@link getZclass}: z-window.
 */
var Window = /** @class */function (_super) {
  __extends(Window, _super);
  function Window(props) {
    var _this = _super.call(this, props) || this;
    /** @internal */
    _this._mode = 'embedded';
    /** @internal */
    _this._border = 'none';
    /** @internal */
    _this._minheight = 100;
    /** @internal */
    _this._minwidth = 200;
    /** @internal */
    _this._shadow = true;
    /** @internal */
    _this._tabindex = 0;
    /** @internal */
    _this._nativebar = true;
    _this._fellows = {};
    _this._lastSize = {};
    // NOTE: Prior to TS migration, super is called after _fellows/_lastSize
    // are initialized above, but it seems to not matter, as nowhere does super
    // nor do zkcml overrides use _fellows/_lastSize during initialization.
    _this.listen({
      onMaximize: _this,
      onClose: _this,
      onMove: _this,
      onSize: _this.onSizeEvent,
      onZIndex: _this
    }, -1000);
    _this._skipper = new zul.wnd.Skipper(_this);
    return _this;
  }
  Window_1 = Window;
  /**
   * Sets the mode to overlapped, popup, modal, embedded or highlighted.
   *
   * @param name - the mode which could be one of
   * "embedded", "overlapped", "popup", "modal", "highlighted".
   * Note: it cannot be "modal". Use {@link doModal} instead.
   */
  Window.prototype.setMode = function (mode, opts) {
    var o = this._mode;
    this._mode = mode;
    if (o !== mode || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  Window.prototype.getMode = function () {
    return this._mode;
  };
  /**
   * Sets the title.
   */
  Window.prototype.setTitle = function (title, opts) {
    var o = this._title;
    this._title = title;
    if (o !== title || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.caption) this.caption.updateDomContent_(); // B50-ZK-313
      else window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns the title.
   * Besides this attribute, you could use {@link zul.wgt.Caption} to define
   * a more sophisticated caption (aka., title).
   * <p>If a window has a caption whose label ({@link zul.wgt.Caption#getLabel})
   * is not empty, then this attribute is ignored.
   * @defaultValue empty.
   */
  Window.prototype.getTitle = function () {
    return this._title;
  };
  /**
   * Sets the border (either none or normal).
   * @param border - the border. If null or "0", "none" is assumed.
   */
  Window.prototype.setBorder = function (border, opts) {
    var o = this._border;
    this._border = border;
    if (o !== border || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns the border.
   * The border actually controls what the content style class is
   * is used. In fact, the name of the border (except "normal")
   * is generate as part of the style class used for the content block.
   * Refer to {@link getContentSclass} for more details.
   *
   * @defaultValue `"none"`.
   */
  Window.prototype.getBorder = function () {
    return this._border;
  };
  /**
   * Sets whether to show a close button on the title bar.
   * If closable, a button is displayed and the onClose event is sent
   * if an user clicks the button.
   *
   * @defaultValue `false`.
   *
   * <p>Note: the close button won't be displayed if no title or caption at all.
   */
  Window.prototype.setClosable = function (closable, opts) {
    var o = this._closable;
    this._closable = closable;
    if (o !== closable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns whether to show a close button on the title bar.
   */
  Window.prototype.isClosable = function () {
    return !!this._closable;
  };
  /**
   * Sets whether the window is sizable.
   * If true, an user can drag the border to change the window width.
   * @defaultValue `false`.
   */
  Window.prototype.setSizable = function (sizable, opts) {
    var o = this._sizable;
    this._sizable = sizable;
    if (o !== sizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        if (sizable) window.zul.wnd.Window_._makeSizer(this);else if (this._sizer) {
          this._sizer.destroy();
          this._sizer = undefined;
        }
      }
    }
    return this;
  };
  /**
   * @returns whether the window is sizable.
   */
  Window.prototype.isSizable = function () {
    return !!this._sizable;
  };
  /**
   * Sets whether to display the maximizing button and allow the user to maximize
   * the window, when a window is maximized, the button will automatically
   * change to a restore button with the appropriate behavior already built-in
   * that will restore the window to its previous size.
   * @defaultValue `false`.
   *
   * <p>Note: the maximize button won't be displayed if no title or caption at all.
   */
  Window.prototype.setMaximizable = function (maximizable, opts) {
    var o = this._maximizable;
    this._maximizable = maximizable;
    if (o !== maximizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns whether to display the maximizing button and allow the user to maximize
   * the window.
   * @defaultValue `false`.
   */
  Window.prototype.isMaximizable = function () {
    return !!this._maximizable;
  };
  /**
   * Sets whether to display the minimizing button and allow the user to minimize
   * the window. Note that this button provides no implementation -- the behavior
   * of minimizing a window is implementation-specific, so the MinimizeEvent
   * event must be handled and a custom minimize behavior implemented for this
   * option to be useful.
   *
   * @defaultValue `false`.
   * <p>Note: the maximize button won't be displayed if no title or caption at all.
   */
  Window.prototype.setMinimizable = function (minimizable, opts) {
    var o = this._minimizable;
    this._minimizable = minimizable;
    if (o !== minimizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns whether to display the minimizing button and allow the user to minimize
   * the window.
   * @defaultValue `false`.
   */
  Window.prototype.isMinimizable = function () {
    return !!this._minimizable;
  };
  /**
   * Sets whether the window is maximized, and then the size of the window will depend
   * on it to show a appropriate size. In other words, if true, the size of the
   * window will count on the size of its offset parent node whose position is
   * absolute (by not {@link doEmbedded}) or its parent node. Otherwise, its size
   * will be original size. Note that the maximized effect will run at client's
   * sizing phase not initial phase.
   *
   * @defaultValue `false`.
   */
  Window.prototype.setMaximized = function (maximized, fromServer, opts) {
    var o = this._maximized;
    this._maximized = maximized;
    if (o !== maximized || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var node = this.$n();
      if (node) {
        var isRealVisible = this.isRealVisible();
        if (!isRealVisible && maximized) return this;
        var l,
          t,
          w,
          h,
          s = node.style,
          up = this.getMaximizableIconClass_(),
          down = this.getMaximizedIconClass_();
        if (maximized) {
          jq(this.$n_('max')).addClass(this.$s('maximized')).attr('title', msgzul.PANEL_RESTORE).children('.' + up).removeClass(up).addClass(down);
          var floated = this._mode != 'embedded',
            $op = floated ? jq(node).offsetParent() : jq(node).parent(),
            zkop = $op.zk;
          l = s.left;
          t = s.top;
          w = s.width;
          h = s.height;
          // prevent the scroll bar.
          s.top = '-10000px';
          s.left = '-10000px';
          s.width = jq.px0(zkop.clientWidthDoubleValue() - (!floated ? zkop.paddingWidth() : 0));
          s.height = jq.px0(zkop.clientHeightDoubleValue() - (!floated ? zkop.paddingHeight() : 0));
          this._lastSize = {
            l: l,
            t: t,
            w: w,
            h: h
          };
          // restore.
          s.top = '0';
          s.left = '0';
          // resync
          w = s.width;
          h = s.height;
        } else {
          var max = this.$n_('max'),
            $max = jq(max);
          $max.removeClass(this.$s('maximized')).attr('title', msgzul.PANEL_MAXIMIZE).children('.' + down).removeClass(down).addClass(up);
          if (this._lastSize) {
            s.left = this._lastSize.l;
            s.top = this._lastSize.t;
            s.width = this._lastSize.w;
            s.height = this._lastSize.h;
            this._lastSize = undefined;
          }
          l = s.left;
          t = s.top;
          w = s.width;
          h = s.height;
          var body = this.$n('cave');
          if (body) body.style.width = body.style.height = '';
        }
        if (!fromServer || isRealVisible) {
          this._visible = true;
          // B50-ZK-462: Window fire unexpected onMaximize event
          if (!this._notSendMaximize) {
            var p = window.zul.wnd.Window_._getPosByParent(this, l, t); //Bug ZK-1689
            this.fire('onMaximize', {
              left: p[0],
              top: p[1],
              width: w,
              height: h,
              maximized: maximized,
              fromServer: fromServer
            });
          }
        }
        if (isRealVisible) zUtl.fireSized(this);
      }
    }
    return this;
  };
  /**
   * @returns whether the window is maximized.
   */
  Window.prototype.isMaximized = function () {
    return !!this._maximized;
  };
  /**
   * Sets whether the window is minimized.
   * @defaultValue `false`.
   */
  Window.prototype.setMinimized = function (minimized, fromServer, opts) {
    var o = this._minimized;
    this._minimized = minimized;
    if (o !== minimized || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._maximized) this.setMaximized(false);
      var node = this.$n();
      if (node) {
        var s = node.style;
        if (minimized) {
          zWatch.fireDown('onHide', this);
          jq(node).hide();
        } else {
          jq(node).show();
          zUtl.fireShown(this);
        }
        if (!fromServer) {
          this._visible = false;
          this.zsync();
          var p = window.zul.wnd.Window_._getPosByParent(this, s.left, s.top); //Bug ZK-1689
          this.fire('onMinimize', {
            left: p[0],
            top: p[1],
            width: s.width,
            height: s.height,
            minimized: minimized
          });
        }
      }
    }
    return this;
  };
  /**
   * @returns whether the window is minimized.
   * @defaultValue `false`.
   */
  Window.prototype.isMinimized = function () {
    return !!this._minimized;
  };
  /**
   * Sets the CSS style for the content block of the window.
   * @defaultValue `null`.
   */
  Window.prototype.setContentStyle = function (contentStyle, opts) {
    var o = this._contentStyle;
    this._contentStyle = contentStyle;
    if (o !== contentStyle || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns the CSS style for the content block of the window.
   */
  Window.prototype.getContentStyle = function () {
    return this._contentStyle;
  };
  /**
   * Sets the style class used for the content block.
   */
  Window.prototype.setContentSclass = function (contentSclass, opts) {
    var o = this._contentSclass;
    this._contentSclass = contentSclass;
    if (o !== contentSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomOuter(this);
    }
    return this;
  };
  /**
   * @returns the style class used for the content block.
   */
  Window.prototype.getContentSclass = function () {
    return this._contentSclass;
  };
  /**
   * Sets how to position the window at the client screen.
   * It is meaningless if the embedded mode is used.
   *
   * @param pos - how to position. It can be null (the default), or
   * a combination of the following values (by separating with comma).
   * <dl>
   * <dt>center</dt>
   * <dd>Position the window at the center. {@link setTop} and {@link setLeft}
   * are both ignored.</dd>
   * <dt>left</dt>
   * <dd>Position the window at the left edge. {@link setLeft} is ignored.</dd>
   * <dt>right</dt>
   * <dd>Position the window at the right edge. {@link setLeft} is ignored.</dd>
   * <dt>top</dt>
   * <dd>Position the window at the top edge. {@link setTop} is ignored.</dd>
   * <dt>bottom</dt>
   * <dd>Position the window at the bottom edge. {@link setTop} is ignored.</dd>
   * <dt>parent</dt>
   * <dd>Position the window relative to its parent.
   * That is, the left and top ({@link getTop} and {@link getLeft})
   * is an offset to his parent's let-top corner.</dd>
   * </dl>
   * <p>For example, "left,center" means to position it at the center of
   * the left edge.
   */
  Window.prototype.setPosition = function (position, opts) {
    var o = this._position;
    this._position = position;
    if (o !== position || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.wnd.Window_._updDomPos(this, false, this._visible);
    }
    return this;
  };
  /**
   * @returns how to position the window at the client screen.
   * It is meaningless if the embedded mode is used.
   *
   * @defaultValue `null` which depends on {@link getMode}:
   * If overlapped or popup, {@link setLeft} and {@link setTop} are
   * assumed. If modal or highlighted, it is centered.
   */
  Window.prototype.getPosition = function () {
    return this._position;
  };
  /**
   * Sets the minimum height in pixels allowed for this window.
   * If negative, 100 is assumed.
   * @defaultValue `100`.
   * <p>Note: Only applies when {@link isSizable} = true.
   */
  Window.prototype.setMinheight = function (minheight) {
    this._minheight = minheight;
    return this;
  };
  /**
   * @returns the minimum height.
   * @defaultValue `100`.
   * @returns int
   */
  Window.prototype.getMinheight = function () {
    return this._minheight;
  };
  /**
   * Sets the minimum width in pixels allowed for this window. If negative,
   * 200 is assumed.
   * @defaultValue `200`.
   * <p>Note: Only applies when {@link isSizable} = true.
   */
  Window.prototype.setMinwidth = function (minwidth) {
    this._minwidth = minwidth;
    return this;
  };
  /**
   * @returns the minimum width.
   * @defaultValue `200`.
   * @returns int
   */
  Window.prototype.getMinwidth = function () {
    return this._minwidth;
  };
  /**
   * Sets whether to show the shadow of an overlapped/popup/modal
   * window. It is meaningless if it is an embedded window.
   * @defaultValue `true`.
   */
  Window.prototype.setShadow = function (shadow, opts) {
    var o = this._shadow;
    this._shadow = shadow;
    if (o !== shadow || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._shadow) {
        this.zsync();
      } else if (this._shadowWgt) {
        this._shadowWgt.destroy();
        this._shadowWgt = undefined;
      }
    }
    return this;
  };
  /**
   * @returns whether to show the shadow of an overlapped/popup/modal
   * window. It is meaningless if it is an embedded window.
   */
  Window.prototype.isShadow = function () {
    return this._shadow;
  };
  /**
   * Re-position the window based on the value of {@link getPosition}.
   * @since 5.0.3
   */
  Window.prototype.repos = function () {
    window.zul.wnd.Window_._updDomPos(this, false, this._visible);
  };
  /**
   * Makes this window as overlapped with other components.
   */
  Window.prototype.doOverlapped = function () {
    this.setMode('overlapped');
  };
  /**
   * Makes this window as popup, which is overlapped with other component
   * and auto-hiden when user clicks outside of the window.
   */
  Window.prototype.doPopup = function () {
    this.setMode('popup');
  };
  /**
   * Makes this window as highlited. The visual effect is
   * the similar to the modal window.
   */
  Window.prototype.doHighlighted = function () {
    this.setMode('highlighted');
  };
  /**
   * Makes this window as a modal dialog.
   * It will automatically center the window (ignoring {@link getLeft} and
   * {@link getTop}).
   */
  Window.prototype.doModal = function () {
    this.setMode('modal');
  };
  /**
   * Makes this window as embeded with other components (Default).
   */
  Window.prototype.doEmbedded = function () {
    this.setMode('embedded');
  };
  /** @internal */
  Window.prototype.afterAnima_ = function (visible) {
    _super.prototype.afterAnima_.call(this, visible);
    this.zsync();
  };
  Window.prototype.zsync = function (opts) {
    _super.prototype.zsync.call(this, opts);
    if (this.desktop) {
      if (this._mode == 'embedded') {
        if (this._shadowWgt) {
          this._shadowWgt.destroy();
          this._shadowWgt = undefined;
        }
      } else if (this._shadow) {
        if (!this._shadowWgt) this._shadowWgt = new zk.eff.Shadow(this.$n_(), {
          left: -4,
          right: 4,
          top: -2,
          bottom: 3
        });
        if (this._maximized || this._minimized || !this._visible)
          //since action might be applied, we have to check _visible
          window.zul.wnd.Window_._hideShadow(this);else this._shadowWgt.sync();
      }
      if (this._mask) {
        //ZK-1079
        var n = this._shadowWgt && this._shadowWgt.getBottomElement() || this.$n(); //null if ff3.5 (no shadow/stackup)
        if (n) this._mask.sync(n);
      }
    }
  };
  //event handler//
  Window.prototype.onClose = function () {
    if (!this.inServer)
      //let server handle if in server
      this.parent.removeChild(this); //default: remove
  };
  Window.prototype.onMove = function (evt) {
    this._left = evt.left;
    this._top = evt.top;
    if (this._visible)
      //notify children onMove
      zWatch.fireDown('onMove', this);
  };
  Window.prototype.onMaximize = function (evt) {
    var data = evt.data;
    this._top = data.top;
    this._left = data.left;
    this._height = data.height;
    this._width = data.width;
  };
  Window.prototype.onSizeEvent = function (evt) {
    var data = evt.data,
      node = this.$n_(),
      s = node.style;
    window.zul.wnd.Window_._hideShadow(this);
    if (data.width != s.width) {
      s.width = data.width;
      // ZK-2363
      this._width = s.width;
    }
    if (data.height != s.height) {
      s.height = data.height;
      this._fixHgh();
      // ZK-2363
      this._height = s.height;
    }
    if (data.left != s.left || data.top != s.top) {
      s.left = data.left;
      s.top = data.top;
      this._fireOnMove(evt.keys);
    }
    this.zsync();
    var self = this;
    setTimeout(function () {
      zUtl.fireSized(self);
    });
  };
  Window.prototype.onZIndex = function (evt) {
    this.zsync();
  };
  //watch//
  Window.prototype.onResponse = function (evt) {
    this.onZIndex(evt);
  };
  Window.prototype.onCommandReady = function () {
    if (this.desktop && this._shallSize) {
      this._shallSize = false;
      for (var w = this.firstChild; w; w = w.nextSibling) {
        if (w._nvflex || w._nhflex) {
          zUtl.fireSized(this);
          break;
        }
      }
    }
  };
  Window.prototype.onShow = function (ctl) {
    var w = ctl.origin;
    if (this != w && this._mode != 'embedded' && this.isRealVisible({
      until: w,
      dom: true
    })) {
      zk(this.$n()).cleanVisibility();
      this.zsync();
    }
  };
  Window.prototype.onHide = function (ctl) {
    var w = ctl.origin;
    if (this != w && this._mode != 'embedded' && this.isRealVisible({
      until: w,
      dom: true
    })) {
      //Note: dom:true, since isVisible might be wrong when onHide is called.
      //For example, tab sets selected and then fire onHide, and tabpanel's
      //isVisible returns false (since unselected). Thus, it is better to
      //count on DOM only
      this.$n_().style.visibility = 'hidden';
      this.zsync();
    }
  };
  Window.prototype.onSize = function () {
    window.zul.wnd.Window_._hideShadow(this);
    if (this._maximized) window.zul.wnd.Window_._syncMaximized(this);
    this._fixHgh(true);
    if (this._mode == 'modal') window.zul.wnd.Window_._updDomPos(this, true, false, true); // B70-ZK-2892
    else window.zul.wnd.Window_._updDomPos(this);
    this.zsync();
  };
  Window.prototype.onFloatUp = function (ctl) {
    /*
        * ZK-1309: If window already has mask, ignore onFloatUp routine.
        * The reason is prevent zindex of window change(in `setTopmost()`) when dragging,
        * it will let full-mask is not visible.
        */
    if (!this._visible || this._mode == 'embedded' || this._mask) return; //just in case
    var wgt = ctl.origin;
    if (this._mode == 'popup') {
      for (var floatFound = false; wgt; wgt = wgt.parent) {
        if (wgt == this) {
          if (!floatFound) this.setTopmost();
          return;
        }
        floatFound = floatFound || wgt.isFloating_();
      }
      this.setVisible(false);
      this.fire('onOpen', {
        open: false
      });
    } else for (; wgt; wgt = wgt.parent) {
      if (wgt == this) {
        this.setTopmost();
        return;
      }
      if (wgt.isFloating_()) return;
    }
  };
  /** @internal */
  Window.prototype._fixHgh = function (ignoreVisible /* speed up */) {
    if (ignoreVisible || this.isRealVisible()) {
      var n = this.$n_(),
        hgh = n.style.height,
        cave = this.$n_('cave'),
        cvh = cave.style.height;
      if (!hgh && this._cssflex && this._vflex)
        // due to css flex, need to use offsetHeight
        hgh = n.offsetHeight;
      if (hgh && hgh != 'auto') {
        cave.style.height = jq.px0(this._offsetHeight(n));
      } else if (cvh && cvh != 'auto') {
        cave.style.height = '';
      }
    }
  };
  /** @internal */
  Window.prototype._offsetHeight = function (n) {
    return zk(n).offsetHeight() - this._titleHeight() - zk(n).padBorderHeight();
  };
  /** @internal */
  Window.prototype._titleHeight = function () {
    var cap = this.getTitle() || this.caption ? this.$n('cap') : undefined;
    return cap ? cap.offsetHeight : 0;
  };
  /** @internal */
  Window.prototype._fireOnMove = function (keys) {
    var s = this.$n_().style,
      p = window.zul.wnd.Window_._getPosByParent(this, s.left, s.top); //Bug ZK-1689
    this.fire('onMove', zk.copy({
      left: p[0],
      top: p[1]
    }, keys), {
      ignorable: true
    });
  };
  Window.prototype.setVisible = function (visible) {
    if (this._visible != visible) {
      if (this._maximized) {
        this.setMaximized(false);
      } else if (this._minimized) {
        this.setMinimized(false);
      }
      var modal = window.zul.wnd.Window_._isModal(this._mode),
        p = this.parent;
      if (visible) {
        window.zul.wnd.Window_._updDomPos(this, modal, true, modal);
        if (modal && (!p || p.isRealVisible())) {
          this.setTopmost();
          window.zul.wnd.Window_._markModal(this);
        }
      } else if (modal) window.zul.wnd.Window_._unmarkModal(this);
      _super.prototype.setVisible.call(this, visible);
      if (!visible) this.zsync();
      if (this.isFloating_() && p && !p.isRealVisible()) {
        var n = this.$n_();
        if (this._visible && n.style.display == 'none') {
          this.setDomVisible_(n, false, {
            visibility: true
          });
          this.setDomVisible_(n, true, {
            display: true
          });
        } else if (!this._visible && n.style.display != 'none') {
          this.setDomVisible_(n, false, {
            display: true
          });
        }
      }
    }
    return this;
  };
  Window.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) zUtl.fireSized(this);
    // Note: IE6 is broken, because its offsetHeight doesn't update.
    return this;
  };
  Window.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) zUtl.fireSized(this);
    return this;
  };
  Window.prototype.setTop = function (top) {
    window.zul.wnd.Window_._hideShadow(this);
    _super.prototype.setTop.call(this, top);
    this.zsync();
    return this;
  };
  Window.prototype.setLeft = function (left) {
    window.zul.wnd.Window_._hideShadow(this);
    _super.prototype.setLeft.call(this, left);
    this.zsync();
    return this;
  };
  Window.prototype.setZIndex = function (zIndex, opts) {
    var old = this._zIndex;
    _super.prototype.setZIndex.call(this, zIndex, opts);
    if (old != zIndex) this.zsync();
    return this;
  };
  Window.prototype.setZindex = function (zindex, opts) {
    return this.setZIndex(zindex, opts);
  };
  /** @internal */
  Window.prototype.focus_ = function (timeout) {
    var cap = this.caption;
    if (!zk.mobile) {
      //Bug ZK-1314: avoid focus on input widget to show keyboard on ipad
      for (var w = this.firstChild; w; w = w.nextSibling)
      //B65-ZK-1797: avoid focusing on removed widge when enable client ROD
      if (w.desktop && w != cap && w.focus_(timeout)) return true;
    }
    if (cap === null || cap === void 0 ? void 0 : cap.focus_(timeout)) {
      return true;
    } else if (this._anchor) {
      this._anchor.focus();
      return true;
    }
    return false;
  };
  /** @internal */
  Window.prototype.domClass_ = function (no) {
    var /*safe*/cls = _super.prototype.domClass_.call(this, no),
      bordercls = this._border;
    bordercls = 'normal' == bordercls ? '' : 'none' == bordercls ? 'noborder' : bordercls;
    if (bordercls) cls += ' ' + this.$s(bordercls);
    if (!(this.getTitle() || this.caption)) cls += ' ' + this.$s('noheader');
    cls += ' ' + this.$s(this._mode);
    return cls;
  };
  /** @internal */
  Window.prototype.onChildVisible_ = function (child) {
    _super.prototype.onChildVisible_.call(this, child);
    if (this.desktop) {
      this._shallSize = true;
    }
  };
  /** @internal */
  Window.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.wgt.Caption) {
      this.caption = child;
      this.rerender(this._skipper); // B50-ZK-275
    }
  };
  /** @internal */
  Window.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.caption) {
      this.caption = undefined;
      this.rerender(this._skipper); // B50-ZK-275
    }
    if (this.desktop) {
      this._shallSize = true;
    }
  };
  /** @internal */
  Window.prototype.insertChildHTML_ = function (child, before, desktop) {
    if (!(child instanceof zul.wgt.Caption))
      // B50-ZK-275
      _super.prototype.insertChildHTML_.call(this, child, before, desktop);
  };
  /** @internal */
  Window.prototype.domStyle_ = function (no) {
    var /*safe*/style = _super.prototype.domStyle_.call(this, no);
    if ((!no || !no.visible) && this._minimized) style = 'display:none;' + style;
    if (this._mode != 'embedded') style = 'position:absolute;' + style;
    return style;
  };
  /** @internal */
  Window.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var mode = this._mode;
    zWatch.listen({
      onSize: this
    });
    if (mode != 'embedded') {
      zWatch.listen({
        onFloatUp: this,
        onHide: this,
        onShow: this
      });
      this.setFloating_(true);
      if (window.zul.wnd.Window_._isModal(mode)) window.zul.wnd.Window_._doModal(this);else window.zul.wnd.Window_._doOverlapped(this);
    }
    if (this._sizable) window.zul.wnd.Window_._makeSizer(this);
    if (this._maximizable && this._maximized) {
      var self = this;
      after.push(function () {
        self._maximized = false;
        self.setMaximized(true, true);
      });
    }
    if (this._mode != 'embedded' && !zk.css3) {
      jq.onzsync(this); //sync shadow if it is implemented with div
      zWatch.listen({
        onResponse: this
      });
    }
    zWatch.listen({
      onCommandReady: this
    });
  };
  Window.prototype.detach = function () {
    // ZK-3910: the side effect of the removing iframe, the ckeditor would throw the error message
    // at console. It should unbind ckeditor before remove it. Put here can works well on every browser.
    this.unbindChildren_();
    // ZK-2247: remove iframe to prevent load twice
    if (zk.chrome) {
      var n = this.$n();
      if (n) {
        var $jq = jq(n).find('iframe');
        if ($jq.length) $jq.hide().remove();
      }
    }
    _super.prototype.detach.call(this);
  };
  /** @internal */
  Window.prototype.unbind_ = function (skipper, after, keepRod) {
    var node = this.$n_();
    zk(node).beforeHideOnUnbind();
    node.style.visibility = 'hidden'; //avoid unpleasant effect
    if (!zk.css3) jq.unzsync(this);
    //we don't check this._mode here since it might be already changed
    if (this._shadowWgt) {
      this._shadowWgt.destroy();
      this._shadowWgt = undefined;
    }
    if (this._drag) {
      this._drag.destroy();
      this._drag = undefined;
    }
    if (this._sizer) {
      this._sizer.destroy();
      this._sizer = undefined;
    }
    if (this._mask) {
      if (this._anchor) this._anchor = undefined;
      this._mask.destroy();
      this._mask = undefined;
    }
    zk(node).undoVParent(); //no need to fire onVParent in unbind_
    zWatch.unlisten({
      onFloatUp: this,
      onSize: this,
      onShow: this,
      onHide: this,
      onResponse: this,
      onCommandReady: this
    });
    this.setFloating_(false);
    window.zul.wnd.Window_._unmarkModal(this);
    this.domUnlisten_(this.$n_(), 'onMouseMove');
    this.domUnlisten_(this.$n_(), 'onMouseOut');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Window.prototype._doMouseMove = function (evt) {
    if (this._sizer && evt.target == this) {
      var n = this.$n_(),
        c = Window_1._insizer(n, zk(n).revisedOffset(), evt.pageX, evt.pageY),
        handle = this._mode == 'embedded' ? false : this.$n('cap');
      if (!this._maximized && c) {
        if (this._backupCursor == undefined) this._backupCursor = n.style.cursor;
        n.style.cursor = c == 1 ? 'n-resize' : c == 2 ? 'ne-resize' : c == 3 ? 'e-resize' : c == 4 ? 'se-resize' : c == 5 ? 's-resize' : c == 6 ? 'sw-resize' : c == 7 ? 'w-resize' : 'nw-resize';
        if (handle) jq(handle).removeClass(this.$s('header-move'));
      } else {
        n.style.cursor = this._backupCursor || ''; // bug #2977948
        if (handle) jq(handle).addClass(this.$s('header-move'));
      }
    }
  };
  /** @internal */
  Window.prototype._doMouseOut = function (evt) {
    this.$n_().style.cursor = this._backupCursor || '';
  };
  /** @internal */
  Window.prototype.doClick_ = function (evt, popupOnly) {
    var n = evt.domTarget;
    if (!n.id) n = n.parentNode;
    if (n) {
      //If node does not exist, should propagation event directly
      switch (n) {
        case this.$n('close'):
          this.fire('onClose');
          break;
        case this.$n('max'):
          this.setMaximized(!this._maximized);
          break;
        case this.$n('min'):
          this.setMinimized(!this._minimized);
          break;
        default:
          _super.prototype.doClick_.call(this, evt, popupOnly);
          return;
      }
      evt.stop();
    }
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  //@Override, children minimum flex might change window dimension, have to re-position. bug #3007908.
  /** @internal */
  Window.prototype.afterChildrenMinFlex_ = function (orient) {
    _super.prototype.afterChildrenMinFlex_.call(this, orient);
    if (window.zul.wnd.Window_._isModal(this._mode))
      //win hflex="min"
      window.zul.wnd.Window_._updDomPos(this, true, false, true); //force re-position since window width might changed. //B70-ZK-2891
  };
  //@Override, children minimize flex might change window dimension, have to re-position. bug #3007908.
  /** @internal */
  Window.prototype.afterChildrenFlex_ = function (cwgt) {
    _super.prototype.afterChildrenFlex_.call(this, cwgt);
    if (window.zul.wnd.Window_._isModal(this._mode)) window.zul.wnd.Window_._updDomPos(this, true, false, true); //force re-position since window width might changed. //B70-ZK-2891
  };
  //@Override, Bug ZK-1524: caption children should not considered.
  /** @internal */
  Window.prototype.getChildMinSize_ = function (attr, wgt) {
    var including = true;
    if (wgt == this.caption) {
      if (attr == 'w') {
        including = !!wgt.$n_().style.width;
      } else {
        including = !!wgt.$n_().style.height;
      }
    }
    if (including) {
      return _super.prototype.getChildMinSize_.call(this, attr, wgt);
    } else {
      return 0;
    }
  };
  //@Override, related to Bug ZK-1799
  /** @internal */
  Window.prototype.getContentEdgeWidth_ = function (width) {
    if (this.caption && width == this.caption.$n_().offsetWidth) {
      // use caption's edge width
      var p = this.$n_(),
        fc = this.caption,
        // eslint-disable-next-line zk/noNull
        c = fc ? fc.$n() : p.firstChild,
        zkp = zk(p),
        w = zkp.padBorderWidth();
      if (c) {
        c = c.parentNode;
        while (c && c.nodeType == 1 && p != c) {
          var zkc = zk(c);
          w += zkc.padBorderWidth() + zkc.sumStyles('lr', jq.margins);
          c = c.parentNode;
        }
        return w;
      }
      return 0;
    } else {
      return _super.prototype.getContentEdgeWidth_.call(this, width);
    }
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  /** @internal */
  Window.prototype.setFlexSizeH_ = function (flexSizeH, zkn, height, isFlexMin) {
    if (isFlexMin) {
      height += this._titleHeight();
    }
    _super.prototype.setFlexSizeH_.call(this, flexSizeH, zkn, height, isFlexMin);
  };
  //@Override, do not count size of floating window in flex calculation. bug #3172785.
  /** @internal */
  Window.prototype.ignoreFlexSize_ = function (type) {
    return this._mode != 'embedded';
  };
  /** @internal */
  Window.prototype.getClosableIconClass_ = function () {
    return 'z-icon-times';
  };
  /** @internal */
  Window.prototype.getMaximizableIconClass_ = function () {
    return 'z-icon-expand';
  };
  /** @internal */
  Window.prototype.getMaximizedIconClass_ = function () {
    return 'z-icon-compress';
  };
  /** @internal */
  Window.prototype.getMinimizableIconClass_ = function () {
    return 'z-icon-minus';
  };
  // drag sizing (also referenced by Panel.js)
  /** @internal */
  Window._startsizing = function (dg, evt) {
    window.zul.wnd.Window_._hideShadow(dg.control); //ZK-3877: startsizing is the better event to hideShadow
    zWatch.fire('onFloatUp', dg.control); //notify all
  };
  /** @internal */
  Window._snapsizing = function (dg, pos) {
    var z_dir = dg.z_dir;
    // snap y only when dragging upper boundary/corners
    var px = z_dir >= 6 && z_dir <= 8 ? Math.max(pos[0], 0) : pos[0],
      // snap x only when dragging left boundary/corners
      py = z_dir == 8 || z_dir <= 2 ? Math.max(pos[1], 0) : pos[1];
    return [px, py];
  };
  /** @internal */
  Window._ghostsizing = function (dg, ofs, evt) {
    var wnd = dg.control,
      el = dg.node;
    window.zul.wnd.Window_._hideShadow(wnd);
    wnd.setTopmost();
    var $el = jq(el);
    jq(document.body).append(DOMPurify.sanitize('<div id="zk_ddghost" class="' + wnd.getZclass() + '-resize-faker"' + ' style="position:absolute;top:' + jq.px(ofs[1]) + ';left:' + jq.px(ofs[0]) + ';width:' + jq.px($el.zk.offsetWidth()) + ';height:' + jq.px($el.zk.offsetHeight()) + ';z-index:' + /*safe*/el.style.zIndex + '"><dl></dl></div>'));
    return jq('#zk_ddghost')[0];
  };
  /** @internal */
  Window._endghostsizing = function (dg, origin) {
    var el = dg.node; //ghostvar org = zkau.getGhostOrgin(dg);
    if (origin) {
      var offset = zk(origin).cmOffset(),
        s = origin.style,
        offsetX = offset[0] - parseInt(s.left),
        offsetY = offset[1] - parseInt(s.top);
      dg.z_szofs = {
        top: jq.px(el.offsetTop - offsetY),
        left: jq.px(el.offsetLeft - offsetX),
        height: jq.px0(zk(el).revisedHeight(el.offsetHeight)),
        width: jq.px0(zk(el).revisedWidth(el.offsetWidth))
      };
    }
  };
  /** @internal */
  Window._insizer = function (node, ofs, x, y) {
    var r = ofs[0] + node.offsetWidth,
      b = ofs[1] + node.offsetHeight;
    if (x - ofs[0] <= 5) {
      if (y - ofs[1] <= 5) return 8;else if (b - y <= 5) return 6;else return 7;
    } else if (r - x <= 5) {
      if (y - ofs[1] <= 5) return 2;else if (b - y <= 5) return 4;else return 3;
    } else {
      if (y - ofs[1] <= 5) return 1;else if (b - y <= 5) return 5;
    }
  };
  /** @internal */
  Window._ignoresizing = function (dg, pointer, evt) {
    var el = dg.node,
      wgt = dg.control;
    if (wgt._maximized || evt.target != wgt) return true;
    var offs = zk(el).revisedOffset(),
      v = Window_1._insizer(el, offs, pointer[0], pointer[1]);
    if (v) {
      dg.z_dir = v;
      dg.z_box = {
        top: offs[1],
        left: offs[0],
        height: el.offsetHeight,
        width: el.offsetWidth,
        minHeight: zk.parseInt(wgt.getMinheight()),
        minWidth: zk.parseInt(wgt.getMinwidth())
      };
      dg.z_orgzi = el.style.zIndex;
      return false;
    }
    return true;
  };
  /** @internal */
  Window._aftersizing = function (dg, evt) {
    var wgt = dg.control,
      data = dg.z_szofs;
    if (wgt._hflex) wgt.setHflex_();
    if (wgt._vflex) wgt.setVflex_();
    wgt.fire('onSize', zk.copy(data, evt.keys), {
      ignorable: true
    });
    dg.z_szofs = undefined;
  };
  /** @internal */
  Window._drawsizing = function (dg, pointer, evt) {
    var z_dir = dg.z_dir,
      z_box = dg.z_box,
      style = dg.node.style;
    if (z_dir == 8 || z_dir <= 2) {
      var h = z_box.height + z_box.top - pointer[1];
      if (h < z_box.minHeight) {
        pointer[1] = z_box.height + z_box.top - z_box.minHeight;
        h = z_box.minHeight;
      }
      style.height = jq.px0(h);
      style.top = jq.px(pointer[1]);
    }
    if (z_dir >= 4 && z_dir <= 6) {
      var h = z_box.height + pointer[1] - z_box.top;
      if (h < z_box.minHeight) h = z_box.minHeight;
      style.height = jq.px0(h);
    }
    if (z_dir >= 6 && z_dir <= 8) {
      var w = z_box.width + z_box.left - pointer[0];
      if (w < z_box.minWidth) {
        pointer[0] = z_box.width + z_box.left - z_box.minWidth;
        w = z_box.minWidth;
      }
      style.width = jq.px0(w);
      style.left = jq.px(pointer[0]);
    }
    if (z_dir >= 2 && z_dir <= 4) {
      var w = z_box.width + pointer[0] - z_box.left;
      if (w < z_box.minWidth) w = z_box.minWidth;
      style.width = jq.px0(w);
    }
  };
  var Window_1;
  /** @internal */
  Window._startmove = window.zul.wnd.Window_._startmove;
  /** @internal */
  Window._ghostmove = window.zul.wnd.Window_._ghostmove;
  /** @internal */
  Window._endghostmove = window.zul.wnd.Window_._endghostmove;
  /** @internal */
  Window._ignoremove = window.zul.wnd.Window_._ignoremove;
  /** @internal */
  Window._aftermove = window.zul.wnd.Window_._aftermove;
  Window = Window_1 = __decorate([zk.WrapClass('zul.wnd.Window')], Window);
  return Window;
}(zul.ContainerWidget);
exports.Window = Window;
var Skipper = /** @class */function (_super) {
  __extends(Skipper, _super);
  function Skipper(wnd) {
    var _this = _super.call(this) || this;
    _this._w = wnd;
    return _this;
  }
  Skipper.prototype.restore = function (wgt, skip) {
    _super.prototype.restore.call(this, wgt, skip);
    var w = this._w;
    if (w._mode != 'embedded') {
      window.zul.wnd.Window_._updDomPos(w); //skipper's size is wrong in bind_
      w.zsync();
    }
  };
  Skipper = __decorate([zk.WrapClass('zul.wnd.Skipper')], Skipper);
  return Skipper;
}(zk.Skipper);
exports.Skipper = Skipper;
/** @class zul.wnd.WindowRenderer
 * The renderer used to render a window.
 * It is designed to be overriden
 * @since 5.0.5
 */
exports.WindowRenderer = {
  /**
   * @returns whether to check the border's height.
   * @param wgt - the window
   */
  shallCheckBorder: function (wgt) {
    return wgt._mode != 'popup' && (wgt._mode != 'embedded' || wgt.getBorder() != 'none');
  }
};
zul.wnd.WindowRenderer = exports.WindowRenderer;
window.zul.wnd.Window_._modals = _modals;
window.zul.wnd.Window_._lastfocus = _lastfocus;
window.zul.wnd.Window_.Window = Window;
window.zul.wnd.Window_.Skipper = Skipper;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wnd/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wnd/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./Window */ "./zul/src/main/resources/web/js/zul/wnd/Window.ts"), exports);
__exportStar(__webpack_require__(/*! ./Panel */ "./zul/src/main/resources/web/js/zul/wnd/Panel.ts"), exports);
__exportStar(__webpack_require__(/*! ./Panelchildren */ "./zul/src/main/resources/web/js/zul/wnd/Panelchildren.ts"), exports);
__exportStar(__webpack_require__(/*! ./messagebox */ "./zul/src/main/resources/web/js/zul/wnd/messagebox.ts"), exports);

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/wnd/messagebox.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/wnd/messagebox.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports) {



if (!window.zul) window.zul = {};
if (!window.zul.wnd) window.zul.wnd = {};
if (!window.zul.wnd.messagebox_) window.zul.wnd.messagebox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Messagebox = void 0;
exports.Messagebox = {
  onBind: function (label, minWidth) {
    var win = label.$o(),
      outer = win.$n(),
      msgbox = label.$n_().parentElement,
      outerOrigWd = outer.offsetWidth;
    if (minWidth) {
      outer.style.width = jq.px0(Math.min(zk.parseInt(minWidth), jq.innerWidth() - 20));
      msgbox.style.width = jq.px0(zk.parseInt(minWidth) - (outerOrigWd - msgbox.offsetWidth));
    }
    zk(outer).center();
    var top = zk.parseInt(outer.style.top),
      y = jq.innerY();
    if (y) {
      var y1 = top - y;
      if (y1 > 100) outer.style.top = jq.px0(top - (y1 - 100));
    } else if (top > 100) outer.style.top = '100px';
    win.onSize();
  }
};
zul.wnd.Messagebox = exports.Messagebox;

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/wnd/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;