/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Row;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.impl.XulElement;

public class Cell
extends XulElement {
    private AuxInfo _auxinf;

    public String getAlign() {
        return this._auxinf != null ? this._auxinf._align : null;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this.getAlign(), (Object)align)) {
            this.initAuxInfoForCell()._align = align;
            this.smartUpdate("align", this.getAlign());
        }
    }

    public String getValign() {
        return this._auxinf != null ? this._auxinf._valign : null;
    }

    public void setValign(String valign) {
        if (!Objects.equals((Object)this.getValign(), (Object)valign)) {
            this.initAuxInfoForCell()._valign = valign;
            this.smartUpdate("valign", this.getValign());
        }
    }

    public int getColspan() {
        return this._auxinf != null ? this._auxinf._colspan : 1;
    }

    public void setColspan(int colspan) throws WrongValueException {
        if (colspan <= 0) {
            throw new WrongValueException("Positive only");
        }
        if (this.getColspan() != colspan) {
            this.initAuxInfoForCell()._colspan = colspan;
            this.smartUpdate("colspan", this.getColspan());
        }
    }

    public int getRowspan() {
        return this._auxinf != null ? this._auxinf._rowspan : 1;
    }

    public void setRowspan(int rowspan) throws WrongValueException {
        if (rowspan <= 0) {
            throw new WrongValueException("Positive only");
        }
        if (this.getRowspan() != rowspan) {
            this.initAuxInfoForCell()._rowspan = rowspan;
            this.smartUpdate("rowspan", this.getRowspan());
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-cell" : this._zclass;
    }

    @Override
    public Object clone() {
        Cell clone = (Cell)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    public void beforeParentChanged(Component parent) {
        if (!(parent == null || parent instanceof Row || parent instanceof Hbox || parent instanceof Vbox)) {
            throw new UiException("Unsupported parent for cell: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.getColspan() != 1) {
            renderer.render("colspan", this.getColspan());
        }
        if (this.getRowspan() != 1) {
            renderer.render("rowspan", this.getRowspan());
        }
        renderer.render("align", this.getAlign());
        renderer.render("valign", this.getValign());
    }

    private AuxInfo initAuxInfoForCell() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    public boolean evalCSSFlex() {
        return false;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String _align = null;
        private String _valign = null;
        private int _colspan = 1;
        private int _rowspan = 1;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

