/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.zkoss.io.Files;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.au.out.AuDownload;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class Filedownload {
    public static void save(Media media) {
        Filedownload.save(media, null);
    }

    public static void save(Media media, String flnm) {
        Desktop desktop = Executions.getCurrent().getDesktop();
        ((WebAppCtrl)desktop.getWebApp()).getUiEngine().addResponse((AuResponse)new AuDownload((DeferredValue)new DownloadURL(media, flnm)));
    }

    public static void save(byte[] content, String contentType, String flnm) {
        Filedownload.save((Media)new AMedia(flnm, null, contentType, content), flnm);
    }

    public static void save(String content, String contentType, String flnm) {
        Filedownload.save((Media)new AMedia(flnm, null, contentType, content), flnm);
    }

    public static void save(InputStream content, String contentType, String flnm) {
        Filedownload.save((Media)new AMedia(flnm, null, contentType, content), flnm);
    }

    public static void save(Reader content, String contentType, String flnm) {
        Filedownload.save((Media)new AMedia(flnm, null, contentType, content), flnm);
    }

    public static void save(File file, String contentType) throws FileNotFoundException {
        Filedownload.save((Media)new AMedia(file, contentType, null), file.getName());
    }

    public static void save(URL url, String contentType) throws FileNotFoundException {
        String name = url.toExternalForm();
        int j = name.lastIndexOf(47);
        if (j >= 0 && j < name.length() - 1) {
            name = name.substring(j + 1);
        }
        Filedownload.save((Media)new AMedia(url, contentType, null), name);
    }

    public static void save(String path, String contentType) throws FileNotFoundException {
        URL url = Executions.getCurrent().getDesktop().getWebApp().getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        Filedownload.save(url, contentType);
    }

    public static void saveMultiple(Media ... medias) {
        if (medias == null || medias.length == 0) {
            return;
        }
        for (Media media : medias) {
            Filedownload.save(media, null);
        }
    }

    public static void saveMultiple(Map<Media, String> mediaMap) {
        if (mediaMap == null || mediaMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Media, String> entry : mediaMap.entrySet()) {
            Filedownload.save(entry.getKey(), entry.getValue());
        }
    }

    public static void saveMultiple(DownloadItem ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (DownloadItem item : items) {
            Filedownload.save(item.getMedia(), item.getFilename());
        }
    }

    public static void saveAsZip(Media[] medias, String zipFilename) {
        if (medias == null || medias.length == 0) {
            return;
        }
        LinkedHashMap<Media, String> mediaMap = new LinkedHashMap<Media, String>();
        for (Media media : medias) {
            mediaMap.put(media, null);
        }
        Filedownload.saveAsZip(mediaMap, zipFilename);
    }

    public static void saveAsZip(Map<Media, String> mediaMap, String zipFilename) {
        if (mediaMap == null || mediaMap.isEmpty()) {
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            for (Map.Entry<Media, String> entry : mediaMap.entrySet()) {
                String format;
                Media media = entry.getKey();
                Object filename = entry.getValue();
                if (filename == null || ((String)filename).isEmpty()) {
                    filename = media.getName();
                }
                if (filename != null && ((String)filename).lastIndexOf(46) < 0 && (format = media.getFormat()) != null && !format.isEmpty()) {
                    filename = (String)filename + "." + format;
                }
                ZipEntry zipEntry = new ZipEntry((String)(filename != null ? filename : "file"));
                zos.putNextEntry(zipEntry);
                if (media.isBinary()) {
                    if (media.inMemory()) {
                        zos.write(media.getByteData());
                    } else {
                        try (InputStream is = media.getStreamData();){
                            Files.copy((OutputStream)zos, (InputStream)is);
                        }
                    }
                } else if (media.inMemory()) {
                    zos.write(media.getStringData().getBytes("UTF-8"));
                } else {
                    try (Reader reader = media.getReaderData();){
                        int len;
                        char[] buffer = new char[8192];
                        while ((len = reader.read(buffer)) > 0) {
                            zos.write(new String(buffer, 0, len).getBytes("UTF-8"));
                        }
                    }
                }
                zos.closeEntry();
            }
            zos.close();
            if (zipFilename == null || ((String)zipFilename).isEmpty()) {
                zipFilename = "download.zip";
            } else if (!((String)zipFilename).toLowerCase().endsWith(".zip")) {
                zipFilename = (String)zipFilename + ".zip";
            }
            byte[] zipData = baos.toByteArray();
            AMedia zipMedia = new AMedia((String)zipFilename, "zip", "application/zip", zipData);
            Filedownload.save((Media)zipMedia, (String)zipFilename);
        }
        catch (IOException e) {
            throw new UiException("Failed to create ZIP file: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void saveAsZip(DownloadItem[] items, String zipFilename) {
        if (items == null || items.length == 0) {
            return;
        }
        LinkedHashMap<Media, String> mediaMap = new LinkedHashMap<Media, String>();
        for (DownloadItem item : items) {
            mediaMap.put(item.getMedia(), item.getFilename());
        }
        Filedownload.saveAsZip(mediaMap, zipFilename);
    }

    private static class DownloadURL
    implements DeferredValue {
        private final Media _media;
        private final String _path;

        private DownloadURL(Media media, String flnm) {
            this._media = media;
            if (flnm == null) {
                flnm = media.getName();
            }
            StringBuffer sb = new StringBuffer(32);
            if (flnm != null && flnm.length() != 0) {
                String format;
                sb.append('/');
                sb.append(flnm);
                if (flnm.lastIndexOf(46) < 0 && (format = media.getFormat()) != null) {
                    sb.append('.').append(format);
                }
            }
            this._path = sb.toString();
        }

        public Object getValue() {
            return Executions.getCurrent().getDesktop().getDownloadMediaURI(this._media, this._path);
        }
    }

    public static class DownloadItem {
        private final Media media;
        private final String filename;

        public DownloadItem(Media media, String filename) {
            if (media == null) {
                throw new IllegalArgumentException("media cannot be null");
            }
            this.media = media;
            this.filename = filename;
        }

        public DownloadItem(Media media) {
            this(media, null);
        }

        public static DownloadItem of(Media media, String filename) {
            return new DownloadItem(media, filename);
        }

        public static DownloadItem of(Media media) {
            return new DownloadItem(media);
        }

        public Media getMedia() {
            return this.media;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

