/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.mesg.MZul;

public abstract class SimpleNumberInputConstraint<T extends Number>
extends SimpleConstraint {
    private T _min;
    private T _max;

    public SimpleNumberInputConstraint() {
        super(0);
    }

    public SimpleNumberInputConstraint(int flags) {
        super(flags);
    }

    public SimpleNumberInputConstraint(String constraint) {
        super(constraint);
    }

    public T getMin() {
        return this._min;
    }

    public void setMin(T min) {
        this._min = min;
    }

    public T getMax() {
        return this._max;
    }

    public void setMax(T max) {
        this._max = max;
    }

    protected abstract T parseValue(String var1);

    @Override
    protected int parseConstraint(String constraint) throws UiException {
        int minIndex = constraint.indexOf("min");
        int maxIndex = constraint.indexOf("max");
        try {
            if (minIndex >= 0 && maxIndex >= 0) {
                if (maxIndex > minIndex) {
                    this._min = this.parseValue(constraint.substring(minIndex + 3, maxIndex).trim());
                    this._max = this.parseValue(constraint.substring(maxIndex + 3).trim());
                } else {
                    this._min = this.parseValue(constraint.substring(minIndex + 3).trim());
                    this._max = this.parseValue(constraint.substring(maxIndex + 3, minIndex).trim());
                }
                if (((Comparable)this._min).compareTo(this._max) > 0) {
                    throw new UiException("Constraint error: " + String.valueOf(this._min) + " > " + String.valueOf(this._max));
                }
                return 0;
            }
            if (minIndex >= 0) {
                this._min = this.parseValue(constraint.substring(minIndex + 3).trim());
                return 0;
            }
            if (maxIndex >= 0) {
                this._max = this.parseValue(constraint.substring(maxIndex + 3).trim());
                return 0;
            }
        }
        catch (NumberFormatException e) {
            throw new UiException("Constraint error: " + constraint);
        }
        return super.parseConstraint(constraint);
    }

    @Override
    public void validate(Component comp, Object value) throws WrongValueException {
        Number typedValue;
        super.validate(comp, value);
        try {
            typedValue = (Number)value;
        }
        catch (ClassCastException e) {
            throw new WrongValueException(comp, "Type mismatch");
        }
        if (this._min != null && ((Comparable)this._min).compareTo(typedValue) > 0) {
            throw this.outOfRangeValue(comp);
        }
        if (this._max != null && ((Comparable)this._max).compareTo(typedValue) < 0) {
            throw this.outOfRangeValue(comp);
        }
    }

    protected WrongValueException outOfRangeValue(Component comp) {
        String errmsg = this.getErrorMessage(comp);
        if (errmsg != null) {
            return new WrongValueException(comp, errmsg);
        }
        String s = this._min != null ? (this._max != null ? String.valueOf(this._min) + " ~ " + String.valueOf(this._max) : ">= " + String.valueOf(this._min)) : "<= " + String.valueOf(this._max);
        return new WrongValueException(comp, MZul.OUT_OF_RANGE, (Object)s);
    }
}

