/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.ext.Uploadable;
import org.zkoss.zk.ui.ext.Uploads;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.LabelImageElement;
import org.zkoss.zul.impl.Utils;

public class Button
extends LabelImageElement
implements Disable,
Uploadable {
    private AuxInfo _auxinf;
    private static final String HORIZONTAL = "horizontal";
    private static final String NORMAL = "normal";
    private static final String BUTTON = "button";

    public Button() {
    }

    public Button(String label) {
        super(label);
    }

    public Button(String label, String image) {
        super(label, image);
    }

    public boolean isDisabled() {
        return this._auxinf != null && this._auxinf.disabled;
    }

    public void setDisabled(boolean disabled) {
        if ((this._auxinf != null && this._auxinf.disabled) != disabled) {
            this.initAuxInfoForButton().disabled = disabled;
            this.smartUpdate("disabled", this.isDisabled());
        }
    }

    public String getAutodisable() {
        return this._auxinf != null ? this._auxinf.autodisable : null;
    }

    public void setAutodisable(String autodisable) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.autodisable : null), (Object)autodisable)) {
            this.initAuxInfoForButton().autodisable = autodisable;
            this.smartUpdate("autodisable", this.getAutodisable());
        }
    }

    public String getDir() {
        return this._auxinf != null ? this._auxinf.dir : NORMAL;
    }

    public void setDir(String dir) throws WrongValueException {
        if (!NORMAL.equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.dir : NORMAL), (Object)dir)) {
            this.initAuxInfoForButton().dir = dir;
            this.smartUpdate("dir", this.getDir());
        }
    }

    public String getOrient() {
        return this._auxinf != null ? this._auxinf.orient : HORIZONTAL;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!HORIZONTAL.equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.orient : HORIZONTAL), (Object)orient)) {
            this.initAuxInfoForButton().orient = orient;
            this.smartUpdate("orient", this.getOrient());
        }
    }

    public String getType() {
        return this._auxinf != null ? this._auxinf.type : BUTTON;
    }

    public void setType(String type) throws WrongValueException {
        if (!(BUTTON.equals(type) || "submit".equals(type) || "reset".equals(type))) {
            throw new WrongValueException(type);
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.type : BUTTON), (Object)type)) {
            this.initAuxInfoForButton().type = type;
            this.smartUpdate("type", this.getType());
        }
    }

    public String getHref() {
        return this._auxinf != null ? this._auxinf.href : null;
    }

    public void setHref(String href) {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.href : null), (Object)href)) {
            this.initAuxInfoForButton().href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._auxinf != null ? this._auxinf.target : null;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.target : null), (Object)target)) {
            this.initAuxInfoForButton().target = target;
            this.smartUpdate("target", this.getTarget());
        }
    }

    public String getUpload() {
        return this._auxinf != null ? this._auxinf.upload : null;
    }

    public void setUpload(String upload) {
        if (upload != null && (upload.length() == 0 || "false".equals(upload))) {
            upload = null;
        }
        if (!Objects.equals((Object)upload, this._auxinf != null ? this._auxinf.upload : null)) {
            this.onUploadChanged(upload);
            this.initAuxInfoForButton().upload = upload;
            Uploads.parseUpload((Component)this, (String)upload);
            this.smartUpdate("upload", Uploads.getRealUpload((Component)this, (String)this.getUpload()));
        }
    }

    private void onUploadChanged(String upload) {
        if (upload != null && !"trendy".equals(this.getMold()) && this.getDefinition().getMoldNames().contains("trendy")) {
            this.setMold("trendy");
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._auxinf != null && this._auxinf.href != null && dt != null ? dt.getExecution().encodeURL(this._auxinf.href) : null;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        String s = this.getDir();
        if (!NORMAL.equals(s)) {
            this.render(renderer, "dir", s);
        }
        if (!HORIZONTAL.equals(s = this.getOrient())) {
            this.render(renderer, "orient", s);
        }
        if (!BUTTON.equals(s = this.getType())) {
            this.render(renderer, "type", s);
        }
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "autodisable", this.getAutodisable());
        String href = this.getEncodedHref();
        this.render(renderer, "href", href);
        this.render(renderer, "target", this.getTarget());
        this.render(renderer, "upload", Uploads.getRealUpload((Component)this, (String)this.getUpload()));
        Utils.renderCrawlableA(href, this.getLabel());
    }

    @Override
    protected void renderCrawlable(String label) throws IOException {
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-button";
    }

    @Override
    public Object clone() {
        Button clone = (Button)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    protected boolean isChildable() {
        return false;
    }

    protected void updateByClient(String name, Object value) {
        if ("disabled".equals(name)) {
            this.setDisabled(value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(Objects.toString((Object)value)));
        } else {
            super.updateByClient(name, value);
        }
    }

    private AuxInfo initAuxInfoForButton() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onUpload".equals(cmd)) {
            Events.postEvent((Event)UploadEvent.getUploadEvent((String)cmd, (Component)this, (AuRequest)request));
        } else {
            super.service(request, everError);
        }
    }

    static {
        Button.addClientEvent(Button.class, (String)"onFocus", (int)8192);
        Button.addClientEvent(Button.class, (String)"onBlur", (int)8192);
        Button.addClientEvent(Button.class, (String)"onUpload", (int)0);
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String orient = "horizontal";
        private String dir = "normal";
        private String type = "button";
        private String href;
        private String target;
        private String autodisable;
        protected String upload;
        private boolean disabled;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return Button.this.getEncodedHref();
        }
    }
}

