/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.jpa;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zkplus.jpa.JpaUtil;

public class OpenEntityManagerInViewListener
implements ExecutionCleanup,
ExecutionInit {
    private static final Logger log = LoggerFactory.getLogger(OpenEntityManagerInViewListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Execution exec, Execution parent, List errs) throws Exception {
        if (parent == null) {
            try {
                if (errs == null || errs.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("JPA: Committing the database transaction: {} for entityManager:{}", (Object)exec, (Object)JpaUtil.getEntityManager());
                    }
                    JpaUtil.getEntityManager().getTransaction().commit();
                } else {
                    Throwable ex = (Throwable)errs.get(0);
                    this.handleException(exec, ex);
                }
            }
            finally {
                if (JpaUtil.getEntityManager().isOpen()) {
                    if (log.isDebugEnabled()) {
                        log.debug("JPA: close a database transaction: {} for entityManager:{}", (Object)exec, (Object)JpaUtil.getEntityManager());
                    }
                    JpaUtil.getEntityManager().close();
                } else if (log.isDebugEnabled()) {
                    log.debug("JPA: the database transaction is not open: {} for entityManager:{}", (Object)exec, (Object)JpaUtil.getEntityManager());
                }
            }
        }
    }

    public void init(Execution exec, Execution parent) throws Exception {
        if (parent == null) {
            if (log.isDebugEnabled()) {
                log.debug("JPA: Starting a database transaction: {} for entityManager:{}", (Object)exec, (Object)JpaUtil.getEntityManager());
            }
            JpaUtil.getEntityManager().getTransaction().begin();
        }
    }

    protected void handleException(Execution exec, Throwable ex) {
        log.error("Exception occurred during execution cleanup", ex);
        this.rollback(exec, ex);
    }

    private void rollback(Execution exec, Throwable ex) {
        try {
            if (JpaUtil.getEntityManager().getTransaction().isActive()) {
                if (log.isDebugEnabled()) {
                    log.debug("Trying to rollback database transaction after exception:{}", (Object)String.valueOf(ex));
                }
                JpaUtil.getEntityManager().getTransaction().rollback();
            }
        }
        catch (Throwable rbEx) {
            log.error("Could not rollback transaction after exception! Original Exception:\n{}", (Object)ex, (Object)rbEx);
        }
    }
}

