/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zkplus.util.ThreadLocals;

public class ThreadLocalListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalListener.class);
    private Map<String, String[]> _fieldsMap;
    private Map<String, Object[]> _threadLocalsMap;
    private final boolean _enabled;

    public ThreadLocalListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._fieldsMap = Generics.cast((Map)((Map)app.getAttribute("zkplus.util.ThreadLocalListener.fieldsMap")));
        this._enabled = app.getConfiguration().isEventThreadEnabled();
        if (this._fieldsMap == null) {
            this._fieldsMap = new HashMap<String, String[]>(8);
            String PREF = "zkplus.util.ThreadLocalListener.fieldsMap";
            app.setAttribute("zkplus.util.ThreadLocalListener.fieldsMap", this._fieldsMap);
            String val = app.getConfiguration().getPreference("ThreadLocal", null);
            if (val == null) {
                val = Library.getProperty((String)"zkplus.util.ThreadLocalListener.fieldsMap");
            }
            if (val != null) {
                Collection klassSets = CollectionsX.parse(null, (String)val, (char)';');
                for (String klassSetStr : klassSets) {
                    Collection klassSet = CollectionsX.parse(null, (String)klassSetStr, (char)'=');
                    Iterator itz = klassSet.iterator();
                    String klass = (String)itz.next();
                    String fieldsStr = (String)itz.next();
                    Collection fields = CollectionsX.parse(null, (String)fieldsStr, (char)',');
                    this._fieldsMap.put(klass, fields.toArray(new String[fields.size()]));
                }
            }
        }
        this._threadLocalsMap = new HashMap<String, Object[]>(this._fieldsMap.size());
    }

    public void prepare(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public boolean init(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
        return true;
    }

    public void cleanup(Component comp, Event evt, List errs) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void complete(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void beforeResume(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void afterResume(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void getThreadLocals() {
        for (Map.Entry<String, String[]> me : this._fieldsMap.entrySet()) {
            String clsName = me.getKey();
            try {
                Class cls = Classes.forNameByThread((String)clsName);
                String[] fields = me.getValue();
                Object[] threadLocals = new Object[fields.length];
                this._threadLocalsMap.put(clsName, threadLocals);
                for (int j = 0; j < threadLocals.length; ++j) {
                    try {
                        threadLocals[j] = this.getThreadLocal(cls, fields[j]).get();
                        continue;
                    }
                    catch (SystemException ex) {
                        log.warn("Failed to get ThreadLocal: " + clsName + "." + fields[j], (Throwable)ex);
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                log.warn("Class not found: " + clsName, (Throwable)ex);
            }
        }
    }

    private void setThreadLocals() {
        for (Map.Entry<String, Object[]> me : this._threadLocalsMap.entrySet()) {
            String clsName = me.getKey();
            try {
                Class cls = Classes.forNameByThread((String)clsName);
                Object[] threadLocals = me.getValue();
                String[] fields = this._fieldsMap.get(clsName);
                for (int j = 0; j < threadLocals.length; ++j) {
                    this.getThreadLocal(cls, fields[j]).set(threadLocals[j]);
                }
            }
            catch (ClassNotFoundException ex) {
                log.warn("Class not found: " + clsName, (Throwable)ex);
            }
        }
        this._threadLocalsMap.clear();
    }

    private ThreadLocal<Object> getThreadLocal(Class cls, String fldname) {
        return Generics.cast((ThreadLocal)ThreadLocals.getThreadLocal(cls, fldname));
    }
}

